#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 wai-extra
version:              3.1.7
visibility:           public
id:                   wai-extra-3.1.7-B23YpUDkXJKJRUMohg3vbP
key:                  wai-extra-3.1.7-B23YpUDkXJKJRUMohg3vbP
license:              MIT
maintainer:           michael@snoyman.com
author:               Michael Snoyman
stability:            Stable
homepage:             http://github.com/yesodweb/wai
synopsis:             Provides some basic WAI handlers and middleware.
description:
    Provides basic WAI handler and middleware functionality:

    * WAI Testing Framework

    Hspec testing facilities and helpers for WAI.

    * Event Source/Event Stream

    Send server events to the client. Compatible with the JavaScript
    EventSource API.

    * Accept Override

    Override the Accept header in a request. Special handling for the
    _accept query parameter (which is used throughout WAI override the
    Accept header).

    * Add Headers

    WAI Middleware for adding arbitrary headers to an HTTP request.

    * Clean Path

    Clean a request path to a canonical form.

    * GZip Compression

    Negotiate HTTP payload gzip compression.

    * HTTP Basic Authentication

    WAI Basic Authentication Middleware which uses Authorization header.

    * JSONP

    \"JSON with Padding\" middleware. Automatic wrapping of JSON
    responses to convert into JSONP.

    * Method Override / Post

    Allows overriding of the HTTP request method via the _method query string
    parameter.

    * Request Logging

    Request logging middleware for development and production environments

    * Request Rewrite

    Rewrite request path info based on a custom conversion rules.

    * Stream Files

    Convert ResponseFile type responses into ResponseStream type.

    * Virtual Host

    Redirect incoming requests to a new host based on custom rules.


    API docs and the README are available at <http://www.stackage.org/package/wai-extra>.

category:             Web
abi:                  dd107be3b9d194f4927c87399854cff1
exposed:              True
exposed-modules:
    Network.Wai.EventSource Network.Wai.EventSource.EventStream
    Network.Wai.Handler.CGI Network.Wai.Handler.SCGI Network.Wai.Header
    Network.Wai.Middleware.AcceptOverride
    Network.Wai.Middleware.AddHeaders Network.Wai.Middleware.Approot
    Network.Wai.Middleware.Autohead Network.Wai.Middleware.CleanPath
    Network.Wai.Middleware.ForceDomain Network.Wai.Middleware.ForceSSL
    Network.Wai.Middleware.Gzip Network.Wai.Middleware.HttpAuth
    Network.Wai.Middleware.Jsonp Network.Wai.Middleware.Local
    Network.Wai.Middleware.MethodOverride
    Network.Wai.Middleware.MethodOverridePost
    Network.Wai.Middleware.RealIp Network.Wai.Middleware.RequestLogger
    Network.Wai.Middleware.RequestLogger.JSON
    Network.Wai.Middleware.RequestSizeLimit
    Network.Wai.Middleware.RequestSizeLimit.Internal
    Network.Wai.Middleware.Rewrite Network.Wai.Middleware.Routed
    Network.Wai.Middleware.StreamFile
    Network.Wai.Middleware.StripHeaders Network.Wai.Middleware.Timeout
    Network.Wai.Middleware.Vhost Network.Wai.Parse Network.Wai.Request
    Network.Wai.Test Network.Wai.Test.Internal Network.Wai.UrlMap

hidden-modules:       Network.Wai.Middleware.RequestLogger.Internal
import-dirs:          /usr/lib/ghc-9.0.1/site-local/wai-extra-3.1.7
library-dirs:         /usr/lib/ghc-9.0.1/site-local/wai-extra-3.1.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/wai-extra-3.1.7
hs-libraries:         HSwai-extra-3.1.7-B23YpUDkXJKJRUMohg3vbP
depends:
    HUnit-1.6.2.0-2lDDmQCEetY9OrwZ2lDZMS
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs
    ansi-terminal-0.11-DOUngjGM5e9DBdxKKdJoVq base-4.15.0.0
    base64-bytestring-1.2.1.0-1T6dUoRSPJz5Ioae8XlZq2
    bytestring-0.10.12.1 call-stack-0.4.0-8Okwb0cowpe8mB1pBLnCB
    case-insensitive-1.2.1.0-810KinvQcYx7xuCoSIHpwY containers-0.6.4.1
    cookie-0.4.5-KsNYn2KTPEnIdTHNDYXGny
    data-default-class-0.1.2.0-LBmwYNzg9cwLSaLiX5AQfC directory-1.3.6.1
    fast-logger-3.0.5-AJNZEa0hP3t8Kob0tv00Bx
    http-types-0.12.3-J3pS8fDTy4j62mHquuNqa5
    http2-3.0.2-ElAkJcjohCP5vODV3cmTtj
    iproute-1.7.11-F27VP43fQER6qAmg0EFZzp
    network-3.1.2.2-HXcjy5szECnDN1PS9jNchP
    resourcet-1.2.4.3-8689t6OWpHGD0T1pI8fpT0
    streaming-commons-0.2.2.1-8n8dllyBp1F12Lm7Sqc21T text-1.2.4.1
    time-1.9.3 transformers-0.5.6.2 unix-2.7.2.2
    vault-0.3.1.5-LDTtIWpWoGTEQp4jnlvcxt
    wai-3.2.3-GecSYae22qn12CDRauoVPu
    wai-logger-2.3.6-4CgnttGFl98Db0xXogvdtV
    word8-0.1.3-6en08JYOoMR9XQOtl02Wug

haddock-interfaces:   /usr/share/doc/haskell-wai-extra/html/wai-extra.haddock
haddock-html:         /usr/share/doc/haskell-wai-extra/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

