#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 websockets
version:              0.12.7.2
visibility:           public
id:                   websockets-0.12.7.2-HrqtAtodQh6L2AEmH9WXXF
key:                  websockets-0.12.7.2-HrqtAtodQh6L2AEmH9WXXF
license:              BSD-3-Clause
copyright:
    (c) 2010-2011 Siniša Biđin
    (c) 2011-2018 Jasper Van der Jeugt
    (c) 2011 Steffen Schuldenzucker
    (c) 2011 Alex Lang

maintainer:           Jasper Van der Jeugt <m@jaspervdj.be>
author:
    Siniša Biđin <sinisa@bidin.cc>
    Jasper Van der Jeugt <m@jaspervdj.be>
    Steffen Schuldenzucker <steffen.schuldenzucker@googlemail.com>
    Alex Lang <lang@tsurucapital.com>

stability:            experimental
homepage:             http://jaspervdj.be/websockets
synopsis:
    A sensible and clean way to write WebSocket-capable servers in Haskell.

description:
    This library allows you to write WebSocket-capable servers.

    An example server:
    <https://github.com/jaspervdj/websockets/blob/master/example/server.lhs>

    An example client:
    <https://github.com/jaspervdj/websockets/blob/master/example/client.hs>

    See also:

    * The specification of the WebSocket protocol:
    <http://www.whatwg.org/specs/web-socket-protocol/>

    * The JavaScript API for dealing with WebSockets:
    <http://www.w3.org/TR/websockets/>

category:             Network
abi:                  e9021a26a061a74f8ef7f9d13cffb345
exposed:              True
exposed-modules:
    Network.WebSockets Network.WebSockets.Client
    Network.WebSockets.Connection Network.WebSockets.Extensions
    Network.WebSockets.Stream

hidden-modules:
    Network.WebSockets.Connection.Options
    Network.WebSockets.Extensions.Description
    Network.WebSockets.Extensions.PermessageDeflate
    Network.WebSockets.Extensions.StrictUnicode Network.WebSockets.Http
    Network.WebSockets.Hybi13 Network.WebSockets.Hybi13.Demultiplex
    Network.WebSockets.Hybi13.Mask Network.WebSockets.Protocol
    Network.WebSockets.Server Network.WebSockets.Types

import-dirs:          /usr/lib/ghc-9.0.1/site-local/websockets-0.12.7.2
library-dirs:         /usr/lib/ghc-9.0.1/site-local/websockets-0.12.7.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/websockets-0.12.7.2
hs-libraries:         HSwebsockets-0.12.7.2-HrqtAtodQh6L2AEmH9WXXF
depends:
    SHA-1.6.4.4-7e0sYz0lBWb1CdwjpynTkG
    async-2.2.3-9hcO3XZAP863cAPa5inA8N
    attoparsec-0.14.1-B8P567zH1pOF107V9enGUK base-4.15.0.0
    base64-bytestring-1.2.1.0-1T6dUoRSPJz5Ioae8XlZq2 binary-0.8.8.0
    bytestring-0.10.12.1
    case-insensitive-1.2.1.0-810KinvQcYx7xuCoSIHpwY
    clock-0.8.2-FEbX8RY0vheCS7qJJxWpPc containers-0.6.4.1
    entropy-0.4.1.7-66OkMQHXKESGwpio7bQXje
    network-3.1.2.2-HXcjy5szECnDN1PS9jNchP
    random-1.2.1-Iy7yOfCz74T6VyvkhFUFfX
    streaming-commons-0.2.2.1-8n8dllyBp1F12Lm7Sqc21T text-1.2.4.1

haddock-interfaces:   /usr/share/doc/haskell-websockets/html/websockets.haddock
haddock-html:         /usr/share/doc/haskell-websockets/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

