#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 x509
version:              1.7.5
visibility:           public
id:                   x509-1.7.5-HyBJj96t9GC2vaOmQQ4ozv
key:                  x509-1.7.5-HyBJj96t9GC2vaOmQQ4ozv
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           Vincent Hanquez <vincent@snarc.org>
author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             http://github.com/vincenthz/hs-certificate
synopsis:             X509 reader and writer
description:          X509 reader and writer. please see README
category:             Data
abi:                  caf5535c8a4f5b597f564e8adc2beb99
exposed:              True
exposed-modules:      Data.X509 Data.X509.EC
hidden-modules:
    Data.X509.Internal Data.X509.CertificateChain
    Data.X509.AlgorithmIdentifier Data.X509.DistinguishedName
    Data.X509.Cert Data.X509.PublicKey Data.X509.PrivateKey
    Data.X509.Ext Data.X509.ExtensionRaw Data.X509.CRL Data.X509.OID
    Data.X509.Signed

import-dirs:          /usr/lib/ghc-9.0.1/site-local/x509-1.7.5
library-dirs:         /usr/lib/ghc-9.0.1/site-local/x509-1.7.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/x509-1.7.5
hs-libraries:         HSx509-1.7.5-HyBJj96t9GC2vaOmQQ4ozv
depends:
    asn1-encoding-0.9.6-GST7u8YWSVMBlxeVag7x5g
    asn1-parse-0.9.5-KQ3hwiqcctko4GvkLYM3W
    asn1-types-0.3.4-7gCtfa0duAqTepdsDJGVJ base-4.15.0.0
    bytestring-0.10.12.1 containers-0.6.4.1
    cryptonite-0.29-GRn4QfSajtp4ejYMImOiTS
    hourglass-0.2.12-1wkJ9BEKC60A2qbJDgDFCi
    memory-0.16.0-CGaPOmXCTce28vOCDDnDFr mtl-2.2.2
    pem-0.2.4-HYg3Jt06Zqq3C6bOo96L1R

haddock-interfaces:   /usr/share/doc/haskell-x509/html/x509.haddock
haddock-html:         /usr/share/doc/haskell-x509/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

