#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 idris
version:              1.3.3
visibility:           public
id:                   idris-1.3.3-DVfEDQFdHKxIxDPikYJLu2
key:                  idris-1.3.3-DVfEDQFdHKxIxDPikYJLu2
license:              BSD-3-Clause
maintainer:           Niklas Larsson <niklas@mm.st>
author:               Edwin Brady
stability:            Beta
homepage:             https://www.idris-lang.org/
synopsis:             Functional Programming Language with Dependent Types
description:
    Idris is a general purpose language with full dependent types.
    It is compiled, with eager evaluation.
    Dependent types allow types to be predicated on values,
    meaning that some aspects of a program'\''s behaviour can be
    specified precisely in the type. The language is closely
    related to Epigram and Agda. There is a tutorial at
    <https://www.idris-lang.org/documentation>.
    Features include:

    * Full, first class, dependent types with dependent pattern matching

    * where clauses, with rule, case expressions,
    pattern matching let and lambda bindings

    * Interfaces (similar to type classes), monad comprehensions

    * do notation, idiom brackets, syntactic conveniences for lists,
    tuples, dependent pairs

    * Totality checking

    * Coinductive types

    * Indentation significant syntax, extensible syntax

    * Cumulative universes

    * Simple foreign function interface (to C)

    * Hugs style interactive environment

category:             Compilers/Interpreters, Dependent Types
abi:                  a989a11ed13be51365940335b2c1e5ac
exposed:              True
exposed-modules:
    IRTS.Bytecode IRTS.CodegenC IRTS.CodegenCommon
    IRTS.CodegenJavaScript IRTS.Compiler IRTS.Defunctionalise
    IRTS.DumpBC IRTS.Exports IRTS.Inliner IRTS.JavaScript.AST
    IRTS.JavaScript.Codegen IRTS.JavaScript.LangTransforms
    IRTS.JavaScript.Name IRTS.JavaScript.PrimOp
    IRTS.JavaScript.Specialize IRTS.Lang IRTS.LangOpts IRTS.Portable
    IRTS.Simplified IRTS.System Idris.ASTUtils Idris.AbsSyntax
    Idris.AbsSyntaxTree Idris.Apropos Idris.CaseSplit Idris.Chaser
    Idris.CmdOptions Idris.Colours Idris.Completion Idris.Core.Binary
    Idris.Core.CaseTree Idris.Core.Constraints Idris.Core.DeepSeq
    Idris.Core.Elaborate Idris.Core.Evaluate Idris.Core.Execute
    Idris.Core.ProofState Idris.Core.ProofTerm Idris.Core.TT
    Idris.Core.Typecheck Idris.Core.Unify Idris.Core.WHNF
    Idris.Coverage Idris.DSL Idris.DataOpts Idris.DeepSeq
    Idris.Delaborate Idris.Directives Idris.Docs Idris.Docstrings
    Idris.Elab.AsPat Idris.Elab.Clause Idris.Elab.Data
    Idris.Elab.Implementation Idris.Elab.Interface Idris.Elab.Provider
    Idris.Elab.Quasiquote Idris.Elab.Record Idris.Elab.Rewrite
    Idris.Elab.RunElab Idris.Elab.Term Idris.Elab.Transform
    Idris.Elab.Type Idris.Elab.Utils Idris.Elab.Value Idris.ElabDecls
    Idris.Erasure Idris.ErrReverse Idris.Error Idris.Help Idris.IBC
    Idris.IdeMode Idris.IdrisDoc Idris.Imports Idris.Info
    Idris.Info.Show Idris.Inliner Idris.Interactive Idris.Main
    Idris.ModeCommon Idris.Options Idris.Output Idris.Package
    Idris.Package.Common Idris.Package.Parser Idris.Parser
    Idris.Parser.Data Idris.Parser.Expr Idris.Parser.Helpers
    Idris.Parser.Ops Idris.Parser.Stack Idris.PartialEval
    Idris.Primitives Idris.ProofSearch Idris.Prover Idris.Providers
    Idris.REPL Idris.REPL.Browse Idris.REPL.Commands Idris.REPL.Parser
    Idris.Reflection Idris.Termination Idris.Transforms
    Idris.TypeSearch Idris.Unlit Idris.WhoCalls Util.DynamicLinker
    Util.ScreenSize Util.System

hidden-modules:
    Util.Pretty Util.Net Paths_idris Version_idris Tools_idris
    BuildFlags_idris

import-dirs:          /usr/lib/ghc-9.0.1/site-local/idris-1.3.3
library-dirs:         /usr/lib/ghc-9.0.1/site-local/idris-1.3.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/idris
hs-libraries:         HSidris-1.3.3-DVfEDQFdHKxIxDPikYJLu2
extra-libraries:      gmp
depends:
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs
    annotated-wl-pprint-0.7.0-70TwcJulbP410FZMDCXWmO
    ansi-terminal-0.11-DOUngjGM5e9DBdxKKdJoVq
    ansi-wl-pprint-0.6.9-BXMgVftyT2QAgtHXr6JIlm array-0.5.4.0
    async-2.2.3-9hcO3XZAP863cAPa5inA8N base-4.15.0.0
    base64-bytestring-1.2.1.0-1T6dUoRSPJz5Ioae8XlZq2 binary-0.8.8.0
    blaze-html-0.9.1.2-KB0lS4ujoOZB0BWG67YZVZ
    blaze-markup-0.8.2.8-8PH9vh1UAZb2ZrMELNvjH9 bytestring-0.10.12.1
    cheapskate-0.1.1.2-AtCDMsgSau8HbLKS5bjTsP
    code-page-0.2.1-CYVTpGA5RICHN6wyF6l377 containers-0.6.4.1
    deepseq-1.4.5.0 directory-1.3.6.1 filepath-1.4.2.1
    fingertree-0.1.4.2-9J2gUWTCQY5GuREJSkXzUp
    fsnotify-0.3.0.1-8Hesh2nJhwpESUCPt3dopX haskeline-0.8.1.0
    ieee754-0.8.0-DCmgNmM9a4g4zjg2yOVRf
    libffi-0.1-6JV49STIEUfA7HvLqLSQvL
    megaparsec-9.2.0-LDByiSVjBO1EnZacitxvZW mtl-2.2.2
    network-3.1.2.2-HXcjy5szECnDN1PS9jNchP
    optparse-applicative-0.16.1.0-Hmp4enGFORO7G3xu1QJ5as
    parser-combinators-1.3.0-5jHqYWwdpCqFWQLuYLRvi6 pretty-1.1.3.6
    process-1.6.11.0 regex-tdfa-1.3.1.1-JysT5HHQf7SDqagoTfdJw
    safe-0.3.19-BCcHjTM7bV690cTfMWPidj
    split-0.2.3.4-BM0SHXGG6RG9udnJVWQWWX
    terminal-size-0.3.2.1-8rLUbNor4uN6iQgtxjW6lw text-1.2.4.1
    time-1.9.3 transformers-0.5.6.2
    uniplate-1.6.13-2uz31erAwds7VFkT8cOsFY unix-2.7.2.2
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX
    utf8-string-1.0.2-FSV4F6pxd5y7PjtRkbEpDf
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL
    vector-binary-instances-0.2.5.2-20zf7Gm3C4DADIkedFqC2R
    zip-archive-0.4.1-Lieq7SJeCzrEKDiRptI22s

haddock-interfaces:   /usr/share/doc/idris/html/idris.haddock
haddock-html:         /usr/share/doc/idris/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

