#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 pandoc
version:              2.14.1
visibility:           public
id:                   pandoc-2.14.1-9RHFdgCL4bL9fWRb98dm5f
key:                  pandoc-2.14.1-9RHFdgCL4bL9fWRb98dm5f
license:              GPL-2.0-or-later
copyright:            (c) 2006-2021 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. It can read several dialects of Markdown and
    (subsets of) HTML, reStructuredText, LaTeX, DocBook, JATS,
    MediaWiki markup, DokuWiki markup, TWiki markup,
    TikiWiki markup, Jira markup, Creole 1.0, Haddock markup,
    OPML, Emacs Org-Mode, Emacs Muse, txt2tags, ipynb (Jupyter
    notebooks), Vimwiki, Word Docx, ODT, EPUB, FictionBook2,
    roff man, Textile, BibTeX, BibLaTeX, CSL JSON,
    , and CSV, and it can write Markdown,
    reStructuredText, XHTML, HTML 5, LaTeX, ConTeXt, DocBook,
    JATS, OPML, TEI, OpenDocument, ODT, Word docx,
    PowerPoint pptx, RTF, MediaWiki, DokuWiki, XWiki,
    ZimWiki, Textile, Jira, roff man, roff ms, plain text,
    Emacs Org-Mode, AsciiDoc, Haddock markup,
    EPUB (v2 and v3), ipynb, FictionBook2,
    InDesign ICML, Muse, CSL JSON, LaTeX beamer slides,
    and several kinds of HTML/JavaScript slide shows
    (S5, Slidy, Slideous, DZSlides, reveal.js).

    In contrast to most existing tools for converting Markdown
    to HTML, pandoc has a modular design: it consists of a set of
    readers, which parse text in a given format and produce a
    native representation of the document, and a set of writers,
    which convert this native representation into a target
    format. Thus, adding an input or output format requires
    only adding a reader or writer.

category:             Text
abi:                  4873cd2c3eedd8693dfa9326dfba6e0e
exposed:              True
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify
    Text.Pandoc.Citeproc Text.Pandoc.Class Text.Pandoc.Emoji
    Text.Pandoc.Error Text.Pandoc.Extensions Text.Pandoc.Filter
    Text.Pandoc.Highlighting Text.Pandoc.ImageSize Text.Pandoc.Logging
    Text.Pandoc.Lua Text.Pandoc.MIME Text.Pandoc.MediaBag
    Text.Pandoc.Options Text.Pandoc.PDF Text.Pandoc.Parsing
    Text.Pandoc.Process Text.Pandoc.Readers Text.Pandoc.Readers.BibTeX
    Text.Pandoc.Readers.CSV Text.Pandoc.Readers.CommonMark
    Text.Pandoc.Readers.Creole Text.Pandoc.Readers.CslJson
    Text.Pandoc.Readers.DocBook Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.DokuWiki Text.Pandoc.Readers.EPUB
    Text.Pandoc.Readers.FB2 Text.Pandoc.Readers.HTML
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.Ipynb
    Text.Pandoc.Readers.JATS Text.Pandoc.Readers.Jira
    Text.Pandoc.Readers.LaTeX Text.Pandoc.Readers.Man
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.MediaWiki
    Text.Pandoc.Readers.Muse Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.OPML Text.Pandoc.Readers.Odt
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.RST
    Text.Pandoc.Readers.TWiki Text.Pandoc.Readers.Textile
    Text.Pandoc.Readers.TikiWiki Text.Pandoc.Readers.Txt2Tags
    Text.Pandoc.Readers.Vimwiki Text.Pandoc.SelfContained
    Text.Pandoc.Shared Text.Pandoc.Sources Text.Pandoc.Templates
    Text.Pandoc.UTF8 Text.Pandoc.Writers
    Text.Pandoc.Writers.AnnotatedTable Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.BibTeX Text.Pandoc.Writers.CommonMark
    Text.Pandoc.Writers.ConTeXt Text.Pandoc.Writers.CslJson
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.Docx Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.HTML Text.Pandoc.Writers.Haddock
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.Ipynb
    Text.Pandoc.Writers.JATS Text.Pandoc.Writers.Jira
    Text.Pandoc.Writers.LaTeX Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.Math
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.Ms
    Text.Pandoc.Writers.Muse Text.Pandoc.Writers.Native
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.OOXML
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.Powerpoint
    Text.Pandoc.Writers.RST Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.Shared Text.Pandoc.Writers.TEI
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.XWiki Text.Pandoc.Writers.ZimWiki
    Text.Pandoc.XML

hidden-modules:
    Text.Pandoc.App.CommandLineOptions Text.Pandoc.App.FormatHeuristics
    Text.Pandoc.App.Opt Text.Pandoc.App.OutputSettings
    Text.Pandoc.Class.CommonState Text.Pandoc.Class.IO
    Text.Pandoc.Class.PandocMonad Text.Pandoc.Class.PandocIO
    Text.Pandoc.Class.PandocPure Text.Pandoc.Filter.JSON
    Text.Pandoc.Filter.Lua Text.Pandoc.Filter.Path
    Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
    Text.Pandoc.Readers.Docx.Parse
    Text.Pandoc.Readers.Docx.Parse.Styles Text.Pandoc.Readers.Docx.Util
    Text.Pandoc.Readers.Docx.Fields Text.Pandoc.Readers.HTML.Parsing
    Text.Pandoc.Readers.HTML.Table
    Text.Pandoc.Readers.HTML.TagCategories
    Text.Pandoc.Readers.HTML.Types Text.Pandoc.Readers.LaTeX.Inline
    Text.Pandoc.Readers.LaTeX.Citation Text.Pandoc.Readers.LaTeX.Lang
    Text.Pandoc.Readers.LaTeX.Macro Text.Pandoc.Readers.LaTeX.Math
    Text.Pandoc.Readers.LaTeX.Parsing Text.Pandoc.Readers.LaTeX.SIunitx
    Text.Pandoc.Readers.LaTeX.Table Text.Pandoc.Readers.LaTeX.Types
    Text.Pandoc.Readers.Odt.Base Text.Pandoc.Readers.Odt.Namespaces
    Text.Pandoc.Readers.Odt.StyleReader
    Text.Pandoc.Readers.Odt.ContentReader
    Text.Pandoc.Readers.Odt.Generic.Fallible
    Text.Pandoc.Readers.Odt.Generic.SetMap
    Text.Pandoc.Readers.Odt.Generic.Utils
    Text.Pandoc.Readers.Odt.Generic.Namespaces
    Text.Pandoc.Readers.Odt.Generic.XMLConverter
    Text.Pandoc.Readers.Odt.Arrows.State
    Text.Pandoc.Readers.Odt.Arrows.Utils
    Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
    Text.Pandoc.Readers.Org.DocumentTree
    Text.Pandoc.Readers.Org.ExportSettings
    Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
    Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
    Text.Pandoc.Readers.Org.Shared Text.Pandoc.Readers.Metadata
    Text.Pandoc.Readers.Roff Text.Pandoc.Writers.Docx.StyleMap
    Text.Pandoc.Writers.Docx.Table Text.Pandoc.Writers.Docx.Types
    Text.Pandoc.Writers.GridTable Text.Pandoc.Writers.JATS.References
    Text.Pandoc.Writers.JATS.Table Text.Pandoc.Writers.JATS.Types
    Text.Pandoc.Writers.LaTeX.Caption Text.Pandoc.Writers.LaTeX.Notes
    Text.Pandoc.Writers.LaTeX.Table Text.Pandoc.Writers.LaTeX.Lang
    Text.Pandoc.Writers.LaTeX.Types Text.Pandoc.Writers.LaTeX.Citation
    Text.Pandoc.Writers.LaTeX.Util Text.Pandoc.Writers.Markdown.Types
    Text.Pandoc.Writers.Markdown.Inline Text.Pandoc.Writers.Roff
    Text.Pandoc.Writers.Powerpoint.Presentation
    Text.Pandoc.Writers.Powerpoint.Output
    Text.Pandoc.Lua.ErrorConversion Text.Pandoc.Lua.Filter
    Text.Pandoc.Lua.Global Text.Pandoc.Lua.Init
    Text.Pandoc.Lua.Marshaling Text.Pandoc.Lua.Marshaling.AST
    Text.Pandoc.Lua.Marshaling.AnyValue
    Text.Pandoc.Lua.Marshaling.CommonState
    Text.Pandoc.Lua.Marshaling.Context Text.Pandoc.Lua.Marshaling.List
    Text.Pandoc.Lua.Marshaling.MediaBag
    Text.Pandoc.Lua.Marshaling.PandocError
    Text.Pandoc.Lua.Marshaling.ReaderOptions
    Text.Pandoc.Lua.Marshaling.SimpleTable
    Text.Pandoc.Lua.Marshaling.Version Text.Pandoc.Lua.Module.MediaBag
    Text.Pandoc.Lua.Module.Pandoc Text.Pandoc.Lua.Module.System
    Text.Pandoc.Lua.Module.Types Text.Pandoc.Lua.Module.Utils
    Text.Pandoc.Lua.Packages Text.Pandoc.Lua.PandocLua
    Text.Pandoc.Lua.Util Text.Pandoc.Lua.Walk Text.Pandoc.XML.Light
    Text.Pandoc.XML.Light.Types Text.Pandoc.XML.Light.Proc
    Text.Pandoc.XML.Light.Output Text.Pandoc.CSS Text.Pandoc.CSV
    Text.Pandoc.RoffChar Text.Pandoc.UUID Text.Pandoc.Translations
    Text.Pandoc.Slides Text.Pandoc.Image Text.Pandoc.Citeproc.BibTeX
    Text.Pandoc.Citeproc.CslJson Text.Pandoc.Citeproc.Data
    Text.Pandoc.Citeproc.Locator Text.Pandoc.Citeproc.MetaValue
    Text.Pandoc.Citeproc.Util Paths_pandoc

import-dirs:          /usr/lib/ghc-9.0.1/site-local/pandoc-2.14.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/pandoc-2.14.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/pandoc
hs-libraries:         HSpandoc-2.14.1-9RHFdgCL4bL9fWRb98dm5f
depends:
    Glob-0.10.2-IjufxCfuL2iDDJXTBrJ8rg
    HTTP-4000.3.16-47PIRMcNTfUEK5XzWQH8Hw
    HsYAML-0.2.1.0-LAsgCVHgNRz6f9JP8l2UCC
    JuicyPixels-3.3.6-5yAP8iT0aIeEE4pgU9R0vo
    SHA-1.6.4.4-7e0sYz0lBWb1CdwjpynTkG
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs
    aeson-pretty-0.8.9-4VpDxWXnDJA8Bu2hhX3Ado array-0.5.4.0
    attoparsec-0.14.1-B8P567zH1pOF107V9enGUK base-4.15.0.0
    base64-bytestring-1.2.1.0-1T6dUoRSPJz5Ioae8XlZq2 binary-0.8.8.0
    blaze-html-0.9.1.2-KB0lS4ujoOZB0BWG67YZVZ
    blaze-markup-0.8.2.8-8PH9vh1UAZb2ZrMELNvjH9 bytestring-0.10.12.1
    case-insensitive-1.2.1.0-810KinvQcYx7xuCoSIHpwY
    citeproc-0.4.1-5HplXFxEeXxBE3V7ioofzb
    commonmark-0.2.1-5Gf7xWEODtsFeV6J7YsOcm
    commonmark-extensions-0.2.1.2-HOz2NwvtQ7QDV9iAFDxLB0
    commonmark-pandoc-0.2.1.1-Bbe3kzUHhTM3ZKU7GXPoN7
    connection-0.3.1-H4KhtDdubpW9iyDC57W5cr containers-0.6.4.1
    data-default-0.7.1.1-5RJjHNv19ESJeD93LU2jRn deepseq-1.4.5.0
    directory-1.3.6.1 doclayout-0.3.0.2-L2xJHHFXdLOHIwvIdowM95
    doctemplates-0.10.0.1-7jiNL6qdXVT35FdHMBFVFH
    emojis-0.1-J7GYQrMPfSAExkhwN0NeBn exceptions-0.10.4
    file-embed-0.0.14.0-DpVDNlFaM0M9fTuZiTfuRf filepath-1.4.2.1
    haddock-library-1.10.0-6rGY9xFNd4T5spKGwkORJB
    hslua-1.3.0.1-1o4YmhkhdSXEXz3hy6nfXx
    hslua-module-path-0.1.0.1-6qxeEoOURc5LPSVa7giF1d
    hslua-module-system-0.2.2.1-Ew6R5KwNFSw4ZujqFwnlFJ
    hslua-module-text-0.3.0.1-JU6kTkGZQOCFiD3uciH53B
    http-client-0.7.9-7wDH1vBZ53F4ywxYQ5UKER
    http-client-tls-0.3.5.3-7hBZQpnwFgt4IofGsLNJcL
    http-types-0.12.3-J3pS8fDTy4j62mHquuNqa5
    ipynb-0.1.0.1-7MBlNQP1BeT9VbWC6TihJP
    jira-wiki-markup-1.4.0-D0DokfJeXTRKsdLsuuL3U4 mtl-2.2.2
    network-3.1.2.2-HXcjy5szECnDN1PS9jNchP
    network-uri-2.6.4.1-BnEimF9gukhI4cE0Ew2RUr
    pandoc-types-1.22-CvHsUw0mT5oDQ6Epv01rf5 parsec-3.1.14.0
    process-1.6.11.0 random-1.2.1-Iy7yOfCz74T6VyvkhFUFfX
    safe-0.3.19-BCcHjTM7bV690cTfMWPidj
    scientific-0.3.7.0-80Xt5iXHAGIBd7njyVx1yZ
    skylighting-0.11-KQyarW80JNwF472RXVCIU9
    skylighting-core-0.11-MBsGqfdKCi2u5NMJO1pgJ
    split-0.2.3.4-BM0SHXGG6RG9udnJVWQWWX
    syb-0.7.2.1-1KAKIfi7jVfHb7rx2ko4wD
    tagsoup-0.14.8-7sYPJCLaWmJ8tJLTduobQE
    temporary-1.3-6FIxg0ZrJD07j9FbKd9D73
    texmath-0.12.3.1-9tJ2p0jEiKU1MZL1r9ZUrr text-1.2.4.1
    text-conversions-0.3.1-JMYEIdXTQc3DS8mbL95eZg time-1.9.3
    unicode-collation-0.1.3.1-6X6KQLFRGZZICR5dKy37KI
    unicode-transforms-0.3.8-6CkzGFVdNEmJF9QGGvzfpZ unix-2.7.2.2
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX
    xml-1.3.14-21i4vhiJSXU6kuSJCTj4ZG
    xml-conduit-1.9.1.1-8szrhDccdR56PHnyZ5pHlE
    zip-archive-0.4.1-Lieq7SJeCzrEKDiRptI22s
    zlib-0.6.2.3-6H3hMes2qwq6KLF45PsaZ5

haddock-interfaces:   /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

