/*!
* OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(['./NavContainer','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/core/IntervalTrigger','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/core/Icon','sap/ui/model/Filter','./FacetFilterRenderer',"sap/ui/events/KeyCodes","sap/base/assert","sap/base/Log","sap/ui/events/jquery/EventSimulation","sap/ui/thirdparty/jquery","sap/m/Button","sap/m/ToolbarSpacer","sap/m/OverflowToolbar","sap/m/Text","sap/m/Toolbar","sap/m/Popover","sap/m/SearchField","sap/m/Bar","sap/m/Dialog","sap/m/List","sap/m/StandardListItem","sap/m/CheckBox","sap/m/Page","sap/ui/dom/jquery/scrollRightRTL","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/Selectors"],function(N,l,C,I,a,b,c,D,M,d,F,e,K,f,L,E,q,B,T,O,g,h,P,S,m,n,o,p,r,s){"use strict";var t=l.ToolbarDesign;var u=l.ListType;var v=l.ListMode;var w=l.FacetFilterListDataType;var x=l.ButtonType;var y=l.PlacementType;var z=l.FacetFilterType;var A=C.extend("sap.m.FacetFilter",{metadata:{interfaces:["sap.ui.core.IShrinkable"],library:"sap.m",properties:{showPersonalization:{type:"boolean",group:"Appearance",defaultValue:false},type:{type:"sap.m.FacetFilterType",group:"Appearance",defaultValue:z.Simple},liveSearch:{type:"boolean",group:"Behavior",defaultValue:true},showSummaryBar:{type:"boolean",group:"Behavior",defaultValue:false},showReset:{type:"boolean",group:"Behavior",defaultValue:true},showPopoverOKButton:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"lists",aggregations:{lists:{type:"sap.m.FacetFilterList",multiple:true,singularName:"list"},buttons:{type:"sap.m.Button",multiple:true,singularName:"button",visibility:"hidden"},removeFacetIcons:{type:"sap.ui.core.Icon",multiple:true,singularName:"removeFacetIcon",visibility:"hidden"},popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"},addFacetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},summaryBar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},resetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},arrowLeft:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},arrowRight:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{reset:{},confirm:{}}}});A.SCROLL_STEP=264;A.prototype.setType=function(i){var j,k;if(D.system.phone){this.setProperty("type",z.Light);k=true;}else{this.setProperty("type",i);k=(i===z.Light);}j=this._getSummaryBar();j.setActive(k);if(i===z.Light){if(this.getShowReset()){this._addResetToSummary(j);}else{this._removeResetFromSummary(j);}}return this;};A.prototype.setShowReset=function(V){this.setProperty("showReset",V);var i=this._getSummaryBar();if(V){if(this.getShowSummaryBar()||this.getType()===z.Light){this._addResetToSummary(i);}}else{if(this.getShowSummaryBar()||this.getType()===z.Light){this._removeResetFromSummary(i);}}return this;};A.prototype.setShowSummaryBar=function(V){this.setProperty("showSummaryBar",V);if(V){var i=this._getSummaryBar();if(this.getShowReset()){this._addResetToSummary(i);}else{this._removeResetFromSummary(i);}i.setActive(this.getType()===z.Light);}return this;};A.prototype.setLiveSearch=function(V){this.setProperty("liveSearch",V);if(this._displayedList){var i=this._displayedList;var j=sap.ui.getCore().byId(i.getAssociation("search"));j.detachLiveChange(i._handleSearchEvent,i);if(V){j.attachLiveChange(i._handleSearchEvent,i);}}return this;};A.prototype.getLists=function(){var i=this.getAggregation("lists");if(!i){i=[];}if(this._displayedList){i.splice(this._listAggrIndex,0,this._displayedList);}i.forEach(function(j){if(!j.hasListeners("listItemsChange")){j.attachEvent("listItemsChange",_.bind(this));}}.bind(this));return i;};function _(i){var j=i.getSource();if(this._oAllCheckBoxBar){this._oAllCheckBoxBar.setVisible(Boolean(j.getItems(true).length));}}A.prototype.removeList=function(i){var j=M.prototype.removeAggregation.call(this,"lists",i);this._removeList(j);return j;};A.prototype.removeAggregation=function(){var i=M.prototype.removeAggregation.apply(this,arguments);if(arguments[0]==="lists"){this._removeList(i);}return i;};A.prototype.openFilterDialog=function(){var i=this._getFacetDialog();var j=this._getFacetDialogNavContainer();i.addContent(j);this.getLists().forEach(function(k){if(k.getMode()===v.MultiSelect){k._preserveOriginalActiveState();}});i.setInitialFocus(j.getPages()[0].getContent()[0].getItems()[0]);i.open();return this;};A.prototype.init=function(){this._pageSize=5;this._addDelegateFlag=false;this._invalidateFlag=false;this._lastCategoryFocusIndex=0;this._aDomRefs=null;this._previousTarget=null;this._addTarget=null;this._aRows=null;this._bundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.data("sap-ui-fastnavgroup","true",true);this._buttons={};this._aOwnedLabels=[];this._removeFacetIcons={};this._listAggrIndex=-1;this._displayedList=null;this._lastScrolling=false;this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._getAddFacetButton();this.setAggregation("resetButton",this._createResetButton());if(E.touchEventMode==="ON"&&!D.system.phone){this._enableTouchSupport();}if(D.system.phone){this.setType(z.Light);}};A.prototype.exit=function(){var i;c.removeListener(this._checkOverflow,this);if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();}if(this._aOwnedLabels){this._aOwnedLabels.forEach(function(j){i=sap.ui.getCore().byId(j);if(i){i.destroy();}});this._aOwnedLabels=null;}if(this._oAllCheckBoxBar){this._oAllCheckBoxBar=undefined;}};A.prototype.onBeforeRendering=function(){if(this.getShowSummaryBar()||this.getType()===z.Light){var i=this._getSummaryBar();var j=i.getContent()[0];j.setText(this._getSummaryText());}c.removeListener(this._checkOverflow,this);};A.prototype.onAfterRendering=function(){var i=this.getShowSummaryBar(),j=this.getType(),k=this._getSummaryBar().$();if(j!==z.Light&&!D.system.phone){c.addListener(this._checkOverflow,this);}if(j!==z.Light){this._startItemNavigation();}if(j===z.Light){k.attr("aria-roledescription",this._bundle.getText("FACETFILTER_ACTIVE_TITLE"));k.attr("role","group");}else if(i){k.attr("aria-roledescription",this._bundle.getText("FACETFILTER_TITLE"));}};A.prototype._startItemNavigation=function(){var j=this.getDomRef(),R=j.getElementsByClassName("sapMFFHead"),k=[];if(R.length>0){for(var i=0;i<R[0].childNodes.length;i++){if(R[0].childNodes[i].id.indexOf("ff")<0&&R[0].childNodes[i].id.indexOf("icon")<0&&R[0].childNodes[i].id.indexOf("add")<0){k.push(R[0].childNodes[i]);}if(R[0].childNodes[i].id.indexOf("add")>=0){k.push(R[0].childNodes[i]);}}}if(k!=""){this._aDomRefs=k;}if((!this.oItemNavigation)||this._addDelegateFlag==true){this.oItemNavigation=new a();this.addDelegate(this.oItemNavigation);this._addDelegateFlag=false;}this._aRows=R;for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].id.indexOf("add")>=0){this._addTarget=this.$().find(":sapTabbable")[i];break;}}this.oItemNavigation.setRootDomRef(j);this.oItemNavigation.setItemDomRefs(k);this.oItemNavigation.setCycling(false);this.oItemNavigation.setPageSize(this._pageSize);};A.prototype.onsapdelete=function(i){var j,G;if(this.getType()===z.Light){return;}if(!this.getShowPersonalization()){return;}j=sap.ui.getCore().byId(i.target.id);if(!j){return;}G=sap.ui.getCore().byId(j.getAssociation("list"));if(!G){return;}if(!G.getShowRemoveFacetIcon()){return;}G.removeSelections(true);G.setSelectedKeys();G.setProperty("active",false,true);this.invalidate();var $=this.$().find(":sapTabbable");q($[$.length-1]).trigger("focus");var H=this.oItemNavigation.getFocusedIndex();q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(H+1);this.focus();if(this.oItemNavigation.getFocusedIndex()==0){for(var k=0;k<this.$().find(":sapTabbable").length-1;k++){if($[k].id.indexOf("add")>=0){q($[k]).trigger("focus");}}}};A.prototype.onsaptabnext=function(j){if(this.getType()===z.Light){return;}this._previousTarget=j.target;if(j.target.parentNode.className=="sapMFFHead"){for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].parentNode.className=="sapMFFResetDiv"){q(this.$().find(":sapTabbable")[i]).trigger("focus");this._invalidateFlag=false;j.preventDefault();j.setMarked();return;}}}this._lastCategoryFocusIndex=this.oItemNavigation.getFocusedIndex();if(this._invalidateFlag==true){this.oItemNavigation.setFocusedIndex(-1);this.focus();this._invalidateFlag=false;}};A.prototype.onsaptabprevious=function(i){if(this.getType()===z.Light){return;}if(i.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget==null){q(this.$().find(":sapTabbable")[0]).trigger("focus");i.preventDefault();i.setMarked();return;}if(i.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget!=null&&this._previousTarget.id!=i.target.id){q(this._previousTarget).trigger("focus");i.preventDefault();i.setMarked();return;}if(i.target.id.indexOf("add")>=0||i.target.parentNode.className=="sapMFFHead"){this._previousTarget=i.target;q(this.$().find(":sapTabbable")[0]).trigger("focus");}};A.prototype.onsapend=function(i){if(this.getType()===z.Light){return;}if(this._addTarget!=null){q(this._addTarget).trigger("focus");i.preventDefault();i.setMarked();}else{q(this._aRows[this._aRows.length-1]).trigger("focus");i.preventDefault();i.setMarked();}this._previousTarget=i.target;};A.prototype.onsaphome=function(i){if(this.getType()===z.Light){return;}q(this._aRows[0]).trigger("focus");i.preventDefault();i.setMarked();this._previousTarget=i.target;};A.prototype.onsappageup=function(i){this._previousTarget=i.target;};A.prototype.onsappagedown=function(i){this._previousTarget=i.target;};A.prototype.onsapincreasemodifiers=function(i){if(this.getType()===z.Light){return;}if(i.which==K.ARROW_RIGHT){this._previousTarget=i.target;var j=this.oItemNavigation.getFocusedIndex()-1;var k=j+this._pageSize;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(k);this.focus();}};A.prototype.onsapdecreasemodifiers=function(i){if(this.getType()===z.Light){return;}var j=0;if(i.which==K.ARROW_LEFT){this._previousTarget=i.target;j=this.oItemNavigation.getFocusedIndex()+1;var k=j-this._pageSize;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(k);this.focus();}};A.prototype.onsapdownmodifiers=function(i){if(this.getType()===z.Light){return;}this._previousTarget=i.target;var j=0;j=this.oItemNavigation.getFocusedIndex()-1;var k=j+this._pageSize;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(k);this.focus();};A.prototype.onsapupmodifiers=function(i){if(this.getType()===z.Light){return;}this._previousTarget=i.target;var j=0;j=this.oItemNavigation.getFocusedIndex();if(j!=0){j=j+1;}var k=j-this._pageSize;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(k);this.focus();};A.prototype.onsapexpand=function(i){if(this.getType()===z.Light){return;}this._previousTarget=i.target;var j=this.oItemNavigation.getFocusedIndex()+1;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(j);this.focus();};A.prototype.onsapcollapse=function(i){if(this.getType()===z.Light){return;}this._previousTarget=i.target;var j=this.oItemNavigation.getFocusedIndex()-1;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(j);this.focus();};A.prototype.onsapdown=function(i){if(this.getType()===z.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).trigger("focus");i.preventDefault();i.setMarked();return;}};A.prototype.onsapup=function(i){if(this.getType()===z.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).trigger("focus");i.preventDefault();i.setMarked();}};A.prototype.onsapleft=function(i){if(this.getType()===z.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).trigger("focus");i.preventDefault();i.setMarked();}};A.prototype.onsapright=function(i){if(this.getType()===z.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).trigger("focus");i.preventDefault();i.setMarked();}};A.prototype.onsapescape=function(i){if(this.getType()===z.Light){return;}if(i.target.parentNode.className=="sapMFFResetDiv"){return;}var j=this._lastCategoryFocusIndex;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(j);this.focus();};A.prototype._getPopover=function(){var i=this.getAggregation("popover");if(!i){var j=this;i=new P({placement:y.Bottom,beforeOpen:function(G){if(j._displayedList){j._displayedList._bSearchEventDefaultBehavior&&j._displayedList._setSearchValue("");}this.setCustomHeader(j._createFilterItemsSearchFieldBar(j._displayedList));var H=this.getSubHeader();if(!H){this.setSubHeader(j._createSelectAllCheckboxBar(j._displayedList));}k(j._displayedList);},afterClose:function(G){j._addDelegateFlag=true;j._handlePopoverAfterClose();},horizontalScrolling:false});this.setAggregation("popover",i,true);i.setContentWidth("30%");i.addStyleClass("sapMFFPop");var k=function(G){if(!G){return;}var H=j._getFacetRemoveIcon(G);if(H){H._bTouchStarted=false;}};}if(this.getShowPopoverOKButton()){this._addOKButtonToPopover(i);}else{i.destroyAggregation("footer");}return i;};A.prototype._handlePopoverAfterClose=function(){var i=this.getAggregation("popover"),j=this._displayedList;if(!i){return;}var k=this._getFacetRemoveIcon(j);if(k&&k._bTouchStarted){return;}this._restoreListFromDisplayContainer(i);this._displayRemoveIcon(false,j);j._fireListCloseEvent();this._fireConfirmEvent();this.destroyAggregation("popover");if(this._oOpenPopoverDeferred){setTimeout(function(){this._oOpenPopoverDeferred.resolve();this._oOpenPopoverDeferred=undefined;}.bind(this),0);}};A.prototype._fireConfirmEvent=function(){this.fireEvent('confirm');};A.prototype._openPopover=function(i,j){var k;if(!i.isOpen()){var G=sap.ui.getCore().byId(j.getAssociation("list"));f(G,"The facet filter button should be associated with a list.");k=!G.fireListOpen({});this._moveListToDisplayContainer(G,i);i.openBy(j);if(G.getShowRemoveFacetIcon()){this._displayRemoveIcon(true,G);}if(G.getWordWrap()){i.setContentWidth("30%");}if(!k){G._applySearch();}}return this;};A.prototype._getAddFacetButton=function(){var i=this.getAggregation("addFacetButton");if(!i){i=new B(this.getId()+"-add",{icon:I.getIconURI("add-filter"),type:x.Transparent,tooltip:this._bundle.getText("FACETFILTER_ADDFACET"),press:function(j){this.openFilterDialog();}.bind(this)});this.setAggregation("addFacetButton",i,true);}return i;};A.prototype._getButtonForList=function(i){if(this._buttons[i.getId()]){this._setButtonText(i);return this._buttons[i.getId()];}var j=this;var k=new B({type:x.Transparent,press:function(G){var H=this;var J=function(){var Q=j._getPopover();j._openPopover(Q,H);};if(i.getMode()===v.MultiSelect){i._preserveOriginalActiveState();}var Q=j._getPopover();if(Q.isOpen()){setTimeout(function(){if(Q.isOpen()){return;}j._oOpenPopoverDeferred=q.Deferred();j._oOpenPopoverDeferred.promise().done(J);},100);}else{setTimeout(J.bind(this),100);}}});this._buttons[i.getId()]=k;this.addAggregation("buttons",k);k.setAssociation("list",i.getId(),true);this._setButtonText(i);return k;};A.prototype._setButtonText=function(i){var j=this._buttons[i.getId()];if(i._iAllItemsCount===undefined&&i.getMaxItemsCount()||!i._bSearchEventDefaultBehavior){i._iAllItemsCount=i.getMaxItemsCount();}if(j){var k="";var G=Object.getOwnPropertyNames(i._oSelectedKeys);var H=G.length;if(H===1){var J=i._oSelectedKeys[G[0]];k=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[i.getTitle(),J]);}else if(H>0&&H===(i._iAllItemsCount?i._iAllItemsCount:0)){k=this._bundle.getText("FACETFILTER_ALL_SELECTED",[i.getTitle()]);}else if(H>0){k=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[i.getTitle(),H]);}else{k=i.getTitle();}j.setText(k);}};A.prototype._getFacetRemoveIcon=function(i){var j=this,k=this._removeFacetIcons[i.getId()];if(!k){k=new d({src:I.getIconURI("decline"),tooltip:this._bundle.getText("FACETFILTER_REMOVE"),press:function(){k._bPressed=true;}});k.addDelegate({ontouchstart:function(){k._bTouchStarted=true;k._bPressed=false;},ontouchend:function(){j._displayRemoveIcon(false,i);k._bTouchStarted=false;setTimeout(G.bind(this),100);}},true);var G=function(){if(k._bPressed){i.removeSelections(true);i.setSelectedKeys();i.setProperty("active",false,true);}j._handlePopoverAfterClose();};k.setAssociation("list",i.getId(),true);k.addStyleClass("sapMFFLRemoveIcon");this._removeFacetIcons[i.getId()]=k;this.addAggregation("removeFacetIcons",k);this._displayRemoveIcon(false,i);}return k;};A.prototype._displayRemoveIcon=function(i,j){if(this.getShowPersonalization()){var k=this._removeFacetIcons[j.getId()];if(i){k.removeStyleClass("sapMFFLHiddenRemoveIcon");k.addStyleClass("sapMFFLVisibleRemoveIcon");}else{k.removeStyleClass("sapMFFLVisibleRemoveIcon");k.addStyleClass("sapMFFLHiddenRemoveIcon");}}};A.prototype._getFacetDialogNavContainer=function(){var i=new N({autoFocus:false});var j=this._createFacetPage();i.addPage(j);i.setInitialPage(j);i.attachAfterNavigate(function(k){var G=k.getParameters()["to"];var H=k.getParameters()['from'];if(H===j){var J=(this._displayedList.getMode()===v.MultiSelect)?G.getContent(0)[1].getItems()[0]:G.getContent(0)[0].getItems()[0];if(J){J.focus();}}if(G===j){H.destroySubHeader();f(this._displayedList===null,"Filter items list should have been placed back in the FacetFilter aggregation before page content is destroyed.");H.destroyContent();this._selectedFacetItem.invalidate();G.invalidate();this._selectedFacetItem.focus();this._selectedFacetItem=null;}}.bind(this));return i;};A.prototype._createFacetPage=function(){var i=this._createFacetList();var j=new S({width:"100%",tooltip:this._bundle.getText("FACETFILTER_SEARCH"),liveChange:function(G){var H=i.getBinding("items");if(H){var J=new F("text",sap.ui.model.FilterOperator.Contains,G.getParameters()["newValue"]);H.filter([J]);}}});var k=new s({enableScrolling:true,title:this._bundle.getText("FACETFILTER_TITLE"),subHeader:new m({contentMiddle:j}),content:[i]});return k;};A.prototype._createFilterItemsPage=function(){var i=new s({showNavButton:true,enableScrolling:true,navButtonPress:function(j){var k=j.getSource().getParent();this._navFromFilterItemsPage(k);}.bind(this)});return i;};A.prototype._getFilterItemsPage=function(i){var j=i.getPages()[1];if(j){i.removePage(j);j.destroy();}var k=this._createFilterItemsPage();i.addPage(k);return k;};A.prototype._createFilterItemsSearchFieldBar=function(i){var j=true;if(i.getDataType()!=w.String){j=false;}var k=new S({value:i._getSearchValue(),width:"100%",enabled:j,tooltip:this._bundle.getText("FACETFILTER_SEARCH"),search:function(H){this._displayedList._handleSearchEvent(H);}.bind(this)});if(this.getLiveSearch()){k.attachLiveChange(i._handleSearchEvent,i);}var G=new m({contentMiddle:k});i.setAssociation("search",k);return G;};A.prototype._getFacetDialog=function(){var i=this.getAggregation("dialog");if(!i){var j=this;i=new n({showHeader:false,stretch:D.system.phone?true:false,afterClose:function(){j._addDelegateFlag=true;j._invalidateFlag=true;var k=this.getContent()[0];var G=k.getPages()[1];if(k.getCurrentPage()===G){var H=j._restoreListFromDisplayContainer(G);if(H.getMode()===v.MultiSelect){H._updateActiveState();j._bCheckForAddListBtn=true;}H._fireListCloseEvent();H._bSearchEventDefaultBehavior&&H._search("");}this.destroyAggregation("content",true);j.invalidate();},beginButton:new B({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),press:function(){j._closeDialog();}}),contentHeight:"500px",ariaLabelledBy:[b.getStaticId("sap.m","FACETFILTER_AVAILABLE_FILTER_NAMES")]});i.addStyleClass("sapMFFDialog");i.onsapentermodifiers=function(k){if(k.shiftKey&&!k.ctrlKey&&!k.altKey){var G=this.getContent()[0];j._navFromFilterItemsPage(G);}};this.setAggregation("dialog",i,true);}return i;};A.prototype._closeDialog=function(){var i=this.getAggregation("dialog");if(i&&i.isOpen()){i.close();this._fireConfirmEvent();}};A.prototype._closePopover=function(){var i=this.getAggregation("popover");if(i&&i.isOpen()){i.close();}};A.prototype._createFacetList=function(){var j=this._oFacetList=new o({mode:v.None,items:{path:"/items",template:new p({title:"{text}",counter:"{count}",type:u.Navigation,customData:[new sap.ui.core.CustomData({key:"index",value:"{index}"})]})}});var k=this._getMapFacetLists();var G=new sap.ui.model.json.JSONModel({items:k});if(k.length>100){G.setSizeLimit(k.length);}var H=this;j.attachUpdateFinished(function(){for(var i=0;i<j.getItems().length;i++){var J=this.getItems()[i];J.detachPress(H._handleFacetListItemPress,H);J.attachPress(H._handleFacetListItemPress,H);}});j.setModel(G);return j;};A.prototype.refreshFacetList=function(){this._oFacetList.getModel().setData({items:this._getMapFacetLists()});return this;};A.prototype._getMapFacetLists=function(){return this.getLists().map(function(i,j){return{text:i.getTitle(),count:i.getAllCount(),index:j};});};A.prototype._createSelectAllCheckboxBar=function(i){if(!i.getMultiSelect()){return null;}var j=i.getActive()&&i.getItems().length>0&&Object.getOwnPropertyNames(i._oSelectedKeys).length===i.getItems().length;var k=new r(i.getId()+"-selectAll",{text:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),tooltip:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),selected:j,select:function(H){k.setSelected(H.getParameter("selected"));i._handleSelectAllClick(H.getParameter("selected"));}});i.setAssociation("allcheckbox",k);var G=new m({visible:Boolean(i.getItems(true).length)});G.addEventDelegate({ontap:function(H){if(H.srcControl===this){i._handleSelectAllClick(k.getSelected());}}},G);G.addContentLeft(k);G.addStyleClass("sapMFFCheckbar");this._oAllCheckBoxBar=G;return G;};A.prototype._handleFacetListItemPress=function(i){this._navToFilterItemsPage(i.getSource());};A.prototype._navToFilterItemsPage=function(i){this._selectedFacetItem=i;var j=this.getAggregation("dialog").getContent()[0];var k=i.getCustomData();f(k.length===1,"There should be exactly one custom data for the original facet list item index");var G=k[0].getValue();var H=this.getLists()[G];this._listIndexAgg=this.indexOfAggregation("lists",H);if(this._listIndexAgg==G){var J=this._getFilterItemsPage(j);H.fireListOpen({});this._moveListToDisplayContainer(H,J);J.setSubHeader(this._createFilterItemsSearchFieldBar(H));var Q=this._createSelectAllCheckboxBar(H);if(Q){J.insertContent(Q,0);}J.setTitle(H.getTitle());j.to(J);}};A.prototype._navFromFilterItemsPage=function(i){var j=i.getPages()[1];var k=this._restoreListFromDisplayContainer(j);if(k.getMode()===v.MultiSelect){k._updateActiveState();}k._fireListCloseEvent();k._bSearchEventDefaultBehavior&&k._search("");this._selectedFacetItem.setCounter(k.getAllCount());i.backToTop();};A.prototype._moveListToDisplayContainer=function(i,j){this._listAggrIndex=this.indexOfAggregation("lists",i);f(this._listAggrIndex>-1,"The lists index should be valid.");M.prototype.removeAggregation.call(this,"lists",i,true);j.addAggregation("content",i,false);i.setAssociation("facetFilter",this,true);this._displayedList=i;};A.prototype._restoreListFromDisplayContainer=function(i){var j=i.removeAggregation("content",this._displayedList,true);this.insertAggregation("lists",j,this._listAggrIndex,j.getActive());this._listAggrIndex=-1;this._displayedList=null;return j;};A.prototype._getSequencedLists=function(){var k=-1;var G=[];var H=this.getLists();if(H.length>0){for(var i=0;i<H.length;i++){if(H[i].getActive()){if(H[i].getSequence()<-1){H[i].setSequence(-1);}else if(H[i].getSequence()>k){k=H[i].getSequence();}G.push(H[i]);}else if(!H[i].getRetainListSequence()){H[i].setSequence(-1);}}for(var j=0;j<G.length;j++){if(G[j].getSequence()<=-1){k+=1;G[j].setSequence(k);}}if(G.length>1){G.sort(function(J,Q){return J.getSequence()-Q.getSequence();});}}return G;};A.prototype._getSummaryBar=function(){var i=this.getAggregation("summaryBar"),j=this.getType();if(!i){var k=new g({maxLines:1});i=new h({content:[k],active:j===z.Light?true:false,design:t.Info,ariaLabelledBy:k,press:function(G){this.openFilterDialog();}.bind(this)});i._setRootAccessibilityRole("group");this.setAggregation("summaryBar",i);}return i;};A.prototype._createResetButton=function(){var j=new B({type:x.Transparent,icon:I.getIconURI("undo"),tooltip:this._bundle.getText("FACETFILTER_RESET"),press:function(k){this._addDelegateFlag=true;this._invalidateFlag=true;this.fireReset();var G=this.getLists();for(var i=0;i<G.length;i++){G[i]._setSearchValue("");G[i]._applySearch();var H=G[i].getItems()[0];if(H){H.focus();}}this.invalidate();}.bind(this)});return j;};A.prototype._addOKButtonToPopover=function(i){var j=i.getFooter(),k;if(!j){k=new B({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),press:function(){this._closePopover();}.bind(this)});j=new O({content:[new T(),k]});i.setFooter(j);}};A.prototype._getSummaryText=function(){var k=", ";var G=" ";var H="";var J=true;var Q=this.getLists();if(Q.length>0){for(var i=0;i<Q.length;i++){var R=Q[i];if(R.getActive()){var U=this._getSelectedItemsText(R);var V="";for(var j=0;j<U.length;j++){V=V+U[j]+k;}if(V){V=V.substring(0,V.lastIndexOf(k)).trim();if(J){H=this._bundle.getText("FACETFILTER_INFOBAR_FILTERED_BY",[R.getTitle(),V]);J=false;}else{H=H+G+this._bundle.getText("FACETFILTER_INFOBAR_AND")+G+this._bundle.getText("FACETFILTER_INFOBAR_AFTER_AND",[R.getTitle(),V]);}}}}}if(!H){H=this._bundle.getText("FACETFILTER_INFOBAR_NO_FILTERS");}return H;};A.prototype._getSelectedItemsText=function(i){var j=i.getSelectedItems().map(function(k){return k.getText();});i._oSelectedKeys&&Object.getOwnPropertyNames(i._oSelectedKeys).forEach(function(k){j.indexOf(i._oSelectedKeys[k])===-1&&j.push(i._oSelectedKeys[k]);});return j;};A.prototype._addResetToSummary=function(i){if(i.getContent().length===1){i.addContent(new T({width:""}));var j=this._createResetButton();i.addContent(j);j.addStyleClass("sapUiSizeCompact");j.addStyleClass("sapMFFRefresh");j.addStyleClass("sapMFFBtnHoverable");}};A.prototype._removeResetFromSummary=function(i){if(i.getContent().length===3){var j=i.removeAggregation("content",1);j.destroy();var k=i.removeAggregation("content",1);k.destroy();}};A.prototype._removeList=function(i){if(i){var j=this._buttons[i.getId()];if(j){this.removeAggregation("buttons",j);j.destroy();}var R=this._removeFacetIcons[i.getId()];if(R){this.removeAggregation("removeIcons",R);R.destroy();}delete this._buttons[i.getId()];delete this._removeFacetIcons[i.getId()];}};A.prototype._getScrollingArrow=function(j){var k=null;var G={src:"sap-icon://navigation-"+j+"-arrow"};if(j==="left"){k=this.getAggregation("arrowLeft");if(!k){G.id=this.getId()+"-arrowScrollLeft";k=I.createControlByURI(G);var H=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollLeft"];for(var i=0;i<H.length;i++){k.addStyleClass(H[i]);k.setTooltip(this._bundle.getText("FACETFILTER_PREVIOUS"));}this.setAggregation("arrowLeft",k);}}else if(j==="right"){k=this.getAggregation("arrowRight");if(!k){G.id=this.getId()+"-arrowScrollRight";k=I.createControlByURI(G);var J=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollRight"];for(var i=0;i<J.length;i++){k.addStyleClass(J[i]);k.setTooltip(this._bundle.getText("FACETFILTER_NEXT"));}this.setAggregation("arrowRight",k);}}else{L.error("Scrolling arrow name "+j+" is not valid");}return k;};A.prototype._checkOverflow=function(){var i=this.getDomRef("head"),$=q(i),j=this.$(),k=false,G=false,H=false,J=null,Q=null,R=null;if(i){J=i.scrollLeft;Q=i.scrollWidth;R=i.clientWidth;if(Q>R){if(Q-R==1){Q=R;}else{H=true;}}j.toggleClass("sapMFFScrolling",H);j.toggleClass("sapMFFNoScrolling",!H);this._lastScrolling=H;if(!this._bRtl){k=J>0;G=(Q>R)&&(Q>J+R);}else{G=$.scrollLeftRTL()>0;k=$.scrollRightRTL()>0;}if((G!=this._bPreviousScrollForward)||(k!=this._bPreviousScrollBack)){j.toggleClass("sapMFFNoScrollBack",!k);j.toggleClass("sapMFFNoScrollForward",!G);}}};A.prototype.onclick=function(i){var j=i.target.id;if(j){var k=this.getId(),G=i.target;i.preventDefault();if(j==k+"-arrowScrollLeft"){G.tabIndex=-1;G.focus();this._scroll(-A.SCROLL_STEP,500);}else if(j==k+"-arrowScrollRight"){G.tabIndex=-1;G.focus();this._scroll(A.SCROLL_STEP,500);}}};A.prototype._scroll=function(i,j){var k=this.getDomRef("head");var G=k.scrollLeft;if(!D.browser.internet_explorer&&this._bRtl){i=-i;}var H=G+i;q(k).stop(true,true).animate({scrollLeft:H},j);};A.prototype._enableTouchSupport=function(){var i=function(G){var H=this.getType();if(H===z.Light){return;}G.preventDefault();if(this._iInertiaIntervalId){window.clearInterval(this._iInertiaIntervalId);}this.startScrollX=this.getDomRef("head").scrollLeft;this.startTouchX=G.touches[0].pageX;this._bTouchNotMoved=true;this._lastMoveTime=new Date().getTime();}.bind(this);var j=function(G){var H=this.getType();if(H===z.Light){return;}var J=G.touches[0].pageX-this.startTouchX;var Q=this.getDomRef("head");var R=Q.scrollLeft;var U=this.startScrollX-J;Q.scrollLeft=U;this._bTouchNotMoved=false;var V=new Date().getTime()-this._lastMoveTime;this._lastMoveTime=new Date().getTime();if(V>0){this._velocity=(U-R)/V;}G.preventDefault();}.bind(this);var k=function(G){var H=this.getType();if(H===z.Light){return;}if(this._bTouchNotMoved===false){G.preventDefault();var J=this.getDomRef("head");var Q=50;var R=Math.abs(this._velocity/10);this._iInertiaIntervalId=window.setInterval(function(){this._velocity=this._velocity*0.80;var U=this._velocity*Q;J.scrollLeft=J.scrollLeft+U;if(Math.abs(this._velocity)<R){window.clearInterval(this._iInertiaIntervalId);this._iInertiaIntervalId=undefined;}},Q);}else if(this._bTouchNotMoved===true){this.onclick(G);G.preventDefault();}this._bTouchNotMoved=undefined;this._lastMoveTime=undefined;}.bind(this);this.addEventDelegate({ontouchstart:i},this);this.addEventDelegate({ontouchend:k},this);this.addEventDelegate({ontouchmove:j},this);};return A;});
