/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','./ColumnListItem','./P13nPanel','./SearchField','./Text','./Table','./Column','./ScrollContainer','./P13nSelectionItem','./VBox','./Link','./OverflowToolbar','./OverflowToolbarLayoutData','./ToolbarSpacer','sap/ui/core/library','sap/ui/model/ChangeReason','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/core/ResizeHandler',"sap/ui/thirdparty/jquery"],function(l,C,P,S,T,a,b,c,d,V,L,O,e,f,g,h,J,B,R,q){"use strict";var i=l.ToolbarDesign;var j=l.ListType;var k=l.ListMode;var m=l.P13nPanelType;var n=P.extend("sap.m.P13nSelectionPanel",{metadata:{library:"sap.m",aggregations:{selectionItems:{type:"sap.m.P13nSelectionItem",multiple:true,singularName:"selectionItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{changeSelectionItems:{parameters:{items:{type:"object[]"}}}}},renderer:{apiVersion:2,render:function(r,o){r.openStart("div",o);r.class("sapMP13nColumnsPanel");r.openEnd();o.getAggregation("content").forEach(function(p){r.renderControl(p);});r.close("div");}}});n.prototype.init=function(){this._iLiveChangeTimer=0;this._iSearchTimer=0;this._bIgnoreUpdateInternalModel=false;this._bUpdateInternalModel=true;this._bOnAfterRenderingFirstTimeExecuted=false;var M=new J({items:[],countOfSelectedItems:0,countOfItems:0});M.setDefaultBindingMode(B.TwoWay);M.setSizeLimit(1000);this.setModel(M,"$sapmP13nSelectionPanel");this.setType(m.selection);this._createTable();this._createToolbar();this.setVerticalScrolling(false);var s=new c({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this.addAggregation("content",s);var t=this;this._fnHandleResize=function(){var o=false,p,r;if(t.getParent){var $=null,u,H;var v=t.getParent();var w=t._getToolbar();if(v&&v.$){$=v.$("cont");if($.children().length>0&&w.$().length>0){p=s.$()[0].clientHeight;u=$.children()[0].clientHeight;H=w?w.$()[0].clientHeight:0;r=u-H;if(p!==r){s.setHeight(r+'px');o=true;}}}}return o;};this._sContainerResizeListener=R.register(s,this._fnHandleResize);};n.prototype.onBeforeRendering=function(){this._updateInternalModel();};n.prototype.onAfterRendering=function(){var t=this;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);this._iLiveChangeTimer=window.setTimeout(function(){t._fnHandleResize();},0);}};n.prototype.getOkPayload=function(){this._updateInternalModel();var M=this._getInternalModel().getProperty("/items");return{selectionItems:M.map(function(o){return{columnKey:o.columnKey,selected:o.persistentSelected};})};};n.prototype.exit=function(){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};n.prototype.addItem=function(I){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("items",I);return this;};n.prototype.insertItem=function(I,o){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("items",I,o);return this;};n.prototype.removeItem=function(I){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}I=this.removeAggregation("items",I);return I;};n.prototype.removeAllItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("items");};n.prototype.destroyItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("items");return this;};n.prototype.addSelectionItem=function(s){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("selectionItems",s);return this;};n.prototype.insertSelectionItem=function(s,I){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("selectionItems",s,I);return this;};n.prototype.updateSelectionItems=function(r){this.updateAggregation("selectionItems");if(r===h.Change&&!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}};n.prototype.removeSelectionItem=function(s){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("selectionItems",s);};n.prototype.removeAllSelectionItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("selectionItems");};n.prototype.destroySelectionItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("selectionItems");return this;};n.prototype.onBeforeNavigationFrom=function(){return true;};n.prototype._notifyChange=function(){var o=this.getChangeNotifier();if(o){o(this);}};n.prototype._getInternalModel=function(){return this.getModel("$sapmP13nSelectionPanel");};n.prototype._createTable=function(){var t=this;this._oTable=new a({mode:k.MultiSelect,rememberSelections:false,selectionChange:q.proxy(this._onSelectionChange,this),columns:[new b({vAlign:g.VerticalAlign.Middle,header:new T({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(o,p){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[o,p]);}}})})],items:{path:"/items",templateShareable:false,template:new C({cells:new V({items:[new L({href:"{href}",text:"{text}",target:"{target}",enabled:{path:'href',formatter:function(v){if(!v){this.addStyleClass("sapUiCompSmartLink");}return!!v;}},press:function(E){var H=E.getSource().getHref();var I=t.getItems().filter(function(o){return o.getHref()===H&&!!o.getPress();});if(!I.length){return;}var p=I[0].getPress();p(E);}}),new T({visible:{path:'description',formatter:function(D){return!!D;}},text:"{description}"})]}),visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:j.Active})}});this._oTable.setModel(this._getInternalModel());};n.prototype._createToolbar=function(){var t=this;var o=new O(this.getId()+"-toolbar",{design:i.Auto,content:[new f(),new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(t._iSearchTimer);if(D){t._iSearchTimer=window.setTimeout(function(){t._onExecuteSearch();},D);}else{t._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new e({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:false,stayInOverflow:false})})]});o.setModel(this._getInternalModel());this.addAggregation("content",o);};n.prototype._onExecuteSearch=function(){this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._updateControlLogic();};n.prototype._switchVisibilityOfUnselectedModelItems=function(){var s=this._isFilteredByShowSelected();var M=this._getInternalModel().getProperty("/items");M.forEach(function(o){if(o.persistentSelected){o.visible=true;return;}o.visible=!s;});this._getInternalModel().setProperty("/items",M);};n.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return!!M.visible;});};n.prototype._getModelItemByColumnKey=function(s){var M=this._getInternalModel().getProperty("/items").filter(function(o){return o.columnKey===s;});return M[0];};n.prototype._updateCounts=function(M){var o=0;var p=0;M.forEach(function(r){o++;if(r.persistentSelected){p++;}});this._getInternalModel().setProperty("/countOfItems",o);this._getInternalModel().setProperty("/countOfSelectedItems",p);};n.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};n.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};n.prototype._getSearchText=function(){var s=this._getSearchField();return s?s.getValue():"";};n.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};n.prototype._isFilteredByShowSelected=function(){return false;};n.prototype._updateControlLogic=function(){var I=this._isFilteredBySearchText();var s=this._isFilteredByShowSelected();var t=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(t){t.setEnabled(!I&&!s);}};n.prototype._fireChangeSelectionItems=function(){this._bIgnoreUpdateInternalModel=true;var M=this._getInternalModel().getProperty("/items");this.fireChangeSelectionItems({items:M.map(function(o){return{columnKey:o.columnKey,selected:o.persistentSelected};})});this._bIgnoreUpdateInternalModel=false;};n.prototype._onSelectionChange=function(){this._selectTableItem();};n.prototype._selectTableItem=function(){var M=this._getInternalModel().getProperty("/items");this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._fireChangeSelectionItems();this._notifyChange();};n.prototype._filterModelItemsBySearchText=function(){var s=this._getSearchText();s=s.replace(/(^\s+)|(\s+$)/g,'');s=s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var r=new RegExp(s,'igm');this._getVisibleModelItems().forEach(function(M){M.visible=false;if(M.text&&M.text.match(r)){M.visible=true;}if(M.tooltip&&M.tooltip.match(r)){M.visible=true;}});this._getInternalModel().refresh();};n.prototype._updateInternalModel=function(){if(!this._bUpdateInternalModel){return;}this._bUpdateInternalModel=false;this._getInternalModel().setProperty("/items",this.getItems().map(function(I){return{columnKey:I.getColumnKey(),visible:true,text:I.getText(),tooltip:I.getTooltip(),href:I.getHref(),target:I.getTarget(),persistentSelected:I.getVisible(),description:I.getDescription()};},this));this.getSelectionItems().forEach(function(s){var o=this._getModelItemByColumnKey(s.getColumnKey());if(!o){return;}if(s.getSelected()!==undefined){o.persistentSelected=s.getSelected();}},this);this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();var M=this._getInternalModel().getProperty("/items");this._updateCounts(M);this._getInternalModel().setProperty("/items",M);};return n;});
