/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.getCore().loadLibrary("sap.ui.unified");sap.ui.define(['sap/m/delegate/DateNavigation','sap/ui/core/Control','sap/ui/base/ManagedObject','sap/ui/base/ManagedObjectObserver','sap/ui/unified/library','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/DatesRow','sap/ui/unified/calendar/OneMonthDatesRow','sap/ui/unified/calendar/MonthsRow','sap/ui/unified/calendar/TimesRow','sap/ui/unified/DateRange','sap/ui/unified/DateTypeRange','sap/ui/unified/CalendarAppointment','sap/ui/unified/CalendarRow','sap/ui/unified/CalendarRowRenderer','sap/ui/Device','sap/ui/core/Core','sap/ui/core/Element','sap/ui/core/Renderer','sap/ui/core/ResizeHandler','sap/ui/core/InvisibleText','sap/ui/core/Item','sap/ui/core/dnd/DragInfo','sap/ui/core/dnd/DropInfo','sap/ui/core/dnd/DragDropInfo','sap/ui/core/format/DateFormat','sap/m/Select','sap/m/Button','sap/m/OverflowToolbar','sap/m/Toolbar','sap/m/Table','sap/m/Column','sap/m/ColumnListItem','sap/m/ColumnListItemRenderer','sap/m/SegmentedButtonItem','sap/m/StandardListItem','sap/m/StandardListItemRenderer','sap/m/PlanningCalendarHeader','sap/m/PlanningCalendarRow','sap/m/PlanningCalendarRenderer','sap/m/PlanningCalendarView','sap/m/CheckBox','sap/m/library',"sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(D,C,M,a,u,b,c,d,O,e,T,f,g,h,k,l,m,n,E,R,o,I,p,q,r,s,t,S,B,v,w,x,y,z,A,F,G,H,P,J,K,L,N,Q,U,V,W){"use strict";var X=Q.Sticky;var Y=u.CalendarDayType;var Z=Q.ListMode;var $=Q.ToolbarDesign;var _=Q.PlanningCalendarBuiltInView;var a1=Q.ScreenSize;var b1=u.CalendarAppointmentVisualization;var c1=u.GroupAppointmentsMode;var d1=u.CalendarIntervalType;var e1=u.CalendarAppointmentHeight;var f1=u.CalendarAppointmentRoundWidth;var g1="DragDropConfig";var h1="ResizeConfig";var i1="CreateConfig";var j1="-CLI";var k1=C.extend("sap.m.PlanningCalendar",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},viewKey:{type:"string",group:"Appearance",defaultValue:d1.Hour},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showRowHeaders:{type:"boolean",group:"Appearance",defaultValue:true},noDataText:{type:"string",group:"Misc",defaultValue:null},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:c1.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentHeight:{type:"sap.ui.unified.CalendarAppointmentHeight",group:"Appearance",defaultValue:e1.Regular},appointmentRoundWidth:{type:"sap.ui.unified.CalendarAppointmentRoundWidth",group:"Appearance",defaultValue:f1.None},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:b1.Standard},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:false},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:false},builtInViews:{type:"string[]",group:"Appearance",defaultValue:[]},stickyHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{rows:{type:"sap.m.PlanningCalendarRow",multiple:true,singularName:"row"},views:{type:"sap.m.PlanningCalendarView",multiple:true,singularName:"view"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},toolbarContent:{type:"sap.ui.core.Control",multiple:true,singularName:"toolbarContent",forwarding:{getter:"_getHeader",aggregation:"actions"},forwardBinding:true},table:{type:"sap.m.Table",multiple:false,visibility:"hidden"},header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"},row:{type:"sap.m.PlanningCalendarRow"}}},rowSelectionChange:{parameters:{rows:{type:"sap.m.PlanningCalendarRow[]"}}},startDateChange:{},viewChange:{},rowHeaderClick:{parameters:{headerId:{type:"string"},row:{type:"sap.m.PlanningCalendarRow"}}}},designtime:"sap/m/designtime/PlanningCalendar.designtime"},constructor:function(i,j){C.prototype.constructor.apply(this,arguments);if(typeof i!=="string"){j=i;}if(j&&typeof j.customAppointmentsSorterCallback==="function"){this._fnCustomSortedAppointments=j.customAppointmentsSorterCallback;}}});var l1=["_oTimesRow","_oDatesRow","_oMonthsRow","_oWeeksRow","_oOneMonthsRow"],m1={};m1[d1.Day]={sInstanceName:"_oDatesRow",sIdSuffix:"-DatesRow",oClass:d};m1[d1.Week]={sInstanceName:"_oWeeksRow",sIdSuffix:"-WeeksRow",oClass:d};m1[d1.OneMonth]={sInstanceName:"_oOneMonthsRow",sIdSuffix:"-OneMonthsRow",oClass:O};var n1=a1.Desktop;var o1=[_.Hour,_.Day,_.Month,_.Week,_.OneMonth];var p1={PHONE:"600",TABLET:"1024"};var q1=["sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.OneMonthDatesRow"];var r1=C.extend("CalendarHeader",{metadata:{aggregations:{"toolbar":{type:"sap.m.Toolbar",multiple:false},"allCheckBox":{type:"sap.m.CheckBox",multiple:false}}},renderer:{apiVersion:2,render:function(i,j){i.openStart("div",j);i.class("sapMPlanCalHead");i.openEnd();var R1=j.getToolbar();if(R1){i.renderControl(R1);}var S1=j.getAllCheckBox();if(S1){i.renderControl(S1);}i.close("div");}}});k1.prototype.init=function(){this._dateNav=new D();this._iBreakPointTablet=m.media._predefinedRangeSets[m.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=m.media._predefinedRangeSets[m.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=m.media._predefinedRangeSets[m.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];if(m.system.phone||W('html').hasClass("sapUiMedia-Std-Phone")){this._iSize=0;this._iSizeScreen=0;}else if((m.system.tablet||W('html').hasClass("sapUiMedia-Std-Tablet"))&&!(m.system.desktop||W('html').hasClass("sapUiMedia-Std-Desktop"))){this._iSize=1;this._iSizeScreen=1;}else{this._iSize=2;this._iSizeScreen=2;}this.setAggregation("header",this._createHeader());this._attachHeaderEvents();this._oRB=n.getLibraryResourceBundle("sap.m");var i=this.getId();this._oIntervalTypeSelect=this._getHeader()._getOrCreateViewSwitch();this._oIntervalTypeSelect.attachEvent("selectionChange",s1,this);this._oTodayButton=this._getHeader()._getTodayButton();this._oCalendarHeader=new r1(i+"-CalHead",{});this._oInfoToolbar=new w(i+"-InfoToolbar",{height:"auto",design:$.Transparent,content:[this._oCalendarHeader,this._oTimesRow],ariaLabelledBy:I.getStaticId("sap.m","PC_INTERVAL_TOOLBAR")});var j=new x(i+"-Table",{sticky:[],infoToolbar:this._oInfoToolbar,mode:Z.SingleSelectMaster,columns:[new y({styleClass:"sapMPlanCalRowHead"}),new y({width:"80%",styleClass:"sapMPlanCalAppRow",minScreenWidth:n1,demandPopin:true})],ariaLabelledBy:i+"-Descr"});j.attachEvent("selectionChange",I1,this);j.addDelegate({onBeforeRendering:function(){if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();}},onAfterRendering:function(){this._rowHeaderClickEvent=j.$().find(".sapMPlanCalRowHead > div.sapMLIB").on("click",function(R1){var S1=W(R1.currentTarget).control(0),T1=E1(S1.getParent()),U1=S1.getId();this.fireRowHeaderClick({headerId:U1,row:T1});}.bind(this));this._adjustColumnHeadersTopOffset();}},false,this);this.setAggregation("table",j,true);this.setStartDate(new Date());this._resizeProxy=W.proxy(w1,this);this._fnCustomSortedAppointments=undefined;this.iWidth=0;};k1.prototype.exit=function(){if(this._sResizeListener){o.deregister(this._sResizeListener);this._sResizeListener=undefined;}m.orientation.detachHandler(this._updateStickyHeader,this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}var i=this.getAggregation("table");i.removeAllItems();l1.forEach(function(R1){if(this[R1]){this[R1]._oPlanningCalendar=undefined;this[R1].destroy();this[R1]=undefined;}},this);if(this._oViews){for(var j in this._oViews){this._oViews[j].destroy();}}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.destroy();}if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();this._rowHeaderClickEvent=null;}};k1.prototype.onBeforeRendering=function(){this._bBeforeRendering=true;if((!this._oTimesRow&&!this._oDatesRow&&!this._oMonthsRow&&!this._oWeeksRow&&!this._oOneMonthsRow)||this._bCheckView){this.setViewKey(this.getViewKey());this._bCheckView=undefined;}L1.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._updatePickerSelection();this._updateHeaderButtons();m.orientation.detachHandler(this._updateStickyHeader,this);this._bBeforeRendering=undefined;this._toggleStickyClasses();};k1.prototype.attachEvent=function(i,j,R1,S1){C.prototype.attachEvent.call(this,i,j,R1,S1);if(this.hasListeners("intervalSelect")){l1.forEach(function(T1){if(this[T1]){this[T1]._setAriaRole("button");}},this);}return this;};k1.prototype.detachEvent=function(i,j,R1){C.prototype.detachEvent.call(this,i,j,R1);if(!this.hasListeners("intervalSelect")){l1.forEach(function(S1){if(this[S1]){this[S1]._setAriaRole("gridcell");}},this);}return this;};k1.prototype._createHeader=function(){var i=new P(this.getId()+"-Header");i.getAggregation("_actionsToolbar").addAriaLabelledBy(I.getStaticId("sap.m","PC_FUNCTIONS_TOOLBAR"));i.getAggregation("_navigationToolbar").addAriaLabelledBy(I.getStaticId("sap.m","PC_INTERVAL_SELECTION_TOOLBAR"));return i;};k1.prototype._attachHeaderEvents=function(){var i=this._getHeader();i.attachEvent("pressPrevious",this._handlePressArrow,this);i.attachEvent("pressToday",this._handleTodayPress,this);i.attachEvent("pressNext",this._handlePressArrow,this);i.attachEvent("dateSelect",this._handleDateSelect,this);return this;};k1.prototype._handlePressArrow=function(i){this._applyArrowsLogic(i.getId()==="pressPrevious");};k1.prototype._applyArrowsLogic=function(i){if(i){this._dateNav.previous();}else{this._dateNav.next();}if(this.getMinDate()&&this._dateNav.getStart().getTime()<=this.getMinDate().getTime()){this._dateNav.setStart(this.getMinDate());this._dateNav.setCurrent(this.getMinDate());}if(this.getMaxDate()&&this._dateNav.getEnd().getTime()>=this.getMaxDate().getTime()){this._dateNav.setStart(this.getMaxDate());this._dateNav.setCurrent(this.getMaxDate());}var j=this._getRowInstanceByViewKey(this.getViewKey());this.setStartDate(this._dateNav.getStart());j.setDate(this._dateNav.getCurrent());this._updatePickerSelection();this.fireStartDateChange();};k1.prototype._formatPickerText=function(){var i=this._getFirstAndLastRangeDate(),j=b._createLocalDate(i.oStartDate,true),R1=b._createLocalDate(i.oEndDate,true),S1=this.getViewKey(),T1=d1[S1]?d1[S1]:this._getView(S1).getIntervalType(),U1=n.getConfiguration().getRTL(),V1,W1,X1,Y1;switch(T1){case d1.Hour:V1=t.getDateInstance({format:"yMMMMd"});X1=V1.format(j);if(j.getDate()!==R1.getDate()){Y1=V1.format(R1);}break;case d1.Day:case d1.Week:V1=t.getDateInstance({format:"yMMMMd"});X1=V1.format(j);Y1=V1.format(R1);break;case d1.OneMonth:V1=t.getDateInstance({format:"yMMMM"});X1=V1.format(j);break;case d1.Month:V1=t.getDateInstance({format:"y"});X1=V1.format(j);if(j.getFullYear()!==R1.getFullYear()){Y1=V1.format(R1);}break;default:throw new Error("Unknown IntervalType: "+S1+"; "+this);}if(!U1){W1=X1;if(Y1){W1+=" - "+Y1;}}else{if(Y1){W1=Y1+" - "+X1;}else{W1=X1;}}return W1;};k1.prototype._getFirstAndLastRangeDate=function(){var i=b._createUniversalUTCDate(this.getStartDate(),"Gregorian",true),j=b._createUniversalUTCDate(this._dateNav.getEnd(),"Gregorian",true);return{oStartDate:i,oEndDate:j};};k1.prototype._getHeader=function(){return this.getAggregation("header");};k1.prototype._toggleStickyClasses=function(){this.toggleStyleClass("sapMPCSticky",this.getStickyHeader());return this;};k1.prototype._adjustColumnHeadersTopOffset=function(){var i=this.getStickyHeader(),j=this.getDomRef().querySelector(".sapMListInfoTBarContainer"),R1;switch(i){case true:R1=this._getHeader().$().outerHeight()+"px";break;default:R1="auto";break;}j.style.top=R1;return this;};k1.prototype._setAriaRole=function(i){if(this.hasListeners("intervalSelect")){i._setAriaRole("button");}else{i._setAriaRole("gridcell");}};k1.prototype._updateTodayButtonState=function(){if(this._oTodayButton){this._oTodayButton.setEnabled(!this._dateMatchesVisibleRange(new Date(),this.getViewKey()));}};k1.prototype._dateMatchesVisibleRange=function(i,j){var R1=this._getView(j,!this._bBeforeRendering);if(!R1){return false;}var S1=R1.getIntervalType(),T1=m1[S1],U1=T1?this[T1.sInstanceName]:null,V1=false;if(U1&&j==="One Month"){return b._isSameMonthAndYear(c.fromLocalJSDate(this.getStartDate()),c.fromLocalJSDate(i));}else if(U1&&j==="Week"){var W1=U1.getDays(),X1=c.fromLocalJSDate(i),Y1=c.fromLocalJSDate(this.getStartDate()),Z1=c.fromLocalJSDate(this.getStartDate());Z1.setDate(Z1.getDate()+W1);return X1.isSameOrAfter(Y1)&&X1.isBefore(Z1);}return V1;};k1.prototype.onAfterRendering=function(i){i.size={width:this.getDomRef().offsetWidth};w1.call(this,i,true);if(!this._sResizeListener){this._sResizeListener=o.register(this,this._resizeProxy);}if(m.system.phone&&this.getStickyHeader()){m.orientation.attachHandler(this._updateStickyHeader,this);}this._updateCurrentTimeVisualization(false);if(this.getHeight()){var j=this.getDomRef().querySelector("table");if(this.getHeight().indexOf("%")>-1){j.style.height=this.getHeight();return;}var R1=this.$().height()-this._oInfoToolbar.$().height()+"px";j.style.height=R1;}this._adjustColumnHeadersTopOffset();};k1.prototype.onThemeChanged=function(){if(this.getDomRef()){this._adjustColumnHeadersTopOffset();}};k1.prototype.addToolbarContent=function(i){if(i&&i.isA("sap.m.Title")){this._observeHeaderTitleText(i);this._getHeader().setTitle(i.getText());i.setVisible(false);}this.addAggregation("toolbarContent",i);return this;};k1.prototype.insertToolbarContent=function(i,j){if(i&&i.isA("sap.m.Title")){this._observeHeaderTitleText(i);this._getHeader().setTitle(i.getText());i.setVisible(false);}this.insertAggregation("toolbarContent",i,j);return this;};k1.prototype.removeToolbarContent=function(i){var j;if(i&&i.isA("sap.m.Title")){this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver();}else{j=this.removeAggregation("toolbarContent",i);}return j;};k1.prototype.removeAllToolbarContent=function(){var i=this.removeAllAggregation("toolbarContent");this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver();return i;};k1.prototype.destroyToolbarContent=function(){var i=this.destroyAggregation("toolbarContent");this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver();return i;};k1.prototype._getHeaderObserver=function(){if(!this._oHeaderObserver){this._oHeaderObserver=new a(this._handleTitleTextChange.bind(this));}return this._oHeaderObserver;};k1.prototype._observeHeaderTitleText=function(i){this._getHeaderObserver().observe(i,{properties:["text"]});};k1.prototype._handleTitleTextChange=function(i){this._getHeader().setTitle(i.current);};k1.prototype._disconnectAndDestroyHeaderObserver=function(){if(this._oHeaderObserver){this._oHeaderObserver.disconnect();this._oHeaderObserver.destroy();this._oHeaderObserver=null;}};k1.prototype.setStartDate=function(i){var j;if(!i){j=new Date();}else{b._checkJSDateObject(i);j=new Date(i.getTime());}j=this._shiftStartDate(j);if(U(j,this.getStartDate())){this._updateTodayButtonState();return this;}var R1=j.getFullYear();b._checkYearInValidRange(R1);var S1=this.getMinDate();if(S1&&S1.getTime()>j.getTime()){V.warning("StartDate < minDate -> StartDate set to minDate",this);j=new Date(S1.getTime());}else{var T1=this.getMaxDate();if(T1&&T1.getTime()<j.getTime()){V.warning("StartDate > maxDate -> StartDate set to minDate",this);if(S1){j=new Date(S1.getTime());}else{j=new Date(1,0,1);j.setFullYear(1);}}}this.setProperty("startDate",j,true);this._dateNav.setStart(j);this._dateNav.setCurrent(j);this._getHeader().setStartDate(j);l1.forEach(function(U1){if(this[U1]){this[U1].setStartDate(new Date(j.getTime()));}},this);if(this.getViewKey()===_.OneMonth&&this._oOneMonthsRow.getMode()<2&&this._oOneMonthsRow.getSelectedDates().length){this._setRowsStartDate(this._oOneMonthsRow.getSelectedDates()[0].getStartDate());}else{this._setRowsStartDate(new Date(j.getTime()));}if(this.getViewKey()===_.Week||this.getViewKey()===_.OneMonth){this._updateTodayButtonState();}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);this._updatePickerSelection();}this._updateHeaderButtons();return this;};k1.prototype.setMinDate=function(i){if(U(i,this.getMinDate())){return this;}var j=this.getMaxDate(),R1=this._getHeader();if(i){b._checkJSDateObject(i);var S1=i.getFullYear();b._checkYearInValidRange(S1);this.setProperty("minDate",i,true);this._bNoStartDateChange=true;R1.getAggregation("_calendarPicker").setMinDate(new Date(i.getTime()));R1.getAggregation("_monthPicker").setMinDate(new Date(i.getTime()));R1.getAggregation("_yearPicker").setMinDate(new Date(i.getTime()));if(j&&j.getTime()<i.getTime()){V.warning("minDate > maxDate -> maxDate set to end of the month",this);j=new Date(i.getTime());j.setMonth(j.getMonth()+1,0);j.setHours(23);j.setMinutes(59);j.setSeconds(59);j.setMilliseconds(0);this.setMaxDate(j);}this._bNoStartDateChange=undefined;var T1=this.getStartDate();if(T1&&T1.getTime()<i.getTime()){V.warning("StartDate < minDate -> StartDate set to minDate",this);T1=new Date(i.getTime());this.setStartDate(T1);R1.setPickerText(this._formatPickerText());}}else{this.setProperty("minDate",undefined,true);R1.getAggregation("_calendarPicker").setMinDate();R1.getAggregation("_monthPicker").setMinDate();R1.getAggregation("_yearPicker").setMinDate();}var U1=new Date();if(i&&U1.getTime()<i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||U1.getTime()<j.getTime()){this._oTodayButton.setVisible(true);}return this;};k1.prototype.setMaxDate=function(i){if(U(i,this.getMaxDate())){return this;}var j=this.getMinDate(),R1=this._getHeader();if(i){b._checkJSDateObject(i);var S1=i.getFullYear();b._checkYearInValidRange(S1);this.setProperty("maxDate",i,true);this._bNoStartDateChange=true;R1.getAggregation("_calendarPicker").setMaxDate(new Date(i.getTime()));R1.getAggregation("_monthPicker").setMaxDate(new Date(i.getTime()));R1.getAggregation("_yearPicker").setMaxDate(new Date(i.getTime()));if(j&&j.getTime()>i.getTime()){V.warning("maxDate < minDate -> maxDate set to begin of the month",this);j=new Date(i.getTime());j.setDate(1);j.setHours(0);j.setMinutes(0);j.setSeconds(0);j.setMilliseconds(0);this.setMinDate(j);}this._bNoStartDateChange=undefined;var T1=this.getStartDate();if(T1&&T1.getTime()>i.getTime()){V.warning("StartDate > maxDate -> StartDate set to minDate",this);if(j){T1=new Date(j.getTime());}else{T1=new Date(1,0,1);T1.setFullYear(1);}this.setStartDate(T1);R1.setPickerText(this._formatPickerText());}}else{this.setProperty("maxDate",undefined,true);R1.getAggregation("_calendarPicker").setMaxDate();R1.getAggregation("_monthPicker").setMaxDate();R1.getAggregation("_yearPicker").setMaxDate();}var U1=new Date();if(i&&U1.getTime()>i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||U1.getTime()>j.getTime()){this._oTodayButton.setVisible(true);}return this;};k1.prototype.removeIntervalInstanceFromInfoToolbar=function(){var i=this._oInfoToolbar.getContent();i.forEach(function(j){if(j.isA(q1)){this._oInfoToolbar.removeContent(j);}}.bind(this));};k1.prototype.setViewKey=function(j){var R1,S1,T1,U1=this.getViewKey(),V1=this._getHeader(),W1;this.setProperty("viewKey",j,true);this._oIntervalTypeSelect.setSelectedKey(j);this.removeIntervalInstanceFromInfoToolbar();var X1=this.getStartDate();var Y1=this.getMinDate();var Z1=this.getMaxDate();var $1=this._getView(j,!this._bBeforeRendering);if(!$1){this._bCheckView=true;this.invalidate();}else{var _1=$1.getIntervalType();var a2=this._getIntervals($1);this._bCheckView=false;this._dateNav.setUnit(_1);this._dateNav.setStep(a2);this._dateNav.setCurrent(undefined);switch(_1){case d1.Hour:if(!this._oTimesRow){this._oTimesRow=new T(this.getId()+"-TimesRow",{startDate:new Date(X1.getTime()),items:a2,legend:this.getLegend()});this._setAriaRole(this._oTimesRow);this._oTimesRow._setLegendControlOrigin(this);this._oTimesRow.attachEvent("focus",this._handleFocus,this);this._oTimesRow.attachEvent("select",this._handleCalendarSelect,this);this._oTimesRow._oPlanningCalendar=this;this._oTimesRow._getSpecialDates=function(){return this._oPlanningCalendar._getSpecialDates();};this._oTimesRow.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};}else if(this._oTimesRow.getItems()!==a2){this._oTimesRow.setItems(a2);this._dateNav.setStep(a2);}this._insertInterval(this._oTimesRow);V1.setAssociation("currentPicker",V1.getAggregation("_calendarPicker"));break;case d1.Day:case d1.Week:case d1.OneMonth:T1=m1[_1];R1=this[T1.sInstanceName];if(!R1){R1=new T1.oClass(this.getId()+T1.sIdSuffix,{startDate:new Date(X1.getTime()),days:a2,showDayNamesLine:this.getShowDayNamesLine(),legend:this.getLegend(),showWeekNumbers:this.getShowWeekNumbers()});this._setAriaRole(R1);R1.attachEvent("select",this._handleCalendarSelect,this);R1.attachEvent("focus",this._handleFocus,this);if(j===_.OneMonth){R1._setRowsStartDate=this._setRowsStartDate.bind(this);}R1._oPlanningCalendar=this;R1._getSpecialDates=function(){return this._oPlanningCalendar._getSpecialDates();};R1.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};}else if(R1.getDays()!==a2){R1.setDays(a2);this._dateNav.setStep(a2);}this._insertInterval(R1);this[T1.sInstanceName]=R1;if(_1===d1.OneMonth){V1.setAssociation("currentPicker",V1.getAggregation("_monthPicker"));}else{V1.setAssociation("currentPicker",V1.getAggregation("_calendarPicker"));}break;case d1.Month:if(!this._oMonthsRow){this._oMonthsRow=new e(this.getId()+"-MonthsRow",{startDate:new Date(X1.getTime()),months:a2,legend:this.getLegend()});this._setAriaRole(this._oMonthsRow);this._oMonthsRow._setLegendControlOrigin(this);this._oMonthsRow.attachEvent("focus",this._handleFocus,this);this._oMonthsRow.attachEvent("select",this._handleCalendarSelect,this);this._oMonthsRow._oPlanningCalendar=this;this._oMonthsRow._getSpecialDates=function(){return this._oPlanningCalendar._getSpecialDates();};this._oMonthsRow.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};}else if(this._oMonthsRow.setMonths()!==a2){this._oMonthsRow.setMonths(a2);this._dateNav.setStep(a2);}this._insertInterval(this._oMonthsRow);V1.setAssociation("currentPicker",V1.getAggregation("_yearPicker"));break;default:throw new Error("Unknown IntervalType: "+_1+"; "+this);}var b2=this.getRows();for(var i=0;i<b2.length;i++){var c2=b2[i];var d2=H1(c2);d2.setIntervalType(_1);d2.setIntervals(a2);d2.setShowSubIntervals($1.getShowSubIntervals());}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);u1.call(this,this.getShowWeekNumbers(),this._viewAllowsWeekNumbers(j));v1.call(this,this.getShowDayNamesLine(),!!R1);}this._updatePickerSelection();}if(j===_.Week||j===_.OneMonth||j===_.Month){S1=this.getStartDate();this.setStartDate(new Date(S1.getTime()));if(S1.getTime()!==this.getStartDate().getTime()){this.fireStartDateChange();}}if(this._oOneMonthsRow&&j===_.OneMonth){this._oOneMonthsRow.setMode(this._iSize);this._oOldStartDate=new Date(this.getStartDate().getTime());this._adjustSelectedDate(c.fromLocalJSDate(S1));if(this._iSize<2){this._setRowsStartDate(S1);}}else if(this._oOneMonthsRow&&U1===_.OneMonth&&this._oOneMonthsRow.getSelectedDates().length){W1=this._oOneMonthsRow.getSelectedDates()[0].getStartDate();W1.setHours(this._oOldStartDate.getHours());W1.setMinutes(this._oOldStartDate.getMinutes());W1.setSeconds(this._oOldStartDate.getSeconds());W1.setMilliseconds(this._oOldStartDate.getMilliseconds());if(W1){this.setStartDate(W1);}}if(Y1){V1.getAggregation("_calendarPicker").setMinDate(new Date(Y1.getTime()));V1.getAggregation("_yearPicker").setMinDate(new Date(Y1.getTime()));V1.getAggregation("_monthPicker").setMinDate(new Date(Y1.getTime()));}if(Z1){V1.getAggregation("_calendarPicker").setMaxDate(new Date(Z1.getTime()));V1.getAggregation("_yearPicker").setMaxDate(new Date(Z1.getTime()));V1.getAggregation("_monthPicker").setMaxDate(new Date(Z1.getTime()));}this._updateTodayButtonState();return this;};k1.prototype._handleFocus=function(i){var j=i.getParameter("date"),R1=i.getParameter("restoreOldDate");if(R1){return;}this.shiftToDate(j,i.getParameter("otherMonth"));};k1.prototype.shiftToDate=function(i,j){var R1=this._getRowInstanceByViewKey(this.getViewKey()),S1,T1;this._dateNav.toDate(i);S1=this._dateNav.getStart();T1=this._dateNav.getCurrent();if(this._dateNav.getCurrent()>this._dateNav.getEnd()){S1=new Date(this._dateNav.getStart());S1.setDate(S1.getDate()+1);}if((this.getMaxDate()&&this.getMaxDate()<i)||(this.getMinDate()&&this.getMinDate()>i)){return;}if(j){this.fireStartDateChange();}if(R1&&!(R1.getMode&&R1.getMode()<2&&!j)){this.setStartDate(S1);R1.setStartDate(S1);R1.setDate(T1);}};k1.prototype._shiftStartDate=function(i){if(this.getViewKey()===_.Week){var j=b.getFirstDateOfWeek(b._createUniversalUTCDate(i,undefined,true));i.setTime(b._createLocalDate(j,true).getTime());}if((this.getViewKey()===_.OneMonth||this.getViewKey()===_.Month)){var R1=b.getFirstDateOfMonth(b._createUniversalUTCDate(i,undefined,true));i.setTime(b._createLocalDate(R1,true).getTime());}return i;};k1.prototype._updatePickerSelection=function(){var i=this._getFirstAndLastRangeDate(),j=this._getHeader().getAssociation("currentPicker"),R1=n.byId(j),S1;S1=new f({startDate:b._createLocalDate(i.oStartDate,true),endDate:b._createLocalDate(i.oEndDate,true)});R1.destroySelectedDates();R1.addSelectedDate(S1);this._getHeader().setPickerText(this._formatPickerText());this._updateTodayButtonState();};k1.prototype._adjustSelectedDate=function(i){var j=i.toLocalJSDate();if(this._oOneMonthsRow.getMode&&this._oOneMonthsRow.getMode()<2){this._oOneMonthsRow.removeAllSelectedDates();this._oOneMonthsRow.addSelectedDate(new f({startDate:j}));this._oOneMonthsRow.selectDate(j);}};k1.prototype._insertInterval=function(i){if(this._iSizeScreen>1){this._oInfoToolbar.addContent(i);}else{this._oInfoToolbar.insertContent(i,1);}};k1.prototype._viewAllowsWeekNumbers=function(i){var j=this._getView(i).getIntervalType(),R1=m1[j];return!!R1&&!!R1.oClass.prototype.setShowWeekNumbers;};k1.prototype._viewAllowsDayNamesLine=function(i){var j=this._getView(i).getIntervalType(),R1=m1[j];return!!R1&&!!R1.oClass.prototype.setShowDayNamesLine;};k1.prototype._getRowInstanceByViewKey=function(i){var j=this._getView(i).getIntervalType(),R1=m1[j],S1;if(R1){S1=this[R1.sInstanceName];}if(j===d1.Month){S1=this._oMonthsRow;}if(j===d1.Hour){S1=this._oTimesRow;}return S1;};k1.prototype.setShowWeekNumbers=function(i){this.setProperty("showWeekNumbers",i,true);this._getViews().forEach(function(j){var R1=j.getKey(),S1=this._viewAllowsWeekNumbers(R1),T1=this._getRowInstanceByViewKey(R1);if(T1&&S1){T1.setShowWeekNumbers(i);}if(this.getDomRef()&&this.getViewKey()===R1){u1.call(this,i,S1);}},this);return this;};k1.prototype.setShowIntervalHeaders=function(j){this.setProperty("showIntervalHeaders",j,true);var R1=this.getRows();for(var i=0;i<R1.length;i++){var S1=R1[i];H1(S1).setShowIntervalHeaders(j);}return this;};k1.prototype.setShowEmptyIntervalHeaders=function(j){this.setProperty("showEmptyIntervalHeaders",j,true);var R1=this.getRows();for(var i=0;i<R1.length;i++){var S1=R1[i];H1(S1).setShowEmptyIntervalHeaders(j);}return this;};k1.prototype.setGroupAppointmentsMode=function(j){this.setProperty("groupAppointmentsMode",j,true);var R1=this.getRows();for(var i=0;i<R1.length;i++){var S1=R1[i];H1(S1).setGroupAppointmentsMode(j);}return this;};k1.prototype.setAppointmentsReducedHeight=function(j){this.setProperty("appointmentsReducedHeight",j,true);var R1=this.getRows();for(var i=0;i<R1.length;i++){var S1=R1[i];H1(S1).setAppointmentsReducedHeight(j);}return this;};k1.prototype.setAppointmentHeight=function(j){var R1=this.getRows(),i;this.setProperty("appointmentHeight",j);for(i=0;i<R1.length;i++){var S1=R1[i];H1(S1).setAppointmentHeight(j);}return this;};k1.prototype.setAppointmentRoundWidth=function(j){var R1=this.getRows(),i;this.setProperty("appointmentRoundWidth",j);for(i=0;i<R1.length;i++){var S1=R1[i];H1(S1).setAppointmentRoundWidth(j);}return this;};k1.prototype.setAppointmentsVisualization=function(j){this.setProperty("appointmentsVisualization",j,true);var R1=this.getRows();for(var i=0;i<R1.length;i++){var S1=R1[i];H1(S1).setAppointmentsVisualization(j);}return this;};k1.prototype.setShowRowHeaders=function(i){this.setProperty("showRowHeaders",i,true);var j=this.getAggregation("table");j.getColumns()[0].setVisible(i);this._toggleAppointmentsColumnPopinState(i);this.$().toggleClass("sapMPlanCalNoHead",!i);P1.call(this);this._setSelectionMode.call(this);return this;};k1.prototype.setShowDayNamesLine=function(i){var j,R1,S1,T1=!!this.getDomRef(),U1=this.getViewKey();for(j in m1){R1=m1[j].sInstanceName;if(this[R1]){S1=this[R1];S1.setShowDayNamesLine(i);if(T1&&j===U1){v1.call(this,i,true);}}}return this.setProperty("showDayNamesLine",i,false);};k1.prototype.setStickyHeader=function(i){if(this.getStickyHeader()===i){return this;}this.setProperty("stickyHeader",i,true);if(m.system.phone){if(i){m.orientation.attachHandler(this._updateStickyHeader,this);}else{m.orientation.detachHandler(this._updateStickyHeader,this);}}this._updateStickyHeader();return this;};k1.prototype._updateStickyHeader=function(){var i=[],j=this.getStickyHeader(),R1=this.getViewKey()===_.OneMonth&&this._iSize<2,S1=j&&!m.system.phone&&!R1,T1=j&&!(m.system.phone&&m.orientation.landscape)&&!R1;if(S1){i.push(X.HeaderToolbar);}if(this._oInfoToolbar&&T1){i.push(X.InfoToolbar);}this.getAggregation("table").setSticky(i);};k1.prototype.addRow=function(i){this.addAggregation("rows",i);this.getAggregation("table").addItem(this._createPlanningCalendarListItem(i));return this;};k1.prototype.insertRow=function(i,j){this.insertAggregation("rows",i,j);this.getAggregation("table").insertItem(this._createPlanningCalendarListItem(i),j,true);return this;};k1.prototype.removeRow=function(i){var j=this.removeAggregation("rows",i,true),R1=this.getAggregation("table");R1.removeItem(F1(j),true);this._handleRowRemoval(j);O1.call(this);this._setSelectionMode.call(this);return j;};k1.prototype.removeAllRows=function(){var i=this.removeAllAggregation("rows",true),j=this.getAggregation("table");j.removeAllItems(true);i.forEach(this._handleRowRemoval,this);O1.call(this);this._setSelectionMode.call(this);return i;};k1.prototype.destroyRows=function(){var i;var j=this.getAggregation("table");j.destroyItems(true);i=this.destroyAggregation("rows");O1.call(this);this._setSelectionMode.call(this);return i;};k1.prototype.setSingleSelection=function(i){this.setProperty("singleSelection",i,true);P1.call(this);this._setSelectionMode.call(this);if(i){this.selectAllRows(false);}else{O1.call(this);}this.$().toggleClass("sapMPlanCalMultiSel",!i);return this;};k1.prototype.setNoDataText=function(i){this.setProperty("noDataText",i,true);var j=this.getAggregation("table");j.setNoDataText(i);return this;};k1.prototype.setLegend=function(j){this.setAssociation("legend",j,true);var R1=this.getRows(),S1=this.getLegend()&&n.byId(this.getLegend()),T1;for(var i=0;i<R1.length;i++){var U1=R1[i];H1(U1).setLegend(j);}l1.forEach(function(V1){if(this[V1]){this[V1].setLegend(j);}},this);if(S1){T1=new a(function(V1){this.invalidate();}.bind(this));T1.observe(S1,{destroy:true});}return this;};k1.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.addAriaLabelledBy(i);return this;};k1.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.removeAriaLabelledBy(i);return this;};k1.prototype.removeAllAriaLabelledBy=function(){this.removeAllAssociation("ariaLabelledBy",true);var i=this.getAggregation("table");i.removeAllAriaLabelledBy();i.addAriaLabelledBy(this.getId()+"-Descr");return this;};k1.prototype.invalidate=function(i){var j=i&&i instanceof f;if(!this._bIsBeingDestroyed&&(this._bDateRangeChanged||j)){if(this.getDomRef()){var R1=this.getViewKey();var S1=this._getView(R1);var T1=S1.getIntervalType();switch(T1){case d1.Hour:if(this._oTimesRow){this._oTimesRow.invalidate(arguments);}break;case d1.Day:if(this._oDatesRow){this._oDatesRow.invalidate(arguments);}break;case d1.Month:if(this._oMonthsRow){this._oMonthsRow.invalidate(arguments);}break;case d1.OneMonth:if(this._oOneMonthsRow){this._oOneMonthsRow.invalidate(arguments);}break;case d1.Week:if(this._oWeeksRow){this._oWeeksRow.invalidate(arguments);}break;default:throw new Error("Unknown IntervalType: "+T1+"; "+this);}}this._bDateRangeChanged=undefined;}else{if(i&&i instanceof sap.m.PlanningCalendarView){this._bCheckView=true;}C.prototype.invalidate.apply(this,arguments);}};k1.prototype.addSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.addAggregation.call(this,"specialDates",i);};k1.prototype.insertSpecialDate=function(i,j){this._bDateRangeChanged=true;return C.prototype.insertAggregation.call(this,"specialDates",i,j);};k1.prototype.removeSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.removeAggregation.call(this,"specialDates",i);};k1.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;return this.removeAllAggregation("specialDates");};k1.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;return this.destroyAggregation("specialDates");};k1.prototype.removeAllViews=function(){this._bCheckView=true;var i=this.removeAllAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(o1[0]);}return i;};k1.prototype.destroyViews=function(){this._bCheckView=true;var i=this.destroyAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(o1[0]);}return i;};k1.prototype.getSelectedRows=function(){return this.getRows().filter(function(i){return i.getSelected();});};k1.prototype.selectAllRows=function(j){var R1=this.getRows();if(!(j&&this.getSingleSelection())){for(var i=0;i<R1.length;i++){var S1=R1[i];S1.setSelected(j);}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.setSelected(j);}}return this;};k1.prototype.onsaphomemodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var R1=j[0];var S1=new W.Event("saphome");S1._bPlanningCalendar=true;H1(R1).onsaphome(S1);i.preventDefault();i.stopPropagation();}};k1.prototype.onsapendmodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var R1=j[j.length-1];var S1=new W.Event("sapend");S1._bPlanningCalendar=true;H1(R1).onsapend(S1);i.preventDefault();i.stopPropagation();}};k1.prototype.setBuiltInViews=function(i){this.setProperty("builtInViews",i);this.setViewKey(this._getViews()[0].getKey());return this;};k1.prototype.removeView=function(i){var j=this.removeAggregation("views",i);if(!this.getViews().length){this.setViewKey(this._getViews()[0].getKey());}return j;};k1.prototype._getIntervals=function(i){var j=0;switch(this._iSize){case 0:j=i.getIntervalsS();break;case 1:j=i.getIntervalsM();break;default:j=i.getIntervalsL();break;}return j;};k1.prototype._getView=function(j,R1){var S1=this._getViews();var T1;for(var i=0;i<S1.length;i++){T1=S1[i];if(T1.getKey()!=j){T1=undefined;}else{break;}}if(!T1&&!R1){throw new Error("PlanningCalendarView with key "+j+" not assigned "+this);}return T1;};k1.prototype._changeStartDate=function(i){if(this._bNoStartDateChange){return;}this.setStartDate(new Date(i.getTime()));this._updatePickerSelection();this.fireStartDateChange();};k1.prototype._updateCurrentTimeVisualization=function(j){if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(j){var R1=this.getRows();for(var i=0;i<R1.length;i++){var S1=R1[i];H1(S1).updateCurrentTimeVisualization();}}var T1=new Date();var U1=this.getStartDate();var V1=this.getViewKey();var W1=this._getView(V1);var X1=W1.getIntervalType();var Y1=this._getIntervals(W1);var Z1=0;var $1=0;var _1=0;switch(X1){case d1.Hour:Z1=60000;$1=U1.getTime()-3600000;_1=U1.getTime()+Y1*3600000;break;case d1.Day:case d1.Week:case d1.OneMonth:Z1=1800000;$1=U1.getTime()-3600000;_1=U1.getTime()+Y1*86400000;break;default:Z1=-1;break;}if(T1.getTime()<=_1&&T1.getTime()>=$1&&Z1>0){this._sUpdateCurrentTime=setTimeout(this['_updateCurrentTimeVisualization'].bind(this,true),Z1);}};function s1(i){this.setViewKey(i.getParameter("item").getKey());this.fireViewChange();}k1.prototype._handleTodayPress=function(i){var j=new Date(),R1,S1=this.getViewKey();if(S1===_.OneMonth){R1=b.getFirstDateOfMonth(b._createUniversalUTCDate(j,undefined,true));this._adjustSelectedDate(c.fromLocalJSDate(j));j=b._createLocalDate(R1,true);}if(S1===_.Week){R1=this.getStartDate();j.setHours(R1.getHours());j.setMinutes(R1.getMinutes());j.setSeconds(R1.getSeconds());}this.setStartDate(j);this._dateNav.setCurrent(j);this._updatePickerSelection();this.fireStartDateChange();};k1.prototype._handleStartDateChange=function(i){var j=i.oSource.getStartDate();if(this._getView(this.getViewKey()).getIntervalType()!==d1.Hour){var R1=this.getStartDate();j.setHours(R1.getHours());j.setMinutes(R1.getMinutes());j.setSeconds(R1.getSeconds());}this._changeStartDate(j);};k1.prototype._handleDateSelect=function(i){var j=i.oSource.getStartDate();if(this._getView(this.getViewKey()).getIntervalType()===d1.Hour){var R1=this.getStartDate();j.setHours(R1.getHours());j.setMinutes(R1.getMinutes());j.setSeconds(R1.getSeconds());}this._changeStartDate(j);this._dateNav.setCurrent(j);var S1=this.getViewKey(),T1=this._getView(S1),U1=T1.getIntervalType(),V1;if(U1==="Hour"){U1="Time";}else if(U1==="Day"){U1="Date";}else if(U1==="One Month"){U1="OneMonth";}V1="_o"+U1+"sRow";if(this[V1]){this[V1].setDate(j);}};k1.prototype._handleCalendarSelect=function(i){var j=i.getSource().getSelectedDates();if(!j.length){return;}var R1=new Date(j[0].getStartDate());var S1=b._createUniversalUTCDate(R1,undefined,true);var T1=this.getViewKey();var U1=this._getView(T1);var V1=U1.getIntervalType();if(V1!==d1.OneMonth||this._iSize>1){j[0].setStartDate();}switch(V1){case d1.Hour:S1.setUTCHours(S1.getUTCHours()+1);break;case d1.Day:case d1.Week:S1.setUTCDate(S1.getUTCDate()+1);break;case d1.OneMonth:if(this._iSize<2){var W1=new Date(R1.getTime());if(b.monthsDiffer(this.getStartDate(),R1)){this.setStartDate(R1);this._getHeader().setPickerText(this._formatPickerText());}this._setRowsStartDate(W1);this._oOneMonthsRow._focusDate(c.fromLocalJSDate(W1),true);}else if(b._isNextMonth(R1,this.getStartDate())){this.shiftToDate(R1);return;}S1.setUTCDate(S1.getUTCDate()+1);break;case d1.Month:S1.setUTCMonth(S1.getUTCMonth()+1);break;default:throw new Error("Unknown IntervalType: "+V1+"; "+this);}S1.setUTCMilliseconds(S1.getUTCMilliseconds()-1);S1=b._createLocalDate(S1,true);this._formatPickerText();this.fireIntervalSelect({startDate:R1,endDate:S1,subInterval:false,row:undefined});};function t1(i){var j=i.getParameter("startDate");var R1=this.getViewKey();var S1=this._getView(R1);var T1=S1.getIntervalType();if(T1===d1.OneMonth&&b._isNextMonth(j,this.getStartDate())){this.shiftToDate(j);return;}var U1=i.getParameter("endDate");var V1=i.getParameter("subInterval");var W1=E1(i.oSource.getParent());this._formatPickerText();this.fireIntervalSelect({startDate:j,endDate:U1,subInterval:V1,row:W1});}k1.prototype._applyContextualSettings=function(i){return C.prototype._applyContextualSettings.call(this,i||M._defaultContextualSettings);};function u1(i,j){this.$().toggleClass("sapMPlanCalWithWeekNumbers",i&&j);}function v1(i,j){this.$().toggleClass("sapMPlanCalWithDayNamesLine",i&&j);}function w1(j,R1){if(j.size.width<=0){return;}if(Math.abs(this.iWidth-j.size.width)<15){return;}this.iWidth=j.size.width;this._applyContextualSettings({contextualWidth:this.iWidth});var S1=this.getRows();var T1;var i=0;var U1;var V1=this._iSize;J1.call(this,j.size.width);if(V1!=this._iSize){K1.call(this,this._iSize);var W1=this.getViewKey();var X1=this._getView(W1);var Y1=X1.getIntervalType();var Z1=this._getIntervals(X1);for(i=0;i<S1.length;i++){T1=S1[i];var $1=H1(T1);if(Z1!=$1.getIntervals()){$1.setIntervals(Z1);}else{$1.handleResize();}}switch(Y1){case d1.Hour:if(this._oTimesRow&&this._oTimesRow.getItems()!=Z1){this._oTimesRow.setItems(Z1);this._dateNav.setStep(Z1);}break;case d1.Day:if(this._oDatesRow&&this._oDatesRow.getDays()!=Z1){this._oDatesRow.setDays(Z1);this._dateNav.setStep(Z1);}break;case d1.Month:if(this._oMonthsRow&&this._oMonthsRow.getMonths()!=Z1){this._oMonthsRow.setMonths(Z1);this._dateNav.setStep(Z1);}break;case d1.Week:if(this._oWeeksRow&&this._oWeeksRow.getDays()!=Z1){this._oWeeksRow.setDays(Z1);this._dateNav.setStep(Z1);}break;case d1.OneMonth:if(this._oOneMonthsRow&&this._oOneMonthsRow.getDays()!=Z1){this._oOneMonthsRow.setDays(Z1);this._dateNav.setStep(Z1);if(this._iSize>1){this._setRowsStartDate(new Date(this.getStartDate().getTime()));}}break;default:throw new Error("Unknown IntervalType: "+Y1+"; "+this);}P1.call(this);}else if(!R1){for(i=0;i<S1.length;i++){T1=S1[i];H1(T1).handleResize();}}if(this._oOneMonthsRow&&this.getViewKey()===d1.OneMonth){U1=(this._getSelectedDates().length&&this._getSelectedDates()[0].getStartDate())?this._getSelectedDates()[0].getStartDate():this.getStartDate();this._oOneMonthsRow.setMode(this._iSize);this._adjustSelectedDate(c.fromLocalJSDate(U1));}if(this.getStickyHeader()){this._updateStickyHeader();}}function x1(R1){var S1=R1.getParameter("appointment"),T1=R1.getParameter("multiSelect"),U1=R1.getParameter("appointments"),V1=R1.getParameter("domRefId"),W1,X1,Y1,Z1,$1,i,j;if(!T1){X1=this.getRows();for(i=0;i<X1.length;i++){Y1=X1[i];if(R1.oSource!=H1(Y1)){Z1=Y1.getAppointments();for(j=0;j<Z1.length;j++){$1=Z1[j];$1.setSelected(false);}}}}W1={appointment:S1,appointments:U1,multiSelect:T1,domRefId:V1};this.fireAppointmentSelect(W1);}k1.prototype._setRowsStartDate=function(j){var R1=this.getRows(),S1,i;for(i=0;i<R1.length;i++){S1=R1[i];H1(S1).setStartDate(j);}};k1.prototype._toggleAppointmentsColumnPopinState=function(i){var j=this.getAggregation("table"),R1=j.getColumns()[1];R1.setDemandPopin(i);R1.setMinScreenWidth(i?n1:"");};k1.prototype._getViews=function(){var i=this.getViews(),j=this.getBuiltInViews(),R1,S1=[],T1=_,U1=d1;if(!this._oViews){this._oViews={};}if(j.length){S1=j;}else{S1=i.length?[]:o1;}R1=S1.map(function(W1){switch(W1){case T1.Hour:return this._oViews[T1.Hour]||(this._oViews[T1.Hour]=new L(this.getId()+"-HourView",{key:T1.Hour,intervalType:U1.Hour,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_HOURS"),intervalsS:6,intervalsM:6,intervalsL:12}));case T1.Day:return this._oViews[T1.Day]||(this._oViews[T1.Day]=new L(this.getId()+"-DayView",{key:T1.Day,intervalType:U1.Day,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_DAYS"),intervalsS:7,intervalsM:7,intervalsL:14}));case T1.Month:return this._oViews[T1.Month]||(this._oViews[T1.Month]=new L(this.getId()+"-MonthView",{key:T1.Month,intervalType:U1.Month,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_MONTHS"),intervalsS:3,intervalsM:6,intervalsL:12}));case T1.Week:return this._oViews[T1.Week]||(this._oViews[T1.Week]=new L(this.getId()+"-WeekView",{key:T1.Week,intervalType:U1.Week,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_WEEK"),intervalsS:7,intervalsM:7,intervalsL:7}));case T1.OneMonth:return this._oViews[T1.OneMonth]||(this._oViews[T1.OneMonth]=new L(this.getId()+"-OneMonthView",{key:T1.OneMonth,intervalType:U1.OneMonth,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_ONE_MONTH"),intervalsS:1,intervalsM:1,intervalsL:31}));default:V.error("Cannot get PlanningCalendar views. Invalid view key "+W1);break;}},this);for(var V1 in this._oViews){if(S1.indexOf(V1)<0){this._oViews[V1].destroy();delete this._oViews[V1];}}if(i.length){R1=R1.concat(i);}return R1;};k1.prototype.getSelectedAppointments=function(){var i=[];this.getRows().filter(function(j){i.push.apply(i,H1(j).aSelectedAppointments);});return i;};k1.prototype.setCustomAppointmentsSorterCallback=function(i){if(typeof i==="function"||i===null||i===undefined){this.getRows().forEach(function(j){H1(j)._setCustomAppointmentsSorterCallback(i);});this._fnCustomSortedAppointments=i;}else{V.warning("Your custom sort function won't be used, but the old one will be preserved.",this);}return this;};k1.prototype.setWidth=function(i){var j=this.getStartDate();this.getRows().forEach(function(R1){H1(R1).setStartDate(j);});return this.setProperty("width",i);};k1.prototype.getCustomAppointmentsSorterCallback=function(){return this._fnCustomSortedAppointments;};k1.prototype._onRowDeselectAppointment=function(){var R1=this.getRows();for(var i=0;i<R1.length;i++){var S1=H1(R1[i]).aSelectedAppointments;for(var j=0;j<S1.length;j++){var T1=n.byId(S1[j]);if(T1){T1.setProperty("selected",false,true);T1.$().removeClass("sapUiCalendarAppSel");}}H1(R1[i]).aSelectedAppointments=[];}};k1.prototype._updateRowTimeline=function(i){var j=H1(i),R1,S1,T1,U1,V1=this.getViewKey()===_.OneMonth&&this._iSize<2,W1=this.getStartDate();j.setNonWorkingDays(i.getNonWorkingDays());j.setNonWorkingHours(i.getNonWorkingHours());if(V1&&this._oOneMonthsRow&&this._oOneMonthsRow.getSelectedDates().length){W1=this._oOneMonthsRow.getSelectedDates()[0].getStartDate();}j.setStartDate(W1);j.setShowIntervalHeaders(this.getShowIntervalHeaders());j.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());j.setGroupAppointmentsMode(this.getGroupAppointmentsMode());j.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());j.setAppointmentRoundWidth(this.getAppointmentRoundWidth());j.setLegend(this.getLegend());j.setAppointmentsVisualization(this.getAppointmentsVisualization());j.setAppointmentHeight(this.getAppointmentHeight());j.attachEvent("select",x1,this);j.attachEvent("startDateChange",this._handleStartDateChange,this);j.attachEvent("leaveRow",N1,this);j.attachEvent("intervalSelect",t1,this);O1.call(this);if(Q1.call(this)){R1=this.getViewKey();S1=this._getView(R1);T1=S1.getIntervalType();U1=this._getIntervals(S1);j.setIntervalType(T1);j.setIntervals(U1);j.setShowSubIntervals(S1.getShowSubIntervals());}this._setSelectionMode.call(this);if(this._fnCustomSortedAppointments){j._setCustomAppointmentsSorterCallback(this._fnCustomSortedAppointments);}};k1.prototype._observeRowChanges=function(i){var j=F1(i),R1=G1(i),S1=H1(i);var T1={destroy:function(){j.destroy();},change:{title:function(U1){R1.setProperty(U1.name,U1.current);},icon:function(U1){R1.setProperty(U1.name,U1.current);},text:function(U1){S1.toggleStyleClass("sapMPlanCalRowLarge",!!U1.current);R1.setProperty("description",U1.current);},enableAppointmentsDragAndDrop:function(U1){this._enableAppointmentsDragAndDrop(i);}.bind(this),enableAppointmentsResize:function(U1){this._enableAppointmentsResize(i);}.bind(this),enableAppointmentsCreate:function(U1){this._enableAppointmentsCreate(i);}.bind(this),nonWorkingDays:function(U1){S1.setProperty(U1.name,U1.current);},nonWorkingHours:function(U1){S1.setProperty(U1.name,U1.current);},selected:function(U1){O1.call(this);j.setProperty(U1.name,U1.current);}.bind(this),tooltip:function(U1){if(U1.mutation==="insert"){R1.setTooltip(U1.child);}else if(U1.mutation==="remove"){R1.setTooltip();}},intervalHeaders:function(U1){S1.invalidate();},appointments:function(U1){S1.invalidate();}}};new a(function(U1){if(U1.type==="destroy"){T1.destroy();}else if(T1.change[U1.name]){T1.change[U1.name](U1);}}).observe(i,{properties:["icon","text","title","nonWorkingDays","nonWorkingHours","selected","enableAppointmentsDragAndDrop","enableAppointmentsResize","enableAppointmentsCreate"],aggregations:["tooltip","appointments","intervalHeaders","headerContent"],destroy:true});i.invalidate=function(U1){if(!U1||!(U1 instanceof h)){E.prototype.invalidate.apply(this,arguments);}else if(j){S1.invalidate(U1);}};i.applyFocusInfo=function(U1){S1.applyFocusInfo(U1);return this;};};k1.prototype._createPlanningCalendarListItem=function(i){var j,R1,S1;if(i.getHeaderContent().length||i.getBindingInfo("headerContent")){R1=i._getPlanningCalendarCustomRowHeader();}else{R1=new y1(i.getId()+"-Head",{icon:i.getIcon(),description:i.getText(),title:i.getTitle(),tooltip:i.getTooltip(),iconDensityAware:false});}S1=new A1(i.getId()+"-CalRow",{checkResize:false,updateCurrentTime:false,ariaLabelledBy:R1.getId()});S1.getAppointments=function(){return i.getAppointments();};S1.getIntervalHeaders=function(){return i.getIntervalHeaders();};S1.setAssociation("row",i.getId());j=new C1(i.getId()+j1,{cells:[R1,S1]});this._updateRowTimeline(i);this._observeRowChanges(i);this._enableAppointmentsDragAndDrop(i);this._enableAppointmentsResize(i);this._enableAppointmentsCreate(i);return j;};k1.prototype._handleRowRemoval=function(i){var j=H1(i);j.detachEvent("select",x1,this);j.detachEvent("startDateChange",this._handleStartDateChange,this);j.detachEvent("leaveRow",N1,this);j.detachEvent("intervalSelect",t1,this);if(this._fnCustomSortedAppointments){j._fnCustomSortedAppointments=undefined;}F1(i).destroy();};var y1=G.extend("PlanningCalendarRowHeader",{renderer:R.extend(H),TagName:"div"});y1.prototype.isSelectable=function(){return false;};PlanningCalendarRowHeaderRenderer.renderTabIndex=function(i,j){};PlanningCalendarRowHeaderRenderer.getAriaRole=function(i,j){};var z1=R.extend(l);z1.apiVersion=2;z1.getLegendItems=function(i){var j=[],R1,S1=i.getLegend();if(S1){R1=n.byId(S1);if(R1){j=R1.getAppointmentItems?R1.getAppointmentItems():R1.getItems();}else{V.error("PlanningCalendarLegend with id '"+S1+"' does not exist!",i);}}return j;};z1.renderBeforeAppointments=function(j,R1){var S1=E1(R1.getParent()),T1;if(!S1.getEnableAppointmentsDragAndDrop()&&!S1.getEnableAppointmentsResize()&&!S1.getEnableAppointmentsCreate()||R1._isOneMonthsRowOnSmallSizes()){return;}T1=R1.getAggregation("_intervalPlaceholders");j.openStart("div");j.class("sapUiCalendarRowAppsOverlay");j.openEnd();if(T1){for(var i=0;i<T1.length;i++){var U1=T1[i];U1.setWidth(100/T1.length+"%");j.renderControl(U1);}}j.close("div");};z1.renderResizeHandle=function(i,j,R1){if(!E1(j.getParent()).getEnableAppointmentsResize()||j._isOneMonthsRowOnSmallSizes()||(R1._aAppointments&&R1._aAppointments.length>0)){return;}i.openStart("span");i.class("sapUiCalendarAppResizeHandle");i.openEnd();i.close("span");};z1.writeCustomAttributes=function(i,j){if(E1(j.getParent()).getEnableAppointmentsCreate()){i.attr("draggable","true");}};z1.renderInterval=function(j,R1,S1,T1,U1,V1,W1,X1,Y1,Z1,$1,_1,a2){var b2=R1.getIntervalType(),c2;if(b2===d1.Day||b2===d1.Week||b2===d1.OneMonth){var d2=E1(R1.getParent()),e2=d2.getParent(),f2=function(p2){return p2.getType()===Y.NonWorking;},g2=d2._getSpecialDates().filter(f2),h2=e2._getSpecialDates().filter(f2),i2=R1.getStartDate(),j2,k2,l2,m2;if(h2&&g2){j2=h2.concat(g2);}else if(g2){j2=g2;}if(j2&&j2.length){var n2=function(p2){return p2===k2.getDay();};k2=new Date(i2.getTime());k2.setHours(0,0,0);k2.setDate(i2.getDate()+S1);for(var i=0;i<j2.length;i++){if(j2[i].getStartDate()){l2=new Date(j2[i].getStartDate().getTime());}if(j2[i].getEndDate()){m2=new Date(j2[i].getEndDate().getTime());}else{m2=new Date(j2[i].getStartDate().getTime());m2.setHours(23,59,59);}if(k2.getTime()>=l2.getTime()&&k2.getTime()<=m2.getTime()){var o2=V1.some(n2);if(!o2){c2="sapUiCalendarRowAppsNoWork";}}}}}l.renderInterval(j,R1,S1,T1,U1,V1,W1,X1,Y1,Z1,$1,_1,a2,c2);};var A1=k.extend("PlanningCalendarRowTimeline",{metadata:{aggregations:{intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true},_intervalPlaceholders:{type:"IntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}}},associations:{row:{type:"sap.m.PlanningCalendarRow",multiple:false}},dnd:true},renderer:z1});A1.prototype._updatePlaceholders=function(){var j=this.getProperty("intervals");if(this.getIntervalType()===d1.Hour){j*=2;}this.removeAllAggregation("_intervalPlaceholders");for(var i=0;i<j;i++){this.addAggregation("_intervalPlaceholders",new B1());}};A1.prototype.onBeforeRendering=function(){k.prototype.onBeforeRendering.call(this);this._updatePlaceholders();};A1.prototype.onmousedown=function(i){var j=i.target.classList;this._isResizeHandleMouseDownTarget=j.contains("sapUiCalendarAppResizeHandle");this._isRowAppsIntervalMouseDownTarget=j.contains("sapUiCalendarRowAppsInt");};A1.prototype._isResizingPerformed=function(){return this._isResizeHandleMouseDownTarget;};A1.prototype._isDraggingPerformed=function(){return!this._isResizeHandleMouseDownTarget&&!this._isRowAppsIntervalMouseDownTarget;};A1.prototype._isCreatingPerformed=function(){return this._isRowAppsIntervalMouseDownTarget;};var B1=C.extend("IntervalPlaceholder",{metadata:{properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}}},renderer:function(i,j){i.openStart("div",j);i.style("width",j.getWidth());i.class("sapUiCalendarRowAppsPlaceholder");i.openEnd();i.close("div");}});var C1=z.extend("sap.m.internal.PlanningCalendarRowListItem",{metadata:{library:"sap.m"},renderer:A});C1.prototype.getHeader=function(){return this.getCells()[0];};C1.prototype.getTimeline=function(){return this.getCells()[1];};C1.prototype.getCustomData=function(){return E1(this).getCustomData();};k1.prototype._getSelectedDates=function(){var i=this.getViewKey(),j=this._getView(i),R1=j.getIntervalType(),S1=m1[R1];return this[S1.sInstanceName].getSelectedDates();};k1.prototype._enableAppointmentsDragAndDrop=function(i){var j=H1(i),R1;if(i.getEnableAppointmentsDragAndDrop()){R1=i.getDragDropConfig().some(function(S1){return S1.getGroupName()===g1;});if(!R1){this._addDragDropInfo(i,H1(i));}}else{i.getDragDropConfig().forEach(function(S1){if(S1.getGroupName()===g1){i.removeDragDropConfig(S1);}});j.getDragDropConfig().forEach(function(S1){if(S1.getGroupName()===g1){j.removeDragDropConfig(S1);}});}};k1.prototype._enableAppointmentsResize=function(i){var j=i.getEnableAppointmentsResize(),R1=this._getConfigFromDragDropConfigAggregation(i.getAggregation("dragDropConfig"),h1),S1=this._getResizeConfig(i);if(j&&!R1){i.addAggregation("dragDropConfig",S1,true);}if(!j){i.removeAggregation("dragDropConfig",R1,true);}};k1.prototype._enableAppointmentsCreate=function(i){var j=i.getEnableAppointmentsCreate(),R1=H1(i),S1=this._getConfigFromDragDropConfigAggregation(R1.getAggregation("dragDropConfig"),i1),T1=this._getAppointmentsCreateConfig(i);if(j&&!S1){R1.addAggregation("dragDropConfig",T1,true);}if(!j){R1.removeAggregation("dragDropConfig",S1,true);}};k1.prototype._addDragDropInfo=function(i,j){i.addDragDropConfig(new q({groupName:g1,sourceAggregation:"appointments",dragStart:function(R1){var S1=function(){var T1=W(".sapUiCalendarRowAppsOverlay");setTimeout(function(){T1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);W(document).one("dragend",function(){T1.removeClass("sapUiCalendarRowAppsOverlayDragging");});};if(j._isOneMonthsRowOnSmallSizes()||!j._isDraggingPerformed()){R1.preventDefault();return;}S1();}}));j.addDragDropConfig(new r({groupName:g1,targetAggregation:"_intervalPlaceholders",dragEnter:function(R1){var S1=R1.getParameter("dragSession"),T1=S1.getDragControl(),U1=j.getIntervalType(),V1=j.getStartDate(),W1=j.indexOfAggregation("_intervalPlaceholders",S1.getDropControl()),X1=j.getId(),Y1,Z1=function(){var _1=W(S1.getIndicator()),a2=S1.getDropControl().getDomRef().getBoundingClientRect(),b2=n.byId(X1).getDomRef().getBoundingClientRect(),c2=S1.getDragControl().$().outerWidth(),d2=n.getConfiguration().getRTL(),e2=d2?Math.ceil(a2.right)-b2.left:b2.right-Math.ceil(a2.left);_1.css("min-width",(c2<e2)?c2:e2).css(d2?"border-left-width":"border-right-width",(c2>e2)?"0":"").css("margin-left",d2?-(_1.outerWidth()-parseFloat(_1.context.style.width)):"");};if(i.hasListeners("appointmentDragEnter")){if(U1===d1.Hour){Y1=this._calcNewHoursAppPos(V1,T1.getStartDate(),T1.getEndDate(),W1);}else if(U1===d1.Day||U1===d1.Week||(U1===d1.OneMonth&&!j._isOneMonthsRowOnSmallSizes())){Y1=this._calcNewDaysAppPos(V1,T1.getStartDate(),T1.getEndDate(),W1);}else if(U1===d1.Month){Y1=this._calcNewMonthsAppPos(V1,T1.getStartDate(),T1.getEndDate(),W1);}var $1=i.fireAppointmentDragEnter({appointment:T1,startDate:Y1.startDate,endDate:Y1.endDate,calendarRow:E1(j.getParent())});if(!$1){R1.preventDefault();return;}}else if(H1(T1.getParent())!==j){R1.preventDefault();return;}if(j.getIntervalType()!==d1.Hour){return;}if(!S1.getIndicator()){setTimeout(Z1,0);}else{Z1();}}.bind(this),drop:function(R1){var S1=R1.getParameter("dragSession"),T1=S1.getDragControl(),U1=j.getIntervalType(),V1=j.getStartDate(),W1=j.indexOfAggregation("_intervalPlaceholders",S1.getDropControl()),X1,Y1=R1.getParameter("browserEvent"),Z1=(Y1.metaKey||Y1.ctrlKey);if(U1===d1.Hour){X1=this._calcNewHoursAppPos(V1,T1.getStartDate(),T1.getEndDate(),W1);}else if(U1===d1.Day||U1===d1.Week||(U1===d1.OneMonth&&!j._isOneMonthsRowOnSmallSizes())){X1=this._calcNewDaysAppPos(V1,T1.getStartDate(),T1.getEndDate(),W1);}else if(U1===d1.Month){X1=this._calcNewMonthsAppPos(V1,T1.getStartDate(),T1.getEndDate(),W1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");if(T1.getStartDate().getTime()===X1.startDate.getTime()&&T1.getParent()===E1(j.getParent())){return;}i.fireAppointmentDrop({appointment:T1,startDate:X1.startDate,endDate:X1.endDate,calendarRow:E1(j.getParent()),copy:Z1});}.bind(this)}));};k1.prototype._calcNewHoursAppPos=function(i,j,R1,S1){var T1=b._createUniversalUTCDate(i,null,true),U1=b._createUniversalUTCDate(j,null,true),V1=b._createUniversalUTCDate(R1,null,true),W1=new Date(T1.setUTCMinutes(0,0,0)+(S1*30*60*1000));return{startDate:b._createLocalDate(W1,true),endDate:b._createLocalDate(new Date(W1.getTime()+V1.getTime()-U1.getTime()),true)};};k1.prototype._calcNewDaysAppPos=function(i,j,R1,S1){var T1=b._createUniversalUTCDate(i,null,true),U1=b._createUniversalUTCDate(j,null,true),V1=b._createUniversalUTCDate(R1,null,true),W1=V1.getTime()-U1.getTime();U1.setUTCFullYear(T1.getUTCFullYear(),T1.getUTCMonth(),T1.getUTCDate()+S1);V1=new Date(U1.getTime()+W1);return{startDate:b._createLocalDate(U1,true),endDate:b._createLocalDate(V1,true)};};k1.prototype._calcNewMonthsAppPos=function(i,j,R1,S1){var T1=b._createUniversalUTCDate(i,null,true),U1=b._createUniversalUTCDate(j,null,true),V1=b._createUniversalUTCDate(R1,null,true),W1=V1.getTime()-U1.getTime();U1.setUTCFullYear(T1.getUTCFullYear(),T1.getUTCMonth()+S1);V1=new Date(U1.getTime()+W1);return{startDate:b._createLocalDate(U1,true),endDate:b._createLocalDate(V1,true)};};k1.prototype._getResizeConfig=function(i){var j=H1(i),R1=new s({sourceAggregation:"appointments",targetAggregation:"_intervalPlaceholders",targetElement:H1(i),dragStart:function(S1){if(!i.getEnableAppointmentsResize()||j._isOneMonthsRowOnSmallSizes()||!j._isResizingPerformed()){S1.preventDefault();return;}var T1=S1.getParameter("dragSession"),U1=j.$().find(".sapUiCalendarRowAppsOverlay"),V1=W(T1.getIndicator()),W1=T1.getDragControl().$();V1.addClass("sapUiDnDIndicatorHide");setTimeout(function(){U1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);W(document).one("dragend",function(){U1.removeClass("sapUiCalendarRowAppsOverlayDragging");V1.removeClass("sapUiDnDIndicatorHide");W1.css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});});if(!m.browser.msie&&!m.browser.edge){S1.getParameter("browserEvent").dataTransfer.setDragImage(D1(),0,0);}},dragEnter:function(S1){var T1=S1.getParameter("dragSession"),U1=this.getTargetElement(),V1=function(){var $1=W(T1.getIndicator());$1.addClass("sapUiDnDIndicatorHide");},W1=T1.getDropControl().getDomRef().getBoundingClientRect(),X1=n.byId(U1).getDomRef().getBoundingClientRect(),Y1={width:W1.left+W1.width-(T1.getDragControl().$().position().left+X1.left),"z-index":1,opacity:0.8},Z1=Y1.width;if(W1.width>0){while(Z1<=0){Z1+=W1.width;}while(Z1>W1.width){Z1-=W1.width;}}Y1["min-width"]=Z1;T1.getDragControl().$().css(Y1);if(!T1.getIndicator()){setTimeout(V1,0);}else{V1();}},drop:function(S1){var j=H1(i),T1=S1.getParameter("dragSession"),U1=T1.getDragControl(),V1=j.getIntervalType(),W1=j.getStartDate(),X1=j.indexOfAggregation("_intervalPlaceholders",T1.getDropControl()),Y1;if(V1===d1.Hour){Y1=this._calcResizeNewHoursAppPos(W1,U1.getStartDate(),U1.getEndDate(),X1);}else if(V1===d1.Day||V1===d1.Week||(V1===d1.OneMonth&&!j._isOneMonthsRowOnSmallSizes())){Y1=this._calcResizeNewDaysAppPos(W1,U1.getStartDate(),U1.getEndDate(),X1);}else if(V1===d1.Month){Y1=this._calcResizeNewMonthsAppPos(W1,U1.getStartDate(),U1.getEndDate(),X1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");W(T1.getIndicator()).removeClass("sapUiDnDIndicatorHide");U1.$().css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});if(U1.getEndDate().getTime()===Y1.endDate.getTime()){return;}i.fireAppointmentResize({appointment:U1,startDate:Y1.startDate,endDate:Y1.endDate,calendarRow:i});}.bind(this)});R1.setProperty("groupName",h1);return R1;};k1.prototype._calcResizeNewHoursAppPos=function(i,j,R1,S1){var T1=b._createUniversalUTCDate(new Date(i.getTime()),null,true),U1=30*60*1000,V1=b._createUniversalUTCDate(j,null,true),W1=new Date(T1.setUTCMinutes(0,0,0)+((S1+1)*U1));if(W1.getTime()<=V1.getTime()){W1=new Date(V1.getTime()+U1);}return{startDate:b._createLocalDate(V1,true),endDate:b._createLocalDate(W1,true)};};k1.prototype._calcResizeNewDaysAppPos=function(i,j,R1,S1){var T1=b._createUniversalUTCDate(i,null,true),U1=b._createUniversalUTCDate(j,null,true),V1=new Date(T1.setUTCDate(T1.getUTCDate()+S1+1)),W1={};W1.startDate=b._createLocalDate(U1);W1.startDateTime=b._createLocalDate(U1,true);W1.endDate=b._createLocalDate(V1);if(W1.endDate<=W1.startDate){W1.endDate=b._createLocalDate(new Date(V1.setUTCDate(U1.getUTCDate()+1)));}return{startDate:W1.startDateTime,endDate:W1.endDate};};k1.prototype._calcResizeNewMonthsAppPos=function(i,j,R1,S1){var T1=b._createUniversalUTCDate(i,null,true),U1=b._createUniversalUTCDate(j,null,true),V1=new Date(T1.setUTCMonth(T1.getUTCMonth()+S1+1,1));if(b._monthsBetween(U1,V1,true)<0){V1=new Date(V1.setUTCFullYear(U1.getUTCFullYear(),U1.getUTCMonth()+1,1));}return{startDate:b._createLocalDate(U1,true),endDate:b._createLocalDate(V1)};};k1.prototype._calcCreateNewAppHours=function(i,j,R1){var S1=b._createUniversalUTCDate(i,null,true),T1=30*60*1000,U1=(j<=R1)?j:R1,V1=(j<=R1)?R1+1:j,W1=new Date(S1.setUTCMinutes(0,0,0)),X1=new Date(W1.getTime()+U1*T1),Y1=new Date(W1.getTime()+V1*T1);return{startDate:b._createLocalDate(X1,true),endDate:b._createLocalDate(Y1,true)};};k1.prototype._calcCreateNewAppDays=function(i,j,R1){var S1=b._createUniversalUTCDate(i,null,true),T1=(j<=R1)?j:R1,U1=(j<=R1)?R1+1:j,V1=new Date(S1.getTime()),W1=new Date(S1.getTime());return{startDate:b._createLocalDate(new Date(V1.setUTCDate(V1.getUTCDate()+T1))),endDate:b._createLocalDate(new Date(W1.setUTCDate(W1.getUTCDate()+U1)))};};k1.prototype._calcCreateNewAppMonths=function(i,j,R1){var S1=b._createUniversalUTCDate(i,null,true),T1=(j<=R1)?j:R1,U1=(j<=R1)?R1+1:j,V1=new Date(S1.getTime()),W1=new Date(S1.getTime());return{startDate:b._createLocalDate(new Date(V1.setUTCMonth(V1.getUTCMonth()+T1,1))),endDate:b._createLocalDate(new Date(W1.setUTCMonth(W1.getUTCMonth()+U1,1)))};};k1.prototype._getConfigFromDragDropConfigAggregation=function(j,R1){var S1=j,T1=S1&&S1.length;for(var i=0;i<T1;i++){if(S1[i].getGroupName()===R1){return S1[i];}}return null;};k1.prototype._getAppointmentsCreateConfig=function(i){var j=H1(i),R1=new s({targetAggregation:"_intervalPlaceholders",dragStart:function(S1){if(!i.getEnableAppointmentsCreate()||j._isOneMonthsRowOnSmallSizes()||!j._isCreatingPerformed()){S1.preventDefault();return;}var T1=S1.getParameter("dragSession"),U1=j.$().find(".sapUiCalendarRowAppsOverlay"),V1=W(T1.getIndicator());setTimeout(function(){U1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);W(document).one("dragend",function(){U1.removeClass("sapUiCalendarRowAppsOverlayDragging");V1.html("");V1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");});if(!m.browser.msie&&!m.browser.edge){S1.getParameter("browserEvent").dataTransfer.setDragImage(D1(),0,0);}},dragEnter:function(S1){var T1=S1.getParameter("dragSession"),U1=T1.getDropControl().getDomRef().getBoundingClientRect(),V1=function(){var X1=W(T1.getIndicator());X1.addClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");};var W1=T1.getData("text")?parseFloat(T1.getData("text").split("|")[0]):0;if(W1){if(W1<=U1.left){T1.setIndicatorConfig({left:W1,width:Math.max((U1.left+U1.width-W1),U1.width)});}else{T1.setIndicatorConfig({left:U1.left,width:W1-U1.left});}}else{T1.setData("text",U1.left+"|"+j.indexOfAggregation("_intervalPlaceholders",T1.getDropControl()));}if(!T1.getIndicator()){setTimeout(V1,0);}else{V1();}},drop:function(S1){var T1=S1.getParameter("dragSession"),U1=W(T1.getIndicator()),V1=j.getIntervalType(),W1=H1(i).getStartDate(),X1=parseInt(T1.getData("text").split("|")[1]),Y1=j.indexOfAggregation("_intervalPlaceholders",T1.getDropControl()),Z1;if(V1===d1.Hour){Z1=this._calcCreateNewAppHours(W1,X1,Y1);}else if(V1===d1.Day||V1===d1.Week||(V1===d1.OneMonth&&!j._isOneMonthsRowOnSmallSizes())){Z1=this._calcCreateNewAppDays(W1,X1,Y1);}else if(V1===d1.Month){Z1=this._calcCreateNewAppMonths(W1,X1,Y1);}i.fireAppointmentCreate({startDate:Z1.startDate,endDate:Z1.endDate,calendarRow:i});U1.html("");U1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");}.bind(this)});R1.setProperty("groupName",i1);return R1;};k1.prototype._updateHeaderButtons=function(){var i=this.getViewKey(),j=this._getView(i,true),R1=j&&j.getIntervalType(),S1=new Date(this._dateNav.getStart().getTime()),T1=new Date(this._dateNav.getEnd().getTime()),U1=this.getMinDate()?new Date(this.getMinDate().getTime()):undefined,V1=this.getMaxDate()?new Date(this.getMaxDate().getTime()):undefined;if(R1!=="Hour"){U1&&U1.setHours(0,0,0,0);V1&&V1.setHours(23,59,59,999);S1.setHours(0,0,0,0);T1.setHours(23,59,59,999);}this._getHeader()._oPrevBtn.setEnabled(!U1||S1.getTime()>U1.getTime());this._getHeader()._oNextBtn.setEnabled(!V1||T1.getTime()<V1.getTime());};k1.prototype._getSpecialDates=function(){var j=this.getSpecialDates();for(var i=0;i<j.length;i++){var R1=j[i].getSecondaryType()===u.CalendarDayType.NonWorking&&j[i].getType()!==u.CalendarDayType.NonWorking;if(R1){var S1=new g();S1.setType(u.CalendarDayType.NonWorking);S1.setStartDate(j[i].getStartDate());if(j[i].getEndDate()){S1.setEndDate(j[i].getEndDate());}j.push(S1);}}return j;};function D1(){var i=W("<span></span>").addClass("sapUiCalAppResizeGhost");i.appendTo(document.body);setTimeout(function(){i.remove();},0);return i.get(0);}function E1(i){var j=i.getId();return n.byId(j.substring(0,j.indexOf(j1)));}function F1(i){return n.byId(i.getId()+j1);}function G1(i){var j=F1(i);return j?j.getHeader():null;}function H1(i){var j=F1(i);return j?j.getTimeline():null;}function I1(j){var R1=[];var S1=this.getRows();for(var i=0;i<S1.length;i++){var T1=S1[i];var U1=F1(T1);var V1=U1.getSelected();if(T1.getSelected()!=V1){T1.setProperty("selected",V1,true);R1.push(T1);}}if(!this.getSingleSelection()){O1.call(this);}if(R1.length>0){this.fireRowSelectionChange({rows:R1});}}function J1(i){if(i<this._iBreakPointTablet){this._iSize=0;}else if(i<this._iBreakPointDesktop){this._iSize=1;}else{this._iSize=2;}if(i<p1.PHONE){this._iSizeScreen=0;}else if(i<p1.TABLET){this._iSizeScreen=1;}else{this._iSizeScreen=2;}}function K1(j){var R1='sapMSize'+j,i,S1;for(i=0;i<3;i++){S1='sapMSize'+i;if(S1===R1){this.addStyleClass(S1);}else{this.removeStyleClass(S1);}}}function L1(){var j=this._getViews();this._oIntervalTypeSelect.destroyItems();var i;var R1;for(i=0;i<j.length;i++){var S1=j[i];R1=new F(this.getId()+"-"+i,{key:S1.getKey(),text:S1.getDescription(),tooltip:S1.getTooltip()});this._oIntervalTypeSelect.addItem(R1);}if(this._oIntervalTypeSelect.getItems().length>4){this._getHeader()._convertViewSwitchToSelect();}else{this._getHeader()._convertViewSwitchToSegmentedButton();}this._oIntervalTypeSelect.setVisible(!(j.length===1));}function M1(i){var j=i.getParameter("selected");var R1=this.getRows();if(j){R1=this.getRows().filter(function(S1){return!S1.getSelected();});}this.selectAllRows(j);this.fireRowSelectionChange({rows:R1});}function N1(j){var R1=j.oSource;var S1=j.getParameter("type");var T1=this.getRows();var U1;var V1;var W1;var X1;var i=0;var Y1=0;var Z1;for(i=0;i<T1.length;i++){U1=T1[i];if(H1(U1)==R1){Y1=i;break;}}switch(S1){case"sapup":W1=R1.getFocusedAppointment();X1=W1.getStartDate();if(Y1>0){Y1--;}V1=T1[Y1];H1(V1).focusNearestAppointment(X1);break;case"sapdown":W1=R1.getFocusedAppointment();X1=W1.getStartDate();if(Y1<T1.length-1){Y1++;}V1=T1[Y1];H1(V1).focusNearestAppointment(X1);break;case"saphome":if(Y1>0){V1=T1[0];Z1=new W.Event(S1);Z1._bPlanningCalendar=true;H1(V1).onsaphome(Z1);}break;case"sapend":if(Y1<T1.length-1){V1=T1[T1.length-1];Z1=new W.Event(S1);Z1._bPlanningCalendar=true;H1(V1).onsapend(Z1);}break;default:break;}}function O1(){if(this._oSelectAllCheckBox){var i=this.getRows();var j=this.getSelectedRows();if(i.length==j.length&&j.length>0){this._oSelectAllCheckBox.setSelected(true);}else{this._oSelectAllCheckBox.setSelected(false);}}}function P1(){if(this.getSingleSelection()){if(this._oCalendarHeader.getAllCheckBox()){this._oCalendarHeader.setAllCheckBox();}else if(this._oInfoToolbar.getContent().length>2){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}}else{if(!this._oSelectAllCheckBox){this._oSelectAllCheckBox=new N(this.getId()+"-All",{text:this._oRB.getText("COLUMNSPANEL_SELECT_ALL")});this._oSelectAllCheckBox.attachEvent("select",M1,this);}if(this._iSizeScreen<2||!this.getShowRowHeaders()){var i=this._oInfoToolbar.indexOfContent(this._oSelectAllCheckBox);if(this._iSizeScreen<2){if(i<this._oInfoToolbar.getContent().length-1){this._oInfoToolbar.addContent(this._oSelectAllCheckBox);}}else if(i<0||i>1){if(i>1){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}this._oInfoToolbar.insertContent(this._oSelectAllCheckBox,1);}}else{this._oCalendarHeader.setAllCheckBox(this._oSelectAllCheckBox);}}}k1.prototype._setSelectionMode=function(){var i=this.getAggregation("table");var j=i.getMode();var R1;if(this.getSingleSelection()){if(!this.getShowRowHeaders()&&this.getRows().length==1){R1=Z.None;}else{R1=Z.SingleSelectMaster;}}else{R1=Z.MultiSelect;}if(j!=R1){i.setMode(R1);}};function Q1(){return this._oTimesRow||this._oDatesRow||this._oMonthsRow||this._oWeeksRow||this._oOneMonthsRow;}return k1;});
