/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/library","sap/ui/integration/cards/BaseContent","sap/m/library","sap/m/HBox","sap/m/VBox","sap/m/Text","sap/m/Title","sap/f/Avatar","sap/m/Link","sap/m/Label","sap/ui/core/ResizeHandler","sap/ui/layout/AlignedFlowLayout","sap/ui/dom/units/Rem","sap/ui/integration/util/BindingHelper"],function(l,B,L,H,V,T,a,A,b,c,R,d,e,f){"use strict";var g=l.AreaType;var h=L.AvatarSize;var O=B.extend("sap.ui.integration.cards.ObjectContent",{renderer:{}});O.prototype._getRootContainer=function(){if(this._bIsBeingDestroyed){return null;}var o=this.getAggregation("_content");if(!o){o=new d();this.setAggregation("_content",o);}this._sResizeListenerId=R.register(o,this.onAlignedFlowLayoutResize.bind(this));o.addEventDelegate({"onAfterRendering":function(){this.getContent().forEach(function(E){if(!E.getVisible()){document.getElementById("sap-ui-invisible-"+E.getId()).parentElement.classList.add("sapFCardInvisibleContent");}});}},o);return o;};O.prototype.onAlignedFlowLayoutResize=function(E){if(E&&(E.size.width===E.oldSize.width)&&!E.control){return;}var C=E.control,m=C.getMinItemWidth(),n=C.getContent().length,M;if(m.lastIndexOf("rem")!==-1){M=e.toPx(m);}else if(m.lastIndexOf("px")!==-1){M=parseFloat(m);}var i=Math.floor(E.size.width/M);if(i>n){i=n;}if(this._iColsOld===i){return;}this._iColsOld=i;var j=i-1,r=Math.ceil(n/i);C.getContent().forEach(function(I,k){I.addStyleClass("sapFCardObjectSpaceBetweenGroup");if(j===k&&j<n){I.removeStyleClass("sapFCardObjectSpaceBetweenGroup");j+=i;}if(k+1>(r-1)*i){I.addStyleClass("sapFCardObjectGroupLastInColumn");}else{I.removeStyleClass("sapFCardObjectGroupLastInColumn");}});};O.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId="";}};O.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);if(!C){return this;}if(C.groups){this._addGroups(C);}return this;};O.prototype._addGroups=function(C){var o=this._getRootContainer();var G=C.groups||[];G.forEach(function(i){var j=new V({visible:i.visible}).addStyleClass("sapFCardObjectGroup");var t=new a({text:i.title}).addStyleClass("sapFCardObjectItemTitle");j.addItem(t);i.items.forEach(function(I){var k,v=I.label,m=I.value,n,p,q=[];if(v){v=f.formattedProperty(v,function(x){return x&&x[x.length-1]===":"?x:x+=":";});n=new c({text:v,visible:I.visible}).addStyleClass("sapFCardObjectItemLabel");}if(m){switch(I.type){case'link':k=new b({href:I.url||m,text:m,target:I.target||'_blank',visible:I.visible});break;case'email':if(I.value){q.push(I.value);}if(I.emailSubject){q.push(I.emailSubject);}p=f.formattedProperty(q,function(x,E){if(E){return"mailto:"+x+"?subject="+E;}else{return"mailto:"+x;}});k=new b({href:p,text:m,visible:I.visible});break;case'phone':p=f.formattedProperty(m,function(x){return"tel:"+x;});k=new b({href:p,text:m,visible:I.visible});break;default:k=new T({text:m,visible:I.visible});break;}}if(k){k.addStyleClass("sapFCardObjectItemText");}if(I.icon){var s=f.formattedProperty(I.icon.src,function(x){return this._oIconFormatter.formatSrc(x,this._sAppId);}.bind(this));var r=new A({displaySize:I.icon.size||h.XS,src:s,initials:I.icon.text,displayShape:I.icon.shape,tooltip:I.icon.alt}).addStyleClass("sapFCardObjectItemAvatar sapFCardObjectItemLabel sapFCardIcon");var u=new V({items:[n,k]});var w=new H({visible:I.visible,items:[r,u]});j.addItem(w);}else{j.addItem(n);j.addItem(k);}},this);o.addContent(j);},this);this._oActions.setAreaType(g.Content);this._oActions.attach(C,this);};return O;});
