/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/Device","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSectionBase","./ObjectPageSection","./ObjectPageSubSection","./ObjectPageHeaderContent","./LazyLoading","./ObjectPageLayoutABHelper","./ThrottledTaskHelper","sap/m/ScrollBar","sap/ui/core/library","./library","./ObjectPageLayoutRenderer","sap/base/Log","sap/base/util/array/diff","sap/ui/dom/getScrollbarSize","sap/base/assert","sap/base/util/merge","sap/ui/events/KeyCodes","sap/ui/events/F6Navigation","sap/ui/dom/getFirstEditableInput","sap/ui/core/theming/Parameters",'sap/ui/dom/units/Rem'],function(q,M,R,C,a,D,S,O,b,c,d,L,A,T,e,f,l,g,h,i,j,k,m,K,F,n,P,o){"use strict";var p=f.TitleLevel;var r=f.AccessibleLandmarkRole;var s=l.ObjectPageSubSectionLayout;var t=a.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},backgroundDesignAnchorBar:{type:"sap.m.BackgroundDesign",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:s.TitleOnTop},sectionTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:p.Auto},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},headerContentPinnable:{type:"boolean",group:"Behavior",defaultValue:true},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{selectedSection:{type:"sap.uxap.ObjectPageSection",multiple:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.IHeaderTitle",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},footer:{type:"sap.m.IBar",multiple:false},landmarkInfo:{type:"sap.uxap.ObjectPageAccessibleLandmarkInfo",multiple:false},_anchorBar:{type:"sap.uxap.AnchorBar",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.IHeaderContent",multiple:false,visibility:"hidden"},_customScrollBar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},sectionChange:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},editHeaderButtonPress:{},navigate:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},subSectionVisibilityChange:{parameters:{visibleSubSections:{type:"object"}}}},dnd:{draggable:false,droppable:true},designtime:"sap/uxap/designtime/ObjectPageLayout.designtime"}});t.HEADER_CALC_DELAY=350;t.DOM_CALC_DELAY=200;t.MAX_SNAP_POSITION_OFFSET=20;t.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;t.TITLE_LEVEL_AS_ARRAY=Object.keys(p);t.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};t.BREAK_POINTS={TABLET:1024,PHONE:600};t.MEDIA={PHONE:"sapUxAPObjectPageLayout-Std-Phone",TABLET:"sapUxAPObjectPageLayout-Std-Tablet",DESKTOP:"sapUxAPObjectPageLayout-Std-Desktop"};t.DYNAMIC_HEADERS_MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};t.DIV="div";t.HEADER="header";t.FOOTER="section";t.SHOW_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterShow";t.HIDE_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterHide";t.NO_NAVIGATION_CLASS_NAME="sapUxAPObjectPageNoNavigation";t.prototype._getFirstEditableInput=function(v){var w=this.getDomRef(v);return n(w);};t.prototype._focusFirstEditableInput=function(v){this._getFirstEditableInput(v).focus();};t._getNextTitleLevelEntry=function(v){var w=t.TITLE_LEVEL_AS_ARRAY.indexOf(v),x=w!==-1,H=x&&(w!==t.TITLE_LEVEL_AS_ARRAY.length-1);if(!x){return p.Auto;}return t.TITLE_LEVEL_AS_ARRAY[H?w+1:w];};t._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap");};t.prototype.init=function(){this.oCore=sap.ui.getCore();this._bFirstRendering=true;this._bDomReady=false;this._bPinned=false;this._bStickyAnchorBar=false;this._bHeaderInTitleArea=false;this._bHeaderExpanded=true;this._bHeaderBiggerThanAllowedHeight=false;this._bDelayDOMBasedCalculations=true;this._iStoredScrollTop=0;this._oStoredScrolledSubSectionInfo={};this._bAllContentFitsContainer=false;this._bIsFooterAanimationGoing=false;this._bInternalAnchorBarVisible=true;this._oVisibleSubSections=0;this._$footerWrapper=[];this._$opWrapper=[];this._$anchorBar=[];this._$titleArea=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iFooterHeight=0;this.iTotalHeaderSize=0;this._iHeaderContentPaddingBottom=0;this._oScrollContainerLastState={};this._iREMSize=parseInt(q("body").css("font-size"));this._iOffset=parseInt(0.25*this._iREMSize);this._iResizeId=null;this._iAfterRenderingDomReadyTimeout=null;this._oABHelper=new A(this);this._initializeScroller();};t.prototype.onBeforeRendering=function(){var H,v;this._deregisterScreenSizeListener();if(this._oLazyLoading){this._oLazyLoading.destroy();}this._oLazyLoading=new L(this);this._deregisterCustomEvents();if(!this.getVisible()){return;}if(!this.getSelectedSection()){this._bHeaderExpanded=true;}this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._checkAlwaysShowContentHeader()){this._bHeaderExpanded=true;}this._bHeaderInTitleArea=this._shouldPreserveHeaderInTitleArea();this._createHeaderContent();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().setProperty("upperCase",this.getUpperCaseAnchorBar(),true);this._storeScrollLocation();this._applyUxRules();if(!q.isEmptyObject(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false;}this._bStickyAnchorBar=false;this._handleExpandButtonPressEventLifeCycle(false);this._attachTitlePressHandler();H=this._getHeaderContent();if(H&&H.supportsPinUnpin()){v=this.getHeaderContentPinnable()&&!this.getPreserveHeaderStateOnScroll();this._getHeaderContent().setPinnable(v);if(v){this._attachPinPressHandler();}}this._attachVisualIndicatorsPressHandlers(this._handleDynamicTitlePress,this);if(D.system.desktop){this._attachVisualIndicatorMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);this._attachTitleMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);}if(this.getFooter()&&this._bIsFooterAanimationGoing){this._onToggleFooterAnimationEnd(this.getFooter());}this._$titleArea=[];};t.prototype.setBackgroundDesignAnchorBar=function(B){var v=this.getBackgroundDesignAnchorBar();if(v===B){return this;}this.setProperty("backgroundDesignAnchorBar",B);this._oABHelper._getAnchorBar().setBackgroundDesign(B);return this;};t.prototype.setToggleHeaderOnTitleClick=function(v){var w=this.getHeaderTitle(),x=this.setProperty("toggleHeaderOnTitleClick",v,true);if(!w||!w.supportsToggleHeaderOnTitleClick()){h.warning("Setting toggleHeaderOnTitleClick will not take effect as it is not supported in the ObjectPageHeader, read the API Doc for more information",this);return x;}v=this.getProperty("toggleHeaderOnTitleClick");this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();return x;};t.prototype._attachTitlePressHandler=function(){var v=this.getHeaderTitle();if(u(v)&&!this._bAlreadyAttachedTitlePressHandler){v.attachEvent(t.EVENTS.TITLE_PRESS,this._handleDynamicTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};t.prototype._toggleHeaderVisibility=function(v){var H=this._getHeaderContent();if(u(H)){H.$().toggleClass("sapUxAPObjectPageHeaderContentHidden",!v);}};t.prototype._snapHeader=function(v){var I,H=this._getHeaderContent();if(H&&H.supportsPinUnpin()&&this._bPinned){this._unPin();H.getAggregation("_pinButton").setPressed(false);v=true;}this._toggleHeaderTitle(false,true);this._toggleHeaderVisibility(v);this._moveAnchorBarToTitleArea();if(v){this._moveHeaderToContentArea();this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout(true);I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));if(I){this._scrollTo(this._getSnapPosition()+1);}return;}this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();};t.prototype._expandHeader=function(v){this._toggleHeaderTitle(true,true);this._toggleHeaderVisibility(true);if(v){this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();return;}this._moveAnchorBarToContentArea();this._moveHeaderToContentArea();this._scrollTo(0,0,0);this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();};t.prototype._handleDynamicTitlePress=function(){if(!this.getToggleHeaderOnTitleClick()||!this._hasVisibleDynamicTitleAndHeader()){return;}var E=!this._bHeaderExpanded,I,v,w;if(E){I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));v=!this._headerBiggerThanAllowedToBeExpandedInTitleArea()&&(this._shouldPreserveHeaderInTitleArea()||!I);this._expandHeader(v);if(!v){this._scrollTo(0,0);}}else{w=!this._shouldPreserveHeaderInTitleArea()&&(!this._bAllContentFitsContainer||this._headerBiggerThanAllowedToBeExpandedInTitleArea());this._snapHeader(w);}this.getHeaderTitle()._getFocusSpan().trigger("focus");};t.prototype._attachPinPressHandler=function(){var H=this._getHeaderContent();if(u(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(t.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};t.prototype._handleExpandButtonPressEventLifeCycle=function(v){var H=this.getHeaderTitle(),w=this._hasDynamicTitle(),E;if(H&&!w){E=H.getAggregation("_expandButton");if(E){E[v?"attachPress":"detachPress"](this._handleExpandButtonPress,this);}}};t.prototype._adjustSelectedSectionByUXRules=function(){var v=this.oCore.byId(this.getSelectedSection()),V=v&&this._sectionCanBeRenderedByUXRules(v);if(!V){if(this._oFirstVisibleSection){v=this._oFirstVisibleSection;this.setAssociation("selectedSection",v.getId(),true);}else{this.setAssociation("selectedSection",null,true);return;}}};t.prototype._sectionCanBeRenderedByUXRules=function(v){if(!(v instanceof O)){return false;}var w=v.getBindingInfo("subSections");if(!w&&(!v.getVisible()||!v._getInternalVisible())){return false;}var x=this._aSectionBases.map(function(y){return y.getId();});return(x.indexOf(v.getId())>-1);};t.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var v=this.oCore.byId(this.getSelectedSection());if(this.getUseIconTabBar()&&v){return[v];}else{return this.getSections();}};t.prototype._preloadSectionsOnBeforeFirstRendering=function(){var v=this._getSectionsToPreloadOnBeforeFirstRendering();this._connectModelsForSections(v);if(this.getEnableLazyLoading()){v.forEach(function(w){this.fireEvent("subSectionPreload",{subSection:w});},this);}};t.prototype._getSectionsToPreloadOnBeforeFirstRendering=function(){var v,w,I;if(!this.getEnableLazyLoading()){return this._getSectionsToRender();}if(this.getUseIconTabBar()){return this._oLazyLoading.getSubsectionsToPreload(this._grepCurrentTabSectionBases());}this._adjustSelectedSectionByUXRules();w=this.oCore.byId(this.getSelectedSection());if(!w||(w===this._oFirstVisibleSection)){return this._oLazyLoading.getSubsectionsToPreload(this._aSectionBases);}I=this.indexOfSection(w);var x=function(y){var z=y.isA("sap.uxap.ObjectPageSection")?y:y.getParent();return this.indexOfSection(z)>=I;}.bind(this);v=this._aSectionBases.filter(x);return this._oLazyLoading.getSubsectionsToPreload(v);};t.prototype._grepCurrentTabSectionBases=function(){var v=[],w,x,y,z;this._adjustSelectedSectionByUXRules();w=this.oCore.byId(this.getSelectedSection());if(w){x=w.getId();this._aSectionBases.forEach(function(B){y=B.getParent();z=y&&y.getId();if(B.getId()===x||z===x){v.push(B);}});}return v;};t.prototype.onAfterRendering=function(){var H=this._getHeaderContent(),v=this.getFooter(),w,W=this._getWidth(this);this._bInvalidatedAndNotRerendered=false;this._iResizeId=R.register(this,this._onUpdateScreenSize.bind(this));this._ensureCorrectParentHeight();if(this._$sectionsContainer){this._$sectionsContainer.off("focusout");this._$sectionsContainer.off("focusin");}this._cacheDomElements();if(this._$sectionsContainer){this._$sectionsContainer.focusin(function(){this._skipToNextFastGroup=true;}.bind(this));this._$sectionsContainer.focusout(function(){this._skipToNextFastGroup=false;}.bind(this));}if(this._hasDynamicTitle()){this.addStyleClass("sapUxAPObjectPageHasDynamicTitle");}if(W>0){this._updateMedia(W,t.MEDIA);}this._$opWrapper.on("scroll.OPL",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady();}else{if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}this._iAfterRenderingDomReadyTimeout=setTimeout(this._onAfterRenderingDomReady.bind(this),this._getDOMCalculationDelay());}if(H&&H.supportsPinUnpin()){this.$().toggleClass("sapUxAPObjectPageLayoutHeaderPinnable",H.getPinnable());}if(v){w=t._getLibraryResourceBundle().getText("FOOTER_ARIA_LABEL");v.$().attr("aria-label",w);}this._handleExpandButtonPressEventLifeCycle(true);};t.prototype._onAfterRenderingDomReady=function(){var v,w,x,W=this._getWidth(this);if(this._bIsBeingDestroyed){return;}this._adjustSelectedSectionByUXRules();v=this.getSelectedSection();w=this.oCore.byId(v);this._iAfterRenderingDomReadyTimeout=null;this._bDomReady=true;this._adjustHeaderHeights();this._initAnchorBarScroll();if(v){if(this.getUseIconTabBar()){this._setSelectedSectionId(v);this._setCurrentTabSection(w);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(w);this._checkSubSectionVisibilityChange();}else{this.scrollToSection(v,0);}}this._toggleScrolling(!this._bAllContentFitsContainer);if(D.system.desktop){this._$opWrapper.on("scroll.OPL",this.onWrapperScroll.bind(this));}this._registerOnContentResize();this.getHeaderTitle()&&this._shiftHeaderTitle();this.getFooter()&&this._shiftFooter();this._setSectionsFocusValues();if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(!this._bHeaderExpanded){x=!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer;this._snapHeader(x);}this._restoreScrollPosition();this.oCore.getEventBus().publish("sap.ui","ControlForPersonalizationRendered",this);this._updateMedia(W,t.MEDIA);if(this._hasDynamicTitle()){this._updateMedia(W,t.DYNAMIC_HEADERS_MEDIA);}this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();this.fireEvent("onAfterRenderingDOMReady");};t.prototype._toggleScrolling=function(E){if(this._$opWrapper.length){this._$opWrapper.get(0).style.overflowY=E?"auto":"hidden";}};t.prototype._shiftFooter=function(){var $=this.$("footerWrapper"),v=this._calculateShiftOffset();$.css(v.sStyleAttribute,v.iMarginalsOffset+"px");};t.prototype._calculateShiftOffset=function(){var H=0,v=this.oCore.getConfiguration().getRTL()?"left":"right",w=this._hasVerticalScrollBar(),x=this._iOffset,y;if(D.system.desktop){y=j().width;H=y;if(!w){H=0;x+=y;}}return{"sStyleAttribute":v,"iActionsOffset":x,"iMarginalsOffset":H};};t.prototype._getDOMCalculationDelay=function(){return this._bDelayDOMBasedCalculations?t.HEADER_CALC_DELAY:0;};t.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._oLazyLoading){this._oLazyLoading.destroy();this._oLazyLoading=null;}this._deregisterScreenSizeListener();if(this._iContentResizeId){R.deregister(this._iContentResizeId);}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}this._deregisterCustomEvents();this._oFirstVisibleSection=null;this._oFirstVisibleSubSection=null;};t.prototype._getCustomScrollBar=function(){if(!this.getAggregation("_customScrollBar")){var v=new e(this.getId()+"-vertSB",{scrollPosition:0,scroll:this.onCustomScrollerScroll.bind(this),visible:false});this.setAggregation("_customScrollBar",v,true);}return this.getAggregation("_customScrollBar");};t.prototype.onWrapperScroll=function(E){var v=Math.max(E.target.scrollTop,0);if(this._getCustomScrollBar()){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getCustomScrollBar().setScrollPosition(v);}};t.prototype.onCustomScrollerScroll=function(E){var v=Math.max(this._getCustomScrollBar().getScrollPosition(),0);if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;q(this._$opWrapper).scrollTop(v);};t.prototype.setShowOnlyHighImportance=function(v){var w=this.getShowOnlyHighImportance();if(w!==v){this.setProperty("showOnlyHighImportance",v,true);this.getSections().forEach(function(x){x._updateImportance();});}return this;};t.prototype.setIsHeaderContentAlwaysExpanded=function(v){var w=this.getAlwaysShowContentHeader();var x=(D.system.phone||D.system.tablet);if(w!==v){this.setProperty("alwaysShowContentHeader",v,x);}return this;};t.prototype.setShowEditHeaderButton=function(v){var w=this.getShowEditHeaderButton(),H=this.getAggregation("_headerContent");if(w!==v){this.setProperty("showEditHeaderButton",v,true);H&&H.invalidate();}return this;};t.prototype._initializeScroller=function(){if(this._oScroller){return;}this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:false,vertical:true});};t.prototype.setSelectedSection=function(I){var v,w;if(I instanceof O){I=I.getId();}else if(I!=null&&typeof I!=="string"){k(false,"setSelectedSection(): sId must be a string, an instance of sap.uxap.ObjectPageSection or null");return this;}if(I===this.getSelectedSection()){return this;}if(I===null){this.setAssociation("selectedSection",null,true);this._expandHeader(this._bHeaderInTitleArea);this._selectFirstVisibleSection();return this;}this.scrollToSection(I);v=b._getClosestSection(I);w=(v instanceof b)?v.getId():v;return this.setAssociation("selectedSection",w,true);};t.prototype._selectFirstVisibleSection=function(){if(this.getUseIconTabBar()){this._adjustSelectedSectionByUXRules();this._setCurrentTabSection(this._oFirstVisibleSection);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(this._oFirstVisibleSection);this._preloadSectionsOnBeforeScroll(this._oFirstVisibleSection);this._updateSelectionOnScroll(0);this._checkSubSectionVisibilityChange();}else if(this.$().is(":visible")){this._scrollTo(0,0);if(!this._bInvalidatedAndNotRerendered){this._sScrolledSectionId=null;this._updateSelectionOnScroll(0);}}};t.prototype._ensureCorrectParentHeight=function(){if(this._bCorrectParentHeightIsSet){return;}if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%");}this._bCorrectParentHeightIsSet=true;};t.prototype._cacheDomElements=function(){this._$footerWrapper=q(document.getElementById(this.getId()+"-footerWrapper"));this._$titleArea=q(document.getElementById(this.getId()+"-headerTitle"));this._$anchorBar=q(document.getElementById(this.getId()+"-anchorBar"));this._$stickyAnchorBar=q(document.getElementById(this.getId()+"-stickyAnchorBar"));this._$opWrapper=q(document.getElementById(this.getId()+"-opwrapper"));this._$spacer=q(document.getElementById(this.getId()+"-spacer"));this._$headerContent=q(document.getElementById(this.getId()+"-headerContent"));this._$stickyHeaderContent=q(document.getElementById(this.getId()+"-stickyHeaderContent"));this._$contentContainer=q(document.getElementById(this.getId()+"-scroll"));this._$sectionsContainer=q(document.getElementById(this.getId()+"-sectionsContainer"));this._$skipFastGroupAnchor=q(document.getElementById(this.getId()+"-skipFastGroupAnchor"));this._oScroller._$Container=this._$opWrapper;this._bDomElementsCached=true;};t.prototype._handleExpandButtonPress=function(E){this._expandHeader(true);};t.prototype._toggleHeaderTitle=function(E,U){var H=this.getHeaderTitle();if(this._$titleArea.length){this._$titleArea.toggleClass("sapUxAPObjectPageHeaderStickied",!E);this._$titleArea.toggleClass("sapUxAPObjectPageHeaderSnappedTitleOnMobile",this._hasDynamicTitleWithSnappedTitleOnMobile()&&!E);}if(E){H&&H.unSnap(U);}else{H&&H.snap(U);}};t.prototype._moveHeaderToTitleArea=function(){this._$headerContent.children().appendTo(this._$stickyHeaderContent);this._bHeaderInTitleArea=true;this._bSupressModifyOnScrollOnce=true;};t.prototype._moveHeaderToContentArea=function(){if(this._bHeaderInTitleArea){this._$headerContent.append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._bHeaderInTitleArea=false;}};t.prototype._updateNavigation=function(){if(this.getShowAnchorBar()){this._oABHelper._buildAnchorBar();}};t.prototype._applyUxRules=function(I){var v,w,V,x,y,z,U,B,E,G,H,J,N={};v=this.getSections()||[];x=0;z=this.getShowAnchorBar();U=this.getUseIconTabBar();B=null;this._cleanMemory();v.forEach(function(Q){if(!Q.getVisible()){return true;}this._registerSectionBaseInfo(Q);w=Q.getSubSections()||[];V=0;E=null;w.forEach(function(W){if(!W.getVisible()){return true;}this._registerSectionBaseInfo(W);y=W.getVisibleBlocksCount();if(y===0){W._setInternalVisible(false,I);h.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+W.getTitle()+" forced to hidden");}else{W._setInternalVisible(true,I);N[W.getId()]=true;V++;if(!E){E=W;}if(this._shouldApplySectionTitleLevel(W)){W._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(W));}}},this);if(V==0){Q._setInternalVisible(false,I);h.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+Q.getTitle()+" forced to hidden");}else{Q._setInternalVisible(true,I);N[Q.getId()]=true;if(!B){B=Q;J=V;}if(this.getSubSectionLayout()===s.TitleOnTop&&V===1&&E.getTitle().trim()!==""){h.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched","section "+Q.getTitle()+" is taking its single subsection title "+E.getTitle());Q._setInternalTitle(E.getTitle(),I);N[E.getId()]=false;E._setBorrowedTitleDomId(Q.getId()+"-title");}else{Q._setInternalTitle("",I);}if(V===1&&!E.getTitle().trim()){E._setBorrowedTitleDomId(Q.getId()+"-title");}if(this._shouldApplySectionTitleLevel(Q)){Q._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(Q));}x++;}if(U){N[Q.getId()]=false;}},this);if(x<=1){z=false;h.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");if(U&&B){N[B.getId()]=true;}}else if(B&&z){G=true;N[B.getId()]=false;h.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched","section "+B.getTitle()+" title forced to hidden");}this.toggleStyleClass(t.NO_NAVIGATION_CLASS_NAME,x<=1);Object.keys(N).forEach(function(Q){this.oCore.byId(Q)._setInternalTitleVisible(N[Q],I);}.bind(this));if(z){this._oABHelper._buildAnchorBar();}this._setInternalAnchorBarVisible(z,I);this._oFirstVisibleSection=B;this._oFirstVisibleSubSection=this._getFirstVisibleSubSection(B);this._bAllContentFitsContainer=(x===1)&&(V===1)&&this._oFirstVisibleSubSection.hasStyleClass(c.FIT_CONTAINER_CLASS);if(G&&(J===1)){H=this.getAggregation("_anchorBar").getContent();if(H.length){this._oFirstVisibleSubSection._setBorrowedTitleDomId(H[0].getId()+"-content");}}this._checkSubSectionVisibilityChange();};t.prototype._checkSubSectionVisibilityChange=function(){var U=this.getUseIconTabBar(),v=U&&sap.ui.getCore().byId(this.getSelectedSection()),w=v?[v]:this._getVisibleSections(),V={},I;w.forEach(function(x){x.getSubSections().forEach(function(y){I=y.getVisible()&&y._getInternalVisible();if(I){V[y.getId()]=y;}});});if(i(Object.keys((this._oVisibleSubSections)),Object.keys(V)).length){this._oVisibleSubSections=V;this.fireEvent("subSectionVisibilityChange",{visibleSubSections:V});}};t.prototype.setUseIconTabBar=function(v){var w=this.getUseIconTabBar();if(v!=w){this._applyUxRules();}this.setProperty("useIconTabBar",v);return this;};t.prototype.onsapskipforward=function(E){if(this._skipToNextFastGroup){this._handleGroupNavigation(E,true);}};t.prototype.onsapskipback=function(E){if(this._skipToNextFastGroup){this._handleGroupNavigation(E,false);}};t.prototype._handleGroupNavigation=function(E,v){var w={target:v?this._$skipFastGroupAnchor[0]:this._$sectionsContainer[0]};E.type="keydown";F.handleF6GroupNavigation(E,w);};t.prototype._setCurrentTabSection=function(v,I){if(!v){return;}var w;if(v instanceof sap.uxap.ObjectPageSubSection){w=v;v=v.getParent();}else{w=this._getFirstVisibleSubSection(v);}if(this._oCurrentTabSection!==v){this._renderSection(v);this._oCurrentTabSection=v;}this._oCurrentTabSubSection=w;};t.prototype._renderSection=function(v){var $=this.$().find(".sapUxAPObjectPageContainer"),w;if(v&&$.length){w=this.oCore.createRenderManager();this.getSections().forEach(function(x){if((x.getId()===v.getId())){w.renderControl(v);}else{w.cleanupControlWithoutRendering(x);}});w.flush($[0]);w.destroy();}};t.prototype.setShowAnchorBarPopover=function(v,w){var x=this.getProperty("showAnchorBarPopover"),v=this.validateProperty("showAnchorBarPopover",v),y=this.getSelectedSection();if(v===x){return this;}this._oABHelper._getAnchorBar().setShowPopover(v);this._oABHelper._buildAnchorBar();this._setSelectedSectionId(y);return this.setProperty("showAnchorBarPopover",v,true);};t.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible;};t.prototype._setInternalAnchorBarVisible=function(v,I){if(v!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=v;if(I===true){this.invalidate();}}};t.prototype.setUpperCaseAnchorBar=function(v){this._oABHelper._getAnchorBar().setProperty("upperCase",v);return this.setProperty("upperCaseAnchorBar",v,true);};t.prototype._requestAdjustLayout=function(I){if(!this._oLayoutTask){this._oLayoutTask=new T(this._updateScreenHeightSectionBasesAndSpacer,t.DOM_CALC_DELAY,this);}if(!I){h.debug("ObjectPageLayout :: _requestAdjustLayout","delayed by "+t.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oLayoutTask.reSchedule(I,{}).catch(function(v){});};t.prototype._requestAdjustLayoutAndUxRules=function(I){this._setSectionInfoIsDirty(true);if(!this._oUxRulesTask){this._oUxRulesTask=new T(this._adjustLayoutAndUxRules,t.DOM_CALC_DELAY,this);}if(!I){h.debug("ObjectPageLayout :: _requestAdjustLayoutAndUxRules","delayed by "+t.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oUxRulesTask.reSchedule(I,{}).catch(function(v){});};t.prototype._adjustLayoutAndUxRules=function(){var v,w;h.debug("ObjectPageLayout :: _requestAdjustLayout","refreshing ux rules");this._applyUxRules(true);this._adjustSelectedSectionByUXRules();v=this.getSelectedSection();w=this.oCore.byId(v);if(w){this._setSelectedSectionId(v);if(this.getUseIconTabBar()){this._setCurrentTabSection(w);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(w);}this._requestAdjustLayout(true).then(function(x){if(x){this._oLazyLoading.doLazyLoading();}this._adjustSelectedSectionByUXRules();v=this.getSelectedSection();if(!this._isClosestScrolledSection(v)||this._oScroller._$Container.is(":animated")){this.scrollToSection(v,null,0,false,true);}}.bind(this));}};t.prototype._isClosestScrolledSection=function(v){var w=this._$opWrapper.length>0?this._$opWrapper.scrollTop():0,x=this.iScreenHeight,y=this._getClosestScrolledSectionId(w,x);return y&&(v===y);};t.prototype._setSelectedSectionId=function(v){var w=this.getAggregation("_anchorBar"),x=v&&this._oSectionInfo[v];if(!x){return;}if(w&&x.buttonId){w.setSelectedButton(x.buttonId);this.setAssociation("selectedSection",v,true);}};t.prototype.isFirstRendering=function(){return this._bFirstRendering;};t.prototype._cleanMemory=function(){var v=this.getAggregation("_anchorBar");if(v){v._resetControl();}this._oSectionInfo={};this._aSectionBases=[];};t.prototype._registerSectionBaseInfo=function(v){this._oSectionInfo[v.getId()]={$dom:[],positionTop:0,positionTopMobile:0,buttonId:"",isSection:(v instanceof b),sectionReference:v};this._aSectionBases.push(v);};t.prototype._triggerVisibleSubSectionsEvents=function(){this._bDelayDOMBasedCalculations=false;if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading._triggerVisibleSubSectionsEvents();}};t.prototype.scrollToSection=function(I,v,w,x,y){var z=this.oCore.byId(I),B,E,G=(sap.ui.getCore().getConfiguration().getAnimationMode()!==C.AnimationMode.none),H;if(!this.getDomRef()){h.warning("scrollToSection can only be used after the ObjectPage is rendered",this);return;}if(!z){h.warning("scrollToSection aborted: unknown section",I,this);return;}if(!this._oSectionInfo[I]||!z._getInternalVisible()){h.warning("scrollToSection aborted: section is hidden by UX rules",I,this);return;}if(this.bIsDestroyed){h.debug("ObjectPageLayout :: scrollToSection","scrolling canceled as page is being destroyed");return;}if(this.getUseIconTabBar()){var J=b._getClosestSection(z);var W=this._bAllContentFitsContainer,N;this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(J);this._toggleScrolling(!this._bAllContentFitsContainer);N=this._bAllContentFitsContainer!==W;if(N&&!this._bHeaderExpanded){this._snapHeader(!this._bAllContentFitsContainer);this._bSupressModifyOnScrollOnce=true;}if(this._oCurrentTabSection){this._oCurrentTabSection._allowPropagationToLoadedViews(false);}J._allowPropagationToLoadedViews(true);this._setCurrentTabSection(z);this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[J.getId()].buttonId);this.setAssociation("selectedSection",J.getId(),true);this._checkSubSectionVisibilityChange();}E=z instanceof c?z:this._getFirstVisibleSubSection(z);if(x){this.fireNavigate({section:b._getClosestSection(z),subSection:E});}if(this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();}w=w||0;z._expandSection();this._requestAdjustLayout(true);v=this._computeScrollDuration(v,z);var Q=this._computeScrollPosition(z);if(this._sCurrentScrollId!=I||y){this._sCurrentScrollId=I;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);if(this._$contentContainer){this._$contentContainer.parent().stop(true,false);}}if(this._bDomElementsCached){this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;}.bind(this),v);}this._preloadSectionsOnBeforeScroll(z);this.getHeaderTitle()&&this._shiftHeaderTitle();Q+=w;if(!this._bStickyAnchorBar&&this._shouldSnapHeaderOnScroll(Q)){B=this._getSnapPosition();this._scrollTo(B,0);if(B===0){this._toggleHeader(true);}}H=G&&v&&this.getEnableLazyLoading();this._scrollTo(Q,v,H);}};t.prototype._hasSingleVisibleFullscreenSubSection=function(v){var V=v.getSubSections().filter(function(w){return w.getVisible()&&w._getInternalVisible()&&(w.getBlocks().length>0);});return(V.length===1)&&V[0].hasStyleClass(c.FIT_CONTAINER_CLASS);};t.prototype._computeScrollDuration=function(v,w){var x=parseInt(v);x=x>=0?x:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&((w instanceof b)||this._isFirstVisibleSectionBase(w))&&this._bStickyAnchorBar){x=0;}return x;};t.prototype._computeScrollPosition=function(v){var w=v&&(v instanceof b),I=v.getId(),x=this._bMobileScenario||w?this._oSectionInfo[I].positionTopMobile:this._oSectionInfo[I].positionTop,E=!this._bStickyAnchorBar;if(E&&this._isFirstVisibleSectionBase(v)){x=0;}return x;};t.prototype._preloadSectionsOnBeforeScroll=function(v){var I=v.getId(),w;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){w=(v instanceof b)?v:v.getParent();this._connectModelsForSections([w]);}if(this.getEnableLazyLoading()){var x=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;w=this._oLazyLoading.getSubsectionsToPreload(x,I);if(D.system.desktop){setTimeout(function(){this._connectModelsForSections(w);}.bind(this),50);}else{this._connectModelsForSections(w);}w.forEach(function(y){this.fireEvent("subSectionEnteredViewPort",{subSection:y});},this);}};t.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId;};t.prototype.setDirectScrollingToSection=function(v){this.sDirectSectionId=v;};t.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId;};t.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null;};t.prototype._scrollTo=function(y,v,w){if(this._oScroller&&this._bDomReady&&!this._bSuppressScroll){h.debug("ObjectPageLayout :: scrolling to "+y);if((v===0)&&this._shouldSnapHeaderOnScroll(y)){this._toggleHeader(true);}if(w&&this._oLazyLoading){this._oLazyLoading.suppress();this._oScroller.scrollTo(0,y,v,this._resumeLazyLoading.bind(this));}else{this._oScroller.scrollTo(0,y,v);}}return this;};t.prototype._resumeLazyLoading=function(){if(this._oLazyLoading){this._oLazyLoading.resume();this._oLazyLoading.lazyLoadDuringScroll(true);}};t.prototype._scrollBelowCollapseVisualIndicator=function(){var H=this._getHeaderContent(),$,v,V,w;if(!u(H)||!u(this._$opWrapper)){return;}$=H._getCollapseButton().getDomRef();v=$.getBoundingClientRect().height;V=this._$opWrapper[0].getBoundingClientRect().height;w=$.offsetTop+v-V;this._scrollTo(w);};t.prototype._updateMedia=function(w,v){if(!w){return;}var U=function(x){Object.keys(v).forEach(function(y){var z=v[y],E=x===z;this.toggleStyleClass(z,E);},this);}.bind(this),B=t.BREAK_POINTS;if(w<=B.PHONE){U(v.PHONE);}else if(w<=B.TABLET){U(v.TABLET);}else{U(v.DESKTOP);}};t.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var v,w,x,y,z,B,E=!this._bHeaderExpanded,I,G,H,J=this.getDomRef(),U=this.getUseIconTabBar();if(!J||!this._bDomReady){return false;}h.debug("ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer","re-evaluating dom positions");this.iScreenHeight=this._getDOMRefHeight(J);if(this.iScreenHeight===0){return;}this.iFooterHeight=this._getFooterHeight();var N=-1;this._aSectionBases.forEach(function(Q){var V=this._oSectionInfo[Q.getId()],$=Q.$(),W,X=false;if(!V||!$.length){return;}if(!V.isSection){N++;}V.$dom=$;var Y=$.position().top;V.positionTop=Math.ceil(Y);if(V.isSection){W=Q.$("header");}else{W=Q.$("headerTitle");}X=W.length===0;if(!X){V.positionTopMobile=Math.ceil(l.Utilities.getChildPosition(W,this._$contentContainer).top)+W.outerHeight();}else{V.positionTopMobile=V.positionTop;}if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){V.positionTopMobile-=this.iAnchorBarHeight;V.positionTop-=this.iAnchorBarHeight;}V.sectionReference.toggleStyleClass("sapUxAPObjectPageSubSectionPromoted",X);if(this._bMobileScenario){var Z=this.oCore.byId(Q.getId()).getParent();if(Z instanceof b&&Z._getIsHidden()){return;}if(z){this._oSectionInfo[z].positionBottom=V.positionTop;}z=Q.getId();w=Q;}else{if(V.isSection){if(z){this._oSectionInfo[z].positionBottom=V.positionTop;if(y){this._oSectionInfo[y].positionBottom=V.positionTop;}}z=Q.getId();y=null;}else{if(y){this._oSectionInfo[y].positionBottom=V.positionTop;}y=Q.getId();w=Q;}}if(!V.isSection){G=U||(Q.getParent()===this._oFirstVisibleSection);I=G&&(N===0);H=Q.hasStyleClass(c.FIT_CONTAINER_CLASS);Q._setHeight(this._computeSubSectionHeight(I,H,V.positionTop));}},this);if(w){v=this._computeLastVisibleHeight(w);if(this._bMobileScenario&&z){this._oSectionInfo[z].positionBottom=this._oSectionInfo[z].positionTop+v;}else{if(y){this._oSectionInfo[y].positionBottom=this._oSectionInfo[y].positionTop+v;}if(z&&y){this._oSectionInfo[z].positionBottom=this._oSectionInfo[y].positionTop+v;}}B=this._bStickyAnchorBar||(N>0)||this._checkContentBottomRequiresSnap(w);if(this._bAllContentFitsContainer){B=false;}if(B&&!this._shouldPreserveHeaderInTitleArea()){E=true;}x=this._computeSpacerHeight(w,v,B,E);this._$spacer.height(x+"px");h.debug("ObjectPageLayout :: bottom spacer is now "+x+"px");m(this._oScrollContainerLastState,{iScrollableContentLength:Math.ceil(this._getScrollableContentLength()),iSpacerHeight:x});}this._updateCustomScrollerHeight(E);this._setSectionInfoIsDirty(false);return true;};t.prototype._computeSubSectionHeight=function(v,w,x){var y,z;if(!w){return"";}var I=(this._bAllContentFitsContainer)?this._bHeaderExpanded:v;y=this._getSectionsContainerHeight(!I);if(this._bAllContentFitsContainer){z=(x-this.iHeaderContentHeight)+this.iFooterHeight;y-=z;}return y+"px";};t.prototype._updateCustomScrollerHeight=function(v){if(D.system.desktop&&this.getAggregation("_customScrollBar")){var w=this._computeScrollableContentSize(v);w+=this._getStickyAreaHeight(v);this._getCustomScrollBar().setContentSize(w+"px");var x=(w>Math.ceil(this.iScreenHeight)),V=(x!==this._getCustomScrollBar().getVisible());if(V){this._getCustomScrollBar().setVisible(x);this.getHeaderTitle()&&this._shiftHeaderTitle();}}};t.prototype._computeScrollableContentSize=function(v){var w=0;if(this._$contentContainer&&this._$contentContainer.length){w=this._$contentContainer[0].scrollHeight;}if(!this._bStickyAnchorBar&&v){w-=this.iAnchorBarHeight;}if(this._bStickyAnchorBar&&!v){w+=this.iAnchorBarHeight;}return w;};t.prototype._computeLastVisibleHeight=function(v){var I=this._bStickyAnchorBar||this._bHeaderInTitleArea;var w=this._getSectionPositionTop(v,I);return this._$spacer.position().top-w;};t.prototype._getStickyAreaHeight=function(I){if(I){return this.iHeaderTitleHeightStickied+this.iAnchorBarHeight;}return this.iHeaderTitleHeight;};t.prototype._getScrollableViewportHeight=function(I){return this.getDomRef().getBoundingClientRect().height-this._getStickyAreaHeight(I);};t.prototype._getSectionsContainerHeight=function(I){var v=this._getScrollableViewportHeight(I);if(!I){v-=(this.iHeaderContentHeight+this.iAnchorBarHeight);}return v;};t.prototype._getSectionPositionTop=function(v,w){var x=Math.ceil(l.Utilities.getChildPosition(v.$(),this._$contentContainer).top);if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea&&w){x-=this.iAnchorBarHeight;}return x;};t.prototype._getSectionPositionBottom=function(v,w){var x=this._oSectionInfo[v.getId()].positionBottom;if(!w){x+=this.iAnchorBarHeight;}return x;};t.prototype._determineSectionBaseInternalTitleLevel=function(v){var w=this.getSectionTitleLevel(),I=v instanceof b;if(w===p.Auto){return I?p.H3:p.H4;}return I?w:t._getNextTitleLevelEntry(w);};t.prototype._shouldApplySectionTitleLevel=function(v){return v.getTitleLevel()===p.Auto;};t.prototype._checkContentBottomRequiresSnap=function(v){var w=false;return this._getSectionPositionBottom(v,w)>(this._getScrollableViewportHeight(w)+this._getSnapPosition());};t.prototype._computeSpacerHeight=function(v,w,x,y){var z,B;if(Object.keys(this._oVisibleSubSections).length===1&&this._bHeaderExpanded){z=0;}else{B=this._getScrollableViewportHeight(y);if(x){B=Math.ceil(B);w=Math.floor(w);}else{w=this._$spacer.position().top;}if(w<B){z=B-w;if(this._bMobileScenario){z+=(this._oSectionInfo[v.getId()].positionTopMobile-this._oSectionInfo[v.getId()].positionTop);}}else{z=0;}}if((this.iFooterHeight>z)){z+=this.iFooterHeight;}return z;};t.prototype._isFirstVisibleSectionBase=function(v){var w,x,y,z=this.getSelectedSection(),U=this.getUseIconTabBar();if(!v||!v.getParent()){return;}w=v.getId();if(U&&(w===z)){return true;}if(U&&(v.getParent().getId()===z)){x=sap.ui.getCore().byId(z);y=this._getFirstVisibleSubSection(x);return y&&(y.getId()===w);}if(this._oFirstVisibleSection&&this._oFirstVisibleSubSection){return w===this._oFirstVisibleSection.getId()||w===this._oFirstVisibleSubSection.getId();}return false;};t.prototype._getFirstVisibleSubSection=function(v){if(!v){return;}var w;this._aSectionBases.every(function(x){if(x.getParent()&&(x.getParent().getId()===v.getId())){w=x;return false;}return true;});return w;};t.prototype._initAnchorBarScroll=function(){var v=this.oCore.byId(this.getSelectedSection()),w;this._requestAdjustLayout(true);w=v?this._computeScrollPosition(v):0;this._sScrolledSectionId="";this._sCurrentScrollId="";this._onScroll({target:{scrollTop:w}},true);};t.prototype._setAsCurrentSection=function(v){var w,x,y;if(this._sScrolledSectionId===v){return;}h.debug("ObjectPageLayout :: current section is "+v);this._sScrolledSectionId=v;w=this.getAggregation("_anchorBar");if(w&&this._getInternalAnchorBarVisible()){x=this.oCore.byId(v);y=x&&x instanceof c&&(x.getTitle().trim()===""||!x._getInternalTitleVisible()||x.getParent()._getIsHidden());if(y){v=x.getParent().getId();h.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+v);}if(x&&this._oSectionInfo[v]){w.setSelectedButton(this._oSectionInfo[v].buttonId);this.setAssociation("selectedSection",b._getClosestSection(v).getId(),true);this._setSectionsFocusValues(v);}}};t.prototype._registerOnContentResize=function(){var $=this._$contentContainer.length&&this._$contentContainer[0];if(!$){return;}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}this._iContentResizeId=R.register($,this._onUpdateContentSize.bind(this));};t.prototype._onUpdateContentSize=function(E){var v;if(E.size.height===0||E.size.width===0){h.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}this._adjustHeaderHeights();this._requestAdjustLayout().then(function(){v=this._$opWrapper.scrollTop();this._updateSelectionOnScroll(v);}.bind(this));};t.prototype._onUpdateScreenSize=function(E){var v=this.getHeaderTitle(),H=this._getHeaderContent(),w=E.size.width,x=E.size.height,y=E.oldSize.height,z=(x!==y),B,I=H&&H.supportsAlwaysExpanded()&&this.getAlwaysShowContentHeader();if(E.size.height===0||E.size.width===0){h.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){h.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return;}this._oLazyLoading.setLazyLoadingParameters();setTimeout(function(){this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(I&&(this._bHeaderInTitleArea!=this._checkAlwaysShowContentHeader())){this.invalidate();}if(this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._expandHeader(false);this._scrollTo(0,0);}if(v&&v.isDynamic()){v._onResize(w);this._updateMedia(w,t.DYNAMIC_HEADERS_MEDIA);}this._updateMedia(w,t.MEDIA);this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getFooter()&&this.getShowFooter()){this._shiftFooter();}B=this.getSelectedSection();if((y===0)&&z&&!this._isClosestScrolledSection(B)){B!==null?this.scrollToSection(B,0):this._selectFirstVisibleSection();}this._scrollTo(this._$opWrapper.scrollTop(),0);if((y===0)&&z&&this.getEnableLazyLoading()&&this._oLazyLoading&&!this._bDelayDOMBasedCalculations){this._oLazyLoading.doLazyLoading();}}.bind(this),this._getDOMCalculationDelay());};t.prototype._onUpdateHeaderTitleSize=function(E){if(E.size.height===0||E.size.width===0){h.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){h.info("ObjectPageLayout :: cannot _onUpdateTitleSize before dom is ready");return;}this._adjustHeaderHeights();this._requestAdjustLayout();};t.prototype._shouldSnapHeaderOnScroll=function(v){return(v>0)&&(v>=this._getSnapPosition())&&!this._shouldPreserveHeaderInTitleArea();};t.prototype._getScrollableContentLength=function(){return this._$contentContainer.length?this._getDOMRefHeight(this._$contentContainer[0]):0;};t.prototype._isContentScrolledToBottom=function(){return this._oScrollContainerLastState.iScrollableContentLength<=(this._oScrollContainerLastState.iScrollTop+this._oScrollContainerLastState.iScrollableViewportHeight);};t.prototype._isContentLengthDecreased=function(v){if(v){return((v.iScrollableContentLength>this._oScrollContainerLastState.iScrollableContentLength)&&(v.iSpacerHeight===this._oScrollContainerLastState.iSpacerHeight));}};t.prototype._canReachScrollTop=function(v,E){var w;E=E||0;w=this._oScrollContainerLastState.iScrollableContentLength+E-this._oScrollContainerLastState.iScrollableViewportHeight;return w>=v;};t.prototype._deregisterCustomEvents=function(){if(this._$opWrapper.length){this._$opWrapper.off(".OPL");}};t.prototype._deregisterScreenSizeListener=function(){if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}};t.prototype._onScroll=function(E,I){var v=Math.max(Math.ceil(E.target.scrollTop),0),$=this._$opWrapper.length&&this._$opWrapper[0],w=this._$spacer.length&&this._$spacer[0],x=w.offsetHeight,y,H=this.getHeaderTitle(),z=this._shouldSnapHeaderOnScroll(v),B=this._shouldPreserveHeaderInTitleArea(),G=false,J=this._oScrollContainerLastState;this._oScrollContainerLastState={iScrollTop:v,iScrollableContentLength:Math.ceil(this._getScrollableContentLength()),iScrollableViewportHeight:$.offsetHeight,iSpacerHeight:x};if(this._bSupressModifyOnScrollOnce){this._bSupressModifyOnScrollOnce=false;return;}if(!$||!w){return;}y=this.iScreenHeight;if(y===0){return;}if(this._getSectionInfoIsDirty()){return;}if(J&&this._isContentScrolledToBottom()&&this._isContentLengthDecreased(J)){var N=J.iScrollableContentLength-this._oScrollContainerLastState.iScrollableContentLength;if(!this._canReachScrollTop(J.iScrollTop)&&this._canReachScrollTop(J.iScrollTop,N)){var Q=x+N;this._$spacer.height(Q+"px");this._scrollTo(J.iScrollTop);return;}}if(z&&!B){y-=(this.iAnchorBarHeight+this.iHeaderTitleHeightStickied);}if(this._bHeaderInTitleArea&&!B){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._requestAdjustLayout();}if(!B&&((H&&this.getShowHeaderContent())||this.getShowAnchorBar())){this._toggleHeader(z,!!(E&&E.type==="scroll"));}if(!B){this._adjustHeaderTitleBackgroundPosition(v);}h.debug("ObjectPageLayout :: lazy loading : Scrolling at "+v,"----------------------------------------");this._updateSelectionOnScroll(v);if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(I,v,E.timeStamp,y);}if(H&&H.supportsTitleInHeaderContent()&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&H.getShowTitleSelector()){if(v===0){q(document.getElementById(this.getId()+"-scroll")).css("z-index","1000");G=false;}else if(!G){G=true;q(document.getElementById(this.getId()+"-scroll")).css("z-index","0");}}};t.prototype._updateSelectionOnScroll=function(v){var w=this.iScreenHeight,x,y;if(w===0){return;}x=this._getClosestScrolledSectionId(v,w);y=this._getClosestScrolledSectionId(v,w,true);if(x){var z=this.getDirectScrollingToSection();if(x!==this._sScrolledSectionId){h.debug("ObjectPageLayout :: closest id "+x,"----------------------------------------");var z=this.getDirectScrollingToSection();if(z&&z!==x){return;}this.clearDirectScrollingToSection();this._setAsCurrentSection(x);}else if(x===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection();}if(y!==this._sScrolledSubSectionId){var B=b._getClosestSection(x),E=this.oCore.byId(y);this._sScrolledSubSectionId=y;this.fireEvent("_sectionChange",{section:B,subSection:E});this.fireEvent("sectionChange",{section:B,subSection:E});}}};t.prototype._getSnapPosition=function(){var v=this.iHeaderContentHeight,w=this._getTitleHeightDelta();v-=Math.max(w,this._iHeaderContentPaddingBottom);return v;};t.prototype._getTitleHeightDelta=function(){var v=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;v=Math.max(v,0);v=Math.min(v,t.MAX_SNAP_POSITION_OFFSET);return v;};t.prototype._getClosestScrolledSectionId=function(v,w,x){x=!!x;v=Math.ceil(v);var y=v+w,z,B=x||this._bMobileScenario;q.each(this._oSectionInfo,function(I,E){var G,H,J,N,Q,U=this.getSelectedSection();G=this.oCore.byId(I);if(!G){return;}H=G.getParent();J=H instanceof b&&H._getIsHidden();if(this.getUseIconTabBar()&&U){Q=this.oCore.byId(U);if(!Q){return;}if(E.isSection&&E.sectionReference!=Q){return true;}if(!E.isSection&&Q.indexOfSubSection(E.sectionReference)<0){return true;}}if(E.isSection||(B&&!J)){if(!z&&(E.sectionReference._getInternalVisible()===true)){N=this._getFirstVisibleSubSection(E.sectionReference);if(E.isSection&&x&&N){z=N.getId();}else{z=I;}}if(E.isSection&&x){return true;}if(E.positionTop<=y&&v<=E.positionBottom){if(E.positionTop<=v&&E.positionBottom>v){z=I;return false;}}}}.bind(this));return z;};t.prototype._toggleHeader=function(v,U){var H;if(v===this._bStickyAnchorBar){return;}H=this.getHeaderTitle();if(!this._shouldPreserveHeaderInTitleArea()&&!this._bHeaderInTitleArea){this._toggleHeaderTitle(!v,U);}if(!this._bStickyAnchorBar&&v){this._restoreFocusAfter(this._moveAnchorBarToTitleArea);H&&H.snap();this._bHeaderExpanded=false;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}else if(this._bStickyAnchorBar&&!v){this._restoreFocusAfter(this._moveAnchorBarToContentArea);H&&H.unSnap();this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}};t.prototype._restoreFocusAfter=function(v){var w=this.oCore.byId(this.oCore.getCurrentFocusedControlId());v.call(this);if(D.system.phone!==true){if(!this.oCore.byId(this.oCore.getCurrentFocusedControlId())){w&&w.$().trigger("focus");}}return this;};t.prototype._moveAnchorBarToTitleArea=function(){this._$anchorBar.children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize();}return this;};t.prototype._moveAnchorBarToContentArea=function(){if(!this._shouldPreserveHeaderInTitleArea()){var v=this._$opWrapper.scrollTop();this._$anchorBar.css("height","auto").append(this._$stickyAnchorBar.children());this._$opWrapper.scrollTop(v);this._toggleHeaderStyleRules(false);}return this;};t.prototype._toggleHeaderStyleRules=function(v){v=!!v;var V=v?"hidden":"inherit";this._bStickyAnchorBar=v;this._$headerContent.css("overflow",V);this._$headerContent.toggleClass("sapContrastPlus",!v);this._$headerContent.toggleClass("sapUxAPObjectPageHeaderDetailsHidden",v);this._$anchorBar.css("visibility",V);if(u(this._$stickyAnchorBar)){this._$stickyAnchorBar.attr("aria-hidden",!v);}this.fireToggleAnchorBar({fixed:v});if(!v&&!this.iAnchorBarHeight){this._requestAdjustLayout();}};t.prototype.getScrollDelegate=function(){return this._oScroller;};t.prototype.setHeaderTitle=function(H,v){if(H&&typeof H.addEventDelegate==="function"){H.addEventDelegate({onAfterRendering:this._onAfterHeaderTitleRendering.bind(this)});}this.setAggregation("headerTitle",H,v);this._oObserver&&this._oObserver.disconnect();this._oObserver=new M(this._onModifyHeaderTitle.bind(this));this._oObserver.observe(H,{aggregations:["headerTitle"],properties:["backgroundDesign"]});if(H){this._createHeaderContent();}if(this._hasDynamicTitle()){this._iHeaderContentPaddingBottom=o.toPx(P.get("_sap_f_DynamicPageHeader_PaddingBottom"));}return this;};t.prototype._onAfterHeaderTitleRendering=function(){var H=this.getHeaderTitle(),$=H&&H.$(),v;if(!H||!$.length){return;}v=$.height();if(v!==this._iCachedHeaderTitleHeight){this._adjustHeaderHeights();this._iCachedHeaderTitleHeight=v;}};t.prototype._onModifyHeaderTitle=function(v){var H=this.getAggregation("_headerContent");H&&v.current&&H.setBackgroundDesign(v.current);};t.prototype.invalidate=function(v){this._bInvalidatedAndNotRerendered=true;if(this.getUseIconTabBar()&&v&&(v instanceof b)&&!v.isActive()&&this._oSectionInfo[v.getId()]){return;}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}a.prototype.invalidate.apply(this,arguments);};t.prototype._createHeaderContent=function(){var H=this.getHeaderTitle(),v=H&&H.supportsBackgroundDesign()&&H.getBackgroundDesign(),w=this.getAggregation("_headerContent"),x,N;var y=H?H.getCompatibleHeaderContentClass():d;if(!(w instanceof y)){x=this.getAggregation("_headerContent");if(x){x.destroy();}N=y.createInstance(this.getAggregation("headerContent"),this.getShowHeaderContent(),this._getHeaderDesign(),this.getHeaderContentPinnable(),this.getId()+"-OPHeaderContent");v&&N.setBackgroundDesign(v);this.setAggregation("_headerContent",N,true);}};t.prototype._adjustHeaderBackgroundSize=function(){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(!this._shouldPreserveHeaderInTitleArea()){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}H.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0);}};t.prototype._adjustHeaderTitleBackgroundPosition=function(v){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){H.$().css("background-position","0px "+((this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1)+"px");}else{if(this._shouldPreserveHeaderInTitleArea()){H.$().css("background-position","0px 0px");}else{H.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-v)+"px");}}}};t.prototype._adjustHeaderHeights=function(){var v=this.getHeaderTitle(),w=true;if(v&&!v.supportsAdaptLayoutForDomElement()){w=false;}if(this._$titleArea.length>0){this.iHeaderContentHeight=this._$headerContent.length?Math.round(this._getDOMRefHeight(this._$headerContent[0])):0;this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.outerHeight():this._$anchorBar.outerHeight();if(!this._bHeaderExpanded){this.iHeaderTitleHeightStickied=this._$titleArea.height()-this.iAnchorBarHeight;this.iHeaderTitleHeight=this._obtainExpandedTitleHeight(w);}else{this.iHeaderTitleHeight=this._$titleArea.is(":visible")?this._$titleArea.height():0;this.iHeaderTitleHeightStickied=this._obtainSnappedTitleHeight(w);}this._adjustHeaderBackgroundSize();h.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight);}else{h.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered");}};t.prototype._appendTitleCloneToDOM=function(E){var $=this.getHeaderTitle().$(),v=$.clone();v.css({left:"-10000px",top:"-10000px",width:$.width()+"px",position:"absolute"});v.toggleClass("sapUxAPObjectPageHeaderStickied",E);v.appendTo(this._$titleArea.parent());if(E){this.getHeaderTitle()&&this.getHeaderTitle()._adaptObjectPageHeaderIndentifierLine(v);}return v;};t.prototype._obtainSnappedTitleHeight=function(v){var w=this.getHeaderTitle(),$,H;if(!w){return 0;}if(v){$=this._appendTitleCloneToDOM(true);H=$.height();$.remove();}else if(w.snap){H=this._obtainTitleHeightViaStateChange(true);}return H;};t.prototype._obtainExpandedTitleHeight=function(v){var w=this.getHeaderTitle(),$,H;if(!w){return 0;}if(v){$=this._appendTitleCloneToDOM(false);H=$.is(":visible")?$.height()-this.iAnchorBarHeight:0;$.remove();}else if(w.unSnap){H=this._obtainTitleHeightViaStateChange(false);}return H;};t.prototype._obtainTitleHeightViaStateChange=function(v){var w=this.getHeaderTitle(),H,x=this._$sectionsContainer.height(),y,z=(v)?w.snap:w.unSnap,B=(v)?w.unSnap:w.snap;z.call(w,false);H=w.$().outerHeight();B.call(w,false);y=this._$sectionsContainer.height();this._adjustSpacerHeightUponUnsnapping(x,y);return H;};t.prototype._adjustSpacerHeightUponUnsnapping=function(v,w){var x;if(v!=w){x=this._$spacer.height()-(w-v);this._$spacer.height(x);}};t.prototype._getHeaderDesign=function(){var H=this.getHeaderTitle(),v=l.ObjectPageHeaderDesign.Light;if(H!=null){v=H.getHeaderDesign();}return v;};t.prototype._getVisibleSections=function(){return this.getSections().filter(function(v){return v.getVisible()&&v._getInternalVisible();});};t.prototype._setSectionsFocusValues=function(v){var w=this._getVisibleSections()||[],$,x='0',N='-1',y="tabindex",z,B=w[0];w.forEach(function(E){$=E.$();if(v===E.sId){$.attr(y,x);z=E;E._setSubSectionsFocusValues();}else{$.attr(y,N);E._disableSubSectionsFocus();}});if(!z&&w.length>0){B.$().attr(y,x);B._setSubSectionsFocusValues();z=B;}return z;};t.prototype.setShowHeaderContent=function(v){var w=this.getShowHeaderContent(),H;if(w!==v){if(w&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);}this.setProperty("showHeaderContent",v,true);H=this._getHeaderContent();this.$().toggleClass("sapUxAPObjectPageLayoutNoHeaderContent",!v||!H);if(H){H.setProperty("visible",v);}}return this;};t.prototype._headerTitleChangeHandler=function(I){var v;if(!this.getShowTitleInHeaderContent()){return;}if(I){this._getHeaderContent()._destroyObjectImage(true);}v=this.oCore.createRenderManager();this.getRenderer()._rerenderHeaderContentArea(v,this);this._getHeaderContent().invalidate();v.destroy();};t.prototype.getHeaderContent=function(){if(!this._getHeaderContent()){return this.getAggregation("headerContent",[]);}return this._getHeaderContent().getAggregation("content",[]);};t.prototype.insertHeaderContent=function(v,I,w){if(!this._getHeaderContent()){return this.insertAggregation("headerContent",v,I,w);}return this._getHeaderContent().insertAggregation("content",v,I,w);};t.prototype.addHeaderContent=function(v,w){if(!this._getHeaderContent()){return this.addAggregation("headerContent",v,w);}return this._getHeaderContent().addAggregation("content",v,w);};t.prototype.removeAllHeaderContent=function(v){if(!this._getHeaderContent()){return this.removeAllAggregation("headerContent",v);}return this._getHeaderContent().removeAllAggregation("content",v);};t.prototype.removeHeaderContent=function(v,w){if(!this._getHeaderContent()){return this.removeAggregation("headerContent",v,w);}return this._getHeaderContent().removeAggregation("content",v,w);};t.prototype.destroyHeaderContent=function(v){if(!this._getHeaderContent()){return this.destroyAggregation("headerContent",v);}return this._getHeaderContent().destroyAggregation("content",v);};t.prototype.indexOfHeaderContent=function(v){if(!this._getHeaderContent()){return this.indexOfAggregation("headerContent",v);}return this._getHeaderContent().indexOfAggregation("content",v);};t.prototype._getHeaderContent=function(){return this.getAggregation("_headerContent");};t.prototype._getHeaderContentDomRef=function(){var H=this._getHeaderContent();return H&&H.getDomRef();};t.prototype._connectModelsForSections=function(v){v=v||[];v.forEach(function(w){w.connectToModels();});};t.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()};};t.prototype._hasVerticalScrollBar=function(){return(this._getCustomScrollBar().getVisible()===true);};t.prototype._shiftHeaderTitle=function(){var v=this._calculateShiftOffset(),w=v.sStyleAttribute,x=v.iMarginalsOffset;this.$().find(".sapUxAPObjectPageHeaderTitle").css("padding-"+w,x+"px");};t.prototype._isFirstSection=function(v){var w=this._getVisibleSections();if(v===w[0]){return true;}return false;};t.prototype._isValidStoredSubSectionInfo=function(){var v=this.getSelectedSection(),w=this.oCore.byId(v),x;if(!w||!this._oStoredScrolledSubSectionInfo){return false;}x=this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId);return x&&this._sectionCanBeRenderedByUXRules(x)&&(w.indexOfSubSection(x)>=0);};t.prototype._restoreScrollPosition=function(){var v=this._isValidStoredSubSectionInfo(),w;if(v){w=this._computeScrollPosition(this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId))+this._oStoredScrolledSubSectionInfo.iOffset;this._scrollTo(w,0);}else{this.scrollToSection(this.getSelectedSection(),0);}};t.prototype._storeScrollLocation=function(){if(!this.getDomRef()||!this._bDomReady||!this._oScroller){return;}var v=this._oScroller.getScrollTop(),w=this._getClosestScrolledSectionId(this._oScroller.getScrollTop(),this.iScreenHeight,true),x;if(w){x=v-this._computeScrollPosition(this.oCore.byId(w));}this._iStoredScrollTop=v;this._oStoredScrolledSubSectionInfo={sSubSectionId:w,iOffset:x};this._oCurrentTabSection=null;};t.prototype.onkeyup=function(E){var v,w;if(E.which===K.TAB){v=this.oCore.getCurrentFocusedControlId();w=v&&this.oCore.byId(v);if(w&&this._isFirstSection(w)){this._scrollTo(0,0);}}};t.prototype.setShowFooter=function(v){var w=this.setProperty("showFooter",v,true);this._toggleFooter(v);return w;};t.prototype._toggleFooter=function(v){var U,w=this.getFooter();if(!u(w)||!u(this._$footerWrapper)){return;}U=this.oCore.getConfiguration().getAnimationMode()!==C.AnimationMode.none;if(U){this._toggleFooterAnimation(v,w);}else{this._$footerWrapper.toggleClass("sapUiHidden",!v);}this._requestAdjustLayout();};t.prototype._toggleFooterAnimation=function(v,w){this._$footerWrapper.on("webkitAnimationEnd animationend",this._onToggleFooterAnimationEnd.bind(this,w));this._bIsFooterAanimationGoing=true;if(v){this._$footerWrapper.removeClass("sapUiHidden");}w.toggleStyleClass(t.SHOW_FOOTER_CLASS_NAME,v);w.toggleStyleClass(t.HIDE_FOOTER_CLASS_NAME,!v);};t.prototype._onToggleFooterAnimationEnd=function(v){this._$footerWrapper.off("webkitAnimationEnd animationend");if(v.hasStyleClass(t.HIDE_FOOTER_CLASS_NAME)){this._$footerWrapper.addClass("sapUiHidden");v.removeStyleClass(t.HIDE_FOOTER_CLASS_NAME);}else{v.removeStyleClass(t.SHOW_FOOTER_CLASS_NAME);}this._bIsFooterAanimationGoing=false;};t.prototype.clone=function(){var v,H,w;Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this);v=a.prototype.clone.apply(this,arguments);H=this._getHeaderContent();w=v._getHeaderContent();if(w){w.destroy();}if(H){v.setAggregation("_headerContent",H.clone(),true);}return v;};t.prototype._cloneProxiedAggregations=function(v){var w=this.mAggregations[v];if(Array.isArray(w)&&w.length===0){w=this["get"+v.charAt(0).toUpperCase()+v.slice(1)]();}this.mAggregations[v]=w;};t.prototype._shouldPreserveHeaderInTitleArea=function(){return this._bPinned||this._preserveHeaderStateOnScroll()||this._checkAlwaysShowContentHeader();};t.prototype._checkAlwaysShowContentHeader=function(){return!this._hasDynamicTitle()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader();};t.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return!D.system.desktop&&this._headerBiggerThanAllowedToBeFixed();};t.prototype._headerBiggerThanAllowedToBeFixed=function(){var v=this._getOwnHeight();return this._getEntireHeaderHeight()>t.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*v;};t.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){return this._getEntireHeaderHeight()>=this._getOwnHeight();};t.prototype._getOwnHeight=function(){return this._getHeight(this);};t.prototype._getHeight=function(v){return!(v instanceof a)?0:v.$().outerHeight()||0;};t.prototype._getEntireHeaderHeight=function(){var v=0,H=0,w=this.getHeaderTitle(),x=this._getHeaderContent();if(u(w)){v=w.$().outerHeight();}if(u(x)){H=x.$().outerHeight();}return v+H;};t.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin();}else{this._pin();this._restorePinButtonFocus();}};t.prototype._restorePinButtonFocus=function(){var H=this._getHeaderContent();if(u(H)&&H.supportsPinUnpin()){H._focusPinButton();}};t.prototype._pin=function(){var $=this.$();if(this._bPinned){return;}this._bPinned=true;this._toggleHeaderTitle(true);this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._adjustHeaderHeights();this._requestAdjustLayout();this._togglePinButtonARIAState(this._bPinned);this._updateToggleHeaderVisualIndicators();if(u($)){$.addClass("sapUxAPObjectPageLayoutHeaderPinned");}};t.prototype._unPin=function(){var $=this.$();if(!this._bPinned){return;}this._bPinned=false;this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(u($)){$.removeClass("sapUxAPObjectPageLayoutHeaderPinned");}};t.prototype._togglePinButtonARIAState=function(v){var H=this._getHeaderContent();if(u(H)&&H.supportsPinUnpin()){H._updateARIAPinButtonState(v);}};t.prototype._preserveHeaderStateOnScroll=function(){return this._hasDynamicTitle()&&this.getPreserveHeaderStateOnScroll()&&!this._bHeaderBiggerThanAllowedHeight;};t.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._bHeaderBiggerThanAllowedHeight=false;return;}this._bHeaderBiggerThanAllowedHeight=true;if(this._bHeaderExpanded){this._moveAnchorBarToContentArea();this._moveHeaderToContentArea(true);}else{this._snapHeader(true);}this._adjustHeaderHeights();this._requestAdjustLayout();};t.prototype._hasDynamicTitle=function(){var v=this.getHeaderTitle();return v&&v.isDynamic();};t.prototype._attachVisualIndicatorsPressHandlers=function(v,w){var x=this.getHeaderTitle(),H=this._getHeaderContent();if(u(x)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){x.attachEvent(t.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,function(){v.call(w);if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBelowCollapseVisualIndicator();}this._focusCollapseVisualIndicator();},this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(u(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(t.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,function(){v.call(w);this._focusExpandVisualIndicator();},this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};t.prototype._hasVisibleDynamicTitleAndHeader=function(){var v=this.getHeaderTitle(),H=this.getHeaderContent();return u(v)&&v.isDynamic()&&v.getVisible()&&u(H)&&H.length>0;};t.prototype._hasDynamicTitleWithSnappedTitleOnMobile=function(){var v=this.getHeaderTitle();return u(v)&&v.isDynamic()&&!!v.getSnappedTitleOnMobile()&&D.system.phone;};t.prototype._updateToggleHeaderVisualIndicators=function(){var H,v,E,w=this._hasVisibleDynamicTitleAndHeader();if(!this.getToggleHeaderOnTitleClick()||!w){v=false;E=false;}else{H=this._bHeaderExpanded;v=H;E=!H&&!this._hasDynamicTitleWithSnappedTitleOnMobile();}this._toggleCollapseVisualIndicator(v);this._toggleExpandVisualIndicator(E);};t.prototype._updateTitleVisualState=function(){var v=this.getHeaderTitle(),w=this._hasVisibleDynamicTitleAndHeader()&&this.getToggleHeaderOnTitleClick()&&!this._hasDynamicTitleWithSnappedTitleOnMobile();this.$().toggleClass("sapUxAPObjectPageLayoutTitleClickEnabled",w);if(u(v)){v._toggleFocusableState(w);}};t.prototype._focusCollapseVisualIndicator=function(){var v=this._getHeaderContent();if(u(v)){v._focusCollapseButton();}};t.prototype._focusExpandVisualIndicator=function(){var v=this.getHeaderTitle();if(u(v)){v._focusExpandButton();}};t.prototype._toggleExpandVisualIndicator=function(v){var w=this.getHeaderTitle();if(u(w)){w._toggleExpandButton(v);}};t.prototype._toggleCollapseVisualIndicator=function(v){var w=this._getHeaderContent();if(u(w)){w._toggleCollapseButton(v);}};t.prototype._attachVisualIndicatorMouseOverHandlers=function(v,w,x){var H=this._getHeaderContent();if(u(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(t.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,v,x);H.attachEvent(t.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,w,x);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};t.prototype._attachTitleMouseOverHandlers=function(v,w,x){var y=this.getHeaderTitle();if(u(y)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){y.attachEvent(t.EVENTS.TITLE_MOUSE_OVER,v,x);y.attachEvent(t.EVENTS.TITLE_MOUSE_OUT,w,x);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};t.prototype._suppressScroll=function(){this._bSuppressScroll=true;};t.prototype._resumeScroll=function(){this._bSuppressScroll=false;if(this._iStoredScrollTop){this._scrollTo(this._iStoredScrollTop,0);}else{this._onScroll({target:{scrollTop:this._$opWrapper.scrollTop()}});}};t.prototype._addHoverClass=function(){var $=this.$();if($){$.addClass("sapUxAPObjectPageLayoutTitleForceHovered");}};t.prototype._removeHoverClass=function(){var $=this.$();if($){$.removeClass("sapUxAPObjectPageLayoutTitleForceHovered");}};t.prototype._getHeight=function(v){return!(v instanceof a)?0:v.$().outerHeight()||0;};t.prototype._getWidth=function(v){var w=v.getDomRef();return!(v instanceof a)?0:(w&&w.offsetWidth)||0;};t.prototype._getSectionInfoIsDirty=function(){return this.bSectionInfoIsDirty;};t.prototype._setSectionInfoIsDirty=function(v){this.bSectionInfoIsDirty=v;};t.prototype._getAriaLabelText=function(E,v){var H=this.getHeaderTitle(),w=H?H.getTitleText():null,x;if(H&&w){x=w;if(v){x+=" "+t._getLibraryResourceBundle().getText(E+"_ARIA_LABEL_WITH_TITLE");}}else{x=t._getLibraryResourceBundle().getText(E+"_ARIA_LABEL_WITHOUT_TITLE");}return x;};t.prototype._getFooterHeight=function(){if(this.getFooter()&&this.getShowFooter()){return this._getDOMRefHeight(this.$("footerWrapper").get(0));}return 0;};t.prototype._getDOMRefHeight=function(v){return v.parentElement?v.getBoundingClientRect().height:0;};t.prototype._updateAriaLabels=function(){var v=this.getLandmarkInfo(),w=this._getAriaLabelText("ROOT",true),H=this._getAriaLabelText("HEADER",true),N=this._getAriaLabelText("NAVIGATION",false),x=this._getAriaLabelText("NAVTOOLBAR",true),y=v&&v.getHeaderLabel(),z=v&&v.getRootLabel(),B=v&&v.getNavigationLabel();if(!z){this.$().attr("aria-label",w);}if(!y){this.$("headerTitle").attr("aria-label",H);}if(!B){this.$("anchorBar").attr("aria-label",N);this.$("stickyAnchorBar").attr("aria-label",N);}this.$("anchBar").attr("aria-label",x);};t.prototype._formatLandmarkInfo=function(v,w){if(v){var x=v["get"+w+"Role"]()||"",y=v["get"+w+"Label"]()||"";if(x===r.None){x='';}return{role:x.toLowerCase(),label:y};}return{};};t.prototype._getHeaderTag=function(v){if(v&&v.getHeaderRole()!==r.None){return t.DIV;}return t.HEADER;};t.prototype._getFooterTag=function(v){if(v&&v.getFooterRole()!==r.None){return t.DIV;}return t.FOOTER;};function u(v){if(arguments.length===1){return Array.isArray(v)?v.length>0:!!v;}return Array.prototype.slice.call(arguments).every(function(w){return u(w);});}return t;});
