/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Core','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/delegate/ItemNavigation',"sap/ui/core/InvisibleText",'sap/ui/core/ResizeHandler','sap/ui/Device','sap/m/Button','sap/m/IconTabFilter','sap/m/IconTabSeparator','sap/m/IconTabBarDragAndDropUtil','sap/ui/core/dnd/DropPosition','sap/m/IconTabHeaderRenderer',"sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/events/KeyCodes"],function(l,C,a,E,I,b,R,D,B,c,d,e,f,g,q,L,K){"use strict";var h=l.BackgroundDesign;var k=l.IconTabHeaderMode;var m=l.IconTabDensityMode;var n=a.extend("sap.m.IconTabHeader",{metadata:{library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},selectedKey:{type:"string",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Behavior",defaultValue:true},mode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:k.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:h.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false},maxNestingLevel:{type:"int",group:"Behavior",defaultValue:0},tabDensityMode:{type:"sap.m.IconTabDensityMode",group:"Appearance",defaultValue:m.Cozy},ariaTexts:{type:"object",group:"Accessibility",defaultValue:null}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",dnd:{draggable:true,droppable:true,layout:"Horizontal"}},_overflow:{type:"sap.m.IconTabFilter",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"}}}}}});var r=C.getLibraryResourceBundle("sap.m");E.apply(n.prototype,[true]);n.prototype.init=function(){this._aTabKeys=[];this._oAriaHeadText=null;};n.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._aTabKeys){this._aTabKeys=null;}if(this._oOverflow){this._oOverflow.removeEventDelegate(this._oOverflowEventDelegate);this._oOverflowEventDelegate=null;this._oOverflow=null;}if(this._oAriaHeadText){this._oAriaHeadText.destroy();this._oAriaHeadText=null;}this._bRtl=null;};n.prototype.onBeforeRendering=function(){this._bRtl=C.getConfiguration().getRTL();if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this._updateSelection();this.destroyDragDropConfig();this._setsDragAndDropConfigurations();};n.prototype.onAfterRendering=function(){this._applyTabDensityMode();if(this.oSelectedItem){this._applySelectionToFilters();}if(C.isThemeApplied()){this._setItemsForStrip();}else{C.attachThemeChanged(this._handleThemeLoad,this);}this._initItemNavigation();this._sResizeListenerId=R.register(this.getDomRef(),q.proxy(this._fnResize,this));this.getItems().forEach(function(i){if(i._onAfterParentRendering){i._onAfterParentRendering();}});};n.prototype._getSelectList=function(){return this._getOverflow()._getSelectList();};n.prototype._getOverflow=function(){var o=this.getAggregation("_overflow");if(!o){o=new c({id:this.getId()+'-overflow',text:r.getText("ICONTABHEADER_OVERFLOW_MORE")});o._bIsOverflow=true;this._oOverflowEventDelegate={onsapnext:o.onsapdown};o.addEventDelegate(this._oOverflowEventDelegate,o);this.setAggregation("_overflow",o);this._oOverflow=o;}return o;};n.prototype._getInvisibleHeadText=function(){var A=this.getAriaTexts()||{};if(!this._oAriaHeadText){this._oAriaHeadText=new b({id:this.getId()+"-ariaHeadText"});}this._oAriaHeadText.setText(A.headerDescription);return this._oAriaHeadText;};n.prototype._onItemNavigationFocusLeave=function(){if(!this.oSelectedItem){return;}var j=this.getItems();var o=-1;var p;for(var i=0;i<j.length;i++){p=j[i];if(p instanceof c==false){continue;}o++;if((this.oSelectedItem._getRootTab()||this.oSelectedItem)===p){break;}}this._oItemNavigation.setFocusedIndex(o);};n.prototype.getTabFilters=function(){var t=[];this.getItems().forEach(function(i){if(i instanceof c){t.push(i);}});return t;};n.prototype._setsDragAndDropConfigurations=function(){if(this.getEnableTabReordering()&&!this.getDragDropConfig().length){e.setDragDropAggregations(this,"Horizontal",this._getDropPosition());}};n.prototype._getDropPosition=function(){return this.getMaxNestingLevel()===0?f.Between:f.OnOrBetween;};n.prototype.setSelectedKey=function(s){var j=this.getTabFilters(),o=this._isInsideIconTabBar(),S;if(j.length>0){s=s||j[0]._getNonEmptyKey();}if(this.$().length){for(var i=0;i<j.length;i++){if(j[i]._getNonEmptyKey()===s){this.setSelectedItem(j[i],true);S=true;break;}}if(!S&&!o&&s){this.setSelectedItem(null);}}this.setProperty("selectedKey",s,true);return this;};n.prototype.setSelectedItem=function(i,A){if(!i){if(this.oSelectedItem){this._removeSelectionFromFilters();this.oSelectedItem=null;}return this;}if(this._isUnselectable(i)){return this;}var p=this.getParent();var j=this._isInsideIconTabBar();var o=false;if(i.getContent().length===0&&this.oSelectedItem&&this.oSelectedItem.getContent().length===0){o=true;}if(this.oSelectedItem&&this.oSelectedItem.getVisible()&&(!A&&j&&p.getExpandable()||this.oSelectedItem!==i)){this._removeSelectionFromFilters();}if(i.getVisible()){if(this.oSelectedItem===i){if(!A&&j&&p.getExpandable()){p._toggleExpandCollapse();}}else{if(j){p.$("content").attr('aria-labelledby',i.sId);}this.oSelectedItem=i;this._applySelectionToFilters();this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);if(j&&(p.getExpandable()||p.getExpanded())){var s=this.oSelectedItem.getContent();if(s.length>0){p._rerenderContent(s);}else{if(!o){p._rerenderContent(p.getContent());}}if(!A&&p.getExpandable()&&!p.getExpanded()){p._toggleExpandCollapse(true);}}}}this.oSelectedItem=i;var S=this.oSelectedItem._getNonEmptyKey();this.setProperty("selectedKey",S,true);if(j){p.setProperty("selectedKey",S,true);}if(!A){if(j){p.fireSelect({selectedItem:this.oSelectedItem,selectedKey:S,item:this.oSelectedItem,key:S});}else{this.fireSelect({selectedItem:this.oSelectedItem,selectedKey:S,item:this.oSelectedItem,key:S});}}this.oSelectedItem._startBadgeHiding();this._setItemsForStrip();return this;};n.prototype.getVisibleTabFilters=function(){return this.getTabFilters().filter(function(F){return F.getVisible();});};n.prototype._initItemNavigation=function(){var t=[],s=-1,S=this.oSelectedItem&&this.oSelectedItem._getRootTab();this.getTabFilters().forEach(function(i){var j=this.getFocusDomRef(i);if(!j){return;}j.setAttribute("tabindex","-1");t.push(j);if(i===S||i===this.oSelectedItem){s=t.indexOf(j);}}.bind(this));if(this.$().hasClass("sapMITHOverflowList")){var o=this._getOverflow().getFocusDomRef();o.setAttribute("tabindex","-1");t.push(o);}if(!this._oItemNavigation){this._oItemNavigation=new I().setCycling(false).attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this).setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setRootDomRef(this.getDomRef()).setItemDomRefs(t).setPageSize(t.length).setSelectedIndex(s);};n.prototype.onThemeChanged=function(){this._applyTabDensityMode();};n.prototype._applyTabDensityMode=function(){var t=this.getTabDensityMode();this.$().removeClass("sapUiSizeCompact");switch(t){case m.Compact:this.$().addClass("sapUiSizeCompact");break;case m.Inherit:if(this.$().closest(".sapUiSizeCompact").length){this.$().addClass("sapUiSizeCompact");}break;}};n.prototype._handleThemeLoad=function(){setTimeout(this._setItemsForStrip.bind(this),350);C.detachThemeChanged(this._handleThemeLoad,this);};n.prototype.destroyItems=function(){this.oSelectedItem=null;this._aTabKeys=[];this.destroyAggregation("items");return this;};n.prototype.addItem=function(i){if(!(i instanceof d)){var s=i.getKey();if(this._aTabKeys.indexOf(s)!==-1){L.warning("sap.m.IconTabHeader: duplicate key '"+s+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(s);}this.addAggregation("items",i);this._invalidateParentIconTabBar();};n.prototype.insertItem=function(i,j){if(!(i instanceof d)){var s=i.getKey();if(this._aTabKeys.indexOf(s)!==-1){L.warning("sap.m.IconTabHeader: duplicate key '"+s+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(s);}this.insertAggregation("items",i,j);this._invalidateParentIconTabBar();};n.prototype.removeAllItems=function(){var o=this.removeAllAggregation("items");this._aTabKeys=[];this.oSelectedItem=null;this._invalidateParentIconTabBar();return o;};n.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(i&&!(i instanceof d)){var s=i.getKey();this._aTabKeys.splice(this._aTabKeys.indexOf(s),1);}if(this.oSelectedItem===i){this.oSelectedItem=null;}this._invalidateParentIconTabBar();return i;};n.prototype.updateAggregation=function(){this.oSelectedItem=null;a.prototype.updateAggregation.apply(this,arguments);this.invalidate();};n.prototype.removeAggregation=function(A,o,s){var i=this.getTabFilters();var j=a.prototype.removeAggregation.apply(this,arguments);if(s){return j;}if(j&&j==this.oSelectedItem&&A=='items'){var p=(i?Array.prototype.indexOf.call(i,j):-1);i=this.getTabFilters();p=Math.max(0,Math.min(p,i.length-1));var S=i[p];if(S){this.setSelectedItem(S,true);}else{var t=this.getParent();if(this._isInsideIconTabBar()&&t.getExpanded()){t.$("content").children().remove();}}}return j;};n.prototype.removeAllAggregation=function(A,s){if(A=='items'){var i=this.getParent();if(this._isInsideIconTabBar()&&i.getExpanded()){i.$("content").children().remove();}}return a.prototype.removeAllAggregation.apply(this,arguments);};n.prototype._getDisplayText=function(i){var t=i.getText();if(this.isInlineMode()){var s=i.getCount();if(s){if(this._bRtl){t='('+s+') '+t;}else{t+=' ('+s+')';}}}return t;};n.prototype.isInlineMode=function(){return this._bTextOnly&&this.getMode()==k.Inline;};n.prototype._checkTextOnly=function(){this._bTextOnly=this.getItems().every(function(i){return i instanceof d||!i.getIcon();});return this._bTextOnly;};n.prototype._checkNoText=function(j){if(j.length>0){for(var i=0;i<j.length;i++){if(!(j[i]instanceof d)){if(j[i].getText().length>0){return false;}}}}return true;};n.prototype._checkInLine=function(j){var o;if(j.length>0){for(var i=0;i<j.length;i++){o=j[i];if(!(o instanceof d)){if(o.getIcon()||o.getCount()){this._bInLine=false;return false;}}}}this._bInLine=true;return true;};n.prototype._getItemsInStrip=function(){return this.getItems().filter(function(i){var o=i.getDomRef();return o&&!o.classList.contains("sapMITBFilterHidden");});};n.prototype._setItemsForStrip=function(){var t=this.getVisibleTabFilters();if(!C.isThemeApplied()||!t.length){return;}var T=this.getDomRef("head"),s=(this.oSelectedItem&&this.oSelectedItem.getVisible())?this.oSelectedItem:t[0];if(!T){return;}var j=T.offsetWidth,i,S=(s._getRootTab()||s).getDomRef(),o=this.getItems().filter(function(z){return z.getDomRef();}).map(function(z){return z.getDomRef();});if(!o.length||!S){return;}o.forEach(function(z){z.style.width="";z.classList.remove("sapMITBFilterHidden");z.classList.remove("sapMITBFilterTruncated");});var p=o.indexOf(S),u=this._getItemSize(S),v,w=0,x;if(o[p-1]&&o[p-1].classList.contains("sapMITBSep")){v=o[p-1];w=this._getItemSize(v);}x=u+w;if(j<x){S.style.width=(j-20-w)+"px";S.classList.add("sapMITBFilterTruncated");}o.splice(p,1);if(v){o.splice(p-1,1);}var y=this._findLastVisibleItem(o,j,x);for(i=y+1;i<o.length;i++){o[i].classList.add("sapMITBFilterHidden");}this._getOverflow()._updateExpandButtonBadge();this._getOverflow().$().toggleClass("sapMITHOverflowVisible",y+1!==o.length);this.$().toggleClass("sapMITHOverflowList",y+1!==o.length);};n.prototype._findLastVisibleItem=function(i,t,s){var j=-1,o,p,u,P;for(o=0;o<i.length;o++){p=i[o];u=this._getItemSize(p);if(t>(s+u)){s+=u;j=o;}else{P=i[o-1];if(P&&P.classList.contains("sapMITBSep")){j-=1;}break;}}return j;};n.prototype._getItemSize=function(i){var s=window.getComputedStyle(i),w=i.offsetWidth,M=Number.parseInt(s.marginLeft)+Number.parseInt(s.marginRight);return w+M;};n.prototype._handleActivation=function(o){var t=o.target.id,i=o.srcControl,s,$=q(o.target);if(i instanceof B){return;}var j=q(document.getElementById(t));if(j.parents()&&Array.prototype.indexOf.call(j.parents(),this.$("content")[0])>-1){}else{if(t){o.preventDefault();if($.hasClass('sapMITBFilterIcon')||$.hasClass('sapMITBCount')||$.hasClass('sapMITBText')||$.hasClass('sapMITBTab')||$.hasClass('sapMITBContentArrow')||$.hasClass('sapMITBSep')||$.hasClass('sapMITBSepIcon')){s=o.srcControl.getId().replace(/-icon$/,"");i=C.byId(s);if(i.getMetadata().isInstanceOf("sap.m.IconTab")&&!(i instanceof d)){if(this._isUnselectable(i)){if(i.getItems().length||i._bIsOverflow){i._expandButtonPress();}return;}if(i===this._getOverflow()){i._expandButtonPress();return;}this.setSelectedItem(i);}}else if(i.getMetadata().isInstanceOf("sap.m.IconTab")&&!(i instanceof d)){if(this._isUnselectable(i)){if(i.getItems().length||i._bIsOverflow){i._expandButtonPress();}return;}if(i===this._getOverflow()){i._expandButtonPress();return;}this.setSelectedItem(i);}}else{if(i.getMetadata().isInstanceOf("sap.m.IconTab")&&!(i instanceof d)){if(this._isUnselectable(i)){if(i.getItems().length||i._bIsOverflow){i._expandButtonPress();}return;}if(i===this._getOverflow()){i._expandButtonPress();return;}this.setSelectedItem(i);}}}};n.prototype._fnResize=function(){if(this._getOverflow()._oPopover){this._getOverflow()._oPopover.close();}this._setItemsForStrip();this._initItemNavigation();};n.prototype._isUnselectable=function(i){var F=i._getRealTab();return!F.getEnabled()||(this._isInsideIconTabBar()&&!this.getParent().getContent().length&&F._getNestedLevel()===1&&F.getItems().length&&!F.getContent().length)||F._bIsOverflow;};n.prototype._isInsideIconTabBar=function(){var p=this.getParent();return p instanceof a&&p.isA('sap.m.IconTabBar');};n.prototype._invalidateParentIconTabBar=function(){if(this._isInsideIconTabBar()){this.getParent().invalidate();}};n.prototype.getFocusDomRef=function(F){var t=F||this.oSelectedItem;if(!t){return null;}return t.getDomRef();};n.prototype.applyFocusInfo=function(F){if(F.focusDomRef){q(F.focusDomRef).trigger("focus");}};n.prototype._updateSelection=function(){var j=this.getItems(),s=this.getSelectedKey(),i=0,p=this.getParent(),o=this._isInsideIconTabBar(),t=p&&p.isA("sap.tnt.ToolHeader");if(!j.length){return;}if(!this.oSelectedItem||s&&s!==this.oSelectedItem._getNonEmptyKey()){if(s){this.oSelectedItem=this._findItemByKey(s);}if(!this.oSelectedItem&&(o||!s)){for(i=0;i<j.length;i++){if(!(j[i]instanceof d)&&j[i].getVisible()){this.oSelectedItem=j[i];break;}}}}if(!t&&this.oSelectedItem&&!this.oSelectedItem.getVisible()){for(i=0;i<j.length;i++){if(!(j[i]instanceof d)&&j[i].getVisible()){this.oSelectedItem=j[i];break;}}}if(!this.oSelectedItem){return;}if(this._isUnselectable(this.oSelectedItem)){this.setSelectedItem(this.oSelectedItem._getFirstAvailableSubFilter(),true);return;}this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);};n.prototype._findItemByKey=function(s){var t=this.getTabFilters(),S;for(var i=0;i<t.length;i++){if(t[i]._getNonEmptyKey()===s){return t[i];}S=t[i]._getAllSubFilters();for(var j=0;j<S.length;j++){if(S[j]._getNonEmptyKey()===s){return S[j];}}}};n.prototype._applySelectionToFilters=function(){if(this._isInsideIconTabBar()&&!this.getParent().getExpanded()){return;}this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});if(this.oSelectedItem._getNestedLevel()!==1){var s=this.oSelectedItem._getRootTab();s.$().addClass("sapMITBSelected").attr({"aria-selected":true});}};n.prototype._removeSelectionFromFilters=function(){this.oSelectedItem.$().removeClass("sapMITBSelected").attr({'aria-selected':false});if(this.oSelectedItem._getNestedLevel()!==1){var s=this.oSelectedItem._getRootTab();s.$().removeClass("sapMITBSelected").attr({"aria-selected":false});}};n.prototype._getItemsForOverflow=function(){var i=this._getItemsInStrip(),j=[];this.getItems().forEach(function(o){if(!D.system.phone&&i.indexOf(o)>-1){return;}j.push(o);if(o.isA("sap.m.IconTabFilter")){o._getAllSubItems().forEach(function(s){j.push(s);});}});return j;};n.prototype.ontouchstart=function(o){var t=o.targetTouches[0];this._iActiveTouch=t.identifier;};n.prototype.ontouchend=function(o){if(this._iActiveTouch===undefined){return;}var M=0;var i=1;var j;if(o.which===j||o.which===M||o.which===i){this._handleActivation(o);}this._iActiveTouch=undefined;};n.prototype.ontouchcancel=n.prototype.ontouchend;n.prototype.onkeydown=function(o){switch(o.which){case K.ENTER:this._handleActivation(o);o.preventDefault();break;case K.SPACE:this._handleActivation(o);o.preventDefault();break;}};n.prototype._handleDragAndDrop=function(o){var i=o.getParameter("dropPosition"),j=o.getParameter("draggedControl"),p=o.getParameter("droppedControl"),s=this,t=this.getMaxNestingLevel();if(i===f.On){s=p._getRealTab();}e.handleDrop(s,i,j._getRealTab(),p,false,t);if(j._getNestedLevel()>1){j._getRootTab()._closePopover();}this._setItemsForStrip();this._initItemNavigation();this._getOverflow()._setSelectListItems();this._getSelectList()._initItemNavigation();j._getRealTab().$().trigger("focus");if(i===f.On){p._getRealTab().$().trigger("focus");}};n.prototype._moveTab=function(t,i,M){e.moveItem.call(this,t,i,M);this._setItemsForStrip();this._initItemNavigation();};n.prototype.ondragrearranging=function(o){if(!this.getEnableTabReordering()){return;}var t=o.srcControl,T=this.indexOfItem(this._getItemsInStrip().pop());this._moveTab(t,o.keyCode,T);t.$().trigger("focus");};n.prototype.onsaphomemodifiers=n.prototype.ondragrearranging;n.prototype.onsapendmodifiers=n.prototype.ondragrearranging;n.prototype.onsapincreasemodifiers=n.prototype.ondragrearranging;n.prototype.onsapdecreasemodifiers=n.prototype.ondragrearranging;return n;});
