/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/base/util/ObjectPath',"sap/base/assert","sap/base/Log","sap/base/util/isPlainObject",'sap/base/util/resolveReference'],function(O,a,L,b,r){"use strict";var D=function(){throw new Error();};D.prototype.getName=function(){return undefined;};D.prototype.getBaseType=function(){return undefined;};D.prototype.getPrimitiveType=function(){var T=this;while(T.getBaseType()){T=T.getBaseType();}return T;};D.prototype.getComponentType=function(){return undefined;};D.prototype.getDefaultValue=function(){return undefined;};D.prototype.isArrayType=function(){return false;};D.prototype.isEnumType=function(){return false;};D.prototype.getEnumValues=function(){return undefined;};D.prototype.parseValue=function(v){return v;};D.prototype.isValid=undefined;D.prototype.setNormalizer=function(n){a(typeof n==="function","DataType.setNormalizer: fnNormalizer must be a function");this._fnNormalizer=typeof n==="function"?n:undefined;};D.prototype.normalize=function(v){return this._fnNormalizer?this._fnNormalizer(v):v;};function c(n,s,B){s=s||{};var o=B||D.prototype;var T=Object.create(o);T.getName=function(){return n;};if(s.hasOwnProperty("defaultValue")){var v=s.defaultValue;T.getDefaultValue=function(){return v;};}if(s.isValid){var i=s.isValid;T.isValid=o.isValid?function(V){if(!o.isValid(V)){return false;}return i(V);}:i;}if(s.parseValue){T.parseValue=s.parseValue;}T.getBaseType=function(){return B;};return T;}var d=c("array",{defaultValue:[]});function e(g){a(g instanceof D,"DataType.<createArrayType>: componentType must be a DataType");var T=Object.create(D.prototype);T.getName=function(){return g.getName()+"[]";};T.getComponentType=function(){return g;};T.isValid=function(v){if(v===null){return true;}if(Array.isArray(v)){for(var i=0;i<v.length;i++){if(!g.isValid(v[i])){return false;}}return true;}return false;};T.parseValue=function(v){var V=v.split(",");for(var i=0;i<V.length;i++){V[i]=g.parseValue(V[i]);}return V;};T.isArrayType=function(){return true;};T.getBaseType=function(){return d;};return T;}function f(T,E){var V={},s;for(var n in E){var g=E[n];if(!s){s=g;}if(typeof g!=="string"){throw new Error("Value "+g+" for enum type "+T+" is not a string");}if(!V.hasOwnProperty(g)||n==g){V[g]=n;}}var o=Object.create(D.prototype);o.getName=function(){return T;};o.isValid=function(v){return typeof v==="string"&&V.hasOwnProperty(v);};o.parseValue=function(g){return E[g];};o.getDefaultValue=function(){return s;};o.getBaseType=function(){return t.string;};o.isEnumType=function(){return true;};o.getEnumValues=function(){return E;};return o;}var t={"any":c("any",{defaultValue:null,isValid:function(v){return true;}}),"boolean":c("boolean",{defaultValue:false,isValid:function(v){return typeof v==="boolean";},parseValue:function(v){return v=="true";}}),"int":c("int",{defaultValue:0,isValid:function(v){return typeof v==="number"&&(isNaN(v)||Math.floor(v)==v);},parseValue:function(v){return parseInt(v);}}),"float":c("float",{defaultValue:0.0,isValid:function(v){return typeof v==="number";},parseValue:function(v){return parseFloat(v);}}),"string":c("string",{defaultValue:"",isValid:function(v){return typeof v==="string"||v instanceof String;},parseValue:function(v){return v;}}),"object":c("object",{defaultValue:null,isValid:function(v){return typeof v==="object"||typeof v==="function";},parseValue:function(v){return v?JSON.parse(v):null;}}),"function":c("function",{defaultValue:null,isValid:function(v){return v==null||typeof v==='function';},parseValue:function(v,_){if(v===""){return undefined;}if(!/^\.?[A-Z_\$][A-Z0-9_\$]*(\.[A-Z_\$][A-Z0-9_\$]*)*$/i.test(v)){throw new Error("Function references must consist of dot separated "+"simple identifiers (A-Z, 0-9, _ or $) only, but was '"+v+"'");}var R,C=_&&_.context,l=_&&_.locals;R=r(v,Object.assign({".":C},l));if(R&&this.isValid(R)){return R;}throw new TypeError("The string '"+v+"' couldn't be resolved to a function");}})};D.getType=function(T){a(T&&typeof T==='string',"sTypeName must be a non-empty string");var o=t[T];if(!(o instanceof D)){if(T.indexOf("[]",T.length-2)>0){var C=T.slice(0,-2),g=this.getType(C);o=g&&e(g);if(o){t[T]=o;}}else if(T!=='array'){o=O.get(T);if(o instanceof D){t[T]=o;}else if(b(o)){o=t[T]=f(T,o);}else{if(o){L.warning("'"+T+"' is not a valid data type. Falling back to type 'any'.");o=t.any;}else{L.error("data type '"+T+"' could not be found.");o=undefined;}}}}return o;};D.createType=function(n,s,B){a(typeof n==="string"&&n,"DataType.createType: type name must be a non-empty string");a(B==null||B instanceof D||typeof B==="string"&&B,"DataType.createType: base type must be empty or a DataType or a non-empty string");if(/[\[\]]/.test(n)){L.error("DataType.createType: array types ('something[]') must not be created with createType, "+"they're created on-the-fly by DataType.getType");}if(typeof B==="string"){B=D.getType(B);}B=B||t.any;if(B.isArrayType()||B.isEnumType()){L.error("DataType.createType: base type must not be an array- or enum-type");}if(n==='array'||t[n]instanceof D){if(n==='array'||t[n].getBaseType()==null){throw new Error("DataType.createType: primitive or hidden type "+n+" can't be re-defined");}L.warning("DataTypes.createType: type "+n+" is redefined. "+"This is an unsupported usage of DataType and might cause issues.");}var T=t[n]=c(n,s,B);return T;};var I={};D.registerInterfaceTypes=function(T){for(var i=0;i<T.length;i++){O.set(T[i],I[T[i]]=new String(T[i]));}};D.isInterfaceType=function(T){return I.hasOwnProperty(T)&&O.get(T)===I[T];};return D;},true);
