/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/base/util/isPlainObject"],function(M,i){"use strict";var T=M.extend("sap.ui.dt.TaskManager",{metadata:{library:"sap.ui.dt",properties:{suppressEvents:{type:"boolean",defaultValue:false}},events:{add:{parameters:{taskId:"int"}},complete:{parameters:{taskId:"array"}}}},constructor:function(){M.apply(this,arguments);this._mQueuedTasks={};this._mPendingTasks={};},_iNextId:0,_iTaskCounter:0});T.prototype._validateTask=function(t){if(!i(t)||!t.type||typeof t.type!=="string"){throw new Error("Invalid task specified");}};T.prototype._removeOutdatedTasks=function(t,d){if(d){var D;if(typeof d==="string"){D=function(t){return t[d];};}else if(typeof d==="function"){D=d;}else{throw new Error("Validator needs to be a function or a string");}var a=this._mQueuedTasks[t.type];var n=D(t);if(a&&n){this._mQueuedTasks[t.type]=a.filter(function(o){if(D(o)===n){this._iTaskCounter--;return false;}return true;}.bind(this));}}};T.prototype._addTask=function(t){var a=this._iNextId++;this._mQueuedTasks[t.type]=this._mQueuedTasks[t.type]||[];this._mQueuedTasks[t.type].push(Object.assign({},t,{id:a}));this._iTaskCounter++;if(!this.getSuppressEvents()){this.fireAdd({taskId:a});}return a;};T.prototype.add=function(t,d){this._validateTask(t);this._removeOutdatedTasks(t,d);return this._addTask(t);};T.prototype._removeTaskById=function(t,l){Object.keys(this[l]).forEach(function(s){this[l][s]=this[l][s].filter(function(m){if(m.id===t){this._iTaskCounter--;return false;}return true;}.bind(this));},this);};T.prototype.complete=function(t){this._removeTaskById(t,"_mQueuedTasks");this._removeTaskById(t,"_mPendingTasks");if(!this.getSuppressEvents()){this.fireComplete({taskId:[t]});}};T.prototype.completeBy=function(t){this._validateTask(t);var c=[];var _=function(a){return(a||[]).filter(function(l){var C=Object.keys(t).every(function(k){return l[k]&&l[k]===t[k];});if(C){this._iTaskCounter--;c.push(l.id);return false;}return true;}.bind(this));}.bind(this);this._mQueuedTasks[t.type]=_(this._mQueuedTasks[t.type]);this._mPendingTasks[t.type]=_(this._mPendingTasks[t.type]);if(!this.getSuppressEvents()){this.fireComplete({taskId:c});}};T.prototype.cancel=function(t){this.complete(t);};T.prototype.isEmpty=function(){return this._iTaskCounter===0;};T.prototype.count=function(t){return this.getList(t).length;};T.prototype._markAsPending=function(t,a){this._mPendingTasks[t]=(this._mPendingTasks[t]||[]).concat(a);this._mQueuedTasks[t]=[];};T.prototype._getTypedList=function(t,m){var a=[];if(this._mQueuedTasks[t]){a=this._mQueuedTasks[t].slice(0);}if(m){this._markAsPending(t,a);}else if(this._mPendingTasks[t]){a=a.concat(this._mQueuedTasks[t].slice(0));}return a;};T.prototype._getAllTasks=function(m){var a=[];a=Object.keys(this._mQueuedTasks).reduce(function(r,_){r=r.concat(this._mQueuedTasks[_]);if(m){this._markAsPending(_,this._mQueuedTasks[_]);}return r;}.bind(this),[]);if(!m){a=a.concat(Object.keys(this._mPendingTasks).reduce(function(r,_){return r.concat(this._mPendingTasks[_]);}.bind(this),[]));}return a;};T.prototype.getList=function(t){if(t){return this._getTypedList(t,false);}return this._getAllTasks(false);};T.prototype.getQueuedTasks=function(t){if(t){return this._getTypedList(t,true);}return this._getAllTasks(true);};T.prototype.destroy=function(){this.setSuppressEvents(true);this.getList().forEach(function(t){this.cancel(t.id);},this);M.prototype.destroy.apply(this,arguments);};return T;});
