/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/ui/dt/Plugin","sap/ui/dt/DOMUtil","sap/ui/dt/OverlayUtil","sap/ui/dt/OverlayRegistry","sap/ui/thirdparty/jquery","sap/ui/Device"],function(B,P,D,O,a,q,b){"use strict";var c=P.extend("sap.ui.dt.plugin.DragDrop",{metadata:{"abstract":true,library:"sap.ui.dt",properties:{},associations:{},events:{}}});var I=7;var p=false;var o;c.prototype._preventScrollOnTouch=function(E){if(p){E.preventDefault();}};c.prototype.init=function(){P.prototype.init.apply(this,arguments);document.addEventListener('touchmove',this._preventScrollOnTouch,true);this._dragScrollHandler=this._dragScroll.bind(this);this._dragLeaveHandler=this._dragLeave.bind(this);this._mScrollIntervals={};};c.prototype.exit=function(){P.prototype.exit.apply(this,arguments);document.removeEventListener('touchmove',this._preventScrollOnTouch);delete this._mElementOverlayDelegate;delete this._mAggregationOverlayDelegate;delete this._dragScrollHandler;};c.prototype.registerElementOverlay=function(g){g.attachEvent("movableChange",this._onMovableChange,this);if(g.isMovable()){this._attachDragEvents(g);}g.attachBrowserEvent("dragover",this._onDragOver,this);g.attachBrowserEvent("dragenter",this._onDragEnter,this);g.attachBrowserEvent("dragleave",this._onDragLeave,this);};c.prototype.registerAggregationOverlay=function(A){A.attachTargetZoneChange(this._onAggregationTargetZoneChange,this);if(!b.browser.webkit){this._attachDragScrollHandler(A);}};c.prototype.deregisterElementOverlay=function(g){g.detachEvent("movableChange",this._onMovableChange,this);this._detachDragEvents(g);g.detachBrowserEvent("dragover",this._onDragOver,this);g.detachBrowserEvent("dragenter",this._onDragEnter,this);g.detachBrowserEvent("dragleave",this._onDragLeave,this);};c.prototype.deregisterAggregationOverlay=function(A){A.detachTargetZoneChange(this._onAggregationTargetZoneChange,this);if(!b.browser.webkit){this._removeDragScrollHandler(A);this._clearScrollIntervalFor(A.$().attr("id"));}};c.prototype._attachDragEvents=function(g){g.attachBrowserEvent("dragstart",this._onDragStart,this);g.attachBrowserEvent("drag",this._onDrag,this);g.attachBrowserEvent("dragend",this._onDragEnd,this);g.attachBrowserEvent("touchstart",this._onTouchStart,this);};c.prototype._detachDragEvents=function(g){g.detachBrowserEvent("dragstart",this._onDragStart,this);g.detachBrowserEvent("drag",this._onDrag,this);g.detachBrowserEvent("dragend",this._onDragEnd,this);g.detachBrowserEvent("touchstart",this._onTouchStart,this);};c.prototype.onMovableChange=function(){};c.prototype.onDragStart=function(){};c.prototype.onDragEnd=function(){};c.prototype.onDrag=function(){};c.prototype.onDragEnter=function(){};c.prototype.onDragLeave=function(){};c.prototype.onDragOver=function(){};c.prototype.onAggregationDragEnter=function(){};c.prototype.onAggregationDragOver=function(){};c.prototype.onAggregationDragLeave=function(){};c.prototype.onAggregationDrop=function(){};c.prototype._checkMovable=function(g){if(g.isMovable()||D.getDraggable(g.$())!==undefined){D.setDraggable(g.$(),g.isMovable());}};c.prototype._onMovableChange=function(E){var g=E.getSource();if(g.isMovable()){this._attachDragEvents(g);}else{this._detachDragEvents(g);}this.onMovableChange(g);};c.prototype._onDragStart=function(E){var g=a.getOverlay(E.currentTarget.id);E.stopPropagation();if(b.browser.firefox&&E&&E.originalEvent&&E.originalEvent.dataTransfer&&E.originalEvent.dataTransfer.setData){E.originalEvent.dataTransfer.setData('text/plain','');}this.setBusy(true);this.showGhost(g,E);this.onDragStart(g);};c.prototype._attachTouchDragEvents=function(g){g.attachBrowserEvent("touchmove",this._onTouchMove,this);g.attachBrowserEvent("touchend",this._onTouchEnd,this);};c.prototype._detachTouchDragEvents=function(g){g.detachBrowserEvent("touchmove",this._onTouchMove,this);g.detachBrowserEvent("touchend",this._onTouchEnd,this);};c.prototype._onTouchStart=function(E){var t=E.touches[0].pageX;var g=E.touches[0].pageY;var T=a.getOverlay(E.currentTarget.id);function h(){T.detachBrowserEvent("touchmove",j,this);T.detachBrowserEvent("touchend",k,this);T.detachBrowserEvent("contextmenu",k,this);}function i(l,m){var n=t-l;var r=g-m;return Math.sqrt((n*n)+(r*r));}function j(E){var l=E.touches[0].pageX;var m=E.touches[0].pageY;var n=i(l,m);if(n>I){this.onDragStart(T);h.call(this);this._attachTouchDragEvents(T);}}function k(){h.call(this);p=false;}p=true;E.stopPropagation();T.attachBrowserEvent("touchmove",j,this);T.attachBrowserEvent("contextmenu",k,this);T.attachBrowserEvent("touchend",k,this);};c.prototype._getTargetOverlay=function(E){if(B.isA(E,"sap.ui.dt.Overlay")){var t;if(B.isA(E,"sap.ui.dt.AggregationOverlay")&&E.getTargetZone()){t=E;}else if(B.isA(E,"sap.ui.dt.ElementOverlay")&&O.isInTargetZoneAggregation(E)){t=E;}return t||this._getTargetOverlay(E.getParent());}};c.prototype._findTargetOverlayFromCoordinates=function(g,h){var i=document.elementFromPoint(g,h);var E=i?sap.ui.getCore().byId(i.id):undefined;return this._getTargetOverlay(E);};c.prototype._onTouchMove=function(E){var g=a.getOverlay(E.currentTarget.id);this.onDrag(g);var t=E.touches||E.changedTouches;var h=t[0].pageX;var i=t[0].pageY;var T=this._findTargetOverlayFromCoordinates(h,i);if(!T){return;}if(T!==o){if(o){if(B.isA(o,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragLeave(o);}else{this.onDragLeave(o);}}o=T;if(B.isA(T,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragEnter(T);}else{this.onDragEnter(T);}}if(B.isA(T,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragOver(T);}else{this.onDragOver(T);}E.stopPropagation();};c.prototype._getValidTargetZoneAggregationOverlay=function(g){if(B.isA(g,"sap.ui.dt.AggregationOverlay")&&g.getTargetZone()){return g;}return this._getValidTargetZoneAggregationOverlay(g.getParent());};c.prototype._onTouchEnd=function(E){var g=a.getOverlay(E.currentTarget.id);var A=this._getValidTargetZoneAggregationOverlay(g);if(A){this.onAggregationDrop(A);}this.onDragEnd(g);this._detachTouchDragEvents(g);o=undefined;p=false;};c.prototype.showGhost=function(g,E){if(E&&E.originalEvent&&E.originalEvent.dataTransfer){E.originalEvent.dataTransfer.effectAllowed="move";E.originalEvent.dataTransfer.dropEffect="move";if(!b.browser.msie&&!b.browser.edge&&!b.browser.msie&&E.originalEvent.dataTransfer.setDragImage){this._$ghost=this.createGhost(g,E);this._$ghost.appendTo("#overlay-container");setTimeout(function(){this._removeGhost();}.bind(this),0);E.originalEvent.dataTransfer.setDragImage(this._$ghost.get(0),E.originalEvent.pageX-g.$().offset().left,E.originalEvent.pageY-g.$().offset().top);}}};c.prototype._removeGhost=function(){this.removeGhost();delete this._$ghost;};c.prototype.removeGhost=function(){var $=this.getGhost();if($){$.remove();}};c.prototype.createGhost=function(g){var G=g.getAssociatedDomRef();var $;if(!G){G=this._getAssociatedDomCopy(g);$=G;}else{$=q("<div></div>");q.makeArray(G).forEach(function(n){D.cloneDOMAndStyles(n,$);});}var h=q("<div></div>").addClass("sapUiDtDragGhostWrapper");return h.append($.addClass("sapUiDtDragGhost"));};c.prototype._getAssociatedDomCopy=function(g){var $=q("<div></div>");g.getAggregationOverlays().forEach(function(A){A.getChildren().forEach(function(C){var h=C.getAssociatedDomRef();if(h){D.cloneDOMAndStyles(h,$);}else{D.cloneDOMAndStyles(this._getAssociatedDomCopy(C),$);}},this);},this);return $;};c.prototype.getGhost=function(){return this._$ghost;};c.prototype._onDragEnd=function(E){this.setBusy(false);var g=a.getOverlay(E.currentTarget.id);this._removeGhost();this._clearAllScrollIntervals();this.onDragEnd(g);E.stopPropagation();};c.prototype._onDrag=function(E){var g=a.getOverlay(E.currentTarget.id);this.onDrag(g);E.stopPropagation();};c.prototype._onDragEnter=function(E){var g=a.getOverlay(E.currentTarget.id);if(O.isInTargetZoneAggregation(g)){if(!this.onDragEnter(g)){E.stopPropagation();}}E.preventDefault();};c.prototype._onDragLeave=function(E){var g=a.getOverlay(E.currentTarget.id);if(O.isInTargetZoneAggregation(g)){if(!this.onDragLeave(g)){E.stopPropagation();}}E.preventDefault();};c.prototype._onDragOver=function(E){var g=a.getOverlay(E.currentTarget.id);if(O.isInTargetZoneAggregation(g)){if(!this.onDragOver(g)){E.stopPropagation();}}E.preventDefault();};c.prototype._onAggregationTargetZoneChange=function(E){var A=E.getSource();var t=E.getParameter("targetZone");if(t){this._attachAggregationOverlayEvents(A);}else{this._detachAggregationOverlayEvents(A);}};c.prototype._attachAggregationOverlayEvents=function(A){A.attachBrowserEvent("dragenter",this._onAggregationDragEnter,this);A.attachBrowserEvent("dragover",this._onAggregationDragOver,this);A.attachBrowserEvent("dragleave",this._onAggregationDragLeave,this);A.attachBrowserEvent("drop",this._onAggregationDrop,this);};c.prototype._detachAggregationOverlayEvents=function(A){A.detachBrowserEvent("dragenter",this._onAggregationDragEnter,this);A.detachBrowserEvent("dragover",this._onAggregationDragOver,this);A.detachBrowserEvent("dragleave",this._onAggregationDragLeave,this);A.detachBrowserEvent("drop",this._onAggregationDrop,this);};c.prototype._onAggregationDragEnter=function(E){var A=a.getOverlay(E.currentTarget.id);this.onAggregationDragEnter(A);E.preventDefault();E.stopPropagation();};c.prototype._onAggregationDragOver=function(E){var A=a.getOverlay(E.currentTarget.id);this.onAggregationDragOver(A);E.preventDefault();E.stopPropagation();};c.prototype._onAggregationDragLeave=function(E){var A=a.getOverlay(E.currentTarget.id);this.onAggregationDragLeave(A);E.preventDefault();E.stopPropagation();};c.prototype._onAggregationDrop=function(E){var A=a.getOverlay(E.currentTarget.id);this.onAggregationDrop(A);E.preventDefault();E.stopPropagation();};var d=100;var e=20;var f=50;c.prototype._clearScrollInterval=function(E,s){if(this._mScrollIntervals[E]){window.clearInterval(this._mScrollIntervals[E][s]);delete this._mScrollIntervals[E][s];}};c.prototype._clearScrollIntervalFor=function(E){if(this._mScrollIntervals[E]){Object.keys(this._mScrollIntervals[E]).forEach(function(s){this._clearScrollInterval(E,s);},this);}};c.prototype._clearAllScrollIntervals=function(){Object.keys(this._mScrollIntervals).forEach(this._clearScrollIntervalFor.bind(this));};c.prototype._checkScroll=function($,s,E){var S;var g;var i=1;if(s==="top"||s==="bottom"){S=$.outerHeight();g=$.scrollTop.bind($);}else{S=$.outerWidth();g=$.scrollLeft.bind($);}if(s==="top"||s==="left"){i=-1;}var h=Math.floor(S/4);var t=d;if(h<d){t=h;}if(E<t){this._mScrollIntervals[$.attr("id")]=this._mScrollIntervals[$.attr("id")]||{};if(!this._mScrollIntervals[$.attr("id")][s]){this._mScrollIntervals[$.attr("id")][s]=window.setInterval(function(){var j=g();g(j+i*e);},f);}}else{this._clearScrollInterval($.attr("id"),s);}};c.prototype._dragLeave=function(E){var A=a.getOverlay(E.currentTarget.id);this._clearScrollIntervalFor(A.$().attr("id"));};c.prototype._dragScroll=function(E){var A=a.getOverlay(E.currentTarget.id);var $=A.$();var i=E.clientX;var g=E.clientY;var h=$.offset();var H=$.height();var w=$.width();var t=h.top;var l=h.left;var j=t+H;var r=l+w;this._checkScroll($,"bottom",j-g);this._checkScroll($,"top",g-t);this._checkScroll($,"right",r-i);this._checkScroll($,"left",i-l);};c.prototype._attachDragScrollHandler=function(E){var A;if(B.isA(E,"sap.ui.dt.AggregationOverlay")){A=E;}else{A=E.srcControl;}if(D.hasScrollBar(A.$())){A.getDomRef().addEventListener("dragover",this._dragScrollHandler,true);A.getDomRef().addEventListener("dragleave",this._dragLeaveHandler,true);}};c.prototype._removeDragScrollHandler=function(E){var A;if(B.isA(E,"sap.ui.dt.AggregationOverlay")){A=E;}else{A=E.srcControl;}var g=A.getDomRef();if(g){g.removeEventListener("dragover",this._dragScrollHandler,true);}};return c;});
