#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 arch-hs
version:              0.9.1.0
visibility:           public
id:                   arch-hs-0.9.1.0-71J9uhA8UNu2lhAw9p2xXu
key:                  arch-hs-0.9.1.0-71J9uhA8UNu2lhAw9p2xXu
license:              MIT
copyright:            (c) 2020-2021 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  fd9830aa69a031928edebdb69f9da71e
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.CommunityDB
    Distribution.ArchHs.Compat Distribution.ArchHs.Core
    Distribution.ArchHs.Exception Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.0.1/site-local/arch-hs-0.9.1.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/arch-hs-0.9.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/arch-hs-0.9.1.0
hs-libraries:         HSarch-hs-0.9.1.0-71J9uhA8UNu2lhAw9p2xXu
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.0.1/site-local/arch-hs-0.9.1.0/include
depends:
    Cabal-3.4.0.0 Diff-0.4.0-F7vyJzYzam9CwrUJdg8bD2
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S
    algebraic-graphs-0.5-Em1lV5viphAuJ07GovE3M
    arch-web-0.1.0-FuGgcwBPdZgEkBYEhJpnIz base-4.15.0.0
    bytestring-0.10.12.1 conduit-1.3.4.2-AchFtERdZ63E4BSigaitpI
    conduit-extra-1.3.5-IgmaX557TTAKniYRnNEHGm containers-0.6.4.1
    deepseq-1.4.5.0 directory-1.3.6.1 filepath-1.4.2.1
    hackage-db-2.1.2-JfYBxDS4wFJ6RF97T4aZfb
    http-client-0.7.9-FqmYjByM3mW7WXdqjAmvxU
    http-client-tls-0.3.5.3-E3YrvnwOLk7FnDgjHH7fkr
    megaparsec-9.2.0-4jOz50swwTdC1OkC7cXk5Y
    microlens-0.4.12.0-IoK2ncpVKVzEwRUasmz5D3
    microlens-th-0.4.3.10-D8A4jvR3QXlLLaZkQUchH1
    neat-interpolation-0.5.1.2-5GhiYsDrNznAEzvePSWlqz
    optparse-simple-0.1.1.4-I1A5d4RZ2la8ZtEJYgwVD0
    polysemy-1.6.0.0-2himyjO4xotF1I2GJPhroF
    prettyprinter-1.7.1-163EeBePjHLIFZcbZybr4n
    prettyprinter-ansi-terminal-1.1.3-VoiK4SrFFn3Kv8sAYtuCw
    servant-client-0.18.3-928heCnvJQF8YZg3iho1li
    split-0.2.3.4-DqRCEXcI8QnJvOh9Kk2yn3
    tar-conduit-0.3.2-LgIKLCKKTTm9JRB278GA7O template-haskell-2.17.0.0
    text-1.2.4.1

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

