// Copyright 2014 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

goog.require('axs.AuditRules');
goog.require('axs.constants.Severity');

axs.AuditRules.addRule({
    name: 'humanLangMissing',
    heading: 'The web page should have the content\'s human language indicated in the markup',
    url: 'https://github.com/GoogleChrome/accessibility-developer-tools/wiki/Audit-Rules#ax_html_01',
    severity: axs.constants.Severity.WARNING,
    relevantElementMatcher: function(element) {
        return element instanceof element.ownerDocument.defaultView.HTMLHtmlElement;
    },
    test: function(scope) {
        if (!scope.lang)
          return true;
        return false;
    },
    code: 'AX_HTML_01'
});
