Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var _fileView = require('./file-view');

var _fileView2 = _interopRequireDefault(_fileView);

var _getIconServices = require('./get-icon-services');

var _getIconServices2 = _interopRequireDefault(_getIconServices);

var DirectoryView = (function () {
  function DirectoryView(parentView, indexInParentView, archivePath, entry) {
    var _this = this;

    _classCallCheck(this, DirectoryView);

    this.disposables = new _atom.CompositeDisposable();
    this.entries = [];
    this.parentView = parentView;
    this.indexInParentView = indexInParentView;
    this.element = document.createElement('li');
    this.element.classList.add('list-nested-item', 'entry');

    var listItem = document.createElement('span');
    listItem.classList.add('list-item');

    var clickHandler = function clickHandler(event) {
      event.stopPropagation();
      event.preventDefault();
      _this.element.classList.toggle('collapsed');
    };
    listItem.addEventListener('click', clickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      listItem.removeEventListener('click', clickHandler);
    }));

    var entrySpan = document.createElement('span');
    entrySpan.textContent = entry.getName();
    listItem.appendChild(entrySpan);
    this.element.appendChild(listItem);

    this.entry = entry;
    this.entrySpan = entrySpan;
    (0, _getIconServices2['default'])().updateDirectoryIcon(this);

    this.entriesTree = document.createElement('ol');
    this.entriesTree.classList.add('list-tree');
    var index = 0;
    for (var child of entry.children) {
      if (child.isDirectory()) {
        var entryView = new DirectoryView(this, index, archivePath, child);
        this.entries.push(entryView);
        this.entriesTree.appendChild(entryView.element);
      } else {
        var entryView = new _fileView2['default'](this, index, archivePath, child);
        this.entries.push(entryView);
        this.entriesTree.appendChild(entryView.element);
      }

      index++;
    }
    this.element.appendChild(this.entriesTree);
  }

  _createClass(DirectoryView, [{
    key: 'destroy',
    value: function destroy() {
      if (this.iconDisposable) {
        this.iconDisposable.dispose();
        this.iconDisposable = null;
      }

      while (this.entries.length > 0) {
        this.entries.pop().destroy();
      }

      this.disposables.dispose();
      this.element.remove();
    }
  }, {
    key: 'selectFileBeforeIndex',
    value: function selectFileBeforeIndex(index) {
      for (var i = index - 1; i >= 0; i--) {
        var previousEntry = this.entries[i];
        if (previousEntry instanceof _fileView2['default']) {
          previousEntry.select();
          return;
        } else {
          if (previousEntry.selectLastFile()) {
            return;
          }
        }
      }

      this.parentView.selectFileBeforeIndex(this.indexInParentView);
    }
  }, {
    key: 'selectFileAfterIndex',
    value: function selectFileAfterIndex(index) {
      for (var i = index + 1; i < this.entries.length; i++) {
        var nextEntry = this.entries[i];
        if (nextEntry instanceof _fileView2['default']) {
          nextEntry.select();
          return;
        } else {
          if (nextEntry.selectFirstFile()) {
            return;
          }
        }
      }

      this.parentView.selectFileAfterIndex(this.indexInParentView);
    }
  }, {
    key: 'selectFirstFile',
    value: function selectFirstFile() {
      for (var entry of this.entries) {
        if (entry instanceof _fileView2['default']) {
          entry.select();
          return true;
        } else {
          if (entry.selectFirstFile()) {
            return true;
          }
        }
      }

      return false;
    }
  }, {
    key: 'selectLastFile',
    value: function selectLastFile() {
      for (var i = this.entries.length - 1; i >= 0; i--) {
        var entry = this.entries[i];
        if (entry instanceof _fileView2['default']) {
          entry.select();
          return true;
        } else {
          if (entry.selectLastFile()) {
            return true;
          }
        }
      }

      return false;
    }
  }]);

  return DirectoryView;
})();

exports['default'] = DirectoryView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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