Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _selectorKit = require('selector-kit');

var _scopeHelpers = require('./scope-helpers');

'use babel';

var ProviderMetadata = (function () {
  function ProviderMetadata(provider, apiVersion) {
    _classCallCheck(this, ProviderMetadata);

    this.provider = provider;
    this.apiVersion = apiVersion;

    // TODO API: remove this when 2.0 support is removed
    if (this.provider.selector != null) {
      this.scopeSelectors = _selectorKit.Selector.create(this.provider.selector);
    } else {
      this.scopeSelectors = _selectorKit.Selector.create(this.provider.scopeSelector);
    }

    // TODO API: remove this when 2.0 support is removed
    if (this.provider.disableForSelector != null) {
      this.disableForScopeSelectors = _selectorKit.Selector.create(this.provider.disableForSelector);
    } else if (this.provider.disableForScopeSelector != null) {
      this.disableForScopeSelectors = _selectorKit.Selector.create(this.provider.disableForScopeSelector);
    }

    // TODO API: remove this when 1.0 support is removed
    var providerBlacklist = undefined;
    if (this.provider.providerblacklist && this.provider.providerblacklist['autocomplete-plus-fuzzyprovider']) {
      providerBlacklist = this.provider.providerblacklist['autocomplete-plus-fuzzyprovider'];
    }
    if (providerBlacklist) {
      this.disableDefaultProviderSelectors = _selectorKit.Selector.create(providerBlacklist);
    }
  }

  _createClass(ProviderMetadata, [{
    key: 'getLabels',
    value: function getLabels() {
      // The default label will let the provider be used for
      // the main text editors of the workspace.
      return this.provider.labels || ['workspace-center'];
    }
  }, {
    key: 'matchesScopeChain',
    value: function matchesScopeChain(scopeChain) {
      if (this.disableForScopeSelectors != null) {
        if ((0, _scopeHelpers.selectorsMatchScopeChain)(this.disableForScopeSelectors, scopeChain)) {
          return false;
        }
      }

      if ((0, _scopeHelpers.selectorsMatchScopeChain)(this.scopeSelectors, scopeChain)) {
        return true;
      } else {
        return false;
      }
    }
  }, {
    key: 'shouldDisableDefaultProvider',
    value: function shouldDisableDefaultProvider(scopeChain) {
      if (this.disableDefaultProviderSelectors != null) {
        return (0, _scopeHelpers.selectorsMatchScopeChain)(this.disableDefaultProviderSelectors, scopeChain);
      } else {
        return false;
      }
    }
  }, {
    key: 'getSpecificity',
    value: function getSpecificity(scopeChain) {
      var selector = (0, _scopeHelpers.selectorForScopeChain)(this.scopeSelectors, scopeChain);
      if (selector) {
        return selector.getSpecificity();
      } else {
        return 0;
      }
    }
  }]);

  return ProviderMetadata;
})();

exports['default'] = ProviderMetadata;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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