Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _atomSlick = require('atom-slick');

var _atomSlick2 = _interopRequireDefault(_atomSlick);

'use babel';

var EscapeCharacterRegex = /[-!"#$%&'*+,/:;=?@|^~()<>{}[\]]/g;

var cachedMatchesBySelector = {};

var getCachedMatch = function getCachedMatch(selector, scopeChain) {
  var cachedMatchesByScopeChain = cachedMatchesBySelector[selector];
  if (cachedMatchesByScopeChain) {
    return cachedMatchesByScopeChain[scopeChain];
  }
};

var setCachedMatch = function setCachedMatch(selector, scopeChain, match) {
  var cachedMatchesByScopeChain = cachedMatchesBySelector[selector];
  if (!cachedMatchesByScopeChain) {
    cachedMatchesByScopeChain = {};
    cachedMatchesBySelector[selector] = cachedMatchesByScopeChain;
  }
  cachedMatchesByScopeChain[scopeChain] = match;
  cachedMatchesByScopeChain[scopeChain];
};

var parseScopeChain = function parseScopeChain(scopeChain) {
  scopeChain = scopeChain.replace(EscapeCharacterRegex, function (match) {
    return '\\' + match[0];
  });

  var parsed = _atomSlick2['default'].parse(scopeChain)[0];
  if (!parsed || parsed.length === 0) {
    return [];
  }

  var result = [];
  for (var i = 0; i < parsed.length; i++) {
    result.push(parsed[i]);
  }

  return result;
};

var selectorForScopeChain = function selectorForScopeChain(selectors, scopeChain) {
  for (var i = 0; i < selectors.length; i++) {
    var selector = selectors[i];
    var cachedMatch = getCachedMatch(selector, scopeChain);
    if (cachedMatch != null) {
      if (cachedMatch) {
        return selector;
      } else {
        continue;
      }
    } else {
      var scopes = parseScopeChain(scopeChain);
      while (scopes.length > 0) {
        if (selector.matches(scopes)) {
          setCachedMatch(selector, scopeChain, true);
          return selector;
        }
        scopes.pop();
      }
      setCachedMatch(selector, scopeChain, false);
    }
  }

  return null;
};

var selectorsMatchScopeChain = function selectorsMatchScopeChain(selectors, scopeChain) {
  return selectorForScopeChain(selectors, scopeChain) != null;
};

var buildScopeChainString = function buildScopeChainString(scopes) {
  return '.' + scopes.join(' .');
};

exports.selectorsMatchScopeChain = selectorsMatchScopeChain;
exports.selectorForScopeChain = selectorForScopeChain;
exports.buildScopeChainString = buildScopeChainString;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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