Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var BookmarksView = (function () {
  function BookmarksView(editorsBookmarks) {
    var _this = this;

    _classCallCheck(this, BookmarksView);

    this.editorsBookmarks = editorsBookmarks;
    this.selectList = new _atomSelectList2['default']({
      emptyMessage: 'No bookmarks found',
      items: [],
      filterKeyForItem: function filterKeyForItem(bookmark) {
        return bookmark.filterText;
      },
      didConfirmSelection: function didConfirmSelection(_ref) {
        var editor = _ref.editor;
        var marker = _ref.marker;

        _this.hide();
        editor.setSelectedBufferRange(marker.getBufferRange(), { autoscroll: true });
        atom.workspace.paneForItem(editor).activate();
        atom.workspace.paneForItem(editor).activateItem(editor);
      },
      didCancelSelection: function didCancelSelection() {
        _this.hide();
      },
      elementForItem: function elementForItem(_ref2) {
        var marker = _ref2.marker;
        var editor = _ref2.editor;

        var bookmarkStartRow = marker.getStartBufferPosition().row;
        var bookmarkEndRow = marker.getEndBufferPosition().row;
        var bookmarkPath = editor.getPath() ? _path2['default'].basename(editor.getPath()) : 'untitled';
        var bookmarkLocation = bookmarkPath + ':' + (bookmarkStartRow + 1);
        if (bookmarkStartRow !== bookmarkEndRow) {
          bookmarkLocation += '-' + (bookmarkEndRow + 1);
        }

        var lineText = editor.lineTextForBufferRow(bookmarkStartRow);
        var li = document.createElement('li');
        li.classList.add('bookmark');
        var primaryLine = document.createElement('div');
        primaryLine.classList.add('primary-line');
        primaryLine.textContent = bookmarkLocation;
        li.appendChild(primaryLine);
        if (lineText) {
          var secondaryLine = document.createElement('div');
          secondaryLine.classList.add('secondary-line', 'line-text');
          secondaryLine.textContent = lineText.trim();
          li.appendChild(secondaryLine);
          li.classList.add('two-lines');
        }
        return li;
      }
    });
    this.selectList.element.classList.add('bookmarks-view');
  }

  _createClass(BookmarksView, [{
    key: 'destroy',
    value: function destroy() {
      this.selectList.destroy();
      this.getModalPanel().destroy();
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'show',
    value: _asyncToGenerator(function* () {
      var bookmarks = [];
      for (var _ref32 of this.editorsBookmarks) {
        var editor = _ref32.editor;
        var markerLayer = _ref32.markerLayer;

        for (var marker of markerLayer.getMarkers()) {
          var filterText = '' + marker.getStartBufferPosition().row;

          if (editor.getPath()) {
            filterText += ' ' + editor.getPath();
          }

          var bookmarkedLineText = editor.lineTextForBufferRow(marker.getStartBufferPosition().row);
          if (bookmarkedLineText) {
            filterText += ' ' + bookmarkedLineText.trim();
          }

          bookmarks.push({ marker: marker, editor: editor, filterText: filterText });
        }
      }

      this.previouslyFocusedElement = document.activeElement;
      this.selectList.reset();
      yield this.selectList.update({ items: bookmarks });
      this.getModalPanel().show();
      this.selectList.focus();
    })
  }, {
    key: 'hide',
    value: function hide() {
      this.getModalPanel().hide();
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'getModalPanel',
    value: function getModalPanel() {
      if (!this.modalPanel) {
        this.modalPanel = atom.workspace.addModalPanel({ item: this.selectList });
      }
      return this.modalPanel;
    }
  }]);

  return BookmarksView;
})();

exports['default'] = BookmarksView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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