function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

/** @babel */

var assert = require('assert');
var fs = require('fs');
var sinon = require('sinon');
var path = require('path');

var dalek = require('../lib/dalek');

describe('dalek', function () {
  describe('enumerate', function () {
    var availablePackages = {};
    var realPaths = {};
    var bundledPackages = [];
    var packageDirPaths = [];
    var sandbox = null;

    beforeEach(function () {
      availablePackages = {
        'an-unduplicated-installed-package': path.join('Users', 'username', '.atom', 'packages', 'an-unduplicated-installed-package'),
        'duplicated-package': path.join('Users', 'username', '.atom', 'packages', 'duplicated-package'),
        'unduplicated-package': path.join('' + atom.getLoadSettings().resourcePath, 'node_modules', 'unduplicated-package')
      };

      atom.devMode = false;
      bundledPackages = ['duplicated-package', 'unduplicated-package'];
      packageDirPaths = [path.join('Users', 'username', '.atom', 'packages')];
      sandbox = sinon.createSandbox();
      sandbox.stub(dalek, 'realpath').callsFake(function (filePath) {
        return Promise.resolve(realPaths[filePath] || filePath);
      });
      sandbox.stub(atom.packages, 'isBundledPackage').callsFake(function (packageName) {
        return bundledPackages.includes(packageName);
      });
      sandbox.stub(atom.packages, 'getAvailablePackageNames').callsFake(function () {
        return Object.keys(availablePackages);
      });
      sandbox.stub(atom.packages, 'getPackageDirPaths').callsFake(function () {
        return packageDirPaths;
      });
      sandbox.stub(fs, 'existsSync').callsFake(function (candidate) {
        return Object.values(availablePackages).includes(candidate) && !candidate.includes(atom.getLoadSettings().resourcePath);
      });
    });

    afterEach(function () {
      sandbox.restore();
    });

    it('returns a list of duplicate names', _asyncToGenerator(function* () {
      assert.deepEqual((yield dalek.enumerate()), ['duplicated-package']);
    }));

    describe('when in dev mode', function () {
      beforeEach(function () {
        atom.devMode = true;
      });

      it('always returns an empty list', _asyncToGenerator(function* () {
        assert.deepEqual((yield dalek.enumerate()), []);
      }));
    });

    describe('when a package is symlinked into the package directory', _asyncToGenerator(function* () {
      beforeEach(function () {
        var realPath = path.join('Users', 'username', 'duplicated-package');
        var packagePath = path.join('Users', 'username', '.atom', 'packages', 'duplicated-package');
        realPaths[packagePath] = realPath;
      });

      it('is not included in the list of duplicate names', _asyncToGenerator(function* () {
        assert.deepEqual((yield dalek.enumerate()), []);
      }));
    }));
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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