Object.defineProperty(exports, '__esModule', {
  value: true
});
/** @babel */

var _atom = require('atom');

var reporter = undefined;

function getReporter() {
  if (!reporter) {
    var Reporter = require('./reporter');
    reporter = new Reporter();
  }
  return reporter;
}

exports['default'] = {
  activate: function activate() {
    this.subscriptions = new _atom.CompositeDisposable();

    if (!atom.config.get('exception-reporting.userId')) {
      atom.config.set('exception-reporting.userId', require('node-uuid').v4());
    }

    this.subscriptions.add(atom.onDidThrowError(function (_ref) {
      var message = _ref.message;
      var url = _ref.url;
      var line = _ref.line;
      var column = _ref.column;
      var originalError = _ref.originalError;

      try {
        getReporter().reportUncaughtException(originalError);
      } catch (secondaryException) {
        try {
          console.error('Error reporting uncaught exception', secondaryException);
          getReporter().reportUncaughtException(secondaryException);
        } catch (error) {}
      }
    }));

    if (atom.onDidFailAssertion != null) {
      this.subscriptions.add(atom.onDidFailAssertion(function (error) {
        try {
          getReporter().reportFailedAssertion(error);
        } catch (secondaryException) {
          try {
            console.error('Error reporting assertion failure', secondaryException);
            getReporter().reportUncaughtException(secondaryException);
          } catch (error) {}
        }
      }));
    }
  }
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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