(function() {
  var BufferSearch, CompositeDisposable, Disposable, FindOptions, FindView, History, HistoryCycler, ProjectFindView, ReporterProxy, ResultsModel, ResultsPaneView, SelectNext, TextBuffer, getIconServices, metricsReporter, ref, ref1;

  ref = require('atom'), CompositeDisposable = ref.CompositeDisposable, Disposable = ref.Disposable, TextBuffer = ref.TextBuffer;

  SelectNext = require('./select-next');

  ref1 = require('./history'), History = ref1.History, HistoryCycler = ref1.HistoryCycler;

  FindOptions = require('./find-options');

  BufferSearch = require('./buffer-search');

  getIconServices = require('./get-icon-services');

  FindView = require('./find-view');

  ProjectFindView = require('./project-find-view');

  ResultsModel = require('./project/results-model');

  ResultsPaneView = require('./project/results-pane');

  ReporterProxy = require('./reporter-proxy');

  metricsReporter = new ReporterProxy();

  module.exports = {
    activate: function(arg) {
      var findHistory, findOptions, handleEditorCancel, pathsHistory, ref2, replaceHistory, selectNextObjectForEditorElement, showPanel, togglePanel;
      ref2 = arg != null ? arg : {}, findOptions = ref2.findOptions, findHistory = ref2.findHistory, replaceHistory = ref2.replaceHistory, pathsHistory = ref2.pathsHistory;
      if (atom.config.get('find-and-replace.openProjectFindResultsInRightPane')) {
        atom.config.set('find-and-replace.projectSearchResultsPaneSplitDirection', 'right');
      }
      atom.config.unset('find-and-replace.openProjectFindResultsInRightPane');
      atom.workspace.addOpener(function(filePath) {
        if (filePath.indexOf(ResultsPaneView.URI) !== -1) {
          return new ResultsPaneView();
        }
      });
      this.subscriptions = new CompositeDisposable;
      this.currentItemSub = new Disposable;
      this.findHistory = new History(findHistory);
      this.replaceHistory = new History(replaceHistory);
      this.pathsHistory = new History(pathsHistory);
      this.findOptions = new FindOptions(findOptions);
      this.findModel = new BufferSearch(this.findOptions);
      this.resultsModel = new ResultsModel(this.findOptions, metricsReporter);
      this.subscriptions.add(atom.workspace.getCenter().observeActivePaneItem((function(_this) {
        return function(paneItem) {
          _this.subscriptions["delete"](_this.currentItemSub);
          _this.currentItemSub.dispose();
          if (atom.workspace.isTextEditor(paneItem)) {
            return _this.findModel.setEditor(paneItem);
          } else if ((paneItem != null ? paneItem.observeEmbeddedTextEditor : void 0) != null) {
            _this.currentItemSub = paneItem.observeEmbeddedTextEditor(function(editor) {
              if (atom.workspace.getCenter().getActivePaneItem() === paneItem) {
                return _this.findModel.setEditor(editor);
              }
            });
            return _this.subscriptions.add(_this.currentItemSub);
          } else if ((paneItem != null ? paneItem.getEmbeddedTextEditor : void 0) != null) {
            return _this.findModel.setEditor(paneItem.getEmbeddedTextEditor());
          } else {
            return _this.findModel.setEditor(null);
          }
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('.find-and-replace, .project-find', 'window:focus-next-pane', function() {
        return atom.views.getView(atom.workspace).focus();
      }));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:show', (function(_this) {
        return function() {
          _this.createViews();
          return showPanel(_this.projectFindPanel, _this.findPanel, function() {
            return _this.projectFindView.focusFindElement();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:toggle', (function(_this) {
        return function() {
          _this.createViews();
          return togglePanel(_this.projectFindPanel, _this.findPanel, function() {
            return _this.projectFindView.focusFindElement();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:show-in-current-directory', (function(_this) {
        return function(arg1) {
          var target;
          target = arg1.target;
          _this.createViews();
          _this.findPanel.hide();
          _this.projectFindPanel.show();
          _this.projectFindView.focusFindElement();
          return _this.projectFindView.findInCurrentlySelectedDirectory(target);
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:use-selection-as-find-pattern', (function(_this) {
        return function() {
          var ref3, ref4;
          if (((ref3 = _this.projectFindPanel) != null ? ref3.isVisible() : void 0) || ((ref4 = _this.findPanel) != null ? ref4.isVisible() : void 0)) {
            return;
          }
          return _this.createViews();
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:use-selection-as-replace-pattern', (function(_this) {
        return function() {
          var ref3, ref4;
          if (((ref3 = _this.projectFindPanel) != null ? ref3.isVisible() : void 0) || ((ref4 = _this.findPanel) != null ? ref4.isVisible() : void 0)) {
            return;
          }
          return _this.createViews();
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:toggle', (function(_this) {
        return function() {
          _this.createViews();
          return togglePanel(_this.findPanel, _this.projectFindPanel, function() {
            return _this.findView.focusFindEditor();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:show', (function(_this) {
        return function() {
          _this.createViews();
          return showPanel(_this.findPanel, _this.projectFindPanel, function() {
            return _this.findView.focusFindEditor();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:show-replace', (function(_this) {
        return function() {
          _this.createViews();
          return showPanel(_this.findPanel, _this.projectFindPanel, function() {
            return _this.findView.focusReplaceEditor();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:clear-history', (function(_this) {
        return function() {
          _this.findHistory.clear();
          return _this.replaceHistory.clear();
        };
      })(this)));
      handleEditorCancel = (function(_this) {
        return function(arg1) {
          var isMiniEditor, ref3, ref4, target;
          target = arg1.target;
          isMiniEditor = target.tagName === 'ATOM-TEXT-EDITOR' && target.hasAttribute('mini');
          if (!isMiniEditor) {
            if ((ref3 = _this.findPanel) != null) {
              ref3.hide();
            }
            return (ref4 = _this.projectFindPanel) != null ? ref4.hide() : void 0;
          }
        };
      })(this);
      this.subscriptions.add(atom.commands.add('atom-workspace', {
        'core:cancel': handleEditorCancel,
        'core:close': handleEditorCancel
      }));
      selectNextObjectForEditorElement = (function(_this) {
        return function(editorElement) {
          var editor, selectNext;
          if (_this.selectNextObjects == null) {
            _this.selectNextObjects = new WeakMap();
          }
          editor = editorElement.getModel();
          selectNext = _this.selectNextObjects.get(editor);
          if (selectNext == null) {
            selectNext = new SelectNext(editor);
            _this.selectNextObjects.set(editor, selectNext);
          }
          return selectNext;
        };
      })(this);
      showPanel = function(panelToShow, panelToHide, postShowAction) {
        panelToHide.hide();
        panelToShow.show();
        return typeof postShowAction === "function" ? postShowAction() : void 0;
      };
      togglePanel = function(panelToToggle, panelToHide, postToggleAction) {
        panelToHide.hide();
        if (panelToToggle.isVisible()) {
          return panelToToggle.hide();
        } else {
          panelToToggle.show();
          return typeof postToggleAction === "function" ? postToggleAction() : void 0;
        }
      };
      return this.subscriptions.add(atom.commands.add('.editor:not(.mini)', {
        'find-and-replace:select-next': function(event) {
          return selectNextObjectForEditorElement(this).findAndSelectNext();
        },
        'find-and-replace:select-all': function(event) {
          return selectNextObjectForEditorElement(this).findAndSelectAll();
        },
        'find-and-replace:select-undo': function(event) {
          return selectNextObjectForEditorElement(this).undoLastSelection();
        },
        'find-and-replace:select-skip': function(event) {
          return selectNextObjectForEditorElement(this).skipCurrentSelection();
        }
      }));
    },
    consumeMetricsReporter: function(service) {
      metricsReporter.setReporter(service);
      return new Disposable(function() {
        return metricsReporter.unsetReporter();
      });
    },
    consumeElementIcons: function(service) {
      getIconServices().setElementIcons(service);
      return new Disposable(function() {
        return getIconServices().resetElementIcons();
      });
    },
    consumeFileIcons: function(service) {
      getIconServices().setFileIcons(service);
      return new Disposable(function() {
        return getIconServices().resetFileIcons();
      });
    },
    toggleAutocompletions: function(value) {
      var disposable, ref2;
      if (this.findView == null) {
        return;
      }
      if (value) {
        this.autocompleteSubscriptions = new CompositeDisposable;
        disposable = typeof this.autocompleteWatchEditor === "function" ? this.autocompleteWatchEditor(this.findView.findEditor, ['default']) : void 0;
        if (disposable != null) {
          return this.autocompleteSubscriptions.add(disposable);
        }
      } else {
        return (ref2 = this.autocompleteSubscriptions) != null ? ref2.dispose() : void 0;
      }
    },
    consumeAutocompleteWatchEditor: function(watchEditor) {
      this.autocompleteWatchEditor = watchEditor;
      atom.config.observe('find-and-replace.autocompleteSearches', (function(_this) {
        return function(value) {
          return _this.toggleAutocompletions(value);
        };
      })(this));
      return new Disposable((function(_this) {
        return function() {
          var ref2;
          if ((ref2 = _this.autocompleteSubscriptions) != null) {
            ref2.dispose();
          }
          return _this.autocompleteWatchEditor = null;
        };
      })(this));
    },
    provideService: function() {
      return {
        resultsMarkerLayerForTextEditor: this.findModel.resultsMarkerLayerForTextEditor.bind(this.findModel)
      };
    },
    createViews: function() {
      var findBuffer, findHistoryCycler, options, pathsBuffer, pathsHistoryCycler, replaceBuffer, replaceHistoryCycler;
      if (this.findView != null) {
        return;
      }
      findBuffer = new TextBuffer;
      replaceBuffer = new TextBuffer;
      pathsBuffer = new TextBuffer;
      findHistoryCycler = new HistoryCycler(findBuffer, this.findHistory);
      replaceHistoryCycler = new HistoryCycler(replaceBuffer, this.replaceHistory);
      pathsHistoryCycler = new HistoryCycler(pathsBuffer, this.pathsHistory);
      options = {
        findBuffer: findBuffer,
        replaceBuffer: replaceBuffer,
        pathsBuffer: pathsBuffer,
        findHistoryCycler: findHistoryCycler,
        replaceHistoryCycler: replaceHistoryCycler,
        pathsHistoryCycler: pathsHistoryCycler
      };
      this.findView = new FindView(this.findModel, options);
      this.projectFindView = new ProjectFindView(this.resultsModel, options);
      this.findPanel = atom.workspace.addBottomPanel({
        item: this.findView,
        visible: false,
        className: 'tool-panel panel-bottom'
      });
      this.projectFindPanel = atom.workspace.addBottomPanel({
        item: this.projectFindView,
        visible: false,
        className: 'tool-panel panel-bottom'
      });
      this.findView.setPanel(this.findPanel);
      this.projectFindView.setPanel(this.projectFindPanel);
      ResultsPaneView.projectFindView = this.projectFindView;
      return this.toggleAutocompletions(atom.config.get('find-and-replace.autocompleteSearches'));
    },
    deactivate: function() {
      var ref2, ref3, ref4, ref5, ref6, ref7, ref8;
      if ((ref2 = this.findPanel) != null) {
        ref2.destroy();
      }
      this.findPanel = null;
      if ((ref3 = this.findView) != null) {
        ref3.destroy();
      }
      this.findView = null;
      if ((ref4 = this.findModel) != null) {
        ref4.destroy();
      }
      this.findModel = null;
      if ((ref5 = this.projectFindPanel) != null) {
        ref5.destroy();
      }
      this.projectFindPanel = null;
      if ((ref6 = this.projectFindView) != null) {
        ref6.destroy();
      }
      this.projectFindView = null;
      ResultsPaneView.model = null;
      if ((ref7 = this.autocompleteSubscriptions) != null) {
        ref7.dispose();
      }
      this.autocompleteManagerService = null;
      if ((ref8 = this.subscriptions) != null) {
        ref8.dispose();
      }
      return this.subscriptions = null;
    },
    serialize: function() {
      return {
        findOptions: this.findOptions.serialize(),
        findHistory: this.findHistory.serialize(),
        replaceHistory: this.replaceHistory.serialize(),
        pathsHistory: this.pathsHistory.serialize()
      };
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
