Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _helpers = require('./helpers');

var _helpers2 = _interopRequireDefault(_helpers);

'use babel';

var DiffListView = (function () {
  function DiffListView() {
    var _this = this;

    _classCallCheck(this, DiffListView);

    this.selectListView = new _atomSelectList2['default']({
      emptyMessage: 'No diffs in file',
      items: [],
      filterKeyForItem: function filterKeyForItem(diff) {
        return diff.lineText;
      },
      elementForItem: function elementForItem(diff) {
        var li = document.createElement('li');
        li.classList.add('two-lines');

        var primaryLine = document.createElement('div');
        primaryLine.classList.add('primary-line');
        primaryLine.textContent = diff.lineText;
        li.appendChild(primaryLine);

        var secondaryLine = document.createElement('div');
        secondaryLine.classList.add('secondary-line');
        secondaryLine.textContent = '-' + diff.oldStart + ',' + diff.oldLines + ' +' + diff.newStart + ',' + diff.newLines;
        li.appendChild(secondaryLine);

        return li;
      },
      didConfirmSelection: function didConfirmSelection(diff) {
        _this.cancel();
        var bufferRow = diff.newStart > 0 ? diff.newStart - 1 : diff.newStart;
        _this.editor.setCursorBufferPosition([bufferRow, 0], {
          autoscroll: true
        });
        _this.editor.moveToFirstCharacterOfLine();
      },
      didCancelSelection: function didCancelSelection() {
        _this.cancel();
      }
    });
    this.selectListView.element.classList.add('diff-list-view');
    this.panel = atom.workspace.addModalPanel({
      item: this.selectListView,
      visible: false
    });
  }

  _createClass(DiffListView, [{
    key: 'attach',
    value: function attach() {
      this.previouslyFocusedElement = document.activeElement;
      this.selectListView.reset();
      this.panel.show();
      this.selectListView.focus();
    }
  }, {
    key: 'cancel',
    value: function cancel() {
      this.panel.hide();
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.cancel();
      this.panel.destroy();
      return this.selectListView.destroy();
    }
  }, {
    key: 'toggle',
    value: _asyncToGenerator(function* () {
      var editor = atom.workspace.getActiveTextEditor();
      if (this.panel.isVisible()) {
        this.cancel();
      } else if (editor) {
        this.editor = editor;
        var repository = yield (0, _helpers2['default'])(this.editor.getPath());
        var diffs = repository ? repository.getLineDiffs(this.editor.getPath(), this.editor.getText()) : [];
        if (!diffs) diffs = [];
        for (var diff of diffs) {
          var bufferRow = diff.newStart > 0 ? diff.newStart - 1 : diff.newStart;
          var lineText = this.editor.lineTextForBufferRow(bufferRow);
          diff.lineText = lineText ? lineText.trim() : '';
        }

        yield this.selectListView.update({ items: diffs });
        this.attach();
      }
    })
  }]);

  return DiffListView;
})();

exports['default'] = DiffListView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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