Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _atom = require('atom');

var _helpers = require('./helpers');

var _helpers2 = _interopRequireDefault(_helpers);

'use babel';

var MAX_BUFFER_LENGTH_TO_DIFF = 2 * 1024 * 1024;

/**
 * @describe Handles per-editor event and repository subscriptions.
 * @param editor {Atom.TextEditor} - The editor this view will manage.
 */

var GitDiffView = (function () {
  function GitDiffView(editor, editorElement) {
    _classCallCheck(this, GitDiffView);

    // These are the only members guaranteed to exist.
    this.subscriptions = new _atom.CompositeDisposable();
    this.editor = editor;
    this.editorElement = editorElement;
    this.repository = null;
    this.markers = new Map();

    // Assign `null` to all possible child vars here so the JS engine doesn't
    // have to re-evaluate the microcode when we do eventually need them.
    this.releaseChildren();

    // I know this looks janky but it works. Class methods are available
    // before the constructor is executed. It's a micro-opt above lambdas.
    var subscribeToRepository = this.subscribeToRepository.bind(this);
    // WARNING: This gets handed to requestAnimationFrame, so it must be bound.
    this.updateDiffs = this.updateDiffs.bind(this);

    subscribeToRepository();

    this.subscriptions.add(atom.project.onDidChangePaths(subscribeToRepository));
  }

  /**
   * @describe Handles tear down of destructables and subscriptions.
   *   Does not handle release of memory. This method should only be called
   *   just before this object is freed, and should only tear down the main
   *   object components that are guarunteed to exist at all times.
   */

  _createClass(GitDiffView, [{
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      this.destroyChildren();
      this.markers.clear();
    }

    /**
     * @describe Destroys this objects children (non-freeing), it's intended
     *   to be an ease-of use function for maintaing this object. This method
     *   should only tear down objects that are selectively allocated upon
     *   repository discovery.
     *
     *   Example: this.diffs only exists when we have a repository.
     */
  }, {
    key: 'destroyChildren',
    value: function destroyChildren() {
      if (this._animationId) cancelAnimationFrame(this._animationId);

      if (this.diffs) for (var diff of this.diffs) {
        this.markers.get(diff).destroy();
      }
    }

    /**
     * @describe The memory releasing complement function of `destroyChildren`.
     *   frees the memory allocated at all child object storage locations
     *   when there is no repository.
     */
  }, {
    key: 'releaseChildren',
    value: function releaseChildren() {
      this.diffs = null;
      this._repoSubs = null;
      this._animationId = null;
      this.editorPath = null;
      this.buffer = null;
    }

    /**
     * @describe handles all subscriptions based on the repository in focus
     */
  }, {
    key: 'subscribeToRepository',
    value: _asyncToGenerator(function* () {
      var _this = this;

      if (this._repoSubs !== null) {
        this._repoSubs.dispose();
        this.subscriptions.remove(this._repoSubs);
      }

      // Don't cache the path unless we know we need it.
      var editorPath = this.editor.getPath();

      this.repository = yield (0, _helpers2['default'])(editorPath);
      if (this.repository !== null) {
        (function () {
          _this.editorPath = editorPath;
          _this.buffer = _this.editor.getBuffer();

          var subscribeToRepository = _this.subscribeToRepository.bind(_this);
          var updateIconDecoration = _this.updateIconDecoration.bind(_this);
          var scheduleUpdate = _this.scheduleUpdate.bind(_this);

          _this._repoSubs = new _atom.CompositeDisposable(_this.repository.onDidDestroy(subscribeToRepository), _this.repository.onDidChangeStatuses(scheduleUpdate), _this.repository.onDidChangeStatus(function (changedPath) {
            if (changedPath === _this.editorPath) scheduleUpdate();
          }), _this.editor.onDidStopChanging(scheduleUpdate), _this.editor.onDidChangePath(function () {
            _this.editorPath = _this.edtior.getPath();
            _this.buffer = _this.editor.getBuffer();
            scheduleUpdate();
          }), atom.commands.add(_this.editorElement, 'git-diff:move-to-next-diff', _this.moveToNextDiff.bind(_this)), atom.commands.add(_this.editorElement, 'git-diff:move-to-previous-diff', _this.moveToPreviousDiff.bind(_this)), atom.config.onDidChange('git-diff.showIconsInEditorGutter', updateIconDecoration), atom.config.onDidChange('editor.showLineNumbers', updateIconDecoration), _this.editorElement.onDidAttach(updateIconDecoration));

          // Every time the repo is changed, the editor needs to be reinitialized.
          _this.subscriptions.add(_this._repoSubs);

          updateIconDecoration();
          scheduleUpdate();
        })();
      } else {
        this.destroyChildren();
        this.releaseChildren();
      }
    })
  }, {
    key: 'moveToNextDiff',
    value: function moveToNextDiff() {
      var cursorLineNumber = this.editor.getCursorBufferPosition().row + 1;
      var nextDiffLineNumber = null;
      var firstDiffLineNumber = null;

      for (var _ref2 of this.diffs) {
        var newStart = _ref2.newStart;

        if (newStart > cursorLineNumber) {
          if (nextDiffLineNumber == null) nextDiffLineNumber = newStart - 1;

          nextDiffLineNumber = Math.min(newStart - 1, nextDiffLineNumber);
        }

        if (firstDiffLineNumber == null) firstDiffLineNumber = newStart - 1;

        firstDiffLineNumber = Math.min(newStart - 1, firstDiffLineNumber);
      }

      // Wrap around to the first diff in the file
      if (atom.config.get('git-diff.wrapAroundOnMoveToDiff') && nextDiffLineNumber == null) {
        nextDiffLineNumber = firstDiffLineNumber;
      }

      this.moveToLineNumber(nextDiffLineNumber);
    }
  }, {
    key: 'moveToPreviousDiff',
    value: function moveToPreviousDiff() {
      var cursorLineNumber = this.editor.getCursorBufferPosition().row + 1;
      var previousDiffLineNumber = null;
      var lastDiffLineNumber = null;
      for (var _ref32 of this.diffs) {
        var newStart = _ref32.newStart;

        if (newStart < cursorLineNumber) {
          previousDiffLineNumber = Math.max(newStart - 1, previousDiffLineNumber);
        }
        lastDiffLineNumber = Math.max(newStart - 1, lastDiffLineNumber);
      }

      // Wrap around to the last diff in the file
      if (atom.config.get('git-diff.wrapAroundOnMoveToDiff') && previousDiffLineNumber === null) {
        previousDiffLineNumber = lastDiffLineNumber;
      }

      this.moveToLineNumber(previousDiffLineNumber);
    }
  }, {
    key: 'updateIconDecoration',
    value: function updateIconDecoration() {
      var gutter = this.editorElement.querySelector('.gutter');
      if (gutter) {
        if (atom.config.get('editor.showLineNumbers') && atom.config.get('git-diff.showIconsInEditorGutter')) {
          gutter.classList.add('git-diff-icon');
        } else {
          gutter.classList.remove('git-diff-icon');
        }
      }
    }
  }, {
    key: 'moveToLineNumber',
    value: function moveToLineNumber(lineNumber) {
      if (lineNumber !== null) {
        this.editor.setCursorBufferPosition([lineNumber, 0]);
        this.editor.moveToFirstCharacterOfLine();
      }
    }
  }, {
    key: 'scheduleUpdate',
    value: function scheduleUpdate() {
      // Use Chromium native requestAnimationFrame because it yields
      // to the browser, is standard and doesn't involve extra JS overhead.
      if (this._animationId) cancelAnimationFrame(this._animationId);

      this._animationId = requestAnimationFrame(this.updateDiffs);
    }

    /**
     * @describe Uses text markers in the target editor to visualize
     *   git modifications, additions, and deletions. The current algorithm
     *   just redraws the markers each call.
     */
  }, {
    key: 'updateDiffs',
    value: function updateDiffs() {
      if (this.buffer.getLength() < MAX_BUFFER_LENGTH_TO_DIFF) {
        // Before we redraw the diffs, tear down the old markers.
        if (this.diffs) for (var diff of this.diffs) {
          this.markers.get(diff).destroy();
        }this.markers.clear();

        var text = this.buffer.getText();
        this.diffs = this.repository.getLineDiffs(this.editorPath, text);
        this.diffs = this.diffs || []; // Sanitize type to array.

        for (var diff of this.diffs) {
          var newStart = diff.newStart;
          var oldLines = diff.oldLines;
          var newLines = diff.newLines;

          var startRow = newStart - 1;
          var endRow = newStart + newLines - 1;

          var mark = undefined;

          if (oldLines === 0 && newLines > 0) {
            mark = this.markRange(startRow, endRow, 'git-line-added');
          } else if (newLines === 0 && oldLines > 0) {
            if (startRow < 0) {
              mark = this.markRange(0, 0, 'git-previous-line-removed');
            } else {
              mark = this.markRange(startRow, startRow, 'git-line-removed');
            }
          } else {
            mark = this.markRange(startRow, endRow, 'git-line-modified');
          }

          this.markers.set(diff, mark);
        }
      }
    }
  }, {
    key: 'markRange',
    value: function markRange(startRow, endRow, klass) {
      var marker = this.editor.markBufferRange([[startRow, 0], [endRow, 0]], {
        invalidate: 'never'
      });
      this.editor.decorateMarker(marker, { type: 'line-number', 'class': klass });
      return marker;
    }
  }]);

  return GitDiffView;
})();

exports['default'] = GitDiffView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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