Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _atom = require('atom');

var _gitDiffView = require('./git-diff-view');

var _gitDiffView2 = _interopRequireDefault(_gitDiffView);

var _diffListView = require('./diff-list-view');

var _diffListView2 = _interopRequireDefault(_diffListView);

'use babel';

var diffListView = null;
var diffViews = new Set();
var subscriptions = null;

exports['default'] = {
  activate: function activate(state) {
    subscriptions = new _atom.CompositeDisposable();

    subscriptions.add(atom.workspace.observeTextEditors(function (editor) {
      var editorElement = atom.views.getView(editor);
      var diffView = new _gitDiffView2['default'](editor, editorElement);

      diffViews.add(diffView);

      var listViewCommand = 'git-diff:toggle-diff-list';
      var editorSubs = new _atom.CompositeDisposable(atom.commands.add(editorElement, listViewCommand, function () {
        if (diffListView == null) diffListView = new _diffListView2['default']();

        diffListView.toggle();
      }), editor.onDidDestroy(function () {
        diffView.destroy();
        diffViews['delete'](diffView);
        editorSubs.dispose();
        subscriptions.remove(editorSubs);
      }));

      subscriptions.add(editorSubs);
    }));
  },

  deactivate: function deactivate() {
    diffListView = null;

    for (var diffView of diffViews) {
      diffView.destroy();
    }diffViews.clear();

    subscriptions.dispose();
    subscriptions = null;
  }
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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