<!--

Have you read Atom's Code of Conduct? By filing an Issue, you are expected to comply with it, including treating everyone with respect: https://github.com/atom/atom/blob/master/CODE_OF_CONDUCT.md

Do you want to ask a question? Are you looking for support? The Atom message board is the best place for getting support: https://discuss.atom.io

-->

### Prerequisites

* Have you tried to reproduce the problem in [Safe Mode][safe-mode]?
* Have you followed all applicable steps in the [debugging guide][debugging-guide]?
* Have you checked the FAQs on the [message board][message-board] for common solutions?
* Have you checked that your issue [isn't already filed][already-filed]?

[safe-mode]: http://flight-manual.atom.io/hacking-atom/sections/debugging/#using-safe-mode
[debugging-guide]: http://flight-manual.atom.io/hacking-atom/sections/debugging/
[message-board]: https://discuss.atom.io/c/faq
[already-filed]: https://github.com/atom/github/issues

### Description

<!-- High-level description of what's going wrong. Please be sure to include any stack traces that appear in the developer console or the exact text of any error notifications that are shown. -->

### Steps to Reproduce

1. <!-- First Step -->
2. <!-- Second Step -->
3. <!-- and so on... -->

**Expected behavior:**

<!-- What did you expect to happen? -->

**Actual behavior:**

<!-- What actually happened instead? -->

**Reproduces how often:**

<!-- Roughly what percentage of the time does this happen? Is this issue an intermittent glitch or does it occur consistently? -->

### Platform and Versions

What OS and version of OS are you running?

What version of Atom are you using? You can get this information from copy and pasting the output of `atom --version` and `apm --version` from the command line.

### Additional Information

Please include any additional information, configuration or data that might be necessary to reproduce the issue. Screenshots, if appropriate, are helpful as well.

If your issue involves a repository, and that repository is public, please include a link to it.
