"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Command = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Commands extends _react.default.Component {
  render() {
    const {
      registry,
      target
    } = this.props;
    return _react.default.createElement("div", null, _react.default.Children.map(this.props.children, child => {
      return child ? _react.default.cloneElement(child, {
        registry,
        target
      }) : null;
    }));
  }

}

exports.default = Commands;

_defineProperty(Commands, "propTypes", {
  registry: _propTypes.default.object.isRequired,
  target: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes2.DOMNodePropType, _propTypes2.RefHolderPropType]).isRequired,
  children: _propTypes.default.oneOfType([_propTypes.default.element, _propTypes.default.arrayOf(_propTypes.default.element)]).isRequired
});

class Command extends _react.default.Component {
  constructor(props, context) {
    super(props, context);
    this.subTarget = new _eventKit.Disposable();
    this.subCommand = new _eventKit.Disposable();
  }

  componentDidMount() {
    this.observeTarget(this.props);
  }

  componentWillReceiveProps(newProps) {
    if (['registry', 'target', 'command', 'callback'].some(p => newProps[p] !== this.props[p])) {
      this.observeTarget(newProps);
    }
  }

  componentWillUnmount() {
    this.subTarget.dispose();
    this.subCommand.dispose();
  }

  observeTarget(props) {
    this.subTarget.dispose();
    this.subTarget = _refHolder.default.on(props.target).observe(t => this.registerCommand(t, props));
  }

  registerCommand(target, {
    registry,
    command,
    callback
  }) {
    this.subCommand.dispose();
    this.subCommand = registry.add(target, command, callback);
  }

  render() {
    return null;
  }

}

exports.Command = Command;

_defineProperty(Command, "propTypes", {
  registry: _propTypes.default.object,
  target: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes2.DOMNodePropType, _propTypes2.RefHolderPropType]),
  command: _propTypes.default.string.isRequired,
  callback: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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