"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _classnames = _interopRequireDefault(require("classnames"));

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _atomTextEditor = require("./atom-text-editor");

var _marker = require("./marker");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const decorationPropTypes = {
  type: _propTypes.default.oneOf(['line', 'line-number', 'highlight', 'overlay', 'gutter', 'block']).isRequired,
  className: _propTypes.default.string,
  style: _propTypes.default.string,
  onlyHead: _propTypes.default.bool,
  onlyEmpty: _propTypes.default.bool,
  onlyNonEmpty: _propTypes.default.bool,
  omitEmptyLastRow: _propTypes.default.bool,
  position: _propTypes.default.oneOf(['head', 'tail', 'before', 'after']),
  order: _propTypes.default.number,
  avoidOverflow: _propTypes.default.bool,
  gutterName: _propTypes.default.string
};

class BareDecoration extends _react.default.Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "observeParents", () => {
      this.decorationHolder.map(decoration => decoration.destroy());
      const editorValid = this.props.editorHolder.map(editor => !editor.isDestroyed()).getOr(false);
      const decorableValid = this.props.decorableHolder.map(decorable => !decorable.isDestroyed()).getOr(false); // Ensure the Marker or MarkerLayer corresponds to the context's TextEditor

      const decorableMatches = this.props.decorableHolder.map(decorable => this.props.editorHolder.map(editor => {
        const layer = decorable.layer || decorable;
        const displayLayer = editor.getMarkerLayer(layer.id);

        if (!displayLayer) {
          return false;
        }

        if (displayLayer !== layer && displayLayer.bufferMarkerLayer !== layer) {
          return false;
        }

        return true;
      }).getOr(false)).getOr(false);

      if (!editorValid || !decorableValid || !decorableMatches) {
        return;
      } // delay decoration creation when it's a gutter type;
      // instead wait for the Gutter to be added to the editor first


      if (this.props.type === 'gutter') {
        if (!this.props.gutterName) {
          throw new Error('You are trying to decorate a gutter but did not supply gutterName prop.');
        }

        this.props.editorHolder.map(editor => {
          this.gutterSub = editor.observeGutters(gutter => {
            if (gutter.name === this.props.gutterName) {
              this.createDecoration();
            }
          });
          return null;
        });
        return;
      }

      this.createDecoration();
    });

    this.decorationHolder = new _refHolder.default();
    this.editorSub = new _eventKit.Disposable();
    this.decorableSub = new _eventKit.Disposable();
    this.gutterSub = new _eventKit.Disposable();
    this.domNode = null;
    this.item = null;

    if (['gutter', 'overlay', 'block'].includes(this.props.type)) {
      this.domNode = document.createElement('div');
      this.domNode.className = (0, _classnames.default)('react-atom-decoration', this.props.className);
    }
  }

  usesItem() {
    return this.domNode !== null;
  }

  componentDidMount() {
    this.editorSub = this.props.editorHolder.observe(this.observeParents);
    this.decorableSub = this.props.decorableHolder.observe(this.observeParents);
  }

  componentDidUpdate(prevProps) {
    if (this.props.editorHolder !== prevProps.editorHolder) {
      this.editorSub.dispose();
      this.editorSub = this.props.editorHolder.observe(this.observeParents);
    }

    if (this.props.decorableHolder !== prevProps.decorableHolder) {
      this.decorableSub.dispose();
      this.decorableSub = this.props.decorableHolder.observe(this.observeParents);
    }

    if (Object.keys(decorationPropTypes).some(key => this.props[key] !== prevProps[key])) {
      this.decorationHolder.map(decoration => decoration.destroy());
      this.createDecoration();
    }
  }

  render() {
    if (this.usesItem()) {
      return _reactDom.default.createPortal(this.props.children, this.domNode);
    } else {
      return null;
    }
  }

  createDecoration() {
    if (this.usesItem() && !this.item) {
      this.item = (0, _helpers.createItem)(this.domNode, this.props.itemHolder);
    }

    const opts = this.getDecorationOpts(this.props);
    const editor = this.props.editorHolder.get();
    const decorable = this.props.decorableHolder.get();
    this.decorationHolder.setter(editor[this.props.decorateMethod](decorable, opts));
  }

  componentWillUnmount() {
    this.decorationHolder.map(decoration => decoration.destroy());
    this.editorSub.dispose();
    this.decorableSub.dispose();
    this.gutterSub.dispose();
  }

  getDecorationOpts(props) {
    return _objectSpread2({}, (0, _helpers.extractProps)(props, decorationPropTypes, {
      className: 'class'
    }), {
      item: this.item
    });
  }

}

_defineProperty(BareDecoration, "propTypes", _objectSpread2({
  editorHolder: _propTypes2.RefHolderPropType.isRequired,
  decorableHolder: _propTypes2.RefHolderPropType.isRequired,
  decorateMethod: _propTypes.default.oneOf(['decorateMarker', 'decorateMarkerLayer']),
  itemHolder: _propTypes2.RefHolderPropType,
  children: _propTypes.default.node
}, decorationPropTypes));

_defineProperty(BareDecoration, "defaultProps", {
  decorateMethod: 'decorateMarker'
});

class Decoration extends _react.default.Component {
  constructor(props) {
    super(props);
    this.state = {
      editorHolder: _refHolder.default.on(this.props.editor),
      decorableHolder: _refHolder.default.on(this.props.decorable)
    };
  }

  static getDerivedStateFromProps(props, state) {
    const editorChanged = state.editorHolder.map(editor => editor !== props.editor).getOr(props.editor !== undefined);
    const decorableChanged = state.decorableHolder.map(decorable => decorable !== props.decorable).getOr(props.decorable !== undefined);

    if (!editorChanged && !decorableChanged) {
      return null;
    }

    const nextState = {};

    if (editorChanged) {
      nextState.editorHolder = _refHolder.default.on(props.editor);
    }

    if (decorableChanged) {
      nextState.decorableHolder = _refHolder.default.on(props.decorable);
    }

    return nextState;
  }

  render() {
    return _react.default.createElement(_atomTextEditor.TextEditorContext.Consumer, null, editorHolder => _react.default.createElement(_marker.DecorableContext.Consumer, null, decorable => {
      let holder = null;
      let decorateMethod = null;

      if (!this.state.decorableHolder.isEmpty()) {
        holder = this.state.decorableHolder;
        decorateMethod = this.props.decorateMethod;
      } else {
        holder = decorable.holder;
        decorateMethod = decorable.decorateMethod;
      }

      return _react.default.createElement(BareDecoration, _extends({
        editorHolder: editorHolder || this.state.editorHolder,
        decorableHolder: holder,
        decorateMethod: decorateMethod
      }, this.props));
    }));
  }

}

exports.default = Decoration;

_defineProperty(Decoration, "propTypes", {
  editor: _propTypes.default.object,
  decorable: _propTypes.default.object,
  decorateMethod: _propTypes.default.oneOf(['decorateMarker', 'decorateMarkerLayer'])
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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