"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _atomTextEditor = require("./atom-text-editor");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const gutterProps = {
  name: _propTypes.default.string.isRequired,
  priority: _propTypes.default.number.isRequired,
  visible: _propTypes.default.bool,
  type: _propTypes.default.oneOf(['line-number', 'decorated']),
  labelFn: _propTypes.default.func,
  onMouseDown: _propTypes.default.func,
  onMouseMove: _propTypes.default.func
};

class BareGutter extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'observeEditor', 'forceUpdate');
    this.state = {
      gutter: null
    };
    this.sub = new _eventKit.Disposable();
  }

  componentDidMount() {
    this.sub = this.props.editorHolder.observe(this.observeEditor);
  }

  componentDidUpdate(prevProps) {
    if (this.props.editorHolder !== prevProps.editorHolder) {
      this.sub.dispose();
      this.sub = this.props.editorHolder.observe(this.observeEditor);
    }
  }

  componentWillUnmount() {
    if (this.state.gutter !== null) {
      try {
        this.state.gutter.destroy();
      } catch (e) {// Gutter already destroyed. Disregard.
      }
    }

    this.sub.dispose();
  }

  render() {
    return null;
  }

  observeEditor(editor) {
    this.setState((prevState, props) => {
      if (prevState.gutter !== null) {
        prevState.gutter.destroy();
      }

      const options = (0, _helpers.extractProps)(props, gutterProps);
      options.class = props.className;
      return {
        gutter: editor.addGutter(options)
      };
    });
  }

}

_defineProperty(BareGutter, "propTypes", _objectSpread2({
  editorHolder: _propTypes2.RefHolderPropType.isRequired,
  className: _propTypes.default.string
}, gutterProps));

_defineProperty(BareGutter, "defaultProps", {
  visible: true,
  type: 'decorated',
  labelFn: () => {}
});

class Gutter extends _react.default.Component {
  constructor(props) {
    super(props);
    this.state = {
      editorHolder: _refHolder.default.on(this.props.editor)
    };
  }

  static getDerivedStateFromProps(props, state) {
    const editorChanged = state.editorHolder.map(editor => editor !== props.editor).getOr(props.editor !== undefined);
    return editorChanged ? _refHolder.default.on(props.editor) : null;
  }

  render() {
    if (!this.state.editorHolder.isEmpty()) {
      return _react.default.createElement(BareGutter, _extends({}, this.props, {
        editorHolder: this.state.editorHolder
      }));
    }

    return _react.default.createElement(_atomTextEditor.TextEditorContext.Consumer, null, editorHolder => _react.default.createElement(BareGutter, _extends({}, this.props, {
      editorHolder: editorHolder
    })));
  }

}

exports.default = Gutter;

_defineProperty(Gutter, "propTypes", {
  editor: _propTypes.default.object
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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