"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DecorableContext = exports.MarkerContext = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _atomTextEditor = require("./atom-text-editor");

var _markerLayer = require("./marker-layer");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const MarkablePropType = _propTypes.default.shape({
  markBufferRange: _propTypes.default.func.isRequired
});

const markerProps = {
  exclusive: _propTypes.default.bool,
  reversed: _propTypes.default.bool,
  invalidate: _propTypes.default.oneOf(['never', 'surround', 'overlap', 'inside', 'touch'])
};

const MarkerContext = _react.default.createContext();

exports.MarkerContext = MarkerContext;

const DecorableContext = _react.default.createContext();

exports.DecorableContext = DecorableContext;

class BareMarker extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'createMarker', 'didChange');
    this.markerSubs = new _eventKit.CompositeDisposable();
    this.subs = new _eventKit.CompositeDisposable();
    this.markerHolder = new _refHolder.default();
    this.markerHolder.observe(marker => {
      this.props.handleMarker(marker);
    });
    this.decorable = {
      holder: this.markerHolder,
      decorateMethod: 'decorateMarker'
    };
  }

  componentDidMount() {
    this.observeMarkable();
  }

  render() {
    return _react.default.createElement(MarkerContext.Provider, {
      value: this.markerHolder
    }, _react.default.createElement(DecorableContext.Provider, {
      value: this.decorable
    }, this.props.children));
  }

  componentDidUpdate(prevProps) {
    if (prevProps.markableHolder !== this.props.markableHolder) {
      this.observeMarkable();
    }

    if (Object.keys(markerProps).some(key => prevProps[key] !== this.props[key])) {
      this.markerHolder.map(marker => marker.setProperties((0, _helpers.extractProps)(this.props, markerProps)));
    }

    this.updateMarkerPosition();
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

  observeMarkable() {
    this.subs.dispose();
    this.subs = new _eventKit.CompositeDisposable();
    this.subs.add(this.props.markableHolder.observe(this.createMarker));
  }

  createMarker() {
    this.markerSubs.dispose();
    this.markerSubs = new _eventKit.CompositeDisposable();
    this.subs.add(this.markerSubs);
    const options = (0, _helpers.extractProps)(this.props, markerProps);
    this.props.markableHolder.map(markable => {
      let marker;

      if (this.props.id !== undefined) {
        marker = markable.getMarker(this.props.id);

        if (!marker) {
          throw new Error(`Invalid marker ID: ${this.props.id}`);
        }

        marker.setProperties(options);
      } else {
        marker = markable.markBufferRange(this.props.bufferRange, options);
        this.markerSubs.add(new _eventKit.Disposable(() => marker.destroy()));
      }

      this.markerSubs.add(marker.onDidChange(this.didChange));
      this.markerHolder.setter(marker);
      this.props.handleID(marker.id);
      return null;
    });
  }

  updateMarkerPosition() {
    this.markerHolder.map(marker => marker.setBufferRange(this.props.bufferRange));
  }

  didChange(event) {
    const reversed = this.markerHolder.map(marker => marker.isReversed()).getOr(false);
    const oldBufferStartPosition = reversed ? event.oldHeadBufferPosition : event.oldTailBufferPosition;
    const oldBufferEndPosition = reversed ? event.oldTailBufferPosition : event.oldHeadBufferPosition;
    const newBufferStartPosition = reversed ? event.newHeadBufferPosition : event.newTailBufferPosition;
    const newBufferEndPosition = reversed ? event.newTailBufferPosition : event.newHeadBufferPosition;
    this.props.onDidChange(_objectSpread2({
      oldRange: new Range(oldBufferStartPosition, oldBufferEndPosition),
      newRange: new Range(newBufferStartPosition, newBufferEndPosition)
    }, event));
  }

}

_defineProperty(BareMarker, "propTypes", _objectSpread2({}, markerProps, {
  id: _propTypes.default.number,
  bufferRange: _propTypes2.RangePropType,
  markableHolder: _propTypes2.RefHolderPropType,
  children: _propTypes.default.node,
  onDidChange: _propTypes.default.func,
  handleID: _propTypes.default.func,
  handleMarker: _propTypes.default.func
}));

_defineProperty(BareMarker, "defaultProps", {
  onDidChange: () => {},
  handleID: () => {},
  handleMarker: () => {}
});

class Marker extends _react.default.Component {
  constructor(props) {
    super(props);
    this.state = {
      markableHolder: _refHolder.default.on(props.layer || props.editor)
    };
  }

  static getDerivedStateFromProps(props, state) {
    const markable = props.layer || props.editor;

    if (state.markableHolder.map(m => m === markable).getOr(markable === undefined)) {
      return {};
    }

    return {
      markableHolder: _refHolder.default.on(markable)
    };
  }

  render() {
    if (!this.state.markableHolder.isEmpty()) {
      return _react.default.createElement(BareMarker, _extends({}, this.props, {
        markableHolder: this.state.markableHolder
      }));
    }

    return _react.default.createElement(_markerLayer.MarkerLayerContext.Consumer, null, layerHolder => {
      if (layerHolder) {
        return _react.default.createElement(BareMarker, _extends({}, this.props, {
          markableHolder: layerHolder
        }));
      } else {
        return _react.default.createElement(_atomTextEditor.TextEditorContext.Consumer, null, editorHolder => _react.default.createElement(BareMarker, _extends({}, this.props, {
          markableHolder: editorHolder
        })));
      }
    });
  }

}

exports.default = Marker;

_defineProperty(Marker, "propTypes", {
  editor: MarkablePropType,
  layer: MarkablePropType
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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