"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Octicon;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/* eslint-disable max-len */
const SVG = {
  unlock: {
    viewBox: '0 0 24 16',
    element: _react.default.createElement("path", {
      fillRule: "evenodd",
      d: "m 13.4,13 h -1 v -1 h 1 z m 6,-7 h 1 c 0.55,0 1,0.45 1,1 v 7 c 0,0.55 -0.45,1 -1,1 h -10 c -0.55,0 -1,-0.45 -1,-1 V 7 c 0,-0.55 0.45,-1 1,-1 h 1 V 4.085901 C 11.4,2.1862908 9.8780193,2.4095693 8.904902,2.4143325 8.0404588,2.4185637 6.3689542,2.1882296 6.3689542,4.085901 V 7.4918301 L 4.2521568,7.4509801 4.2930068,4.045051 C 4.3176792,1.987953 5.080245,-0.02206145 8.792353,-0.03403364 13.536238,-0.0493335 13.21,3.1688541 13.21,4.085901 V 6 h -0.01 4.41 m 2.79,1 h -9 v 7 h 9 z m -7,1 h -1 v 1 h 1 z m 0,2 h -1 v 1 h 1 z"
    })
  }
};
/* eslint-enable max-len */

function Octicon(_ref) {
  let {
    icon
  } = _ref,
      others = _objectWithoutProperties(_ref, ["icon"]);

  const classes = (0, _classnames.default)('icon', `icon-${icon}`, others.className);
  const svgContent = SVG[icon];

  if (svgContent) {
    return _react.default.createElement("svg", _extends({}, others, {
      viewBox: svgContent.viewBox,
      xmlns: "http://www.w3.org/2000/svg",
      className: classes
    }), svgContent.element);
  }

  return _react.default.createElement("span", _extends({}, others, {
    className: classes
  }));
}

Octicon.propTypes = {
  icon: _propTypes.default.string.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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