"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * `Panel` renders a React component into an Atom panel. Specify the location via the `location` prop, and any
 * additional options to the `addXPanel` method in the `options` prop.
 *
 * You can get the underlying Atom panel via `getPanel()`, but you should consider controlling the panel via React and
 * the Panel component instead.
 */
class Panel extends _react.default.Component {
  constructor(props) {
    super(props);
    this.subscriptions = new _eventKit.CompositeDisposable();
    this.panel = null;
    this.didCloseItem = false;
    this.domNode = document.createElement('div');
    this.domNode.className = 'react-atom-panel';
  }

  componentDidMount() {
    this.setupPanel();
  }

  render() {
    return _reactDom.default.createPortal(this.props.children, this.domNode);
  }

  setupPanel() {
    if (this.panel) {
      return;
    } // "left" => "Left"


    const location = this.props.location.substr(0, 1).toUpperCase() + this.props.location.substr(1);
    const methodName = `add${location}Panel`;
    const item = (0, _helpers.createItem)(this.domNode, this.props.itemHolder);

    const options = _objectSpread2({}, this.props.options, {
      item
    });

    this.panel = this.props.workspace[methodName](options);
    this.subscriptions.add(this.panel.onDidDestroy(() => {
      this.didCloseItem = true;
      this.props.onDidClosePanel(this.panel);
    }));
  }

  componentWillUnmount() {
    this.subscriptions.dispose();

    if (this.panel) {
      this.panel.destroy();
    }
  }

  getPanel() {
    return this.panel;
  }

}

exports.default = Panel;

_defineProperty(Panel, "propTypes", {
  workspace: _propTypes.default.object.isRequired,
  location: _propTypes.default.oneOf(['top', 'bottom', 'left', 'right', 'header', 'footer', 'modal']).isRequired,
  children: _propTypes.default.element.isRequired,
  options: _propTypes.default.object,
  onDidClosePanel: _propTypes.default.func,
  itemHolder: _propTypes2.RefHolderPropType
});

_defineProperty(Panel, "defaultProps", {
  options: {},
  onDidClosePanel: panel => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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