"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class SimpleTooltip extends _react.default.Component {
  componentDidMount() {
    this.disposable = this.props.tooltips.add(_reactDom.default.findDOMNode(this.child), {
      title: () => this.props.title
    });
  }

  componentWillUnmount() {
    this.disposable.dispose();
  }

  componentDidUpdate(prevProps) {
    if (prevProps.title !== this.props.title) {
      this.disposable.dispose();
      this.disposable = this.props.tooltips.add(_reactDom.default.findDOMNode(this.child), {
        title: () => this.props.title
      });
    }
  }

  render() {
    const child = _react.default.Children.only(this.props.children);

    return _react.default.cloneElement(child, {
      ref: e => {
        this.child = e;
      }
    });
  }

}

exports.default = SimpleTooltip;

_defineProperty(SimpleTooltip, "propTypes", {
  tooltips: _propTypes.default.object.isRequired,
  children: _propTypes.default.node.isRequired,
  title: _propTypes.default.string.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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