"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class StatusBar extends _react.default.Component {
  constructor(props) {
    super(props);
    this.domNode = document.createElement('div');
    this.domNode.classList.add('react-atom-status-bar');

    if (props.className) {
      this.domNode.classList.add(props.className);
    }

    this.tile = null;
  }

  componentDidMount() {
    this.consumeStatusBar();
  }

  render() {
    return _reactDom.default.createPortal(this.props.children, this.domNode);
  }

  consumeStatusBar() {
    if (this.tile) {
      return;
    }

    if (!this.props.statusBar) {
      return;
    }

    this.tile = this.props.statusBar.addRightTile({
      item: this.domNode,
      priority: -50
    });
    this.props.onConsumeStatusBar(this.props.statusBar);
  }

  componentWillUnmount() {
    this.tile && this.tile.destroy();
  }

}

exports.default = StatusBar;

_defineProperty(StatusBar, "propTypes", {
  children: _propTypes.default.element.isRequired,
  statusBar: _propTypes.default.object,
  onConsumeStatusBar: _propTypes.default.func,
  className: _propTypes.default.string
});

_defineProperty(StatusBar, "defaultProps", {
  onConsumeStatusBar: statusBar => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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