"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const VERBATIM_OPTION_PROPS = ['title', 'html', 'placement', 'trigger', 'keyBindingCommand', 'keyBindingTarget'];
const OPTION_PROPS = [...VERBATIM_OPTION_PROPS, 'tooltips', 'className', 'showDelay', 'hideDelay'];

class Tooltip extends _react.default.Component {
  constructor(props, context) {
    super(props, context);
    this.refSub = new _eventKit.Disposable();
    this.tipSub = new _eventKit.Disposable();
    this.domNode = null;

    if (this.props.children !== undefined) {
      this.domNode = document.createElement('div');
      this.domNode.className = 'react-atom-tooltip';
    }

    this.lastTooltipProps = {};
  }

  componentDidMount() {
    this.setupTooltip();
  }

  render() {
    if (this.props.children !== undefined) {
      return _reactDom.default.createPortal(this.props.children, this.domNode);
    } else {
      return null;
    }
  }

  componentDidUpdate() {
    if (this.shouldRecreateTooltip()) {
      this.refSub.dispose();
      this.tipSub.dispose();
      this.setupTooltip();
    }
  }

  componentWillUnmount() {
    this.refSub.dispose();
    this.tipSub.dispose();
  }

  getTooltipProps() {
    const p = {};

    for (const key of OPTION_PROPS) {
      p[key] = this.props[key];
    }

    return p;
  }

  shouldRecreateTooltip() {
    return OPTION_PROPS.some(key => this.lastTooltipProps[key] !== this.props[key]);
  }

  setupTooltip() {
    this.lastTooltipProps = this.getTooltipProps();
    const options = {};
    VERBATIM_OPTION_PROPS.forEach(key => {
      if (this.props[key] !== undefined) {
        options[key] = this.props[key];
      }
    });

    if (this.props.className !== undefined) {
      options.class = this.props.className;
    }

    if (this.props.showDelay !== undefined || this.props.hideDelay !== undefined) {
      const delayDefaults = (this.props.trigger === 'hover' || this.props.trigger === undefined) && {
        show: 1000,
        hide: 100
      } || {
        show: 0,
        hide: 0
      };
      options.delay = {
        show: this.props.showDelay !== undefined ? this.props.showDelay : delayDefaults.show,
        hide: this.props.hideDelay !== undefined ? this.props.hideDelay : delayDefaults.hide
      };
    }

    if (this.props.children !== undefined) {
      options.item = (0, _helpers.createItem)(this.domNode, this.props.itemHolder);
    }

    this.refSub = this.props.target.observe(t => {
      this.tipSub.dispose();
      this.tipSub = this.props.manager.add(t, options);
      const h = this.props.tooltipHolder;

      if (h) {
        h.setter(this.tipSub);
      }
    });
  }

}

exports.default = Tooltip;

_defineProperty(Tooltip, "propTypes", {
  manager: _propTypes.default.object.isRequired,
  target: _propTypes2.RefHolderPropType.isRequired,
  title: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.func]),
  html: _propTypes.default.bool,
  className: _propTypes.default.string,
  placement: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.func]),
  trigger: _propTypes.default.oneOf(['hover', 'click', 'focus', 'manual']),
  showDelay: _propTypes.default.number,
  hideDelay: _propTypes.default.number,
  keyBindingCommand: _propTypes.default.string,
  keyBindingTarget: _propTypes.default.element,
  children: _propTypes.default.element,
  itemHolder: _propTypes2.RefHolderPropType,
  tooltipHolder: _propTypes2.RefHolderPropType
});

_defineProperty(Tooltip, "defaultProps", {
  getItemComponent: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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