"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _os = _interopRequireDefault(require("os"));

var _helpers = require("./helpers");

var _asyncQueue = _interopRequireDefault(require("./async-queue"));

var _gitShellOutStrategy = _interopRequireDefault(require("./git-shell-out-strategy"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var _default = {
  create(workingDir, options = {}) {
    return this.withStrategies([_gitShellOutStrategy.default])(workingDir, options);
  },

  withStrategies(strategies) {
    return function createForStrategies(workingDir, options = {}) {
      const parallelism = options.parallelism || Math.max(3, _os.default.cpus().length);
      const commandQueue = new _asyncQueue.default({
        parallelism
      });

      const strategyOptions = _objectSpread2({}, options, {
        queue: commandQueue
      });

      const strategyInstances = strategies.map(Strategy => new Strategy(workingDir, strategyOptions));
      return (0, _helpers.firstImplementer)(...strategyInstances);
    };
  }

};
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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