"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Accumulator extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "attemptToLoadMore", () => {
      this.loadMoreSub.dispose();
      this.nextUpdateID = null;
      /* istanbul ignore if */

      if (!this.props.relay.hasMore() || this.props.relay.isLoading()) {
        return;
      }

      this.loadMoreSub = this.props.relay.loadMore(this.props.pageSize, this.accumulate);
    });

    _defineProperty(this, "accumulate", error => {
      if (error) {
        this.setState({
          error
        });
      } else {
        if (this.props.waitTimeMs > 0 && this.nextUpdateID === null) {
          this.nextUpdateID = setTimeout(this.attemptToLoadMore, this.props.waitTimeMs);
          this.nextUpdateSub = new _eventKit.Disposable(() => {
            clearTimeout(this.nextUpdateID);
            this.nextUpdateID = null;
          });
        } else {
          this.attemptToLoadMore();
        }
      }
    });

    this.refetchSub = new _eventKit.Disposable();
    this.loadMoreSub = new _eventKit.Disposable();
    this.nextUpdateSub = new _eventKit.Disposable();
    this.nextUpdateID = null;
    this.state = {
      error: null
    };
  }

  componentDidMount() {
    this.refetchSub = this.props.onDidRefetch(this.attemptToLoadMore);
    this.attemptToLoadMore();
  }

  componentWillUnmount() {
    this.refetchSub.dispose();
    this.loadMoreSub.dispose();
    this.nextUpdateSub.dispose();
  }

  render() {
    return this.props.children(this.state.error, this.props.resultBatch, this.props.relay.hasMore());
  }

}

exports.default = Accumulator;

_defineProperty(Accumulator, "propTypes", {
  // Relay props
  relay: _propTypes.default.shape({
    hasMore: _propTypes.default.func.isRequired,
    loadMore: _propTypes.default.func.isRequired,
    isLoading: _propTypes.default.func.isRequired
  }).isRequired,
  resultBatch: _propTypes.default.arrayOf(_propTypes.default.any).isRequired,
  // Control props
  pageSize: _propTypes.default.number.isRequired,
  waitTimeMs: _propTypes.default.number.isRequired,
  // Render prop. Called with (error, full result list, loading) each time more results arrive. Return value is
  // rendered as a child element.
  children: _propTypes.default.func,
  // Called right after refetch happens
  onDidRefetch: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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