"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareAggregatedReviewsContainer = void 0;

var _react = _interopRequireDefault(require("react"));

var _eventKit = require("event-kit");

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _helpers = require("../helpers");

var _reviewSummariesAccumulator = _interopRequireDefault(require("./accumulators/review-summaries-accumulator"));

var _reviewThreadsAccumulator = _interopRequireDefault(require("./accumulators/review-threads-accumulator"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareAggregatedReviewsContainer extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "refetch", callback => this.props.relay.refetch({
      prId: this.props.pullRequest.id,
      reviewCount: _helpers.PAGE_SIZE,
      reviewCursor: null,
      threadCount: _helpers.PAGE_SIZE,
      threadCursor: null,
      commentCount: _helpers.PAGE_SIZE,
      commentCursor: null
    }, null, err => {
      if (err) {
        this.props.reportRelayError('Unable to refresh reviews', err);
      } else {
        this.emitter.emit('did-refetch');
      }

      callback();
    }, {
      force: true
    }));

    _defineProperty(this, "onDidRefetch", callback => this.emitter.on('did-refetch', callback));

    this.emitter = new _eventKit.Emitter();
  }

  render() {
    return _react.default.createElement(_reviewSummariesAccumulator.default, {
      onDidRefetch: this.onDidRefetch,
      pullRequest: this.props.pullRequest
    }, ({
      error: summaryError,
      summaries,
      loading: summariesLoading
    }) => {
      return _react.default.createElement(_reviewThreadsAccumulator.default, {
        onDidRefetch: this.onDidRefetch,
        pullRequest: this.props.pullRequest
      }, payload => {
        const result = {
          errors: [],
          refetch: this.refetch,
          summaries,
          commentThreads: payload.commentThreads,
          loading: payload.loading || summariesLoading
        };

        if (summaryError) {
          result.errors.push(summaryError);
        }

        result.errors.push(...payload.errors);
        return this.props.children(result);
      });
    });
  }

}

exports.BareAggregatedReviewsContainer = BareAggregatedReviewsContainer;

_defineProperty(BareAggregatedReviewsContainer, "propTypes", {
  // Relay response
  relay: _propTypes.default.shape({
    refetch: _propTypes.default.func.isRequired
  }),
  // Relay results.
  pullRequest: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired
  }).isRequired,
  // Render prop. Called with {errors, summaries, commentThreads, loading}.
  children: _propTypes.default.func.isRequired,
  // only fetch summaries when we specify a summariesRenderer
  summariesRenderer: _propTypes.default.func,
  // Report errors during refetch
  reportRelayError: _propTypes.default.func.isRequired
});

var _default = (0, _reactRelay.createRefetchContainer)(BareAggregatedReviewsContainer, {
  pullRequest: function () {
    const node = require("./__generated__/aggregatedReviewsContainer_pullRequest.graphql");

    if (node.hash && node.hash !== "830225d5b83d6c320e16cf824fe0cca6") {
      console.error("The definition of 'aggregatedReviewsContainer_pullRequest' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/aggregatedReviewsContainer_pullRequest.graphql");
  }
}, function () {
  const node = require("./__generated__/aggregatedReviewsContainerRefetchQuery.graphql");

  if (node.hash && node.hash !== "2bf1bb4fa69d264bcecbe81f41621908") {
    console.error("The definition of 'aggregatedReviewsContainerRefetchQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/aggregatedReviewsContainerRefetchQuery.graphql");
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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