"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _changedFileController = _interopRequireDefault(require("../controllers/changed-file-controller"));

var _patchBuffer = _interopRequireDefault(require("../models/patch/patch-buffer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ChangedFileContainer extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "onWillUpdatePatch", cb => this.emitter.on('will-update-patch', cb));

    _defineProperty(this, "onDidUpdatePatch", cb => this.emitter.on('did-update-patch', cb));

    (0, _helpers.autobind)(this, 'fetchData', 'renderWithData');
    this.emitter = new _eventKit.Emitter();
    this.patchBuffer = new _patchBuffer.default();
    this.lastMultiFilePatch = null;
    this.sub = new _eventKit.CompositeDisposable();
    this.state = {
      renderStatusOverride: null
    };
  }

  fetchData(repository) {
    const staged = this.props.stagingStatus === 'staged';
    const builderOpts = {};

    if (this.state.renderStatusOverride !== null) {
      builderOpts.renderStatusOverrides = {
        [this.props.relPath]: this.state.renderStatusOverride
      };
    }

    if (this.props.largeDiffThreshold !== undefined) {
      builderOpts.largeDiffThreshold = this.props.largeDiffThreshold;
    }

    const before = () => this.emitter.emit('will-update-patch');

    const after = patch => this.emitter.emit('did-update-patch', patch);

    return (0, _yubikiri.default)({
      multiFilePatch: repository.getFilePatchForPath(this.props.relPath, {
        staged,
        patchBuffer: this.patchBuffer,
        builder: builderOpts,
        before,
        after
      }),
      isPartiallyStaged: repository.isPartiallyStaged(this.props.relPath),
      hasUndoHistory: repository.hasDiscardHistory(this.props.relPath)
    });
  }

  render() {
    return _react.default.createElement(_observeModel.default, {
      model: this.props.repository,
      fetchData: this.fetchData
    }, this.renderWithData);
  }

  renderWithData(data) {
    const currentMultiFilePatch = data && data.multiFilePatch;

    if (currentMultiFilePatch !== this.lastMultiFilePatch) {
      this.sub.dispose();
      /* istanbul ignore else */

      if (currentMultiFilePatch) {
        // Keep this component's renderStatusOverride synchronized with the FilePatch we're rendering
        this.sub = new _eventKit.CompositeDisposable(...currentMultiFilePatch.getFilePatches().map(fp => fp.onDidChangeRenderStatus(() => {
          this.setState({
            renderStatusOverride: fp.getRenderStatus()
          });
        })));
      }

      this.lastMultiFilePatch = currentMultiFilePatch;
    }

    if (this.props.repository.isLoading() || data === null) {
      return _react.default.createElement(_loadingView.default, null);
    }

    return _react.default.createElement(_changedFileController.default, _extends({
      onWillUpdatePatch: this.onWillUpdatePatch,
      onDidUpdatePatch: this.onDidUpdatePatch
    }, data, this.props));
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

}

exports.default = ChangedFileContainer;

_defineProperty(ChangedFileContainer, "propTypes", {
  repository: _propTypes.default.object.isRequired,
  stagingStatus: _propTypes.default.oneOf(['staged', 'unstaged']),
  relPath: _propTypes.default.string.isRequired,
  largeDiffThreshold: _propTypes.default.number,
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  keymaps: _propTypes.default.object.isRequired,
  tooltips: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired,
  destroy: _propTypes.default.func.isRequired,
  undoLastDiscard: _propTypes.default.func.isRequired,
  surfaceFileAtPath: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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