"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _eventKit = require("event-kit");

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _commitDetailController = _interopRequireDefault(require("../controllers/commit-detail-controller"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CommitDetailContainer extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "fetchData", repository => {
      return (0, _yubikiri.default)({
        commit: repository.getCommit(this.props.sha),
        currentBranch: repository.getCurrentBranch(),
        currentRemote: async query => repository.getRemoteForBranch((await query.currentBranch).getName()),
        isCommitPushed: repository.isCommitPushed(this.props.sha)
      });
    });

    _defineProperty(this, "renderResult", data => {
      const currentCommit = data && data.commit;

      if (currentCommit !== this.lastCommit) {
        this.sub.dispose();

        if (currentCommit && currentCommit.isPresent()) {
          this.sub = new _eventKit.CompositeDisposable(...currentCommit.getMultiFileDiff().getFilePatches().map(fp => fp.onDidChangeRenderStatus(() => {
            this.forceUpdate();
          })));
        }

        this.lastCommit = currentCommit;
      }

      if (this.props.repository.isLoading() || data === null || !data.commit.isPresent()) {
        return _react.default.createElement(_loadingView.default, null);
      }

      return _react.default.createElement(_commitDetailController.default, _extends({}, data, this.props));
    });

    this.lastCommit = null;
    this.sub = new _eventKit.CompositeDisposable();
  }

  render() {
    return _react.default.createElement(_observeModel.default, {
      model: this.props.repository,
      fetchData: this.fetchData
    }, this.renderResult);
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

}

exports.default = CommitDetailContainer;

_defineProperty(CommitDetailContainer, "propTypes", {
  repository: _propTypes.default.object.isRequired,
  sha: _propTypes.default.string.isRequired,
  itemType: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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