"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _eventKit = require("event-kit");

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _commitPreviewController = _interopRequireDefault(require("../controllers/commit-preview-controller"));

var _patchBuffer = _interopRequireDefault(require("../models/patch/patch-buffer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CommitPreviewContainer extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "fetchData", repository => {
      const builderOpts = {
        renderStatusOverrides: this.state.renderStatusOverrides
      };

      if (this.props.largeDiffThreshold !== undefined) {
        builderOpts.largeDiffThreshold = this.props.largeDiffThreshold;
      }

      const before = () => this.emitter.emit('will-update-patch');

      const after = patch => this.emitter.emit('did-update-patch', patch);

      return (0, _yubikiri.default)({
        multiFilePatch: repository.getStagedChangesPatch({
          patchBuffer: this.patchBuffer,
          builder: builderOpts,
          before,
          after
        })
      });
    });

    _defineProperty(this, "renderResult", data => {
      const currentMultiFilePatch = data && data.multiFilePatch;

      if (currentMultiFilePatch !== this.lastMultiFilePatch) {
        this.sub.dispose();

        if (currentMultiFilePatch) {
          this.sub = new _eventKit.CompositeDisposable(...currentMultiFilePatch.getFilePatches().map(fp => fp.onDidChangeRenderStatus(() => {
            this.setState(prevState => {
              return {
                renderStatusOverrides: _objectSpread2({}, prevState.renderStatusOverrides, {
                  [fp.getPath()]: fp.getRenderStatus()
                })
              };
            });
          })));
        }

        this.lastMultiFilePatch = currentMultiFilePatch;
      }

      if (this.props.repository.isLoading() || data === null) {
        return _react.default.createElement(_loadingView.default, null);
      }

      return _react.default.createElement(_commitPreviewController.default, _extends({
        stagingStatus: 'staged',
        onWillUpdatePatch: this.onWillUpdatePatch,
        onDidUpdatePatch: this.onDidUpdatePatch
      }, data, this.props));
    });

    _defineProperty(this, "onWillUpdatePatch", cb => this.emitter.on('will-update-patch', cb));

    _defineProperty(this, "onDidUpdatePatch", cb => this.emitter.on('did-update-patch', cb));

    this.emitter = new _eventKit.Emitter();
    this.patchBuffer = new _patchBuffer.default();
    this.lastMultiFilePatch = null;
    this.sub = new _eventKit.CompositeDisposable();
    this.state = {
      renderStatusOverrides: {}
    };
  }

  render() {
    return _react.default.createElement(_observeModel.default, {
      model: this.props.repository,
      fetchData: this.fetchData
    }, this.renderResult);
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

}

exports.default = CommitPreviewContainer;

_defineProperty(CommitPreviewContainer, "propTypes", {
  repository: _propTypes.default.object.isRequired,
  largeDiffThreshold: _propTypes.default.number
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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