"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _createDialogController = _interopRequireDefault(require("../controllers/create-dialog-controller"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _repositoryHomeSelectionView = require("../views/repository-home-selection-view");

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _endpoint = require("../models/endpoint");

var _propTypes2 = require("../prop-types");

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const DOTCOM = (0, _endpoint.getEndpoint)('github.com');

class CreateDialogContainer extends _react.default.Component {
  constructor(_props) {
    super(_props);

    _defineProperty(this, "renderWithToken", token => {
      if (!token) {
        return null;
      }

      const environment = _relayNetworkLayerManager.default.getEnvironmentForHost(DOTCOM, token);

      const query = _graphql || (_graphql = function () {
        const node = require("./__generated__/createDialogContainerQuery.graphql");

        if (node.hash && node.hash !== "862b8ec3127c9a52e9a54020afa47792") {
          console.error("The definition of 'createDialogContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
        }

        return require("./__generated__/createDialogContainerQuery.graphql");
      });

      const variables = {
        organizationCount: _repositoryHomeSelectionView.PAGE_SIZE,
        organizationCursor: null,
        // Force QueryRenderer to re-render when dialog request state changes
        error: this.props.error,
        inProgress: this.props.inProgress
      };
      return _react.default.createElement(_reactRelay.QueryRenderer, {
        environment: environment,
        query: query,
        variables: variables,
        render: this.renderWithResult
      });
    });

    _defineProperty(this, "renderWithResult", ({
      error,
      props
    }) => {
      if (error) {
        return this.renderError(error);
      }

      if (!props && !this.lastProps) {
        return this.renderLoading();
      }

      const currentProps = props || this.lastProps;
      return _react.default.createElement(_createDialogController.default, _extends({
        user: currentProps.viewer,
        isLoading: false
      }, this.props));
    });

    _defineProperty(this, "fetchToken", loginModel => loginModel.getToken(DOTCOM.getLoginAccount()));

    this.lastProps = null;
  }

  render() {
    return _react.default.createElement(_observeModel.default, {
      model: this.props.loginModel,
      fetchData: this.fetchToken
    }, this.renderWithToken);
  }

  renderError(error) {
    return _react.default.createElement(_createDialogController.default, _extends({
      user: null,
      error: error,
      isLoading: false
    }, this.props));
  }

  renderLoading() {
    return _react.default.createElement(_createDialogController.default, _extends({
      user: null,
      isLoading: true
    }, this.props));
  }

}

exports.default = CreateDialogContainer;

_defineProperty(CreateDialogContainer, "propTypes", {
  // Model
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  request: _propTypes.default.object.isRequired,
  error: _propTypes.default.instanceOf(Error),
  inProgress: _propTypes.default.bool.isRequired,
  // Atom environment
  currentWindow: _propTypes.default.object.isRequired,
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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