"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _issueishListController = _interopRequireWildcard(require("../controllers/issueish-list-controller"));

var _createPullRequestTile = _interopRequireDefault(require("../views/create-pull-request-tile"));

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _graphql;

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CurrentPullRequestContainer extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderQueryResult', 'renderEmptyTile');
    this.sub = new _eventKit.Disposable();
  }

  render() {
    const environment = _relayNetworkLayerManager.default.getEnvironmentForHost(this.props.endpoint, this.props.token);

    const head = this.props.branches.getHeadBranch();

    if (!head.isPresent()) {
      return this.renderEmptyResult();
    }

    const push = head.getPush();

    if (!push.isPresent() || !push.isRemoteTracking()) {
      return this.renderEmptyResult();
    }

    const pushRemote = this.props.remotes.withName(push.getRemoteName());

    if (!pushRemote.isPresent() || !pushRemote.isGithubRepo()) {
      return this.renderEmptyResult();
    }

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/currentPullRequestContainerQuery.graphql");

      if (node.hash && node.hash !== "b571ac1d752d4d13bc8e9bdffedb0a5e") {
        console.error("The definition of 'currentPullRequestContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/currentPullRequestContainerQuery.graphql");
    });

    const variables = {
      headOwner: pushRemote.getOwner(),
      headName: pushRemote.getRepo(),
      headRef: push.getRemoteRef(),
      first: this.props.limit,
      checkSuiteCount: _helpers.CHECK_SUITE_PAGE_SIZE,
      checkSuiteCursor: null,
      checkRunCount: _helpers.CHECK_RUN_PAGE_SIZE,
      checkRunCursor: null
    };
    return _react.default.createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: this.renderQueryResult
    });
  }

  renderEmptyResult() {
    return _react.default.createElement(_issueishListController.BareIssueishListController, _extends({
      isLoading: false
    }, this.controllerProps()));
  }

  renderQueryResult({
    error,
    props
  }) {
    if (error) {
      return _react.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false,
        error: error
      }, this.controllerProps()));
    }

    if (props === null) {
      return _react.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: true
      }, this.controllerProps()));
    }

    if (!props.repository || !props.repository.ref) {
      return _react.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false
      }, this.controllerProps()));
    }

    const associatedPullRequests = props.repository.ref.associatedPullRequests;
    return _react.default.createElement(_issueishListController.default, _extends({
      total: associatedPullRequests.totalCount,
      results: associatedPullRequests.nodes,
      isLoading: false,
      endpoint: this.props.endpoint,
      resultFilter: issueish => issueish.getHeadRepositoryID() === this.props.repository.id
    }, this.controllerProps()));
  }

  renderEmptyTile() {
    return _react.default.createElement(_createPullRequestTile.default, {
      repository: this.props.repository,
      remote: this.props.remote,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      onCreatePr: this.props.onCreatePr
    });
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

  controllerProps() {
    return {
      title: 'Checked out pull request',
      onOpenIssueish: this.props.onOpenIssueish,
      onOpenReviews: this.props.onOpenReviews,
      emptyComponent: this.renderEmptyTile,
      needReviewsButton: true
    };
  }

}

exports.default = CurrentPullRequestContainer;

_defineProperty(CurrentPullRequestContainer, "propTypes", {
  // Relay payload
  repository: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    defaultBranchRef: _propTypes.default.shape({
      prefix: _propTypes.default.string.isRequired,
      name: _propTypes.default.string.isRequired
    })
  }).isRequired,
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes.default.string.isRequired,
  // Search constraints
  limit: _propTypes.default.number,
  // Repository model attributes
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes.default.number,
  pushInProgress: _propTypes.default.bool.isRequired,
  // Actions
  onOpenIssueish: _propTypes.default.func.isRequired,
  onOpenReviews: _propTypes.default.func.isRequired,
  onCreatePr: _propTypes.default.func.isRequired
});

_defineProperty(CurrentPullRequestContainer, "defaultProps", {
  limit: 5
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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