"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _commit = require("../models/commit");

var _branch = require("../models/branch");

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _gitTabController = _interopRequireDefault(require("../controllers/git-tab-controller"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const DEFAULT_REPO_DATA = {
  repository: null,
  username: '',
  email: '',
  lastCommit: _commit.nullCommit,
  recentCommits: [],
  isMerging: false,
  isRebasing: false,
  hasUndoHistory: false,
  currentBranch: _branch.nullBranch,
  unstagedChanges: [],
  stagedChanges: [],
  mergeConflicts: [],
  workingDirectoryPath: null,
  mergeMessage: null,
  fetchInProgress: true
};

class GitTabContainer extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "fetchData", repository => {
      return (0, _yubikiri.default)({
        repository,
        username: repository.getConfig('user.name').then(n => n || ''),
        email: repository.getConfig('user.email').then(n => n || ''),
        lastCommit: repository.getLastCommit(),
        recentCommits: repository.getRecentCommits({
          max: 10
        }),
        isMerging: repository.isMerging(),
        isRebasing: repository.isRebasing(),
        hasUndoHistory: repository.hasDiscardHistory(),
        currentBranch: repository.getCurrentBranch(),
        unstagedChanges: repository.getUnstagedChanges(),
        stagedChanges: repository.getStagedChanges(),
        mergeConflicts: repository.getMergeConflicts(),
        workingDirectoryPath: repository.getWorkingDirectoryPath(),
        mergeMessage: async query => {
          const isMerging = await query.isMerging;
          return isMerging ? repository.getMergeMessage() : null;
        },
        fetchInProgress: false
      });
    });
  }

  render() {
    return _react.default.createElement(_observeModel.default, {
      model: this.props.repository,
      fetchData: this.fetchData
    }, data => {
      const dataProps = data || DEFAULT_REPO_DATA;
      return _react.default.createElement(_gitTabController.default, _extends({}, dataProps, this.props, {
        repositoryDrift: this.props.repository !== dataProps.repository
      }));
    });
  }

}

exports.default = GitTabContainer;

_defineProperty(GitTabContainer, "propTypes", {
  repository: _propTypes.default.object.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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