"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _operationStateObserver = _interopRequireWildcard(require("../models/operation-state-observer"));

var _refresher = _interopRequireDefault(require("../models/refresher"));

var _githubTabController = _interopRequireDefault(require("../controllers/github-tab-controller"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _remoteSet = _interopRequireDefault(require("../models/remote-set"));

var _remote = require("../models/remote");

var _branchSet = _interopRequireDefault(require("../models/branch-set"));

var _branch = require("../models/branch");

var _endpoint = require("../models/endpoint");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitHubTabContainer extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "fetchRepositoryData", repository => {
      return (0, _yubikiri.default)({
        workingDirectory: repository.getWorkingDirectoryPath(),
        allRemotes: repository.getRemotes(),
        branches: repository.getBranches(),
        selectedRemoteName: repository.getConfig('atomGithub.currentRemote'),
        aheadCount: async query => {
          const branches = await query.branches;
          const currentBranch = branches.getHeadBranch();
          return repository.getAheadCount(currentBranch.getName());
        },
        pushInProgress: repository.getOperationStates().isPushInProgress()
      });
    });

    _defineProperty(this, "fetchToken", (loginModel, endpoint) => loginModel.getToken(endpoint.getLoginAccount()));

    _defineProperty(this, "renderRepositoryData", repoData => {
      let endpoint = _endpoint.DOTCOM;

      if (repoData) {
        repoData.githubRemotes = repoData.allRemotes.filter(remote => remote.isGithubRepo());
        repoData.currentBranch = repoData.branches.getHeadBranch();
        repoData.currentRemote = repoData.githubRemotes.withName(repoData.selectedRemoteName);
        repoData.manyRemotesAvailable = false;

        if (!repoData.currentRemote.isPresent() && repoData.githubRemotes.size() === 1) {
          repoData.currentRemote = Array.from(repoData.githubRemotes)[0];
        } else if (!repoData.currentRemote.isPresent() && repoData.githubRemotes.size() > 1) {
          repoData.manyRemotesAvailable = true;
        }

        repoData.endpoint = endpoint = repoData.currentRemote.getEndpointOrDotcom();
      }

      return _react.default.createElement(_observeModel.default, {
        model: this.props.loginModel,
        fetchData: this.fetchToken,
        fetchParams: [endpoint]
      }, token => this.renderToken(token, repoData));
    });

    this.state = {
      lastRepository: null,
      remoteOperationObserver: new _eventKit.Disposable(),
      refresher: new _refresher.default(),
      observerSub: new _eventKit.Disposable()
    };
  }

  static getDerivedStateFromProps(props, state) {
    if (props.repository !== state.lastRepository) {
      state.remoteOperationObserver.dispose();
      state.observerSub.dispose();
      const remoteOperationObserver = new _operationStateObserver.default(props.repository, _operationStateObserver.PUSH, _operationStateObserver.PULL, _operationStateObserver.FETCH);
      const observerSub = remoteOperationObserver.onDidComplete(() => state.refresher.trigger());
      return {
        lastRepository: props.repository,
        remoteOperationObserver,
        observerSub
      };
    }

    return null;
  }

  componentWillUnmount() {
    this.state.observerSub.dispose();
    this.state.remoteOperationObserver.dispose();
    this.state.refresher.dispose();
  }

  render() {
    return _react.default.createElement(_observeModel.default, {
      model: this.props.repository,
      fetchData: this.fetchRepositoryData
    }, this.renderRepositoryData);
  }

  renderToken(token, repoData) {
    if (!repoData || this.props.repository.isLoading()) {
      return _react.default.createElement(_githubTabController.default, _extends({}, this.props, {
        refresher: this.state.refresher,
        allRemotes: new _remoteSet.default(),
        githubRemotes: new _remoteSet.default(),
        currentRemote: _remote.nullRemote,
        branches: new _branchSet.default(),
        currentBranch: _branch.nullBranch,
        aheadCount: 0,
        manyRemotesAvailable: false,
        pushInProgress: false,
        isLoading: true,
        token: token
      }));
    }

    if (!this.props.repository.isPresent()) {
      return _react.default.createElement(_githubTabController.default, _extends({}, this.props, {
        refresher: this.state.refresher,
        allRemotes: new _remoteSet.default(),
        githubRemotes: new _remoteSet.default(),
        currentRemote: _remote.nullRemote,
        branches: new _branchSet.default(),
        currentBranch: _branch.nullBranch,
        aheadCount: 0,
        manyRemotesAvailable: false,
        pushInProgress: false,
        isLoading: false,
        token: token
      }));
    }

    return _react.default.createElement(_githubTabController.default, _extends({}, repoData, this.props, {
      refresher: this.state.refresher,
      isLoading: false,
      token: token
    }));
  }

}

exports.default = GitHubTabContainer;

_defineProperty(GitHubTabContainer, "propTypes", {
  workspace: _propTypes.default.object.isRequired,
  repository: _propTypes.default.object,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  rootHolder: _propTypes2.RefHolderPropType.isRequired,
  changeWorkingDirectory: _propTypes.default.func.isRequired,
  onDidChangeWorkDirs: _propTypes.default.func.isRequired,
  getCurrentWorkDirs: _propTypes.default.func.isRequired,
  openCreateDialog: _propTypes.default.func.isRequired,
  openPublishDialog: _propTypes.default.func.isRequired,
  openCloneDialog: _propTypes.default.func.isRequired,
  openGitTab: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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