"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _propTypes2 = require("../prop-types");

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _keytarStrategy = require("../shared/keytar-strategy");

var _author = _interopRequireWildcard(require("../models/author"));

var _githubTabHeaderController = _interopRequireDefault(require("../controllers/github-tab-header-controller"));

var _graphql;

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GithubTabHeaderContainer extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderWithResult", ({
      error,
      props
    }) => {
      if (error || props === null) {
        return this.renderNoResult();
      } // eslint-disable-next-line react/prop-types


      const {
        email,
        name,
        avatarUrl,
        login
      } = props.viewer;
      return _react.default.createElement(_githubTabHeaderController.default, {
        user: new _author.default(email, name, login, false, avatarUrl) // Workspace
        ,
        currentWorkDir: this.props.currentWorkDir,
        contextLocked: this.props.contextLocked,
        getCurrentWorkDirs: this.props.getCurrentWorkDirs,
        changeWorkingDirectory: this.props.changeWorkingDirectory,
        setContextLock: this.props.setContextLock // Event Handlers
        ,
        onDidChangeWorkDirs: this.props.onDidChangeWorkDirs
      });
    });
  }

  render() {
    if (this.props.token == null || this.props.token instanceof Error || this.props.token === _keytarStrategy.UNAUTHENTICATED || this.props.token === _keytarStrategy.INSUFFICIENT) {
      return this.renderNoResult();
    }

    const environment = _relayNetworkLayerManager.default.getEnvironmentForHost(this.props.endpoint, this.props.token);

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/githubTabHeaderContainerQuery.graphql");

      if (node.hash && node.hash !== "003bcc6b15469f788437eba2b4ce780b") {
        console.error("The definition of 'githubTabHeaderContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/githubTabHeaderContainerQuery.graphql");
    });

    return _react.default.createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: {},
      query: query,
      render: this.renderWithResult
    });
  }

  renderNoResult() {
    return _react.default.createElement(_githubTabHeaderController.default, {
      user: _author.nullAuthor // Workspace
      ,
      currentWorkDir: this.props.currentWorkDir,
      contextLocked: this.props.contextLocked,
      changeWorkingDirectory: this.props.changeWorkingDirectory,
      setContextLock: this.props.setContextLock,
      getCurrentWorkDirs: this.props.getCurrentWorkDirs // Event Handlers
      ,
      onDidChangeWorkDirs: this.props.onDidChangeWorkDirs
    });
  }

}

exports.default = GithubTabHeaderContainer;

_defineProperty(GithubTabHeaderContainer, "propTypes", {
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes2.TokenPropType,
  // Workspace
  currentWorkDir: _propTypes.default.string,
  contextLocked: _propTypes.default.bool.isRequired,
  changeWorkingDirectory: _propTypes.default.func.isRequired,
  setContextLock: _propTypes.default.func.isRequired,
  getCurrentWorkDirs: _propTypes.default.func.isRequired,
  // Event Handlers
  onDidChangeWorkDirs: _propTypes.default.func
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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