"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _reactRelay = require("react-relay");

var _helpers = require("../helpers");

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _propTypes2 = require("../prop-types");

var _keytarStrategy = require("../shared/keytar-strategy");

var _githubLoginView = _interopRequireDefault(require("../views/github-login-view"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _queryErrorView = _interopRequireDefault(require("../views/query-error-view"));

var _errorView = _interopRequireDefault(require("../views/error-view"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _relayEnvironment = _interopRequireDefault(require("../views/relay-environment"));

var _aggregatedReviewsContainer = _interopRequireDefault(require("./aggregated-reviews-container"));

var _issueishDetailController = _interopRequireDefault(require("../controllers/issueish-detail-controller"));

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishDetailContainer extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderWithToken", tokenData => {
      const token = tokenData && tokenData.token;

      if (token instanceof Error) {
        return _react.default.createElement(_queryErrorView.default, {
          error: token,
          login: this.handleLogin,
          retry: this.handleTokenRetry,
          logout: this.handleLogout
        });
      }

      if (token === _keytarStrategy.UNAUTHENTICATED) {
        return _react.default.createElement(_githubLoginView.default, {
          onLogin: this.handleLogin
        });
      }

      if (token === _keytarStrategy.INSUFFICIENT) {
        return _react.default.createElement(_githubLoginView.default, {
          onLogin: this.handleLogin
        }, _react.default.createElement("p", null, "Your token no longer has sufficient authorizations. Please re-authenticate and generate a new one."));
      }

      return _react.default.createElement(_observeModel.default, {
        model: this.props.repository,
        fetchData: this.fetchRepositoryData
      }, repoData => this.renderWithRepositoryData(token, repoData));
    });

    _defineProperty(this, "fetchToken", loginModel => {
      return (0, _yubikiri.default)({
        token: loginModel.getToken(this.props.endpoint.getLoginAccount())
      });
    });

    _defineProperty(this, "fetchRepositoryData", repository => {
      return (0, _yubikiri.default)({
        branches: repository.getBranches(),
        remotes: repository.getRemotes(),
        isMerging: repository.isMerging(),
        isRebasing: repository.isRebasing(),
        isAbsent: repository.isAbsent(),
        isLoading: repository.isLoading(),
        isPresent: repository.isPresent()
      });
    });

    _defineProperty(this, "handleLogin", token => this.props.loginModel.setToken(this.props.endpoint.getLoginAccount(), token));

    _defineProperty(this, "handleLogout", () => this.props.loginModel.removeToken(this.props.endpoint.getLoginAccount()));

    _defineProperty(this, "handleTokenRetry", () => this.props.loginModel.didUpdate());
  }

  render() {
    return _react.default.createElement(_observeModel.default, {
      model: this.props.loginModel,
      fetchData: this.fetchToken
    }, this.renderWithToken);
  }

  renderWithRepositoryData(token, repoData) {
    if (!token) {
      return _react.default.createElement(_loadingView.default, null);
    }

    const environment = _relayNetworkLayerManager.default.getEnvironmentForHost(this.props.endpoint, token);

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/issueishDetailContainerQuery.graphql");

      if (node.hash && node.hash !== "c65534cd8bf43f640862f89187b6ff64") {
        console.error("The definition of 'issueishDetailContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/issueishDetailContainerQuery.graphql");
    });

    const variables = {
      repoOwner: this.props.owner,
      repoName: this.props.repo,
      issueishNumber: this.props.issueishNumber,
      timelineCount: _helpers.PAGE_SIZE,
      timelineCursor: null,
      commitCount: _helpers.PAGE_SIZE,
      commitCursor: null,
      reviewCount: _helpers.PAGE_SIZE,
      reviewCursor: null,
      threadCount: _helpers.PAGE_SIZE,
      threadCursor: null,
      commentCount: _helpers.PAGE_SIZE,
      commentCursor: null,
      checkSuiteCount: _helpers.CHECK_SUITE_PAGE_SIZE,
      checkSuiteCursor: null,
      checkRunCount: _helpers.CHECK_RUN_PAGE_SIZE,
      checkRunCursor: null
    };
    return _react.default.createElement(_relayEnvironment.default.Provider, {
      value: environment
    }, _react.default.createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      query: query,
      variables: variables,
      render: queryResult => this.renderWithQueryResult(token, repoData, queryResult)
    }));
  }

  renderWithQueryResult(token, repoData, {
    error,
    props,
    retry
  }) {
    if (error) {
      return _react.default.createElement(_queryErrorView.default, {
        error: error,
        login: this.handleLogin,
        retry: retry,
        logout: this.handleLogout
      });
    }

    if (!props || !repoData) {
      return _react.default.createElement(_loadingView.default, null);
    }

    if (props.repository.issueish.__typename === 'PullRequest') {
      return _react.default.createElement(_aggregatedReviewsContainer.default, {
        pullRequest: props.repository.issueish,
        reportRelayError: this.props.reportRelayError
      }, aggregatedReviews => this.renderWithCommentResult(token, repoData, {
        props,
        retry
      }, aggregatedReviews));
    } else {
      return this.renderWithCommentResult(token, repoData, {
        props,
        retry
      }, {
        errors: [],
        commentThreads: [],
        loading: false
      });
    }
  }

  renderWithCommentResult(token, repoData, {
    props,
    retry
  }, {
    errors,
    commentThreads,
    loading
  }) {
    const nonEmptyThreads = commentThreads.filter(each => each.comments && each.comments.length > 0);
    const totalCount = nonEmptyThreads.length;
    const resolvedCount = nonEmptyThreads.filter(each => each.thread.isResolved).length;

    if (errors && errors.length > 0) {
      const descriptions = errors.map(error => error.toString());
      return _react.default.createElement(_errorView.default, {
        title: "Unable to fetch review comments",
        descriptions: descriptions,
        retry: retry,
        logout: this.handleLogout
      });
    }

    return _react.default.createElement(_issueishDetailController.default, _extends({}, props, repoData, {
      reviewCommentsLoading: loading,
      reviewCommentsTotalCount: totalCount,
      reviewCommentsResolvedCount: resolvedCount,
      reviewCommentThreads: nonEmptyThreads,
      token: token,
      localRepository: this.props.repository,
      workdirPath: this.props.repository.getWorkingDirectoryPath(),
      issueishNumber: this.props.issueishNumber,
      onTitleChange: this.props.onTitleChange,
      switchToIssueish: this.props.switchToIssueish,
      initChangedFilePath: this.props.initChangedFilePath,
      initChangedFilePosition: this.props.initChangedFilePosition,
      selectedTab: this.props.selectedTab,
      onTabSelected: this.props.onTabSelected,
      onOpenFilesTab: this.props.onOpenFilesTab,
      endpoint: this.props.endpoint,
      reportRelayError: this.props.reportRelayError,
      workspace: this.props.workspace,
      commands: this.props.commands,
      keymaps: this.props.keymaps,
      tooltips: this.props.tooltips,
      config: this.props.config,
      itemType: this.props.itemType,
      destroy: this.props.destroy,
      refEditor: this.props.refEditor
    }));
  }

}

exports.default = IssueishDetailContainer;

_defineProperty(IssueishDetailContainer, "propTypes", {
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  // Issueish selection criteria
  owner: _propTypes.default.string.isRequired,
  repo: _propTypes.default.string.isRequired,
  issueishNumber: _propTypes.default.number.isRequired,
  // For opening files changed tab
  initChangedFilePath: _propTypes.default.string,
  initChangedFilePosition: _propTypes.default.number,
  selectedTab: _propTypes.default.number.isRequired,
  onTabSelected: _propTypes.default.func.isRequired,
  onOpenFilesTab: _propTypes.default.func.isRequired,
  // Package models
  repository: _propTypes.default.object.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  // Atom environment
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  keymaps: _propTypes.default.object.isRequired,
  tooltips: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired,
  // Action methods
  switchToIssueish: _propTypes.default.func.isRequired,
  onTitleChange: _propTypes.default.func.isRequired,
  destroy: _propTypes.default.func.isRequired,
  reportRelayError: _propTypes.default.func.isRequired,
  // Item context
  itemType: _propTypes2.ItemTypePropType.isRequired,
  refEditor: _propTypes2.RefHolderPropType.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImlzc3VlaXNoLWRldGFpbC1jb250YWluZXIuanMiXSwibmFtZXMiOlsiSXNzdWVpc2hEZXRhaWxDb250YWluZXIiLCJSZWFjdCIsIkNvbXBvbmVudCIsInRva2VuRGF0YSIsInRva2VuIiwiRXJyb3IiLCJoYW5kbGVMb2dpbiIsImhhbmRsZVRva2VuUmV0cnkiLCJoYW5kbGVMb2dvdXQiLCJVTkFVVEhFTlRJQ0FURUQiLCJJTlNVRkZJQ0lFTlQiLCJwcm9wcyIsInJlcG9zaXRvcnkiLCJmZXRjaFJlcG9zaXRvcnlEYXRhIiwicmVwb0RhdGEiLCJyZW5kZXJXaXRoUmVwb3NpdG9yeURhdGEiLCJsb2dpbk1vZGVsIiwiZ2V0VG9rZW4iLCJlbmRwb2ludCIsImdldExvZ2luQWNjb3VudCIsImJyYW5jaGVzIiwiZ2V0QnJhbmNoZXMiLCJyZW1vdGVzIiwiZ2V0UmVtb3RlcyIsImlzTWVyZ2luZyIsImlzUmViYXNpbmciLCJpc0Fic2VudCIsImlzTG9hZGluZyIsImlzUHJlc2VudCIsInNldFRva2VuIiwicmVtb3ZlVG9rZW4iLCJkaWRVcGRhdGUiLCJyZW5kZXIiLCJmZXRjaFRva2VuIiwicmVuZGVyV2l0aFRva2VuIiwiZW52aXJvbm1lbnQiLCJSZWxheU5ldHdvcmtMYXllck1hbmFnZXIiLCJnZXRFbnZpcm9ubWVudEZvckhvc3QiLCJxdWVyeSIsInZhcmlhYmxlcyIsInJlcG9Pd25lciIsIm93bmVyIiwicmVwb05hbWUiLCJyZXBvIiwiaXNzdWVpc2hOdW1iZXIiLCJ0aW1lbGluZUNvdW50IiwiUEFHRV9TSVpFIiwidGltZWxpbmVDdXJzb3IiLCJjb21taXRDb3VudCIsImNvbW1pdEN1cnNvciIsInJldmlld0NvdW50IiwicmV2aWV3Q3Vyc29yIiwidGhyZWFkQ291bnQiLCJ0aHJlYWRDdXJzb3IiLCJjb21tZW50Q291bnQiLCJjb21tZW50Q3Vyc29yIiwiY2hlY2tTdWl0ZUNvdW50IiwiQ0hFQ0tfU1VJVEVfUEFHRV9TSVpFIiwiY2hlY2tTdWl0ZUN1cnNvciIsImNoZWNrUnVuQ291bnQiLCJDSEVDS19SVU5fUEFHRV9TSVpFIiwiY2hlY2tSdW5DdXJzb3IiLCJxdWVyeVJlc3VsdCIsInJlbmRlcldpdGhRdWVyeVJlc3VsdCIsImVycm9yIiwicmV0cnkiLCJpc3N1ZWlzaCIsIl9fdHlwZW5hbWUiLCJyZXBvcnRSZWxheUVycm9yIiwiYWdncmVnYXRlZFJldmlld3MiLCJyZW5kZXJXaXRoQ29tbWVudFJlc3VsdCIsImVycm9ycyIsImNvbW1lbnRUaHJlYWRzIiwibG9hZGluZyIsIm5vbkVtcHR5VGhyZWFkcyIsImZpbHRlciIsImVhY2giLCJjb21tZW50cyIsImxlbmd0aCIsInRvdGFsQ291bnQiLCJyZXNvbHZlZENvdW50IiwidGhyZWFkIiwiaXNSZXNvbHZlZCIsImRlc2NyaXB0aW9ucyIsIm1hcCIsInRvU3RyaW5nIiwiZ2V0V29ya2luZ0RpcmVjdG9yeVBhdGgiLCJvblRpdGxlQ2hhbmdlIiwic3dpdGNoVG9Jc3N1ZWlzaCIsImluaXRDaGFuZ2VkRmlsZVBhdGgiLCJpbml0Q2hhbmdlZEZpbGVQb3NpdGlvbiIsInNlbGVjdGVkVGFiIiwib25UYWJTZWxlY3RlZCIsIm9uT3BlbkZpbGVzVGFiIiwid29ya3NwYWNlIiwiY29tbWFuZHMiLCJrZXltYXBzIiwidG9vbHRpcHMiLCJjb25maWciLCJpdGVtVHlwZSIsImRlc3Ryb3kiLCJyZWZFZGl0b3IiLCJFbmRwb2ludFByb3BUeXBlIiwiaXNSZXF1aXJlZCIsIlByb3BUeXBlcyIsInN0cmluZyIsIm51bWJlciIsImZ1bmMiLCJvYmplY3QiLCJHaXRodWJMb2dpbk1vZGVsUHJvcFR5cGUiLCJJdGVtVHlwZVByb3BUeXBlIiwiUmVmSG9sZGVyUHJvcFR5cGUiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFFQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7Ozs7Ozs7OztBQUVlLE1BQU1BLHVCQUFOLFNBQXNDQyxlQUFNQyxTQUE1QyxDQUFzRDtBQUFBO0FBQUE7O0FBQUEsNkNBK0NqREMsU0FBUyxJQUFJO0FBQzdCLFlBQU1DLEtBQUssR0FBR0QsU0FBUyxJQUFJQSxTQUFTLENBQUNDLEtBQXJDOztBQUVBLFVBQUlBLEtBQUssWUFBWUMsS0FBckIsRUFBNEI7QUFDMUIsZUFDRSw2QkFBQyx1QkFBRDtBQUNFLFVBQUEsS0FBSyxFQUFFRCxLQURUO0FBRUUsVUFBQSxLQUFLLEVBQUUsS0FBS0UsV0FGZDtBQUdFLFVBQUEsS0FBSyxFQUFFLEtBQUtDLGdCQUhkO0FBSUUsVUFBQSxNQUFNLEVBQUUsS0FBS0M7QUFKZixVQURGO0FBUUQ7O0FBRUQsVUFBSUosS0FBSyxLQUFLSywrQkFBZCxFQUErQjtBQUM3QixlQUFPLDZCQUFDLHdCQUFEO0FBQWlCLFVBQUEsT0FBTyxFQUFFLEtBQUtIO0FBQS9CLFVBQVA7QUFDRDs7QUFFRCxVQUFJRixLQUFLLEtBQUtNLDRCQUFkLEVBQTRCO0FBQzFCLGVBQ0UsNkJBQUMsd0JBQUQ7QUFBaUIsVUFBQSxPQUFPLEVBQUUsS0FBS0o7QUFBL0IsV0FDRSw2SUFERixDQURGO0FBT0Q7O0FBRUQsYUFDRSw2QkFBQyxxQkFBRDtBQUFjLFFBQUEsS0FBSyxFQUFFLEtBQUtLLEtBQUwsQ0FBV0MsVUFBaEM7QUFBNEMsUUFBQSxTQUFTLEVBQUUsS0FBS0M7QUFBNUQsU0FDR0MsUUFBUSxJQUFJLEtBQUtDLHdCQUFMLENBQThCWCxLQUE5QixFQUFxQ1UsUUFBckMsQ0FEZixDQURGO0FBS0QsS0FoRmtFOztBQUFBLHdDQW1RdERFLFVBQVUsSUFBSTtBQUN6QixhQUFPLHVCQUFTO0FBQ2RaLFFBQUFBLEtBQUssRUFBRVksVUFBVSxDQUFDQyxRQUFYLENBQW9CLEtBQUtOLEtBQUwsQ0FBV08sUUFBWCxDQUFvQkMsZUFBcEIsRUFBcEI7QUFETyxPQUFULENBQVA7QUFHRCxLQXZRa0U7O0FBQUEsaURBeVE3Q1AsVUFBVSxJQUFJO0FBQ2xDLGFBQU8sdUJBQVM7QUFDZFEsUUFBQUEsUUFBUSxFQUFFUixVQUFVLENBQUNTLFdBQVgsRUFESTtBQUVkQyxRQUFBQSxPQUFPLEVBQUVWLFVBQVUsQ0FBQ1csVUFBWCxFQUZLO0FBR2RDLFFBQUFBLFNBQVMsRUFBRVosVUFBVSxDQUFDWSxTQUFYLEVBSEc7QUFJZEMsUUFBQUEsVUFBVSxFQUFFYixVQUFVLENBQUNhLFVBQVgsRUFKRTtBQUtkQyxRQUFBQSxRQUFRLEVBQUVkLFVBQVUsQ0FBQ2MsUUFBWCxFQUxJO0FBTWRDLFFBQUFBLFNBQVMsRUFBRWYsVUFBVSxDQUFDZSxTQUFYLEVBTkc7QUFPZEMsUUFBQUEsU0FBUyxFQUFFaEIsVUFBVSxDQUFDZ0IsU0FBWDtBQVBHLE9BQVQsQ0FBUDtBQVNELEtBblJrRTs7QUFBQSx5Q0FxUnJEeEIsS0FBSyxJQUFJLEtBQUtPLEtBQUwsQ0FBV0ssVUFBWCxDQUFzQmEsUUFBdEIsQ0FBK0IsS0FBS2xCLEtBQUwsQ0FBV08sUUFBWCxDQUFvQkMsZUFBcEIsRUFBL0IsRUFBc0VmLEtBQXRFLENBclI0Qzs7QUFBQSwwQ0F1UnBELE1BQU0sS0FBS08sS0FBTCxDQUFXSyxVQUFYLENBQXNCYyxXQUF0QixDQUFrQyxLQUFLbkIsS0FBTCxDQUFXTyxRQUFYLENBQW9CQyxlQUFwQixFQUFsQyxDQXZSOEM7O0FBQUEsOENBeVJoRCxNQUFNLEtBQUtSLEtBQUwsQ0FBV0ssVUFBWCxDQUFzQmUsU0FBdEIsRUF6UjBDO0FBQUE7O0FBdUNuRUMsRUFBQUEsTUFBTSxHQUFHO0FBQ1AsV0FDRSw2QkFBQyxxQkFBRDtBQUFjLE1BQUEsS0FBSyxFQUFFLEtBQUtyQixLQUFMLENBQVdLLFVBQWhDO0FBQTRDLE1BQUEsU0FBUyxFQUFFLEtBQUtpQjtBQUE1RCxPQUNHLEtBQUtDLGVBRFIsQ0FERjtBQUtEOztBQXFDRG5CLEVBQUFBLHdCQUF3QixDQUFDWCxLQUFELEVBQVFVLFFBQVIsRUFBa0I7QUFDeEMsUUFBSSxDQUFDVixLQUFMLEVBQVk7QUFDVixhQUFPLDZCQUFDLG9CQUFELE9BQVA7QUFDRDs7QUFFRCxVQUFNK0IsV0FBVyxHQUFHQyxrQ0FBeUJDLHFCQUF6QixDQUErQyxLQUFLMUIsS0FBTCxDQUFXTyxRQUExRCxFQUFvRWQsS0FBcEUsQ0FBcEI7O0FBQ0EsVUFBTWtDLEtBQUs7QUFBQTs7QUFBQTtBQUFBO0FBQUE7O0FBQUE7QUFBQSxNQUFYOztBQWtEQSxVQUFNQyxTQUFTLEdBQUc7QUFDaEJDLE1BQUFBLFNBQVMsRUFBRSxLQUFLN0IsS0FBTCxDQUFXOEIsS0FETjtBQUVoQkMsTUFBQUEsUUFBUSxFQUFFLEtBQUsvQixLQUFMLENBQVdnQyxJQUZMO0FBR2hCQyxNQUFBQSxjQUFjLEVBQUUsS0FBS2pDLEtBQUwsQ0FBV2lDLGNBSFg7QUFJaEJDLE1BQUFBLGFBQWEsRUFBRUMsa0JBSkM7QUFLaEJDLE1BQUFBLGNBQWMsRUFBRSxJQUxBO0FBTWhCQyxNQUFBQSxXQUFXLEVBQUVGLGtCQU5HO0FBT2hCRyxNQUFBQSxZQUFZLEVBQUUsSUFQRTtBQVFoQkMsTUFBQUEsV0FBVyxFQUFFSixrQkFSRztBQVNoQkssTUFBQUEsWUFBWSxFQUFFLElBVEU7QUFVaEJDLE1BQUFBLFdBQVcsRUFBRU4sa0JBVkc7QUFXaEJPLE1BQUFBLFlBQVksRUFBRSxJQVhFO0FBWWhCQyxNQUFBQSxZQUFZLEVBQUVSLGtCQVpFO0FBYWhCUyxNQUFBQSxhQUFhLEVBQUUsSUFiQztBQWNoQkMsTUFBQUEsZUFBZSxFQUFFQyw4QkFkRDtBQWVoQkMsTUFBQUEsZ0JBQWdCLEVBQUUsSUFmRjtBQWdCaEJDLE1BQUFBLGFBQWEsRUFBRUMsNEJBaEJDO0FBaUJoQkMsTUFBQUEsY0FBYyxFQUFFO0FBakJBLEtBQWxCO0FBb0JBLFdBQ0UsNkJBQUMseUJBQUQsQ0FBa0IsUUFBbEI7QUFBMkIsTUFBQSxLQUFLLEVBQUUxQjtBQUFsQyxPQUNFLDZCQUFDLHlCQUFEO0FBQ0UsTUFBQSxXQUFXLEVBQUVBLFdBRGY7QUFFRSxNQUFBLEtBQUssRUFBRUcsS0FGVDtBQUdFLE1BQUEsU0FBUyxFQUFFQyxTQUhiO0FBSUUsTUFBQSxNQUFNLEVBQUV1QixXQUFXLElBQUksS0FBS0MscUJBQUwsQ0FBMkIzRCxLQUEzQixFQUFrQ1UsUUFBbEMsRUFBNENnRCxXQUE1QztBQUp6QixNQURGLENBREY7QUFVRDs7QUFFREMsRUFBQUEscUJBQXFCLENBQUMzRCxLQUFELEVBQVFVLFFBQVIsRUFBa0I7QUFBQ2tELElBQUFBLEtBQUQ7QUFBUXJELElBQUFBLEtBQVI7QUFBZXNELElBQUFBO0FBQWYsR0FBbEIsRUFBeUM7QUFDNUQsUUFBSUQsS0FBSixFQUFXO0FBQ1QsYUFDRSw2QkFBQyx1QkFBRDtBQUNFLFFBQUEsS0FBSyxFQUFFQSxLQURUO0FBRUUsUUFBQSxLQUFLLEVBQUUsS0FBSzFELFdBRmQ7QUFHRSxRQUFBLEtBQUssRUFBRTJELEtBSFQ7QUFJRSxRQUFBLE1BQU0sRUFBRSxLQUFLekQ7QUFKZixRQURGO0FBUUQ7O0FBRUQsUUFBSSxDQUFDRyxLQUFELElBQVUsQ0FBQ0csUUFBZixFQUF5QjtBQUN2QixhQUFPLDZCQUFDLG9CQUFELE9BQVA7QUFDRDs7QUFFRCxRQUFJSCxLQUFLLENBQUNDLFVBQU4sQ0FBaUJzRCxRQUFqQixDQUEwQkMsVUFBMUIsS0FBeUMsYUFBN0MsRUFBNEQ7QUFDMUQsYUFDRSw2QkFBQyxtQ0FBRDtBQUNFLFFBQUEsV0FBVyxFQUFFeEQsS0FBSyxDQUFDQyxVQUFOLENBQWlCc0QsUUFEaEM7QUFFRSxRQUFBLGdCQUFnQixFQUFFLEtBQUt2RCxLQUFMLENBQVd5RDtBQUYvQixTQUdHQyxpQkFBaUIsSUFBSSxLQUFLQyx1QkFBTCxDQUE2QmxFLEtBQTdCLEVBQW9DVSxRQUFwQyxFQUE4QztBQUFDSCxRQUFBQSxLQUFEO0FBQVFzRCxRQUFBQTtBQUFSLE9BQTlDLEVBQThESSxpQkFBOUQsQ0FIeEIsQ0FERjtBQU9ELEtBUkQsTUFRTztBQUNMLGFBQU8sS0FBS0MsdUJBQUwsQ0FDTGxFLEtBREssRUFFTFUsUUFGSyxFQUdMO0FBQUNILFFBQUFBLEtBQUQ7QUFBUXNELFFBQUFBO0FBQVIsT0FISyxFQUlMO0FBQUNNLFFBQUFBLE1BQU0sRUFBRSxFQUFUO0FBQWFDLFFBQUFBLGNBQWMsRUFBRSxFQUE3QjtBQUFpQ0MsUUFBQUEsT0FBTyxFQUFFO0FBQTFDLE9BSkssQ0FBUDtBQU1EO0FBQ0Y7O0FBRURILEVBQUFBLHVCQUF1QixDQUFDbEUsS0FBRCxFQUFRVSxRQUFSLEVBQWtCO0FBQUNILElBQUFBLEtBQUQ7QUFBUXNELElBQUFBO0FBQVIsR0FBbEIsRUFBa0M7QUFBQ00sSUFBQUEsTUFBRDtBQUFTQyxJQUFBQSxjQUFUO0FBQXlCQyxJQUFBQTtBQUF6QixHQUFsQyxFQUFxRTtBQUMxRixVQUFNQyxlQUFlLEdBQUdGLGNBQWMsQ0FBQ0csTUFBZixDQUFzQkMsSUFBSSxJQUFJQSxJQUFJLENBQUNDLFFBQUwsSUFBaUJELElBQUksQ0FBQ0MsUUFBTCxDQUFjQyxNQUFkLEdBQXVCLENBQXRFLENBQXhCO0FBQ0EsVUFBTUMsVUFBVSxHQUFHTCxlQUFlLENBQUNJLE1BQW5DO0FBQ0EsVUFBTUUsYUFBYSxHQUFHTixlQUFlLENBQUNDLE1BQWhCLENBQXVCQyxJQUFJLElBQUlBLElBQUksQ0FBQ0ssTUFBTCxDQUFZQyxVQUEzQyxFQUF1REosTUFBN0U7O0FBRUEsUUFBSVAsTUFBTSxJQUFJQSxNQUFNLENBQUNPLE1BQVAsR0FBZ0IsQ0FBOUIsRUFBaUM7QUFDL0IsWUFBTUssWUFBWSxHQUFHWixNQUFNLENBQUNhLEdBQVAsQ0FBV3BCLEtBQUssSUFBSUEsS0FBSyxDQUFDcUIsUUFBTixFQUFwQixDQUFyQjtBQUVBLGFBQ0UsNkJBQUMsa0JBQUQ7QUFDRSxRQUFBLEtBQUssRUFBQyxpQ0FEUjtBQUVFLFFBQUEsWUFBWSxFQUFFRixZQUZoQjtBQUdFLFFBQUEsS0FBSyxFQUFFbEIsS0FIVDtBQUlFLFFBQUEsTUFBTSxFQUFFLEtBQUt6RDtBQUpmLFFBREY7QUFRRDs7QUFFRCxXQUNFLDZCQUFDLGlDQUFELGVBQ01HLEtBRE4sRUFFTUcsUUFGTjtBQUdFLE1BQUEscUJBQXFCLEVBQUUyRCxPQUh6QjtBQUlFLE1BQUEsd0JBQXdCLEVBQUVNLFVBSjVCO0FBS0UsTUFBQSwyQkFBMkIsRUFBRUMsYUFML0I7QUFNRSxNQUFBLG9CQUFvQixFQUFFTixlQU54QjtBQU9FLE1BQUEsS0FBSyxFQUFFdEUsS0FQVDtBQVNFLE1BQUEsZUFBZSxFQUFFLEtBQUtPLEtBQUwsQ0FBV0MsVUFUOUI7QUFVRSxNQUFBLFdBQVcsRUFBRSxLQUFLRCxLQUFMLENBQVdDLFVBQVgsQ0FBc0IwRSx1QkFBdEIsRUFWZjtBQVlFLE1BQUEsY0FBYyxFQUFFLEtBQUszRSxLQUFMLENBQVdpQyxjQVo3QjtBQWFFLE1BQUEsYUFBYSxFQUFFLEtBQUtqQyxLQUFMLENBQVc0RSxhQWI1QjtBQWNFLE1BQUEsZ0JBQWdCLEVBQUUsS0FBSzVFLEtBQUwsQ0FBVzZFLGdCQWQvQjtBQWVFLE1BQUEsbUJBQW1CLEVBQUUsS0FBSzdFLEtBQUwsQ0FBVzhFLG1CQWZsQztBQWdCRSxNQUFBLHVCQUF1QixFQUFFLEtBQUs5RSxLQUFMLENBQVcrRSx1QkFoQnRDO0FBaUJFLE1BQUEsV0FBVyxFQUFFLEtBQUsvRSxLQUFMLENBQVdnRixXQWpCMUI7QUFrQkUsTUFBQSxhQUFhLEVBQUUsS0FBS2hGLEtBQUwsQ0FBV2lGLGFBbEI1QjtBQW1CRSxNQUFBLGNBQWMsRUFBRSxLQUFLakYsS0FBTCxDQUFXa0YsY0FuQjdCO0FBb0JFLE1BQUEsUUFBUSxFQUFFLEtBQUtsRixLQUFMLENBQVdPLFFBcEJ2QjtBQXFCRSxNQUFBLGdCQUFnQixFQUFFLEtBQUtQLEtBQUwsQ0FBV3lELGdCQXJCL0I7QUF1QkUsTUFBQSxTQUFTLEVBQUUsS0FBS3pELEtBQUwsQ0FBV21GLFNBdkJ4QjtBQXdCRSxNQUFBLFFBQVEsRUFBRSxLQUFLbkYsS0FBTCxDQUFXb0YsUUF4QnZCO0FBeUJFLE1BQUEsT0FBTyxFQUFFLEtBQUtwRixLQUFMLENBQVdxRixPQXpCdEI7QUEwQkUsTUFBQSxRQUFRLEVBQUUsS0FBS3JGLEtBQUwsQ0FBV3NGLFFBMUJ2QjtBQTJCRSxNQUFBLE1BQU0sRUFBRSxLQUFLdEYsS0FBTCxDQUFXdUYsTUEzQnJCO0FBNkJFLE1BQUEsUUFBUSxFQUFFLEtBQUt2RixLQUFMLENBQVd3RixRQTdCdkI7QUE4QkUsTUFBQSxPQUFPLEVBQUUsS0FBS3hGLEtBQUwsQ0FBV3lGLE9BOUJ0QjtBQStCRSxNQUFBLFNBQVMsRUFBRSxLQUFLekYsS0FBTCxDQUFXMEY7QUEvQnhCLE9BREY7QUFtQ0Q7O0FBalFrRTs7OztnQkFBaERyRyx1QixlQUNBO0FBQ2pCO0FBQ0FrQixFQUFBQSxRQUFRLEVBQUVvRiw2QkFBaUJDLFVBRlY7QUFJakI7QUFDQTlELEVBQUFBLEtBQUssRUFBRStELG1CQUFVQyxNQUFWLENBQWlCRixVQUxQO0FBTWpCNUQsRUFBQUEsSUFBSSxFQUFFNkQsbUJBQVVDLE1BQVYsQ0FBaUJGLFVBTk47QUFPakIzRCxFQUFBQSxjQUFjLEVBQUU0RCxtQkFBVUUsTUFBVixDQUFpQkgsVUFQaEI7QUFTakI7QUFDQWQsRUFBQUEsbUJBQW1CLEVBQUVlLG1CQUFVQyxNQVZkO0FBV2pCZixFQUFBQSx1QkFBdUIsRUFBRWMsbUJBQVVFLE1BWGxCO0FBWWpCZixFQUFBQSxXQUFXLEVBQUVhLG1CQUFVRSxNQUFWLENBQWlCSCxVQVpiO0FBYWpCWCxFQUFBQSxhQUFhLEVBQUVZLG1CQUFVRyxJQUFWLENBQWVKLFVBYmI7QUFjakJWLEVBQUFBLGNBQWMsRUFBRVcsbUJBQVVHLElBQVYsQ0FBZUosVUFkZDtBQWdCakI7QUFDQTNGLEVBQUFBLFVBQVUsRUFBRTRGLG1CQUFVSSxNQUFWLENBQWlCTCxVQWpCWjtBQWtCakJ2RixFQUFBQSxVQUFVLEVBQUU2RixxQ0FBeUJOLFVBbEJwQjtBQW9CakI7QUFDQVQsRUFBQUEsU0FBUyxFQUFFVSxtQkFBVUksTUFBVixDQUFpQkwsVUFyQlg7QUFzQmpCUixFQUFBQSxRQUFRLEVBQUVTLG1CQUFVSSxNQUFWLENBQWlCTCxVQXRCVjtBQXVCakJQLEVBQUFBLE9BQU8sRUFBRVEsbUJBQVVJLE1BQVYsQ0FBaUJMLFVBdkJUO0FBd0JqQk4sRUFBQUEsUUFBUSxFQUFFTyxtQkFBVUksTUFBVixDQUFpQkwsVUF4QlY7QUF5QmpCTCxFQUFBQSxNQUFNLEVBQUVNLG1CQUFVSSxNQUFWLENBQWlCTCxVQXpCUjtBQTJCakI7QUFDQWYsRUFBQUEsZ0JBQWdCLEVBQUVnQixtQkFBVUcsSUFBVixDQUFlSixVQTVCaEI7QUE2QmpCaEIsRUFBQUEsYUFBYSxFQUFFaUIsbUJBQVVHLElBQVYsQ0FBZUosVUE3QmI7QUE4QmpCSCxFQUFBQSxPQUFPLEVBQUVJLG1CQUFVRyxJQUFWLENBQWVKLFVBOUJQO0FBK0JqQm5DLEVBQUFBLGdCQUFnQixFQUFFb0MsbUJBQVVHLElBQVYsQ0FBZUosVUEvQmhCO0FBaUNqQjtBQUNBSixFQUFBQSxRQUFRLEVBQUVXLDZCQUFpQlAsVUFsQ1Y7QUFtQ2pCRixFQUFBQSxTQUFTLEVBQUVVLDhCQUFrQlI7QUFuQ1osQyIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCB5dWJpa2lyaSBmcm9tICd5dWJpa2lyaSc7XG5pbXBvcnQge1F1ZXJ5UmVuZGVyZXIsIGdyYXBocWx9IGZyb20gJ3JlYWN0LXJlbGF5JztcblxuaW1wb3J0IHtQQUdFX1NJWkUsIENIRUNLX1NVSVRFX1BBR0VfU0laRSwgQ0hFQ0tfUlVOX1BBR0VfU0laRX0gZnJvbSAnLi4vaGVscGVycyc7XG5pbXBvcnQgUmVsYXlOZXR3b3JrTGF5ZXJNYW5hZ2VyIGZyb20gJy4uL3JlbGF5LW5ldHdvcmstbGF5ZXItbWFuYWdlcic7XG5pbXBvcnQge0dpdGh1YkxvZ2luTW9kZWxQcm9wVHlwZSwgSXRlbVR5cGVQcm9wVHlwZSwgRW5kcG9pbnRQcm9wVHlwZSwgUmVmSG9sZGVyUHJvcFR5cGV9IGZyb20gJy4uL3Byb3AtdHlwZXMnO1xuaW1wb3J0IHtVTkFVVEhFTlRJQ0FURUQsIElOU1VGRklDSUVOVH0gZnJvbSAnLi4vc2hhcmVkL2tleXRhci1zdHJhdGVneSc7XG5pbXBvcnQgR2l0aHViTG9naW5WaWV3IGZyb20gJy4uL3ZpZXdzL2dpdGh1Yi1sb2dpbi12aWV3JztcbmltcG9ydCBMb2FkaW5nVmlldyBmcm9tICcuLi92aWV3cy9sb2FkaW5nLXZpZXcnO1xuaW1wb3J0IFF1ZXJ5RXJyb3JWaWV3IGZyb20gJy4uL3ZpZXdzL3F1ZXJ5LWVycm9yLXZpZXcnO1xuaW1wb3J0IEVycm9yVmlldyBmcm9tICcuLi92aWV3cy9lcnJvci12aWV3JztcbmltcG9ydCBPYnNlcnZlTW9kZWwgZnJvbSAnLi4vdmlld3Mvb2JzZXJ2ZS1tb2RlbCc7XG5pbXBvcnQgUmVsYXlFbnZpcm9ubWVudCBmcm9tICcuLi92aWV3cy9yZWxheS1lbnZpcm9ubWVudCc7XG5pbXBvcnQgQWdncmVnYXRlZFJldmlld3NDb250YWluZXIgZnJvbSAnLi9hZ2dyZWdhdGVkLXJldmlld3MtY29udGFpbmVyJztcbmltcG9ydCBJc3N1ZWlzaERldGFpbENvbnRyb2xsZXIgZnJvbSAnLi4vY29udHJvbGxlcnMvaXNzdWVpc2gtZGV0YWlsLWNvbnRyb2xsZXInO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBJc3N1ZWlzaERldGFpbENvbnRhaW5lciBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgLy8gQ29ubmVjdGlvblxuICAgIGVuZHBvaW50OiBFbmRwb2ludFByb3BUeXBlLmlzUmVxdWlyZWQsXG5cbiAgICAvLyBJc3N1ZWlzaCBzZWxlY3Rpb24gY3JpdGVyaWFcbiAgICBvd25lcjogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgIHJlcG86IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICBpc3N1ZWlzaE51bWJlcjogUHJvcFR5cGVzLm51bWJlci5pc1JlcXVpcmVkLFxuXG4gICAgLy8gRm9yIG9wZW5pbmcgZmlsZXMgY2hhbmdlZCB0YWJcbiAgICBpbml0Q2hhbmdlZEZpbGVQYXRoOiBQcm9wVHlwZXMuc3RyaW5nLFxuICAgIGluaXRDaGFuZ2VkRmlsZVBvc2l0aW9uOiBQcm9wVHlwZXMubnVtYmVyLFxuICAgIHNlbGVjdGVkVGFiOiBQcm9wVHlwZXMubnVtYmVyLmlzUmVxdWlyZWQsXG4gICAgb25UYWJTZWxlY3RlZDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBvbk9wZW5GaWxlc1RhYjogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcblxuICAgIC8vIFBhY2thZ2UgbW9kZWxzXG4gICAgcmVwb3NpdG9yeTogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIGxvZ2luTW9kZWw6IEdpdGh1YkxvZ2luTW9kZWxQcm9wVHlwZS5pc1JlcXVpcmVkLFxuXG4gICAgLy8gQXRvbSBlbnZpcm9ubWVudFxuICAgIHdvcmtzcGFjZTogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIGNvbW1hbmRzOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAga2V5bWFwczogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIHRvb2x0aXBzOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgY29uZmlnOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG5cbiAgICAvLyBBY3Rpb24gbWV0aG9kc1xuICAgIHN3aXRjaFRvSXNzdWVpc2g6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgb25UaXRsZUNoYW5nZTogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBkZXN0cm95OiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIHJlcG9ydFJlbGF5RXJyb3I6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG5cbiAgICAvLyBJdGVtIGNvbnRleHRcbiAgICBpdGVtVHlwZTogSXRlbVR5cGVQcm9wVHlwZS5pc1JlcXVpcmVkLFxuICAgIHJlZkVkaXRvcjogUmVmSG9sZGVyUHJvcFR5cGUuaXNSZXF1aXJlZCxcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPE9ic2VydmVNb2RlbCBtb2RlbD17dGhpcy5wcm9wcy5sb2dpbk1vZGVsfSBmZXRjaERhdGE9e3RoaXMuZmV0Y2hUb2tlbn0+XG4gICAgICAgIHt0aGlzLnJlbmRlcldpdGhUb2tlbn1cbiAgICAgIDwvT2JzZXJ2ZU1vZGVsPlxuICAgICk7XG4gIH1cblxuICByZW5kZXJXaXRoVG9rZW4gPSB0b2tlbkRhdGEgPT4ge1xuICAgIGNvbnN0IHRva2VuID0gdG9rZW5EYXRhICYmIHRva2VuRGF0YS50b2tlbjtcblxuICAgIGlmICh0b2tlbiBpbnN0YW5jZW9mIEVycm9yKSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8UXVlcnlFcnJvclZpZXdcbiAgICAgICAgICBlcnJvcj17dG9rZW59XG4gICAgICAgICAgbG9naW49e3RoaXMuaGFuZGxlTG9naW59XG4gICAgICAgICAgcmV0cnk9e3RoaXMuaGFuZGxlVG9rZW5SZXRyeX1cbiAgICAgICAgICBsb2dvdXQ9e3RoaXMuaGFuZGxlTG9nb3V0fVxuICAgICAgICAvPlxuICAgICAgKTtcbiAgICB9XG5cbiAgICBpZiAodG9rZW4gPT09IFVOQVVUSEVOVElDQVRFRCkge1xuICAgICAgcmV0dXJuIDxHaXRodWJMb2dpblZpZXcgb25Mb2dpbj17dGhpcy5oYW5kbGVMb2dpbn0gLz47XG4gICAgfVxuXG4gICAgaWYgKHRva2VuID09PSBJTlNVRkZJQ0lFTlQpIHtcbiAgICAgIHJldHVybiAoXG4gICAgICAgIDxHaXRodWJMb2dpblZpZXcgb25Mb2dpbj17dGhpcy5oYW5kbGVMb2dpbn0+XG4gICAgICAgICAgPHA+XG4gICAgICAgICAgICBZb3VyIHRva2VuIG5vIGxvbmdlciBoYXMgc3VmZmljaWVudCBhdXRob3JpemF0aW9ucy4gUGxlYXNlIHJlLWF1dGhlbnRpY2F0ZSBhbmQgZ2VuZXJhdGUgYSBuZXcgb25lLlxuICAgICAgICAgIDwvcD5cbiAgICAgICAgPC9HaXRodWJMb2dpblZpZXc+XG4gICAgICApO1xuICAgIH1cblxuICAgIHJldHVybiAoXG4gICAgICA8T2JzZXJ2ZU1vZGVsIG1vZGVsPXt0aGlzLnByb3BzLnJlcG9zaXRvcnl9IGZldGNoRGF0YT17dGhpcy5mZXRjaFJlcG9zaXRvcnlEYXRhfT5cbiAgICAgICAge3JlcG9EYXRhID0+IHRoaXMucmVuZGVyV2l0aFJlcG9zaXRvcnlEYXRhKHRva2VuLCByZXBvRGF0YSl9XG4gICAgICA8L09ic2VydmVNb2RlbD5cbiAgICApO1xuICB9XG5cbiAgcmVuZGVyV2l0aFJlcG9zaXRvcnlEYXRhKHRva2VuLCByZXBvRGF0YSkge1xuICAgIGlmICghdG9rZW4pIHtcbiAgICAgIHJldHVybiA8TG9hZGluZ1ZpZXcgLz47XG4gICAgfVxuXG4gICAgY29uc3QgZW52aXJvbm1lbnQgPSBSZWxheU5ldHdvcmtMYXllck1hbmFnZXIuZ2V0RW52aXJvbm1lbnRGb3JIb3N0KHRoaXMucHJvcHMuZW5kcG9pbnQsIHRva2VuKTtcbiAgICBjb25zdCBxdWVyeSA9IGdyYXBocWxgXG4gICAgICBxdWVyeSBpc3N1ZWlzaERldGFpbENvbnRhaW5lclF1ZXJ5XG4gICAgICAoXG4gICAgICAgICRyZXBvT3duZXI6IFN0cmluZyFcbiAgICAgICAgJHJlcG9OYW1lOiBTdHJpbmchXG4gICAgICAgICRpc3N1ZWlzaE51bWJlcjogSW50IVxuICAgICAgICAkdGltZWxpbmVDb3VudDogSW50IVxuICAgICAgICAkdGltZWxpbmVDdXJzb3I6IFN0cmluZ1xuICAgICAgICAkY29tbWl0Q291bnQ6IEludCFcbiAgICAgICAgJGNvbW1pdEN1cnNvcjogU3RyaW5nXG4gICAgICAgICRyZXZpZXdDb3VudDogSW50IVxuICAgICAgICAkcmV2aWV3Q3Vyc29yOiBTdHJpbmdcbiAgICAgICAgJHRocmVhZENvdW50OiBJbnQhXG4gICAgICAgICR0aHJlYWRDdXJzb3I6IFN0cmluZ1xuICAgICAgICAkY29tbWVudENvdW50OiBJbnQhXG4gICAgICAgICRjb21tZW50Q3Vyc29yOiBTdHJpbmdcbiAgICAgICAgJGNoZWNrU3VpdGVDb3VudDogSW50IVxuICAgICAgICAkY2hlY2tTdWl0ZUN1cnNvcjogU3RyaW5nXG4gICAgICAgICRjaGVja1J1bkNvdW50OiBJbnQhXG4gICAgICAgICRjaGVja1J1bkN1cnNvcjogU3RyaW5nXG4gICAgICApIHtcbiAgICAgICAgcmVwb3NpdG9yeShvd25lcjogJHJlcG9Pd25lciwgbmFtZTogJHJlcG9OYW1lKSB7XG4gICAgICAgICAgaXNzdWVpc2g6IGlzc3VlT3JQdWxsUmVxdWVzdChudW1iZXI6ICRpc3N1ZWlzaE51bWJlcikge1xuICAgICAgICAgICAgX190eXBlbmFtZVxuICAgICAgICAgICAgLi4uIG9uIFB1bGxSZXF1ZXN0IHtcbiAgICAgICAgICAgICAgLi4uYWdncmVnYXRlZFJldmlld3NDb250YWluZXJfcHVsbFJlcXVlc3QgQGFyZ3VtZW50cyhcbiAgICAgICAgICAgICAgICByZXZpZXdDb3VudDogJHJldmlld0NvdW50XG4gICAgICAgICAgICAgICAgcmV2aWV3Q3Vyc29yOiAkcmV2aWV3Q3Vyc29yXG4gICAgICAgICAgICAgICAgdGhyZWFkQ291bnQ6ICR0aHJlYWRDb3VudFxuICAgICAgICAgICAgICAgIHRocmVhZEN1cnNvcjogJHRocmVhZEN1cnNvclxuICAgICAgICAgICAgICAgIGNvbW1lbnRDb3VudDogJGNvbW1lbnRDb3VudFxuICAgICAgICAgICAgICAgIGNvbW1lbnRDdXJzb3I6ICRjb21tZW50Q3Vyc29yXG4gICAgICAgICAgICAgIClcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG5cbiAgICAgICAgICAuLi5pc3N1ZWlzaERldGFpbENvbnRyb2xsZXJfcmVwb3NpdG9yeSBAYXJndW1lbnRzKFxuICAgICAgICAgICAgaXNzdWVpc2hOdW1iZXI6ICRpc3N1ZWlzaE51bWJlclxuICAgICAgICAgICAgdGltZWxpbmVDb3VudDogJHRpbWVsaW5lQ291bnRcbiAgICAgICAgICAgIHRpbWVsaW5lQ3Vyc29yOiAkdGltZWxpbmVDdXJzb3JcbiAgICAgICAgICAgIGNvbW1pdENvdW50OiAkY29tbWl0Q291bnRcbiAgICAgICAgICAgIGNvbW1pdEN1cnNvcjogJGNvbW1pdEN1cnNvclxuICAgICAgICAgICAgY2hlY2tTdWl0ZUNvdW50OiAkY2hlY2tTdWl0ZUNvdW50XG4gICAgICAgICAgICBjaGVja1N1aXRlQ3Vyc29yOiAkY2hlY2tTdWl0ZUN1cnNvclxuICAgICAgICAgICAgY2hlY2tSdW5Db3VudDogJGNoZWNrUnVuQ291bnRcbiAgICAgICAgICAgIGNoZWNrUnVuQ3Vyc29yOiAkY2hlY2tSdW5DdXJzb3JcbiAgICAgICAgICApXG4gICAgICAgIH1cbiAgICAgIH1cbiAgICBgO1xuICAgIGNvbnN0IHZhcmlhYmxlcyA9IHtcbiAgICAgIHJlcG9Pd25lcjogdGhpcy5wcm9wcy5vd25lcixcbiAgICAgIHJlcG9OYW1lOiB0aGlzLnByb3BzLnJlcG8sXG4gICAgICBpc3N1ZWlzaE51bWJlcjogdGhpcy5wcm9wcy5pc3N1ZWlzaE51bWJlcixcbiAgICAgIHRpbWVsaW5lQ291bnQ6IFBBR0VfU0laRSxcbiAgICAgIHRpbWVsaW5lQ3Vyc29yOiBudWxsLFxuICAgICAgY29tbWl0Q291bnQ6IFBBR0VfU0laRSxcbiAgICAgIGNvbW1pdEN1cnNvcjogbnVsbCxcbiAgICAgIHJldmlld0NvdW50OiBQQUdFX1NJWkUsXG4gICAgICByZXZpZXdDdXJzb3I6IG51bGwsXG4gICAgICB0aHJlYWRDb3VudDogUEFHRV9TSVpFLFxuICAgICAgdGhyZWFkQ3Vyc29yOiBudWxsLFxuICAgICAgY29tbWVudENvdW50OiBQQUdFX1NJWkUsXG4gICAgICBjb21tZW50Q3Vyc29yOiBudWxsLFxuICAgICAgY2hlY2tTdWl0ZUNvdW50OiBDSEVDS19TVUlURV9QQUdFX1NJWkUsXG4gICAgICBjaGVja1N1aXRlQ3Vyc29yOiBudWxsLFxuICAgICAgY2hlY2tSdW5Db3VudDogQ0hFQ0tfUlVOX1BBR0VfU0laRSxcbiAgICAgIGNoZWNrUnVuQ3Vyc29yOiBudWxsLFxuICAgIH07XG5cbiAgICByZXR1cm4gKFxuICAgICAgPFJlbGF5RW52aXJvbm1lbnQuUHJvdmlkZXIgdmFsdWU9e2Vudmlyb25tZW50fT5cbiAgICAgICAgPFF1ZXJ5UmVuZGVyZXJcbiAgICAgICAgICBlbnZpcm9ubWVudD17ZW52aXJvbm1lbnR9XG4gICAgICAgICAgcXVlcnk9e3F1ZXJ5fVxuICAgICAgICAgIHZhcmlhYmxlcz17dmFyaWFibGVzfVxuICAgICAgICAgIHJlbmRlcj17cXVlcnlSZXN1bHQgPT4gdGhpcy5yZW5kZXJXaXRoUXVlcnlSZXN1bHQodG9rZW4sIHJlcG9EYXRhLCBxdWVyeVJlc3VsdCl9XG4gICAgICAgIC8+XG4gICAgICA8L1JlbGF5RW52aXJvbm1lbnQuUHJvdmlkZXI+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlcldpdGhRdWVyeVJlc3VsdCh0b2tlbiwgcmVwb0RhdGEsIHtlcnJvciwgcHJvcHMsIHJldHJ5fSkge1xuICAgIGlmIChlcnJvcikge1xuICAgICAgcmV0dXJuIChcbiAgICAgICAgPFF1ZXJ5RXJyb3JWaWV3XG4gICAgICAgICAgZXJyb3I9e2Vycm9yfVxuICAgICAgICAgIGxvZ2luPXt0aGlzLmhhbmRsZUxvZ2lufVxuICAgICAgICAgIHJldHJ5PXtyZXRyeX1cbiAgICAgICAgICBsb2dvdXQ9e3RoaXMuaGFuZGxlTG9nb3V0fVxuICAgICAgICAvPlxuICAgICAgKTtcbiAgICB9XG5cbiAgICBpZiAoIXByb3BzIHx8ICFyZXBvRGF0YSkge1xuICAgICAgcmV0dXJuIDxMb2FkaW5nVmlldyAvPjtcbiAgICB9XG5cbiAgICBpZiAocHJvcHMucmVwb3NpdG9yeS5pc3N1ZWlzaC5fX3R5cGVuYW1lID09PSAnUHVsbFJlcXVlc3QnKSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8QWdncmVnYXRlZFJldmlld3NDb250YWluZXJcbiAgICAgICAgICBwdWxsUmVxdWVzdD17cHJvcHMucmVwb3NpdG9yeS5pc3N1ZWlzaH1cbiAgICAgICAgICByZXBvcnRSZWxheUVycm9yPXt0aGlzLnByb3BzLnJlcG9ydFJlbGF5RXJyb3J9PlxuICAgICAgICAgIHthZ2dyZWdhdGVkUmV2aWV3cyA9PiB0aGlzLnJlbmRlcldpdGhDb21tZW50UmVzdWx0KHRva2VuLCByZXBvRGF0YSwge3Byb3BzLCByZXRyeX0sIGFnZ3JlZ2F0ZWRSZXZpZXdzKX1cbiAgICAgICAgPC9BZ2dyZWdhdGVkUmV2aWV3c0NvbnRhaW5lcj5cbiAgICAgICk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiB0aGlzLnJlbmRlcldpdGhDb21tZW50UmVzdWx0KFxuICAgICAgICB0b2tlbixcbiAgICAgICAgcmVwb0RhdGEsXG4gICAgICAgIHtwcm9wcywgcmV0cnl9LFxuICAgICAgICB7ZXJyb3JzOiBbXSwgY29tbWVudFRocmVhZHM6IFtdLCBsb2FkaW5nOiBmYWxzZX0sXG4gICAgICApO1xuICAgIH1cbiAgfVxuXG4gIHJlbmRlcldpdGhDb21tZW50UmVzdWx0KHRva2VuLCByZXBvRGF0YSwge3Byb3BzLCByZXRyeX0sIHtlcnJvcnMsIGNvbW1lbnRUaHJlYWRzLCBsb2FkaW5nfSkge1xuICAgIGNvbnN0IG5vbkVtcHR5VGhyZWFkcyA9IGNvbW1lbnRUaHJlYWRzLmZpbHRlcihlYWNoID0+IGVhY2guY29tbWVudHMgJiYgZWFjaC5jb21tZW50cy5sZW5ndGggPiAwKTtcbiAgICBjb25zdCB0b3RhbENvdW50ID0gbm9uRW1wdHlUaHJlYWRzLmxlbmd0aDtcbiAgICBjb25zdCByZXNvbHZlZENvdW50ID0gbm9uRW1wdHlUaHJlYWRzLmZpbHRlcihlYWNoID0+IGVhY2gudGhyZWFkLmlzUmVzb2x2ZWQpLmxlbmd0aDtcblxuICAgIGlmIChlcnJvcnMgJiYgZXJyb3JzLmxlbmd0aCA+IDApIHtcbiAgICAgIGNvbnN0IGRlc2NyaXB0aW9ucyA9IGVycm9ycy5tYXAoZXJyb3IgPT4gZXJyb3IudG9TdHJpbmcoKSk7XG5cbiAgICAgIHJldHVybiAoXG4gICAgICAgIDxFcnJvclZpZXdcbiAgICAgICAgICB0aXRsZT1cIlVuYWJsZSB0byBmZXRjaCByZXZpZXcgY29tbWVudHNcIlxuICAgICAgICAgIGRlc2NyaXB0aW9ucz17ZGVzY3JpcHRpb25zfVxuICAgICAgICAgIHJldHJ5PXtyZXRyeX1cbiAgICAgICAgICBsb2dvdXQ9e3RoaXMuaGFuZGxlTG9nb3V0fVxuICAgICAgICAvPlxuICAgICAgKTtcbiAgICB9XG5cbiAgICByZXR1cm4gKFxuICAgICAgPElzc3VlaXNoRGV0YWlsQ29udHJvbGxlclxuICAgICAgICB7Li4ucHJvcHN9XG4gICAgICAgIHsuLi5yZXBvRGF0YX1cbiAgICAgICAgcmV2aWV3Q29tbWVudHNMb2FkaW5nPXtsb2FkaW5nfVxuICAgICAgICByZXZpZXdDb21tZW50c1RvdGFsQ291bnQ9e3RvdGFsQ291bnR9XG4gICAgICAgIHJldmlld0NvbW1lbnRzUmVzb2x2ZWRDb3VudD17cmVzb2x2ZWRDb3VudH1cbiAgICAgICAgcmV2aWV3Q29tbWVudFRocmVhZHM9e25vbkVtcHR5VGhyZWFkc31cbiAgICAgICAgdG9rZW49e3Rva2VufVxuXG4gICAgICAgIGxvY2FsUmVwb3NpdG9yeT17dGhpcy5wcm9wcy5yZXBvc2l0b3J5fVxuICAgICAgICB3b3JrZGlyUGF0aD17dGhpcy5wcm9wcy5yZXBvc2l0b3J5LmdldFdvcmtpbmdEaXJlY3RvcnlQYXRoKCl9XG5cbiAgICAgICAgaXNzdWVpc2hOdW1iZXI9e3RoaXMucHJvcHMuaXNzdWVpc2hOdW1iZXJ9XG4gICAgICAgIG9uVGl0bGVDaGFuZ2U9e3RoaXMucHJvcHMub25UaXRsZUNoYW5nZX1cbiAgICAgICAgc3dpdGNoVG9Jc3N1ZWlzaD17dGhpcy5wcm9wcy5zd2l0Y2hUb0lzc3VlaXNofVxuICAgICAgICBpbml0Q2hhbmdlZEZpbGVQYXRoPXt0aGlzLnByb3BzLmluaXRDaGFuZ2VkRmlsZVBhdGh9XG4gICAgICAgIGluaXRDaGFuZ2VkRmlsZVBvc2l0aW9uPXt0aGlzLnByb3BzLmluaXRDaGFuZ2VkRmlsZVBvc2l0aW9ufVxuICAgICAgICBzZWxlY3RlZFRhYj17dGhpcy5wcm9wcy5zZWxlY3RlZFRhYn1cbiAgICAgICAgb25UYWJTZWxlY3RlZD17dGhpcy5wcm9wcy5vblRhYlNlbGVjdGVkfVxuICAgICAgICBvbk9wZW5GaWxlc1RhYj17dGhpcy5wcm9wcy5vbk9wZW5GaWxlc1RhYn1cbiAgICAgICAgZW5kcG9pbnQ9e3RoaXMucHJvcHMuZW5kcG9pbnR9XG4gICAgICAgIHJlcG9ydFJlbGF5RXJyb3I9e3RoaXMucHJvcHMucmVwb3J0UmVsYXlFcnJvcn1cblxuICAgICAgICB3b3Jrc3BhY2U9e3RoaXMucHJvcHMud29ya3NwYWNlfVxuICAgICAgICBjb21tYW5kcz17dGhpcy5wcm9wcy5jb21tYW5kc31cbiAgICAgICAga2V5bWFwcz17dGhpcy5wcm9wcy5rZXltYXBzfVxuICAgICAgICB0b29sdGlwcz17dGhpcy5wcm9wcy50b29sdGlwc31cbiAgICAgICAgY29uZmlnPXt0aGlzLnByb3BzLmNvbmZpZ31cblxuICAgICAgICBpdGVtVHlwZT17dGhpcy5wcm9wcy5pdGVtVHlwZX1cbiAgICAgICAgZGVzdHJveT17dGhpcy5wcm9wcy5kZXN0cm95fVxuICAgICAgICByZWZFZGl0b3I9e3RoaXMucHJvcHMucmVmRWRpdG9yfVxuICAgICAgLz5cbiAgICApO1xuICB9XG5cbiAgZmV0Y2hUb2tlbiA9IGxvZ2luTW9kZWwgPT4ge1xuICAgIHJldHVybiB5dWJpa2lyaSh7XG4gICAgICB0b2tlbjogbG9naW5Nb2RlbC5nZXRUb2tlbih0aGlzLnByb3BzLmVuZHBvaW50LmdldExvZ2luQWNjb3VudCgpKSxcbiAgICB9KTtcbiAgfVxuXG4gIGZldGNoUmVwb3NpdG9yeURhdGEgPSByZXBvc2l0b3J5ID0+IHtcbiAgICByZXR1cm4geXViaWtpcmkoe1xuICAgICAgYnJhbmNoZXM6IHJlcG9zaXRvcnkuZ2V0QnJhbmNoZXMoKSxcbiAgICAgIHJlbW90ZXM6IHJlcG9zaXRvcnkuZ2V0UmVtb3RlcygpLFxuICAgICAgaXNNZXJnaW5nOiByZXBvc2l0b3J5LmlzTWVyZ2luZygpLFxuICAgICAgaXNSZWJhc2luZzogcmVwb3NpdG9yeS5pc1JlYmFzaW5nKCksXG4gICAgICBpc0Fic2VudDogcmVwb3NpdG9yeS5pc0Fic2VudCgpLFxuICAgICAgaXNMb2FkaW5nOiByZXBvc2l0b3J5LmlzTG9hZGluZygpLFxuICAgICAgaXNQcmVzZW50OiByZXBvc2l0b3J5LmlzUHJlc2VudCgpLFxuICAgIH0pO1xuICB9XG5cbiAgaGFuZGxlTG9naW4gPSB0b2tlbiA9PiB0aGlzLnByb3BzLmxvZ2luTW9kZWwuc2V0VG9rZW4odGhpcy5wcm9wcy5lbmRwb2ludC5nZXRMb2dpbkFjY291bnQoKSwgdG9rZW4pO1xuXG4gIGhhbmRsZUxvZ291dCA9ICgpID0+IHRoaXMucHJvcHMubG9naW5Nb2RlbC5yZW1vdmVUb2tlbih0aGlzLnByb3BzLmVuZHBvaW50LmdldExvZ2luQWNjb3VudCgpKTtcblxuICBoYW5kbGVUb2tlblJldHJ5ID0gKCkgPT4gdGhpcy5wcm9wcy5sb2dpbk1vZGVsLmRpZFVwZGF0ZSgpO1xufVxuIl19