"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareIssueishTooltipContainer = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const typeAndStateToIcon = {
  Issue: {
    OPEN: 'issue-opened',
    CLOSED: 'issue-closed'
  },
  PullRequest: {
    OPEN: 'git-pull-request',
    CLOSED: 'git-pull-request',
    MERGED: 'git-merge'
  }
};

class BareIssueishTooltipContainer extends _react.default.Component {
  render() {
    const resource = this.props.resource;
    const author = resource.author || _helpers.GHOST_USER;
    const {
      repository,
      state,
      number,
      title,
      __typename
    } = resource;
    const icons = typeAndStateToIcon[__typename] || {};
    const icon = icons[state] || '';
    return _react.default.createElement("div", {
      className: "github-IssueishTooltip"
    }, _react.default.createElement("div", {
      className: "issueish-avatar-and-title"
    }, _react.default.createElement("img", {
      className: "author-avatar",
      src: author.avatarUrl,
      title: author.login,
      alt: author.login
    }), _react.default.createElement("h3", {
      className: "issueish-title"
    }, title)), _react.default.createElement("div", {
      className: "issueish-badge-and-link"
    }, _react.default.createElement("span", {
      className: (0, _classnames.default)('issueish-badge', 'badge', state.toLowerCase())
    }, _react.default.createElement(_octicon.default, {
      icon: icon
    }), state.toLowerCase()), _react.default.createElement("span", {
      className: "issueish-link"
    }, repository.owner.login, "/", repository.name, "#", number)));
  }

}

exports.BareIssueishTooltipContainer = BareIssueishTooltipContainer;

_defineProperty(BareIssueishTooltipContainer, "propTypes", {
  resource: _propTypes.default.shape({
    issue: _propTypes.default.shape({}),
    pullRequest: _propTypes.default.shape({})
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareIssueishTooltipContainer, {
  resource: function () {
    const node = require("./__generated__/issueishTooltipContainer_resource.graphql");

    if (node.hash && node.hash !== "8980fc73c7ed3f632f0612ce14f2f0d1") {
      console.error("The definition of 'issueishTooltipContainer_resource' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueishTooltipContainer_resource.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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