"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _whatTheDiff = require("what-the-diff");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _filter = require("../models/patch/filter");

var _patch = require("../models/patch");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class PullRequestPatchContainer extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      multiFilePatch: null,
      error: null,
      last: {
        url: null,
        patch: null,
        etag: null
      }
    });
  }

  componentDidMount() {
    this.mounted = true;
    this.fetchDiff(this.state.last);
  }

  componentDidUpdate(prevProps) {
    const explicitRefetch = this.props.refetch && !prevProps.refetch;
    const requestedURLChange = this.state.last.url !== this.getDiffURL();

    if (explicitRefetch || requestedURLChange) {
      const {
        last
      } = this.state;
      this.setState({
        multiFilePatch: null,
        error: null,
        last: {
          url: this.getDiffURL(),
          patch: null,
          etag: null
        }
      });
      this.fetchDiff(last);
    }
  }

  componentWillUnmount() {
    this.mounted = false;
  }

  render() {
    return this.props.children(this.state.error, this.state.multiFilePatch);
  } // Generate a v3 GitHub API REST URL for the pull request resource.
  // Example: https://api.github.com/repos/atom/github/pulls/1829


  getDiffURL() {
    return this.props.endpoint.getRestURI('repos', this.props.owner, this.props.repo, 'pulls', this.props.number);
  }

  buildPatch(rawDiff) {
    const {
      filtered,
      removed
    } = (0, _filter.filter)(rawDiff);
    const diffs = (0, _whatTheDiff.parse)(filtered).map(diff => {
      // diff coming from API will have the defaul git diff prefixes a/ and b/ and use *nix-style / path separators.
      // e.g. a/dir/file1.js and b/dir/file2.js
      // see https://git-scm.com/docs/git-diff#_generating_patches_with_p
      return _objectSpread2({}, diff, {
        newPath: diff.newPath ? (0, _helpers.toNativePathSep)(diff.newPath.replace(/^[a|b]\//, '')) : diff.newPath,
        oldPath: diff.oldPath ? (0, _helpers.toNativePathSep)(diff.oldPath.replace(/^[a|b]\//, '')) : diff.oldPath
      });
    });
    const options = {
      preserveOriginal: true,
      removed
    };

    if (this.props.largeDiffThreshold) {
      options.largeDiffThreshold = this.props.largeDiffThreshold;
    }

    const mfp = (0, _patch.buildMultiFilePatch)(diffs, options);
    return mfp;
  }

  async fetchDiff(last) {
    const url = this.getDiffURL();
    let response;

    try {
      const headers = {
        Accept: 'application/vnd.github.v3.diff',
        Authorization: `bearer ${this.props.token}`
      };

      if (url === last.url && last.etag !== null) {
        headers['If-None-Match'] = last.etag;
      }

      response = await fetch(url, {
        headers
      });
    } catch (err) {
      return this.reportDiffError(`Network error encountered fetching the patch: ${err.message}.`, err);
    }

    if (response.status === 304) {
      // Not modified.
      if (!this.mounted) {
        return null;
      }

      return new Promise(resolve => this.setState({
        multiFilePatch: last.patch,
        error: null,
        last
      }));
    }

    if (!response.ok) {
      return this.reportDiffError(`Unable to fetch the diff for this pull request: ${response.statusText}.`);
    }

    try {
      const etag = response.headers.get('ETag');
      const rawDiff = await response.text();

      if (!this.mounted) {
        return null;
      }

      const multiFilePatch = this.buildPatch(rawDiff);
      return new Promise(resolve => this.setState({
        multiFilePatch,
        error: null,
        last: {
          url,
          patch: multiFilePatch,
          etag
        }
      }, resolve));
    } catch (err) {
      return this.reportDiffError('Unable to parse the diff for this pull request.', err);
    }
  }

  reportDiffError(message, error) {
    if (!this.mounted) {
      return null;
    }

    return new Promise(resolve => {
      if (error) {
        // eslint-disable-next-line no-console
        console.error(error);
      }

      if (!this.mounted) {
        resolve();
        return;
      }

      this.setState({
        error: message
      }, resolve);
    });
  }

}

exports.default = PullRequestPatchContainer;

_defineProperty(PullRequestPatchContainer, "propTypes", {
  // Pull request properties
  owner: _propTypes.default.string.isRequired,
  repo: _propTypes.default.string.isRequired,
  number: _propTypes.default.number.isRequired,
  // Connection properties
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes.default.string.isRequired,
  // Fetching and parsing
  refetch: _propTypes.default.bool,
  largeDiffThreshold: _propTypes.default.number,
  // Render prop. Called with (error or null, multiFilePatch or null)
  children: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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